/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.urack;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.tools.urack.UserRackException;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class URackController
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(URackController.class);

    public int addRack(String rackName) throws MxException {
        LOGGER.enter("URackController.addRack(" + rackName + ")");
        MxNode userRackNode = new MxNode();
        ArrayList<String> deviceSubTypesList = new ArrayList<String>();
        deviceSubTypesList.add("multi-class");
        userRackNode.setDeviceSubTypes(deviceSubTypesList);
        userRackNode.setDeviceName(rackName);
        userRackNode.setAgentUUID("Rack_" + rackName);
        userRackNode.setDeviceType("Rack");
        userRackNode.setModel("Rack");
        userRackNode.setSnoozeTime(-2);
        MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), userRackNode);
        NodeAssociationsManager nam = null;
        try {
            nam = NodeAssociationsManager.getDefaultManager();
            NodeAssociations rackNodeAssociations = nam.getNodeAssociations(userRackNode.getDeviceKey());
            rackNodeAssociations.initializeTopologyTree();
        }
        catch (NodeAssociationsPersistenceException excep) {
            LOGGER.exception("Exception thrown while initializing the topology tree of the rack.Exception:" + (Object)((Object)excep));
        }
        LOGGER.fine("A user defined rack with name " + rackName + " has been created.");
        LOGGER.exit("URackController.addRack(" + rackName + ")");
        return userRackNode.getDeviceKey();
    }

    public void editRack(String newRackName, int rackHeight, String dataCenterLocation, String dataCenterID, int rowNumber, int positionInRow, int rackDeviceKey) throws MxException {
        LOGGER.enter("URackController.editRack(" + newRackName + "," + rackHeight + "," + dataCenterLocation + "," + dataCenterID + "," + rowNumber + "," + positionInRow + "," + rackDeviceKey + ")");
        MxNode rackNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(rackDeviceKey));
        if (rackNode != null) {
            rackNode.setDeviceName(newRackName);
            rackNode.setAgentUUID("Rack_" + newRackName);
            rackNode.setClientAttribute("rackHeight", String.valueOf(rackHeight));
            rackNode.setClientAttribute("DataCentreLoc", dataCenterLocation);
            rackNode.setClientAttribute("DataCentreID", dataCenterID);
            rackNode.setClientAttribute("RowNumber", String.valueOf(rowNumber));
            rackNode.setClientAttribute("PositionRow", String.valueOf(positionInRow));
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), rackNode, false);
            LOGGER.fine("New name is set:" + newRackName);
            Vector associatedEnclosures = this.getAssociatedDeviceVector(rackNode.getDeviceKey(), "EnclosureToRack");
            String[] asscEnclosures = new String[associatedEnclosures.size()];
            for (int i = 0; i < associatedEnclosures.size(); ++i) {
                Integer dKey = (Integer)associatedEnclosures.elementAt(i);
                int deviceKey = dKey;
                asscEnclosures[i] = String.valueOf(deviceKey);
            }
            this.setRackNameOnDevice(rackDeviceKey, asscEnclosures);
        }
        LOGGER.enter("URackController.editRack(" + newRackName + "," + rackHeight + "," + dataCenterLocation + "," + dataCenterID + "," + rowNumber + "," + positionInRow + "," + rackDeviceKey + ")");
    }

    public void addEnclosuresToRack(String[] enclosureDeviceKeys, String[] enclosureStartUs, String[] enclosureEndUs, int rackDeviceKey) throws UserRackException, MxException {
        int enclKey;
        int i;
        LOGGER.enter("URackController.addEnclosuresToRack(" + enclosureDeviceKeys + "," + enclosureStartUs + "," + enclosureEndUs + "," + rackDeviceKey + "," + ")");
        NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
        NodeAssociations rackNodeAssociations = nam.getNodeAssociations(rackDeviceKey);
        rackNodeAssociations.initializeTopologyTree();
        DefaultMutableTreeNode rackTopTree = rackNodeAssociations.getContainerDeviceTree();
        for (i = 0; i < enclosureDeviceKeys.length; ++i) {
            enclKey = Integer.parseInt(enclosureDeviceKeys[i]);
            try {
                MxNode oldRackNode = null;
                oldRackNode = this.getAssociatedDeviceNode(enclKey, "EnclosureToRack");
                NodeAssociations oldrackNodeAssociations = nam.getNodeAssociations(oldRackNode.getDeviceKey());
                DefaultMutableTreeNode oldRopologyTree = oldrackNodeAssociations.getContainerDeviceTree();
                this.removeBladeFromTopology(enclKey, oldRopologyTree);
                nam.deleteTheExactEntryForThisDevice(enclKey, oldRackNode.getDeviceKey(), "EnclosureToRack");
                nam.update(oldrackNodeAssociations);
                nam.resetDeviceAssociations(oldRackNode.getDeviceKey());
                LOGGER.fine("enclosure " + enclosureDeviceKeys[i] + " removed from rack " + oldRackNode.getDeviceKey());
            }
            catch (Exception e) {
                LOGGER.fine("enclosure does not belong to a rack");
            }
            int botN = -1;
            NodeAssociations theEnclDevNodeAssociations = nam.getNodeAssociations(enclKey);
            int topN = theEnclDevNodeAssociations.getTopNeighborDeviceKey();
            botN = theEnclDevNodeAssociations.getBottomNeighborDeviceKey();
            LOGGER.fine("enclosure " + enclosureDeviceKeys[i] + " has top " + topN + " and bottom " + botN);
            if (topN != -1) {
                try {
                    NodeAssociations topNA = nam.getNodeAssociations(topN);
                    this.storeNeighborInfoInDb(topN, topNA.getTopNeighborDeviceKey(), botN, 1);
                    topNA.setBottomNeighborDeviceKey(botN);
                    nam.update(topNA);
                    nam.resetDeviceAssociations(topN);
                    LOGGER.fine("top neighbour " + topN + " now has bottom neighbour " + botN);
                }
                catch (Exception ex) {
                    LOGGER.fine("top enclosure may be deleted. do nothing.");
                }
            }
            if (botN == -1) continue;
            try {
                NodeAssociations botNA = nam.getNodeAssociations(botN);
                this.storeNeighborInfoInDb(botN, topN, botNA.getBottomNeighborDeviceKey(), 1);
                botNA.setTopNeighborDeviceKey(topN);
                nam.update(botNA);
                nam.resetDeviceAssociations(botN);
                LOGGER.fine("bottom neighbour " + botN + " now has top neighbour " + topN);
                continue;
            }
            catch (Exception ex) {
                LOGGER.fine("bottom enclosure may be deleted. do nothing.");
            }
        }
        for (i = 0; i < enclosureDeviceKeys.length; ++i) {
            enclKey = Integer.parseInt(enclosureDeviceKeys[i]);
            NodeAssociations enclNA = nam.getNodeAssociations(enclKey);
            if (enclNA != null) {
                enclNA.setInContainer(true);
                if (enclNA.getContainerDeviceTree() == null) {
                    enclNA.initializeTopologyTree();
                }
                enclNA.setParent(rackDeviceKey);
                enclNA.setTheAssociation(enclKey, rackDeviceKey, "EnclosureToRack", false);
            }
            rackTopTree.add(enclNA.getContainerDeviceTree());
            enclNA.getContainerDeviceTree().setParent(rackTopTree);
            this.addDeviceToTopologyTree(rackNodeAssociations, enclKey);
            LOGGER.fine("enclosure " + enclKey + " is now added to rack " + rackDeviceKey);
            nam.removeEnclosureFromTopology(Integer.parseInt(enclosureDeviceKeys[i]));
            MxNode enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(Integer.parseInt(enclosureDeviceKeys[i]));
            if (i < enclosureDeviceKeys.length - 1 && enclosureDeviceKeys[i + 1] != null && i > 0 && enclosureDeviceKeys[i - 1] != null) {
                LOGGER.fine("enclosure " + enclKey + " has " + Integer.parseInt(enclosureDeviceKeys[i - 1]) + " and " + Integer.parseInt(enclosureDeviceKeys[i + 1]));
                this.storeNeighborInfoInDb(Integer.parseInt(enclosureDeviceKeys[i]), Integer.parseInt(enclosureDeviceKeys[i - 1]), Integer.parseInt(enclosureDeviceKeys[i + 1]), 1);
            } else if (i < enclosureDeviceKeys.length - 1 && enclosureDeviceKeys[i + 1] != null) {
                LOGGER.fine("enclosure " + enclKey + " has -1 and " + Integer.parseInt(enclosureDeviceKeys[i + 1]));
                this.storeNeighborInfoInDb(Integer.parseInt(enclosureDeviceKeys[i]), -1, Integer.parseInt(enclosureDeviceKeys[i + 1]), 1);
            } else if (i > 0 && enclosureDeviceKeys[i - 1] != null) {
                LOGGER.fine("enclosure " + enclKey + " has " + Integer.parseInt(enclosureDeviceKeys[i - 1]) + " -1");
                this.storeNeighborInfoInDb(Integer.parseInt(enclosureDeviceKeys[i]), Integer.parseInt(enclosureDeviceKeys[i - 1]), -1, 1);
            } else {
                LOGGER.fine("enclosure " + enclKey + " has -1 -1");
                this.storeNeighborInfoInDb(Integer.parseInt(enclosureDeviceKeys[i]), -1, -1, 1);
            }
            if (i < enclosureDeviceKeys.length - 1 && enclosureDeviceKeys[i + 1] != null) {
                enclNA.setBottomNeighborDeviceKey(Integer.parseInt(enclosureDeviceKeys[i + 1]));
            } else {
                enclNA.setBottomNeighborDeviceKey(-1);
            }
            if (i > 0 && enclosureDeviceKeys[i - 1] != null) {
                enclNA.setTopNeighborDeviceKey(Integer.parseInt(enclosureDeviceKeys[i - 1]));
            } else {
                enclNA.setTopNeighborDeviceKey(-1);
            }
            nam.update(enclNA);
            LOGGER.fine("enclosure " + enclosureDeviceKeys[i] + " is has top " + enclNA.getTopNeighborDeviceKey() + " and bottom " + enclNA.getBottomNeighborDeviceKey());
            enclNode.setClientAttribute("enclStartU", enclosureStartUs[i]);
            enclNode.setClientAttribute("enclEndU", enclosureEndUs[i]);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclNode, false);
        }
        nam.update(rackNodeAssociations);
        rackNodeAssociations.setContainerDeviceTree(rackTopTree);
        LOGGER.fine("new rack " + rackDeviceKey + " updated. save comeplte.");
        this.setRackNameOnDevice(rackDeviceKey, enclosureDeviceKeys);
        LOGGER.fine("new rack name set on all children.");
    }

    void setRackNameOnDevice(int rackDeviceKey, String[] enclosureDeviceKeys) {
        LOGGER.enter("UrackController: setRackNameOnDevice");
        MxNode rackNode = null;
        try {
            rackNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDeviceKey);
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.exception("can not find rack node");
        }
        for (int i = 0; i < enclosureDeviceKeys.length; ++i) {
            MxNode enclNode = null;
            try {
                enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(Integer.parseInt(enclosureDeviceKeys[i]));
                this.modifyTheMxNode(enclNode, rackNode.getNameString());
            }
            catch (MxException e) {
                LOGGER.error("could not find enclosure node");
            }
            if (enclNode == null || !enclNode.getDeviceSubTypes().contains("ServerEnc")) continue;
            Vector associatedServers = this.getAssociatedDeviceVector(enclNode.getDeviceKey(), "ServerToEnclosure");
            Vector associateSwicthes = this.getAssociatedDeviceVector(enclNode.getDeviceKey(), "SwitchToEnclosure");
            this.setRackNameOnMxNode(associatedServers, rackNode.getNameString());
            this.setRackNameOnMxNode(associateSwicthes, rackNode.getNameString());
        }
        LOGGER.exit("URackController :setRackNameOnDevice");
    }

    public void setRackNameOnMxNode(Vector associatedDevices, String rackName) {
        LOGGER.enter("URackController:setRackNameOnMxNode as " + rackName);
        MxNode deviceMxNode = null;
        int deviceKey = 0;
        for (int i = 0; i < associatedDevices.size(); ++i) {
            Integer dKey = (Integer)associatedDevices.elementAt(i);
            deviceKey = dKey;
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                if (deviceMxNode.getDeviceType().equalsIgnoreCase("Server")) {
                    try {
                        MxNode mgmtNode = this.getAssociatedDeviceNode(deviceMxNode.getDeviceKey(), "MgmtProcToServer_Ilo");
                        this.modifyTheMxNode(mgmtNode, rackName);
                    }
                    catch (Exception e) {
                        LOGGER.exception("did not find MP");
                    }
                }
                LOGGER.fine("Device name:" + deviceMxNode.getNameString());
                this.modifyTheMxNode(deviceMxNode, rackName);
                continue;
            }
            catch (Exception e) {
                LOGGER.exception("can not set rack name");
            }
        }
        LOGGER.exit("URackController.setRackNameOnMxNode");
    }

    public void modifyTheMxNode(MxNode mxDevice, String RackName) {
        try {
            mxDevice.setRackName(RackName);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), mxDevice, false);
        }
        catch (Exception e) {
            LOGGER.exception("could not modiyfy" + mxDevice.getNameString());
        }
    }

    public Vector getAssociatedDeviceVector(int enclDeviceKey, String asscType) {
        Vector associatedDeviceKeyVect = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, asscType);
        return associatedDeviceKeyVect;
    }

    public MxNode getAssociatedDeviceNode(int enclDeviceKey, String asscType) {
        MxNode associatedDevice = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, asscType);
        int associatedDeviceKey = 0;
        if (associatedDeviceKeyVect.size() > 0) {
            Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(0);
            associatedDeviceKey = vectKey;
            try {
                associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
        }
        return associatedDevice;
    }

    public void cleanRackTopology(int rackDeviceKey) {
        try {
            NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
            Vector associatedDeviceKeyVect = nam.getAssociatedDevicesUsingATNs(rackDeviceKey, "EnclosureToRack");
            for (int j = 0; j < associatedDeviceKeyVect.size(); ++j) {
                MxNode theOldEncl = null;
                try {
                    theOldEncl = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)associatedDeviceKeyVect.elementAt(j)).intValue());
                    NodeAssociations oldEnclAssociations = nam.getNodeAssociations(theOldEncl.getDeviceKey());
                    oldEnclAssociations.setParent(-1);
                    oldEnclAssociations.setBottomNeighborDeviceKey(-1);
                    oldEnclAssociations.setTopNeighborDeviceKey(-1);
                    this.cutOldNeighborLink(theOldEncl, true);
                    this.cutOldNeighborLink(theOldEncl, false);
                    this.storeNeighborInfoInDb((Integer)associatedDeviceKeyVect.elementAt(j), -1, -1, 1);
                    nam.update(oldEnclAssociations);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            nam.deleteBothEntriesForThisDeviceAndAssocType(rackDeviceKey, "EnclosureToRack");
            nam.resetDeviceAssociations(rackDeviceKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

