/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class MxBPVContainerObjectFactory {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVContainerObjectFactory.class);
    private HashMap<String, String> m_containerClasses = new HashMap();
    private static MxBPVContainerObjectFactory m_ContainerFactory;

    private MxBPVContainerObjectFactory() {
        this.m_containerClasses.put(NodeSubTypeMapper.CCLASS_SUBTYPE.toString() + "-16", "com.hp.mx.portal.bpv.MxBPVOverlordEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.CCLASS_SUBTYPE.toString() + "-8", "com.hp.mx.portal.bpv.MxBPVShortyEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.CCLASS_SUBTYPE.toString() + "-0", "com.hp.mx.portal.bpv.MxBPVOverlordEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.PCLASS_SUBTYPE.toString() + "-0", "com.hp.mx.portal.bpv.MxBPVIceServerEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.PCLASS_SUBTYPE.toString() + "-8", "com.hp.mx.portal.bpv.MxBPVIceServerEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.PCLASS_SUBTYPE.toString() + "-16", "com.hp.mx.portal.bpv.MxBPVTyphoonServerEnclosure");
        this.m_containerClasses.put(NodeSubTypeMapper.ECLASS_SUBTYPE.toString() + "-20", "com.hp.mx.portal.bpv.MxBPVGardianServerEnclosure");
    }

    public static MxBPVContainerObjectFactory getContainerFactoryInstance() {
        if (m_ContainerFactory == null) {
            m_ContainerFactory = new MxBPVContainerObjectFactory();
        }
        return m_ContainerFactory;
    }

    MxBPVServerEnclosure getContainerObject(String enclSubType, int maxNumSlots, MxNode enclNode, MxBPVElement rackElement, MxLoginBean loginBean) throws MxBPVException {
        LOGGER.enter(this.getClass().getName() + "getContainerObject(" + enclSubType + "," + maxNumSlots + ")");
        String className = this.m_containerClasses.get(enclSubType + "-" + maxNumSlots).toString();
        if (className == null) {
            LOGGER.fine("Class not found as the className was not present in theclasses hash map.");
            LOGGER.exit(this.getClass().getName() + "getContainerObject(" + enclSubType + "," + maxNumSlots + ")");
            throw new MxBPVException("Error creating BPV Container element.");
        }
        try {
            Class<?> bpvContainerElement = Class.forName(className);
            Class[] argArray = new Class[]{MxNode.class, MxBPVElement.class, MxLoginBean.class};
            Object[] objArray = new Object[]{enclNode, rackElement, loginBean};
            Object object = null;
            Constructor<?> constructor = null;
            try {
                constructor = bpvContainerElement.getConstructor(argArray);
                object = constructor.newInstance(objArray);
            }
            catch (SecurityException secExp) {
                LOGGER.fine("SecurityException:" + secExp.getMessage());
                throw new MxBPVException(secExp.getMessage());
            }
            catch (NoSuchMethodException noSuchMethExcep) {
                LOGGER.fine("NoSuchMethodException:" + noSuchMethExcep.getMessage());
                throw new MxBPVException(noSuchMethExcep.getMessage());
            }
            catch (IllegalArgumentException illArgExcep) {
                LOGGER.fine("IllegalArgumentException:" + illArgExcep.getMessage());
                throw new MxBPVException(illArgExcep.getMessage());
            }
            catch (InvocationTargetException invocTargetExcep) {
                LOGGER.fine("InvocationTargetException:" + invocTargetExcep.getMessage());
                throw new MxBPVException(invocTargetExcep.getMessage());
            }
            LOGGER.exit(this.getClass().getName() + "getContainerObject(" + enclSubType + "," + maxNumSlots + ")");
            return object;
        }
        catch (InstantiationException instExcep) {
            LOGGER.fine("InstantiationException:" + instExcep.getMessage());
        }
        catch (IllegalAccessException illAccessExcep) {
            LOGGER.fine("IllegalAccessException:" + illAccessExcep.getMessage());
        }
        catch (ClassNotFoundException classNtFndExcep) {
            LOGGER.fine("IllegalAccessException:" + classNtFndExcep.getMessage());
        }
        throw new MxBPVException("Error creating BPV Container element");
    }
}

