/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import org.jdom.Element;

public class MxBPVEmptySlot
extends MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVEmptySlot.class);
    boolean switchSlot;
    private int slotsUsedXDirection;
    private int slotsUsedYDirection;
    private String emptySlotForDevice = null;
    private String location = null;

    public MxBPVEmptySlot(boolean switchSlot, int slot, int slotsUsedXDirection, int slotsUsedYDirection) {
        super(null, null, null);
        this.switchSlot = switchSlot;
        this.deviceType = "EmptySlot";
        this.slotNumber = slot;
        this.location = switchSlot ? "Rear" : "Front";
        this.slotsUsedXDirection = slotsUsedXDirection;
        this.slotsUsedYDirection = slotsUsedYDirection;
    }

    public int getNumSlotsUsedXDir() {
        return this.slotsUsedXDirection;
    }

    public int getNumSlotsUsedYDir() {
        return this.slotsUsedYDirection;
    }

    public Element renderXML() {
        LOGGER.enter("MxBPVEmptySlot.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Element server = bpvXml.createDevice(this, true, this.loginBean);
        LOGGER.exit("MxBPVEmptySlot.renderXML()");
        return server;
    }

    public void setDeviceTypeForEmptySlot(String type) {
        LOGGER.fine("The Empty slot needs to be created for:" + type);
        this.emptySlotForDevice = type;
    }

    public JAXBObject renderJAXBXML() {
        LOGGER.enter("MxBPVEmptySlot:renderJAXBXML()");
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Device device = objFactory.createDevice();
            LOGGER.fine("The devicetype for Empty slot:" + this.emptySlotForDevice);
            device.setBayType(this.emptySlotForDevice);
            device.setLocation(this.location);
            device.setHasDevice("ABSENT");
            device.setSlotNumber(this.slotNumber);
            SlotsUsed slots = objFactory.createSlotsUsed();
            slots.setXDirection(this.slotsUsedXDirection);
            slots.setYDirection(this.slotsUsedYDirection);
            device.setSlotsUsed(slots);
            LOGGER.exit("MxBPVEmptySlot:renderJAXBXML()");
            return (JAXBObject)device;
        }
        catch (Exception je) {
            LOGGER.fine("Exception:MxBPVEmptySlot:renderJAXBXML()" + je);
            je.printStackTrace();
            LOGGER.exit("MxBPVEmptySlot:renderJAXBXML()");
            return null;
        }
    }
}

