/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;

public class MxBPVIceServerEnclosure
extends MxBPVServerEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVIceServerEnclosure.class);
    private final int numSlots = 10;
    private final int firstSlotNumber = 0;

    public MxBPVIceServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getNumSlots() {
        return 10;
    }

    public int getFirstSlotNumber() {
        return 0;
    }

    public void populateAll() throws Exception {
        LOGGER.enter("MxBPVIceServerEnclosure.populateAll()");
        LOGGER.fine("Enclosure Name:" + this.node.getNameString());
        LOGGER.fine("Collecting latest data for the enclosure.");
        this.m_BladeEnclosure = ILOHelper.getILOHelper().refreshBladeEnclosure(this.node);
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.setSize(this.getFirstSlotNumber() + this.getNumSlots());
        int slotNumber = this.getFirstSlotNumber();
        LOGGER.fine("Total Number of slots that we will run in a loop:" + this.getFirstSlotNumber() + this.getNumSlots());
        while (slotNumber < this.getFirstSlotNumber() + this.getNumSlots()) {
            LOGGER.fine("Current slotNumber/loop:" + slotNumber);
            if (slotNumber == this.getFirstSlotNumber() || slotNumber == this.getFirstSlotNumber() + this.getNumSlots() - 1) {
                LOGGER.fine("This is switch slot.:" + slotNumber);
                int pseudoSlot = slotNumber == 0 ? 0 : 9999;
                ArrayList elementList = this.getElementsForSlot(nodeClient, nodeAssociations, pseudoSlot);
                LOGGER.fine("The number of devices @ slot number :" + slotNumber + "is:" + elementList.size());
                boolean isDukesSwitch = false;
                if (elementList.size() > 0) {
                    LOGGER.fine("Switch present at slotnumber:" + slotNumber);
                    for (int i = 0; i < elementList.size(); ++i) {
                        MxBPVElement element = (MxBPVElement)elementList.get(i);
                        LOGGER.fine("Switch Name @ index :" + i + ":" + element.getName());
                        if (!(element instanceof MxBPVSwitch)) continue;
                        String dukesSwitch = element.getNode().getClientAttribute("LOCATION");
                        if (dukesSwitch != null && dukesSwitch.equalsIgnoreCase("RearUpperCube")) {
                            isDukesSwitch = true;
                            LOGGER.fine("Dukes switch present:" + element.getName() + "@ slot :" + element.getSlotNumber());
                            MxBPVElement parentElement = element.getParent();
                            if (parentElement != null) {
                                ++parentElement.numDukesSwitches;
                            }
                            if (element.getSlotNumber() == 0) {
                                parentElement.setDukesSlotNumbers(0);
                            } else {
                                parentElement.setDukesSlotNumbers(1);
                            }
                        }
                        this.setSlotNumber(pseudoSlot);
                        LOGGER.fine("pseudoSlot:" + pseudoSlot);
                        LOGGER.fine("getSlotNumber():" + this.getSlotNumber());
                        this.set(slotNumber, element);
                    }
                } else {
                    LOGGER.fine("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    LOGGER.fine("pseudoSlot:" + pseudoSlot);
                    LOGGER.fine("getSlotNumber():" + this.getSlotNumber());
                    this.set(slotNumber, emptySlot);
                }
                if (isDukesSwitch && elementList.size() == 1) {
                    LOGGER.fine("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    this.set(slotNumber, emptySlot);
                }
                ++slotNumber;
                continue;
            }
            LOGGER.fine("Empty Blade slot.");
            MxBPVElement element = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber);
            if (element != null) {
                this.set(slotNumber, element);
                slotNumber += element.getNumSlotsUsed();
                continue;
            }
            element = new MxBPVEmptySlot(false, slotNumber, 1, 2);
            this.set(slotNumber, element);
            ++slotNumber;
        }
        LOGGER.exit("MxBPVIceServerEnclosure.populateAll()");
    }
}

