/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitch;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVOverlordEnclosure;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.jdom.Element;

public class MxBPVSwitch
extends MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVSwitch.class);
    ObjectFactory m_objFactory = new ObjectFactory();
    int slotsOccupiedByXDirection;
    int slotsOccupiedByYDirection;

    public MxBPVSwitch(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.slotsOccupiedByXDirection = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.slotsOccupiedByYDirection = nodeAssociations.getNumBladeSlotsUsedYDir();
        this.deviceType = "Switch";
    }

    public int getNumSlotsUsedYDir() {
        return 2;
    }

    String getDrillDownURL() {
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN + "&globalselection=true";
    }

    public Element renderXML() {
        LOGGER.enter("MxBPVSwitch.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Element bpv_switch = bpvXml.createDevice(this, false, this.loginBean);
        LOGGER.exit("MxBPVSwitch.renderXML()");
        return bpv_switch;
    }

    public JAXBObject renderJAXBXML() {
        LOGGER.enter("MxBPVSwitch:renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType("Switch");
            device.setLocation("Rear");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            LOGGER.fine("Status of the switch is:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            status.setUID(deviceStatus);
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            return (JAXBObject)device;
        }
        catch (JAXBException je) {
            LOGGER.fine("JAXBException in MxBPVSwitch.renderJAXBXML" + (Object)((Object)je));
            return null;
        }
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVSwitch.setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            LOGGER.fine("X Direction:" + this.slotsOccupiedByXDirection);
            LOGGER.fine("Y Direction:" + this.slotsOccupiedByYDirection);
            slots.setXDirection(this.slotsOccupiedByXDirection);
            slots.setYDirection(this.slotsOccupiedByYDirection);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVSwitch.setSlotsInfoForDevice" + (Object)((Object)e));
        }
    }

    private void setCommonInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVSwitch.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(BPVXML.checkValue(this.node.getNameString(), this.loginBean));
            common.setProduct(BPVXML.checkValue(this.node.getModel(), this.loginBean));
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL());
            common.setIPAddress(BPVXML.checkValue(this.node.getWorkingAddress(), this.loginBean));
            common.setSerialNumber(BPVXML.checkValue(this.node.getSerialNumber(), this.loginBean));
            common.setFabricType(this.getMediaType(this.node));
            device.setCommon(common);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVSwitch.setCommonInfoForDevice" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVSwitch.setCommonInfoForDevice");
    }

    private String getMediaType(MxNode node) {
        LOGGER.enter("MxBPVSwitch.getMediaType(" + node + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        String mediaType = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.loginBean.getLocale());
        try {
            MxBPVOverlordEnclosure parent = (MxBPVOverlordEnclosure)this.getParent();
            OLSwitch olSwitch = (OLSwitch)oaHelper.getOLDevice(parent.m_enclosureObj, node.getDeviceKey());
            mediaType = MonteroResourceManager.getInstance().getString("xml." + olSwitch.getDeviceFabricType(), this.loginBean.getLocale());
        }
        catch (OAException e) {
            LOGGER.fine("Unable to obtain the OLSwitch object" + e);
        }
        LOGGER.fine("Media Type:" + mediaType);
        LOGGER.exit("MxBPVSwitch.getMediaType(" + node + ")");
        return mediaType;
    }
}

