/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.events;

import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.querymanager.DuplicateQueryException;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.UndefinedQueryException;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObjectFactory;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.portal.events.EventException;
import com.hp.mx.portal.events.EventManager;
import com.hp.mx.portal.events.Events;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;
import java.util.Vector;

public class EventsBean {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EventsBean.class);
    private CriteriaDataObjectFactory criteriaFactory;
    private MxQueryClient queryClient;
    private EventManager eventManager;
    private String deviceName;
    private String deviceType;
    private List subTypeList;

    public void init(MxNode mxNode, MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.init(" + mxNode + "," + loginBean + ")");
        this.queryClient = loginBean.getQueryClient();
        try {
            this.criteriaFactory = this.queryClient.getCriteriaFactory();
        }
        catch (MxException e) {
            LOGGER.error("EventsBean.init.Unable to get criteriaFactory object " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
            throw new EventException(e, "Unable to get criteria factory object");
        }
        this.deviceName = mxNode.getNameString();
        this.deviceType = mxNode.getDeviceType();
        this.eventManager = EventManager.getEventManager();
        this.subTypeList = mxNode.getDeviceSubTypes();
        LOGGER.fine("EventsBean.init.deviceName " + this.deviceName);
        LOGGER.fine("EventsBean.init.deviceType " + this.deviceType);
        LOGGER.exit("EventsBean.init(" + mxNode + "," + loginBean + ")");
    }

    public String[][] getBPVEventsList(MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.getBPVEventsList(" + loginBean + ")");
        String[][] bpvEventCatagories = MonteroResourceManager.getInstance().getBPVEventsCategories(loginBean.getLocale());
        if (this.subTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            bpvEventCatagories = MonteroResourceManager.getInstance().getBPVOverlordEventsCategories(loginBean.getLocale());
        }
        LOGGER.fine("EventsBean.getBPVEventsQueryIdList.bpvEventCatagories " + bpvEventCatagories);
        if (bpvEventCatagories == null) {
            throw new EventException("Unable to get events list for BPV");
        }
        LOGGER.exit("EventsBean.getBPVEventsList(" + loginBean + ")");
        return bpvEventCatagories;
    }

    public int getQueryId(String eventType, String filterQName, MxLoginBean loginBean) throws EventException, DuplicateQueryException, UndefinedQueryException, NumberFormatException, MxFailedAuthenticationException, MxInvalidTransactionException {
        LOGGER.enter("EventsBean.getQueryId(" + eventType + "," + loginBean + ")");
        Events eventsObj = this.eventManager.getEventInstance(eventType);
        LOGGER.fine("EventsBean.getQueryId eventsObj class name " + eventsObj.getClass().getName());
        Vector<Object> criteriaVector = eventsObj.getCriteriaList(this.criteriaFactory, this.deviceType, this.deviceName);
        LOGGER.exit("EventsBean.getQueryId(" + eventType + "," + loginBean + ")");
        int eventQId = this.getBPVEventQueryId(criteriaVector, this.queryClient, eventsObj.getEventString(), loginBean);
        if (filterQName != null && filterQName.length() != 0) {
            MxObjectID mergedQId = this.queryClient.mergeQueriesIntoDynamicEventQuery(this.queryClient.getQuery(filterQName).getObjectID(), this.queryClient.getQuery(eventQId).getObjectID());
            eventQId = this.queryClient.getQuery(mergedQId).getQueryId();
        }
        return eventQId;
    }

    private int getBPVEventQueryId(Vector criteriaVector, MxQueryClient queryClient, String queryString, MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.getBPVEventQueryId(" + criteriaVector + "," + queryClient + "," + queryString + "," + loginBean);
        int queryId = 0;
        Query query = null;
        try {
            query = queryClient.getQuery(this.deviceName + queryString);
        }
        catch (MxException e) {
            // empty catch block
        }
        LOGGER.fine("EventsBean.getBPVEventQueryId.query " + query);
        if (query != null) {
            queryId = query.getQueryId();
        } else {
            try {
                query = new Query(this.deviceName + queryString, "EventViews", criteriaVector);
                query.setDynamic(true);
                queryId = queryClient.addQuery(query, loginBean.getLocale());
            }
            catch (MxException e) {
                LOGGER.error("EventsBean.getBPVEventQueryId.Unable to create new query " + (Object)((Object)e));
                LOGGER.exception((Throwable)e);
                throw new EventException(e, "Unable to get new query ID " + (Object)((Object)e));
            }
        }
        LOGGER.fine("EventsBean.getBPVEventQueryId.queryId " + queryId);
        LOGGER.exit("EventsBean.getBPVEventQueryId(" + criteriaVector + "," + queryClient + "," + queryString + "," + loginBean);
        return queryId;
    }
}

