/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.license;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.license.LicenseManager;
import com.hp.mx.portal.lm.lmBean;
import com.hp.mx.utilities.DebugSubsystem;

public class PMPLicense
extends LicenseManager {
    private static final DebugSubsystem LOGGER;
    private final String PMP_PRODUCT_CODE = "4";
    private final String PMP_PRO_VER_CODE = "1";
    private final String PMP_PRONAME_PRESENTATION = "Performance Management Pack";
    private final String PMP_PRO_VER_PRESENCODE = "1";
    private static boolean m_isPMPInstalled;
    private static PMPLicense m_pmpLicManager;

    private PMPLicense() {
        this.m_lmBean = new lmBean();
        this.m_proCode = "4";
        this.m_proVerCode = "1";
        this.m_proPresName = "Performance Management Pack";
        this.m_proPresVerCode = "1";
    }

    public static PMPLicense getLicenseManager() {
        if (m_pmpLicManager == null) {
            m_pmpLicManager = new PMPLicense();
        }
        return m_pmpLicManager;
    }

    public boolean isNodePMPLicensed(int deviceKey) {
        LOGGER.enter("LicenseManager.isNodePMPLicensed(" + deviceKey + ")");
        LOGGER.fine("m_isPMPInstalled:" + m_isPMPInstalled);
        boolean isPMPLicensed = false;
        if (!m_isPMPInstalled) {
            LOGGER.fine("PMP is not installed,Hence returning false.");
            isPMPLicensed = false;
            LOGGER.fine("isPMPLicensed:" + isPMPLicensed);
            LOGGER.exit("LicenseManager.isNodePMPLicensed(" + deviceKey + ")");
            return isPMPLicensed;
        }
        try {
            MxNode devNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
            String isCMS = devNode.getClientAttribute("hp.hpsim.iscms");
            if (isCMS != null && isCMS.equalsIgnoreCase("true")) {
                LOGGER.fine("Node is a CMS Server,CMS Serversare have free PMP license.");
                isPMPLicensed = true;
            } else {
                isPMPLicensed = this.isNodeLicensed(deviceKey);
            }
        }
        catch (MxUndefinedNodeException undefExcep) {
            LOGGER.error("Node is not defined, deviceKey" + deviceKey, new Object[]{undefExcep});
            isPMPLicensed = false;
        }
        LOGGER.fine("isPMPLicensed:" + isPMPLicensed);
        LOGGER.exit("LicenseManager.isNodePMPLicensed(" + deviceKey + ")");
        return isPMPLicensed;
    }

    private static void isPMPInstalled() {
        String pmpInstalled = GlobalSettings.getProperty((String)"PerformanceModuleInstalled");
        if (pmpInstalled != null && pmpInstalled.equalsIgnoreCase("YES")) {
            m_isPMPInstalled = true;
        }
    }

    static {
        PMPLicense.isPMPInstalled();
        LOGGER = new DebugSubsystem(PMPLicense.class);
    }
}

