/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.tools.urack.URackController;
import com.hp.mx.html.core.MxButtons;
import com.hp.mx.html.core.MxDefaultTag;
import com.hp.mx.html.core.MxTag;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.list.MxSystemsListRenderer;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class BPVButtonsList {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(BPVButtonsList.class);
    private MonteroResourceManager m_manager = MonteroResourceManager.getInstance();

    public void addSystemsListButtons(HttpServletRequest request, MxLoginBean loginBean, MxSystemsListRenderer listRenderer, JspWriter out) throws IOException {
        LOGGER.enter("BPVButtonsList:Skin.dumpSystemsListButtons()");
        if (listRenderer.m_bSuppressSaveAs && listRenderer.m_bSuppressInteractionButtons) {
            return;
        }
        MxButtons buttons = new MxButtons();
        buttons.setPadding(new int[]{6, 6, 6, 6});
        buttons.clearMxTags();
        buttons.setId("ID_BOTTOM_BUTTON_ROW");
        MxNode rackNode = null;
        try {
            String guiD = request.getParameter("target");
            if (guiD != null && guiD.length() > 0 && !guiD.equalsIgnoreCase("All e-Class Enclosures")) {
                MxObjectID objID = new MxObjectID(new MxGUID(guiD));
                MxNodeClient nodeClient = loginBean.getNodeCtlr();
                rackNode = nodeClient.getNode(objID, false);
            }
        }
        catch (Exception e) {
            System.out.println("exception" + e);
        }
        if (!listRenderer.m_bSuppressInteractionButtons && listRenderer.m_bHasDeletePriv && rackNode != null && rackNode.getDeviceType().equals("Rack")) {
            this.addMxTag("Edit", this.m_manager.getString("uRack.EditRack", loginBean.getLocale()), "editButtonClicked()", "false", buttons);
        }
        if (!listRenderer.m_bSuppressSaveAs) {
            this.addMxTag("ID_SAVE_AS_BUTTON", listRenderer.m_ResourceBean.get("SaveSelectionAs"), "saveSelectionButtonClicked()", "true", buttons);
        }
        if (!listRenderer.m_bSuppressInteractionButtons) {
            if (listRenderer.m_bHasDeletePriv) {
                this.addMxTag("ID_DELETE_BUTTON", listRenderer.m_ResourceBean.get("Delete"), "deleteButtonClicked()", "true", buttons);
            }
            this.addMxTag("ID_PRINT_BUTTON", listRenderer.m_ResourceBean.get("Print"), "printButtonClicked()", "false", buttons);
        }
        buttons.dumpButtons((Writer)out);
        LOGGER.exit("BPVButtonsList:Skin.dumpSystemsListButtons()");
    }

    public void dumpIframes(MxSystemsListRenderer listRenderer, JspWriter out) throws IOException {
        out.print("<iframe id='resultSpace' name='resultSpace' ");
        out.print("src='/ui/jsp/EmptyFrame.jsp' width='100%' height='0' frameborder='0'></iframe>");
        out.print("<iframe id='ID_TABLE_ACTION_IFRAME' name='ID_TABLE_ACTION_IFRAME' ");
        out.print("style='position:relative; visibility:hidden; width:0; height:0' ");
        out.print("src='/ui/jsp/EmptyFrame.jsp'></iframe>");
    }

    public boolean deleteRackNode(MxLoginBean loginBean, int rDeviceKey) {
        LOGGER.enter("BPVButtonsList:deleteRackNode for " + rDeviceKey);
        boolean isDeletted = false;
        MxObjectID nodeID = null;
        try {
            MxNode rackNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(rDeviceKey);
            MxGUID rGUID = rackNode.getGUID();
            nodeID = new MxObjectID(rGUID);
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            Vector associatedDeviceKeyVect = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(rDeviceKey, "EnclosureToRack");
            URackController uRackController = new URackController();
            for (int j = 0; j < associatedDeviceKeyVect.size(); ++j) {
                MxNode theOldEncl = null;
                try {
                    Vector associateSwicthes;
                    theOldEncl = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)associatedDeviceKeyVect.elementAt(j)).intValue());
                    theOldEncl.setRackName("");
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theOldEncl, false);
                    Vector associatedServers = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(theOldEncl.getDeviceKey(), "ServerToEnclosure");
                    if (associatedServers.size() > 0) {
                        uRackController.setRackNameOnMxNode(associatedServers, "");
                    }
                    if ((associateSwicthes = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(theOldEncl.getDeviceKey(), "SwitchToEnclosure")).size() <= 0) continue;
                    uRackController.setRackNameOnMxNode(associateSwicthes, "");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            uRackController.cleanRackTopology(rDeviceKey);
            myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(rDeviceKey, "EnclosureToRack");
            loginBean.getNodeClient().deleteNode(nodeID);
            isDeletted = true;
        }
        catch (Exception e1) {
            LOGGER.error("excpetion while deleting" + e1);
        }
        LOGGER.exit("BPVButtonsList:deleteRackNode");
        return isDeletted;
    }

    public void addMxTag(String id, String label, String URL2, String disabled, MxButtons buttons) {
        MxDefaultTag btnTag = new MxDefaultTag(id, label, URL2);
        btnTag.setAttr("disabled", (Object)disabled);
        buttons.addMxTag((MxTag)btnTag);
    }
}

