/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.nodesecurity.MxNodeSecurityHandler;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonteroSNMPUtils {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroSNMPUtils.class);
    private MxLoginBean m_loginBean;
    private String sysRomFMVer = null;
    private String remoteInsightROMFMVer = null;

    public MonteroSNMPUtils(MxLoginBean loginBean) {
        this.m_loginBean = loginBean;
    }

    public synchronized ArrayList<String> getSNMPData(MxNode deviceObject, String pOid, boolean convert) {
        LOGGER.enter("MonteroSNMPUtils.getSNMPData()");
        LOGGER.fine("pOid:" + pOid);
        LOGGER.fine("device Name:" + deviceObject.getNameString());
        String status = null;
        try {
            status = deviceObject.getOverallStatus().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> snmpData = new ArrayList<String>();
        if (status != null && !status.equalsIgnoreCase(DeviceStatusType.CRITICAL.toString())) {
            if (!MonteroSNMPUtils.checkSNMP(deviceObject)) {
                LOGGER.fine("SNMP Not supported , SNMP Data will not be retrieved for this device.");
            } else {
                SnmpRequest snmpReq = new SnmpRequest();
                snmpReq.setDeviceAddress(deviceObject.getWorkingAddress());
                snmpReq.setCommunityName(MxNodeSecurityHandler.getSnmpMonitorCommunityString((MxNode)deviceObject));
                snmpReq.setTimeout("" + deviceObject.getSnmpTimeOut());
                snmpReq.setNumberOfRetries("" + deviceObject.getSnmpRetry());
                SnmpResponseVarBind vb = null;
                snmpReq.setAsn1Numbers(pOid + "[0]");
                while (true) {
                    snmpReq.SnmpGetNext();
                    SnmpResponse curResp = snmpReq.getResponseVarbinds();
                    vb = curResp.findById(0);
                    if (vb == null || vb.isError()) {
                        LOGGER.fine("End of reading the MIB Tree for the device with IP:" + deviceObject.getWorkingAddress());
                        break;
                    }
                    String val = vb.getValue();
                    String oid = vb.getOid();
                    if (!oid.startsWith(pOid)) break;
                    LOGGER.fine("Value from the Tree:" + val);
                    if (convert) {
                        try {
                            val = Integer.toString(vb.getIntValue());
                        }
                        catch (NumberFormatException numFmtException) {
                            val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                            LOGGER.fine("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + numFmtException);
                        }
                        catch (Exception e) {
                            LOGGER.fine("Exception while retreiving data from SNMP" + e);
                            e.printStackTrace();
                        }
                    }
                    if (val == null || val == "" || val.length() == 0) {
                        val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                    }
                    snmpData.add(val.trim());
                    LOGGER.fine("Value from the Tree:" + val);
                    snmpReq.clearSnmpReqInfo();
                    snmpReq.addSnmpGetVarbind(oid, "0");
                }
            }
        }
        LOGGER.exit("MonteroSNMPUtils.getSNMPData()");
        return snmpData;
    }

    public static HashMap getMIBData(String oid, SnmpProtocolDataHandler snmpPdh, boolean isOidKey) {
        LOGGER.enter("MonteroSNMPUtils.getMIBData(" + oid + ")");
        HashMap<String, String> dataFrmMIB = new HashMap<String, String>();
        String oidFrmMIB = null;
        String uid = null;
        SnmpRequest req = snmpPdh.getSnmpRequest();
        if (req == null) {
            LOGGER.fine("SnmpRequest is null");
            LOGGER.fine("End:MonteroSNMPUtils.getMIBData(" + oid + ")");
            return dataFrmMIB;
        }
        snmpPdh.getSnmpRequest().setAsn1Numbers(oid);
        String data = null;
        while (true) {
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            uid = oid.substring(oid.indexOf(91) + 1, oid.indexOf(93));
            SnmpResponseVarBind resVarBnd = uid == null || uid.length() <= 0 ? curResp.findResponse(oid) : curResp.findById(Integer.parseInt(uid));
            if (resVarBnd == null || resVarBnd.isError()) break;
            oidFrmMIB = resVarBnd.getOid();
            LOGGER.fine("oidFrmMIB:" + oidFrmMIB);
            LOGGER.fine("vb0.getValueType():" + resVarBnd.getValueType());
            if (!oidFrmMIB.startsWith(oid.substring(0, oid.indexOf(91)))) break;
            data = resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("INTEGER") ? resVarBnd.getIntValue() + "" : (resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("OCTETSTRING") ? resVarBnd.getMACAddrValue() : resVarBnd.getValue())));
            LOGGER.fine("dataFrmMIB :" + data);
            if (data == null || data.length() == 0 || data.equals("")) {
                data = "";
            }
            if (data != null) {
                if (!isOidKey) {
                    dataFrmMIB.put(data, oidFrmMIB);
                } else {
                    dataFrmMIB.put(oidFrmMIB, data);
                }
            }
            snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            if (uid == null || uid.length() <= 0) {
                uid = "0";
            }
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(oidFrmMIB, uid);
        }
        LOGGER.exit("MonteroSNMPUtils.getMIBData(" + oid + ")");
        return dataFrmMIB;
    }

    public static String getMIBDataValue(String oid, MxNode node) {
        LOGGER.enter("MonteroSNMPUtils.getMIBDataValue(" + oid + "," + node + ")");
        SnmpProtocolDataHandler snmpPdh = new SnmpProtocolDataHandler(node);
        String dataFrmMIB = null;
        String oidFrmMIB = null;
        String uid = null;
        SnmpRequest req = snmpPdh.getSnmpRequest();
        if (req == null) {
            LOGGER.fine("SnmpRequest is null");
            LOGGER.exit("MonteroSNMPUtils.getMIBDataValue(" + oid + "," + node + ")");
            return dataFrmMIB;
        }
        snmpPdh.getSnmpRequest().setAsn1Numbers(oid);
        snmpPdh.getSnmpRequest().SnmpGet();
        SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
        uid = oid.substring(oid.indexOf(91) + 1, oid.indexOf(93));
        SnmpResponseVarBind resVarBnd = uid == null || uid.length() <= 0 ? curResp.findResponse(oid) : curResp.findById(Integer.parseInt(uid));
        if (resVarBnd == null || resVarBnd.isError()) {
            return dataFrmMIB;
        }
        oidFrmMIB = resVarBnd.getOid();
        LOGGER.fine("oidFrmMIB:" + oidFrmMIB);
        LOGGER.fine("vb0.getValueType():" + resVarBnd.getValueType());
        dataFrmMIB = resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("INTEGER") ? resVarBnd.getIntValue() + "" : (resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : resVarBnd.getValue()));
        LOGGER.fine("dataFrmMIB :" + dataFrmMIB);
        LOGGER.exit("MonteroSNMPUtils.getMIBDataValue(" + oid + "," + node + ")");
        return dataFrmMIB;
    }

    public static boolean checkSNMP(MxNode deviceObject) {
        LOGGER.enter("MonteroSNMPUtils.checkSNMP(" + deviceObject + ")");
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        boolean retVal = true;
        if (!snmpEnabled.equals("checked")) {
            LOGGER.fine("SNMP check in the GlobalSetting is disabled for " + deviceObject.getWorkingAddress());
            retVal = false;
        }
        if (deviceObject.getWorkingAddress() == null) {
            LOGGER.fine("Ipaddress is null for this deviceObject");
            retVal = false;
        }
        if (!deviceObject.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            LOGGER.fine("SNMP Protocol not supported by device with IP:" + deviceObject.getWorkingAddress());
            retVal = false;
        }
        LOGGER.fine("SNMP supported for this device:" + retVal);
        LOGGER.exit("MonteroSNMPUtils.checkSNMP(" + deviceObject + ")");
        return retVal;
    }

    public void getFirmwareDetails(MxNode d) {
        LOGGER.enter("MonteroSNMPUtils.getFirmWareDetails(MxNode " + d.getNameString() + ")");
        SnmpProtocolDataHandler snmpPdh = new SnmpProtocolDataHandler(d);
        snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.11.2.14.1.1.3[0],1.3.6.1.4.1.232.11.2.14.1.1.4[1],1.3.6.1.4.1.232.11.2.14.1.1.5[2]");
        String fwVersionDeviceTypeOID = null;
        String fwVersionDeviceNameOID = null;
        String fmVersionOID = null;
        while (true) {
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError() || (vb1 = curResp.findById(1)) == null || vb1.isError() || (vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            fwVersionDeviceTypeOID = vb.getOid();
            fwVersionDeviceNameOID = vb1.getOid();
            fmVersionOID = vb2.getOid();
            if (!fwVersionDeviceTypeOID.startsWith("1.3.6.1.4.1.232.11.2.14.1.1.3.")) break;
            int fwDeviceType = vb.getIntValue();
            if (fwDeviceType == 23) {
                this.sysRomFMVer = vb2.getValue();
                LOGGER.fine("The system ROM Version:" + this.sysRomFMVer);
            } else if (fwDeviceType == 25) {
                this.remoteInsightROMFMVer = vb2.getValue();
                LOGGER.fine("The Remote Insight ROM Version" + this.remoteInsightROMFMVer);
            }
            snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(fwVersionDeviceTypeOID, "0");
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(fwVersionDeviceNameOID, "1");
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(fmVersionOID, "2");
        }
        LOGGER.exit("MonteroSNMPUtils.getFirmWareDetails");
    }

    public String getSysROMFMVer() {
        return this.sysRomFMVer;
    }

    public String getRemoteInsightROMFMVer() {
        return this.remoteInsightROMFMVer;
    }

    public String getInsightMgmtVersion(MxNode node) {
        LOGGER.enter("MonteroSNMPUtils.getInsightMgmtVersion(" + node + ")");
        String mgmtAgentString = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.7.2.1.5.0[0]", node);
        String insightMgmtAgentVersion = null;
        if (mgmtAgentString != null && mgmtAgentString.matches("HP Insight Management Agents.*")) {
            insightMgmtAgentVersion = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.7.2.1.8.0[0]", node);
        } else {
            ArrayList<Object> listOfSoftwares = new ArrayList();
            listOfSoftwares = this.getSNMPData(node, "1.3.6.1.4.1.232.11.2.7.2.1.5", false);
            Iterator<Object> iter = listOfSoftwares.iterator();
            int i = 0;
            while (iter.hasNext()) {
                mgmtAgentString = (String)iter.next();
                if (mgmtAgentString != null && mgmtAgentString.toLowerCase().contains("insight management agents")) {
                    LOGGER.exit("MonteroSNMPUtils.getInsightMgmtVersion");
                    insightMgmtAgentVersion = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.7.2.1.8." + i + "[0]", node);
                    break;
                }
                ++i;
            }
        }
        LOGGER.fine("insightMgmtAgentVersion:" + insightMgmtAgentVersion);
        LOGGER.exit("MonteroSNMPUtils.getInsightMgmtVersion(" + node + ")");
        return insightMgmtAgentVersion;
    }
}

