<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

  <xsl:include href="PortMapConstants.xsl" />
    <xsl:include href="PortStatusTemplates.xsl" />


<xsl:template match="*">
<head>
<link href="/mxportal/bladeime/skin/portMapping/css/default.css" type="text/css" rel="stylesheet"/>
<script language="Javascript" src="/mxportal/bladeime/skin/js/Skin.js" type="text/javascript">Skinnable view scripts</script>
</head>
<table border="0" cellpadding="0" cellspacing="0" class="treeTable">
            <thead>
                <tr class="captionRow">
                    <th><xsl:value-of select="//I18N/L10NMezzanine"></xsl:value-of>
                    <br><xsl:value-of select="//I18N/L10NMezzSlot"></xsl:value-of></br></th>
					<th><xsl:value-of select="//I18N/L10NMezzDeviceName"></xsl:value-of></th>
					<th><xsl:value-of select="//I18N/L10NMezzanine"></xsl:value-of>
					<br><xsl:value-of select="//I18N/L10NDevicePort"></xsl:value-of></br></th>
					<th><xsl:value-of select="//I18N/L10NPortStatus"></xsl:value-of></th>
                    <th><xsl:value-of select="//I18N/L10NInterConnect"></xsl:value-of>
                    <br><xsl:value-of select="//I18N/L10NBay"></xsl:value-of></br></th>
                    <th><xsl:value-of select="//I18N/L10NInterConnect"></xsl:value-of>
                    <br><xsl:value-of select="//I18N/L10NBayPort"></xsl:value-of> </br></th>
                    <th><xsl:value-of select="//I18N/L10NDeviceID"></xsl:value-of></th>
                    <th><xsl:value-of select="//I18N/L10NInterfaceName"></xsl:value-of></th>
                </tr>
            </thead>
            <tbody>
            <xsl:choose>
				<xsl:when test="ServerDevice/HasPortMapInfo=$PORTMAP_INFO_ABSENT">
					<tr class="treeTableTopLevel">
					<td align="center">
						<xsl:attribute name="colspan">
							<xsl:value-of select="$NUM_COLS_BLADEPORTMAP"/>
						</xsl:attribute>
						<xsl:value-of select="//I18N/L10NNotAvailable"></xsl:value-of>
					</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<!-- Rendering the Fixed NICS first -->
					<xsl:for-each select="ServerDevice/MEZZDevice">
						<xsl:if test="MezzSlotType='MEZZ_SLOT_TYPE_FIXED' or MezzSlotType='MEZZ_DEV_TYPE_FIXED' ">
							<xsl:call-template name="mezzTableRow" /> 
						</xsl:if>
					</xsl:for-each> 
					<xsl:for-each select="ServerDevice/MEZZDevice">
						<xsl:if test="MezzSlotType!='MEZZ_DEV_TYPE_FIXED' and MezzSlotType!='MEZZ_SLOT_TYPE_FIXED'">
							<xsl:call-template name="mezzTableRow" /> 
						</xsl:if>	
					</xsl:for-each> 
				</xsl:otherwise>
			</xsl:choose>
	</tbody>
	</table>
</xsl:template>

<xsl:template name="mezzTableRow">

	<xsl:variable name="MezzSlot" select="MezzSlot" />

		<tr class="treeTableTopLevel">
			<td class="sorted">
				<b>
						<xsl:value-of select="MezzSlot"/>
				</b>
			</td>
			<td colspan="7">
				<b>
						<xsl:value-of select="MezzSlotName"/>
				</b>
			</td>
		</tr>
		<xsl:if test="MezzSlotName != //I18N/L10NNoCardPresent">
			<xsl:for-each select="MezzPort">
				<xsl:variable name="slotNumber" select="MezzDevicePort" />
					<xsl:if test="count(current()[InterConnectBay=0])=0"> 
						<xsl:call-template name="renderPort">
							<xsl:with-param name="portStatusString" select="PortStatus/PortStatusString"/>
							<xsl:with-param name="mezzSlotType" select="../MezzSlotType"/>
							<xsl:with-param name="slotNumber" select="$slotNumber"/>
							<xsl:with-param name="portStatusValue" select="PortStatus/PortStatusValue"/>
							<xsl:with-param name="interConnectBay" select="InterConnectBay"/>
							<xsl:with-param name="interConnectBayPort" select="InterConnectBayPort"/>
							<xsl:with-param name="deviceID" select="DeviceID"/>
							<xsl:with-param name="interfaceName" select="InterfaceName"/>
						</xsl:call-template>
						<xsl:if test="iSCSI != '' ">
							<xsl:call-template name="renderPort">
								<xsl:with-param name="portStatusString" select="PortStatus/PortStatusString"/>
								<xsl:with-param name="mezzSlotType" select="'iSCSI'"/>
								<xsl:with-param name="slotNumber" select="$slotNumber"/>
								<xsl:with-param name="portStatusValue" select="PortStatus/PortStatusValue"/>
								<xsl:with-param name="interConnectBay" select="InterConnectBay"/>
								<xsl:with-param name="interConnectBayPort" select="InterConnectBayPort"/>
								<xsl:with-param name="deviceID" select="iSCSI"/>
								<xsl:with-param name="interfaceName" select="//I18N/L10NNotAvailable"/>
							</xsl:call-template>
						</xsl:if> 
					</xsl:if> 
				</xsl:for-each>
			</xsl:if>
	</xsl:template>

<xsl:template name="renderPort">
	<xsl:param name="portStatusString"/>
	<xsl:param name="mezzSlotType"/>
	<xsl:param name="slotNumber"/>
	<xsl:param name="portStatusValue"/>
	<xsl:param name="interConnectBay"/>
	<xsl:param name="interConnectBayPort"/>
	<xsl:param name="deviceID"/>
	<xsl:param name="interfaceName"/>
	
		<xsl:element name="tr">
			<xsl:variable name="portStatus" select="$portStatusString"/>
				<xsl:if test="$portStatus = $STATUS_MISMATCH"> 
					<xsl:attribute name="class">mismatchRow</xsl:attribute>
				</xsl:if> 
			<td class="nested1 sorted"></td>
			<td>&#160;</td>
			<td>
				<xsl:choose>
					<xsl:when test="$mezzSlotType=$DEV_FIXED_TYPE">
						<xsl:value-of select="//I18N/L10NENET"/>
					</xsl:when>
					<xsl:when test="$mezzSlotType='iSCSI'">
						<xsl:value-of select="//I18N/L10NISCSI"/>&#160;<xsl:value-of select="//I18N/L10NPort"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="//I18N/L10NPort"/>
					</xsl:otherwise>
				</xsl:choose>	
							&#160;<xsl:value-of select="$slotNumber"/>
			</td>
			<td nowrap="true">
				<xsl:if test="$portStatus != $STATUS_UNKNOWN">
					<xsl:call-template name="getStatusLabel">
						<xsl:with-param name="statusCode" select="$portStatus" />
					</xsl:call-template>&#160;
					
					<xsl:value-of select="$portStatusValue"></xsl:value-of>
				</xsl:if> 
			</td>
			<td>
				<xsl:element name="img">
					<xsl:attribute name="width">13</xsl:attribute>
					<xsl:attribute name="height">13</xsl:attribute>
					<xsl:attribute name="src">
						<xsl:value-of select="concat($INTERCONNECT_BAY_IMAGE,InterConnectBay, '.gif')"/>
					</xsl:attribute>
				</xsl:element>&#160;
				<xsl:value-of select="//I18N/L10NBay"/>&#160;
				<xsl:value-of select="$interConnectBay"/>
			</td>
			<td>
				<xsl:value-of select="$interConnectBayPort"/>
			</td>
			<td nowrap="true">
				<xsl:value-of select="$deviceID"/>
			</td>
			<td nowrap="true">
				<xsl:value-of select="$interfaceName"/>
			</td>
		</xsl:element>
</xsl:template>
</xsl:stylesheet>