<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">
	
	<!-- NOTE: The global templates file depends on the guiConstants.xsl file. -->
	
	<!--
		Status icon template. Takes a status code as a parameter and returns
		an img element with the correct status image path.
	-->
	<xsl:template name="statusIconLink">
		<!-- Icon status code -->
		<xsl:param name="statusCode" />
		<xsl:param name="titleMsg" />
		<xsl:param name="URL" />
		<xsl:param name="fallBackURL" />
		
		<img>
			<!-- Image size and border attributes -->
			<xsl:attribute name="border">0</xsl:attribute>
			<!-- Determine the icon image's src attribute based on status parameter -->
			<xsl:attribute name="src">
				<xsl:value-of select="$STATUS_PATH"/><xsl:value-of select="$statusCode"/><xsl:text>_15.gif</xsl:text>
			</xsl:attribute>
                <xsl:variable name="toolTip1">
					<xsl:choose>
						<xsl:when test="$titleMsg!=''">
							<xsl:value-of select="$titleMsg"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$statusCode"/>	
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
			<xsl:attribute name="onmouseout"><xsl:text>removeDeviceInfoTip();</xsl:text></xsl:attribute>
			<xsl:attribute name="onmouseover"><xsl:text>try{loadDeviceInfoTip(event,'</xsl:text><xsl:value-of select="$toolTip1"/><xsl:text>');}catch(e) {loadDeviceInfoTip(null,'</xsl:text><xsl:value-of select="$toolTip1"/><xsl:text>');}</xsl:text></xsl:attribute>
			
			<xsl:choose>
				<xsl:when test="$URL!=''">
					<xsl:attribute name="onclick"><xsl:text>openNewWindow('</xsl:text><xsl:value-of select="$URL"/><xsl:text>')</xsl:text></xsl:attribute>		
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="onclick"><xsl:text>drillDown('</xsl:text><xsl:value-of select="$fallBackURL"/><xsl:text>')</xsl:text></xsl:attribute>		
				</xsl:otherwise>
			</xsl:choose>		
		</img>
	</xsl:template>
	

	<!--
		Status icon template. Takes a status code as a parameter and returns
		an img element with the correct status image path.
	-->
	<xsl:template name="statusIcon">
		<!-- Icon status code -->
		<xsl:param name="statusCode" />
		<xsl:param name="titleMsg" />
		
		<img border="0" style="cursor:default">
			<!-- Determine the icon image's src attribute based on status parameter -->
			<xsl:attribute name="src">
				<xsl:value-of select="$STATUS_PATH"/><xsl:value-of select="$statusCode"/><xsl:text>_15.gif</xsl:text>
			</xsl:attribute>
                <xsl:variable name="toolTip2">
				<xsl:choose>
					<xsl:when test="$titleMsg!=''">
						<xsl:value-of select="$titleMsg"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$statusCode"/>	
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="onmouseout"><xsl:text>removeDeviceInfoTip();</xsl:text></xsl:attribute>
			<xsl:attribute name="onmouseover"><xsl:text>try{loadDeviceInfoTip(event,'</xsl:text><xsl:value-of select="$toolTip2"/><xsl:text>');}catch(e) {loadDeviceInfoTip(null,'</xsl:text><xsl:value-of select="$toolTip2"/><xsl:text>');}</xsl:text></xsl:attribute>


		</img>
	</xsl:template>

	<!--
		Status icon template for creating status image without ToolTip. 
		Takes a status code as a parameter and returns
		an img element with the correct status image path.
	-->
	<xsl:template name="statusIconNoToolTip">
		<!-- Icon status code -->
		<xsl:param name="statusCode" />
			
		<img border="0" style="cursor:default">
			<!-- Determine the icon image's src attribute based on status parameter -->
			<xsl:attribute name="src">
				<xsl:value-of select="$STATUS_PATH"/><xsl:value-of select="$statusCode"/><xsl:text>_15.gif</xsl:text>
			</xsl:attribute>
		</img>
	</xsl:template>
	
	<!--
		Traverses all the member nodes of the current device node and retreives the value of the member specified by the name as a parameter memberName 
	-->
	<xsl:template name="getMember">
		<xsl:param name="memberName" />
		<xsl:param name="type" />		
			<xsl:for-each select="./Attribute">
				<xsl:if test="./Name=$memberName ">
						<xsl:value-of select="./Value"/>
				</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!--
		Traverses all the member nodes of the current device node and retreives the value of the member specified by the name as a parameter memberName 
	-->
	<xsl:template name="getMemberAttr">
		<xsl:param name="memberName" />
		<xsl:param name="location" />
		<xsl:param name="type" />		
			<xsl:for-each select="./Attribute[@location=$location and Name=$memberName]">
					<xsl:value-of select="./Value"/>
			</xsl:for-each>
	</xsl:template>

	<!--
		Traverses all the Attibute nodes of the current device node and retreives the value of the node attribute specified by the name as a parameter attribName , Attibute Name is
		hardcoded to URL
	-->
	<xsl:template name="getNodeAttribute">
		<xsl:param name="memberName" />
		<xsl:param name="attribName"/>
		
			<xsl:for-each select="./Attribute">
				<xsl:if test="./Name=$memberName ">
						<xsl:value-of select="./@URL"/>
				</xsl:if>
		</xsl:for-each>
	</xsl:template>

<!-- Template to compute the title slot number 
20/25 p Bay 1
40p Bay 1-4
45p Bay 1-2
-->
<xsl:template name="computeTitleBay">
<xsl:param name="slotNumber"/>
<xsl:param name="slotsXDirect"/>
<xsl:param name="slotsYDirect"/>
<xsl:param name="enclosureSubType"/>

<xsl:choose>
	<xsl:when test="$slotNumber!=0 and $slotNumber!=9999">
			<xsl:choose>
				<xsl:when test="$enclosureSubType='c3000'">
					<xsl:choose>
						<xsl:when test="number($slotsYDirect)=1">
							<xsl:value-of select="$slotNumber"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$slotNumber"/><xsl:text>-</xsl:text><xsl:value-of select="number($slotNumber) + number($slotsYDirect) -1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>	
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="number($slotsXDirect)=1">
							<xsl:value-of select="$slotNumber"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$slotNumber"/><xsl:text>-</xsl:text><xsl:value-of select="number($slotNumber) + number($slotsXDirect) -1"/>
						</xsl:otherwise>
					</xsl:choose>		
				</xsl:otherwise>
			</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
		<xsl:choose>
			<xsl:when test="$slotNumber=0">
				<xsl:value-of select="//I18N/L10NA"/>
			</xsl:when>
			<xsl:when test="$slotNumber=9999">
				<xsl:value-of select="//I18N/L10NB"/>
			</xsl:when>
		</xsl:choose>
	</xsl:otherwise>
</xsl:choose>
	
</xsl:template>

<!-- Template to include all the js and css files -->
	<xsl:template name="Head">
		<head>
			<link href="/mxportal/bladeime/skin/css/default.css" type="text/css" rel="stylesheet"/>
			<link href="/mxportal/bladeime/skin/css/blue_theme.css" type="/text/css" rel="stylesheet"/>
			<link href="/mxportal/bladeime/skin/css/MxPortalEx.css" type="/text/css" rel="stylesheet"/>
			<link href="/mxportal/bladeime/skin/css/widgets.css" type="text/css" rel="stylesheet"/>
			<script language="Javascript" src="/mxportal/bladeime/skin/js/tableManager.js" type="text/javascript">Table manipulation script</script>
			<script language="Javascript" src="/mxportal/bladeime/skin/js/global.js" type="text/javascript">Global script</script>
            <script language="Javascript" src="/mxportal/bladeime/skin/js/Skin.js" type="text/javascript">Skinnable view scripts</script>
		</head>
	</xsl:template>

<!-- Template to render the View as combo box -->
<xsl:template name="renderViewAsBox">
	<table border="0" cellpadding="0" cellspacing="0" id="ViewAsCombo">
		<tbody>
			<tr>
				<td>
					<xsl:value-of select="//I18N/L10NViewAs"/>
				</td>
				<td>
					<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
				</td>
				<td>
					<select ID="idSelectView" size="1" onchange="onViewChange(this);">
						<xsl:for-each select="//Attribute[@Section='NavigationURL']">
							<xsl:choose>
								<xsl:when test="./@Selected='No'">
									<option>
										<xsl:attribute name="value"><xsl:value-of select="./Value"/></xsl:attribute>
										<xsl:value-of select="./Name"/>
									</option>
								</xsl:when>
								<xsl:otherwise>
									<option selected="selected">
										<xsl:attribute name="value"><xsl:value-of select="./Value"/></xsl:attribute>
										<xsl:value-of select="./Name"/>
									</option>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</tbody>
	</table>
</xsl:template>

<!-- Renders the check boxes -->
<xsl:template name="drawCheckBox">
	<xsl:param name="checkBoxName"/>
	<xsl:param name="typeOfDisplay"/>
	<xsl:param name="checkBoxId"/>
	<xsl:param name="classtype"/>
		<td>
		 <xsl:element name="input">
				<xsl:attribute name="type">checkbox</xsl:attribute>
				<xsl:attribute name="rowselector">yes</xsl:attribute>
				<xsl:attribute name="devid">bay</xsl:attribute>
				<xsl:attribute name="onclick">applySelection(this);</xsl:attribute>
				<xsl:attribute name="classtype">
					<xsl:value-of select="$classtype" />
				</xsl:attribute>
				 <!-- Give the blade checkbox a unique ID based on the blade number -->
				 <xsl:attribute name="id">
					  <xsl:value-of select="$checkBoxId"/>
				 </xsl:attribute>
		</xsl:element>
		<xsl:value-of select="$checkBoxName"/>
		</td>
</xsl:template>

<xsl:template name="drawCheckBox1">
	<xsl:param name="checkBoxName"/>
	<xsl:param name="typeOfDisplay"/>
	<xsl:param name="checkBoxId"/>
	<xsl:param name="classtype"/>
		<td>
		 <xsl:element name="input">
				<xsl:attribute name="type">checkbox</xsl:attribute>
				<xsl:attribute name="rowselector">yes</xsl:attribute>
				<xsl:attribute name="devid">bay</xsl:attribute>
				<xsl:attribute name="classtype">
					<xsl:value-of select="$classtype" />
				</xsl:attribute>
				<xsl:attribute name="onclick">applySelectiononzoom(this);</xsl:attribute>
				 <!-- Give the blade checkbox a unique ID based on the blade number -->
				 <xsl:attribute name="id">
					  <xsl:value-of select="$checkBoxId"/>
				 </xsl:attribute>
		</xsl:element>
		<xsl:value-of select="$checkBoxName"/>
		</td>
</xsl:template>




<!--
		Individual renderBladeBay template. Contains functionality to draw a blade's status icon
		AM Status icon and checkbox. Takes a blade number, presence value, and status value as parameters.
	-->
	<xsl:template name="renderStatusAndCheckBox">
		
		<!--
			Individual blade status, presence, and blade number parameters
			used when rendering blade status icon and checkbox.
		-->
		<xsl:param name="presence" />
		<xsl:param name="status" />
		<xsl:param name="typeOfDisplay" />
		<xsl:param name="amStatus" />
		<xsl:param name="devHomeURL" />
		<xsl:param name="amURL" />
		<xsl:param name="drillDownURL"/>
		<xsl:param name="hwtitleStatus"/>
		<xsl:param name="amTitleStatus"/>
		<xsl:param name="classtype"/>
		
		<!--
			Determine whether or not the blade is present. If it is present, call the bayBladePresent
			template which draws the blade's status icon and checkbox.  Otherwise, call the bayBladeAbsent
			template which fills the table cell with a non-breaking space.
		-->
		<xsl:choose>
			
			<!-- Blade is present in bay -->
            <xsl:when test="$presence=$PRESENT">
                  <table cellpadding="0" cellspacing="0" border="0" align="center">
						<!--
							Only include the checkbox table cell if the enclosure
							is being rendered as part of a wizard.
						-->
						
							<tr>
								<td valign="bottom" align="center" height="22">
									<!-- Set up the blade's input checkbox -->
									<xsl:element name="input">
										<xsl:attribute name="type">checkbox</xsl:attribute>
											<xsl:attribute name="classtype">
												<xsl:value-of select="$classtype" />
											</xsl:attribute>
										<xsl:attribute name="rowselector">yes</xsl:attribute>
										<xsl:attribute name="devid">bay</xsl:attribute>
										<!-- Give the blade checkbox a unique ID based on the blade number -->
										<xsl:attribute name="id">
										<xsl:choose>
											<xsl:when test="./@bayType='Server' or ./@bayType='Storage' or ./@bayType='Workstation'"><xsl:value-of select="'serverCheckBox'" /> </xsl:when>
											<xsl:otherwise><xsl:value-of select="'switchCheckBox'" /></xsl:otherwise>
										</xsl:choose>
										</xsl:attribute>
						                <!--
												Add an value attribute to <td> this will have the NodeID(GUID) of each device,
												This is used by the javascript to when the user clickes All Blades/All Switches,
												checkbox.
												height value.
										-->
										<xsl:attribute name="guid">
											<xsl:value-of select="./Common/NodeId" />
										</xsl:attribute>
									</xsl:element>

								</td>
							</tr>

						<xsl:variable name="clickMsg">
							<xsl:value-of select="//I18N/DetailsToolTip"/>				
						</xsl:variable>
						<tr>
							<td valign="top" align="center" style="padding-top:3px; padding-left:1px;">
								<!-- Render the status image element -->
									<xsl:variable name="hwToolTip">
										<xsl:value-of select="//I18N/HWStatusToolTip"/>								
									</xsl:variable>
									  <xsl:choose>
											<xsl:when test="($typeOfDisplay=$BPV or $typeOfDisplay=$URACK)">
												<xsl:call-template name="statusIconLink">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="URL" select="$devHomeURL" />
													<xsl:with-param name="fallBackURL" select="$drillDownURL"/>
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="statusIcon">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:otherwise>
									</xsl:choose>
							</td>
						</tr>
				</table>
			<!-- No blade is present in bay (absent) -->
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>	

<!--
		Individual renderBladeBay template. Contains functionality to draw a blade's status icon
		AM Status icon and checkbox. Takes a blade number, presence value, and status value as parameters.
	-->
	<xsl:template name="renderHorizontalStatusAndCheckBox">
		
		<!--
			Individual blade status, presence, and blade number parameters
			used when rendering blade status icon and checkbox.
		-->
		<xsl:param name="presence" />
		<xsl:param name="status" />
		<xsl:param name="typeOfDisplay" />
		<xsl:param name="amStatus" />
		<xsl:param name="devHomeURL" />
		<xsl:param name="amURL" />
		<xsl:param name="drillDownURL"/>
		<xsl:param name="hwtitleStatus"/>
		<xsl:param name="amTitleStatus"/>
		<xsl:param name="classtype"/>
		<xsl:param name="slotNumber"/>
		
		<!--
			Determine whether or not the blade is present. If it is present, call the bayBladePresent
			template which draws the blade's status icon and checkbox.  Otherwise, call the bayBladeAbsent
			template which fills the table cell with a non-breaking space.
		-->
		<xsl:choose>
			
			<!-- Blade is present in bay -->
            <xsl:when test="$presence=$PRESENT">
                  <table cellpadding="0" cellspacing="0" border="0" >
                  <xsl:attribute name="align">
					  <xsl:choose>
						<xsl:when test="$slotNumber >= 5"> 
							<xsl:text>right</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>left</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
						<!--
							Only include the checkbox table cell if the enclosure
							is being rendered as part of a wizard.
						-->
						<xsl:variable name="clickMsg">
							<xsl:value-of select="//I18N/DetailsToolTip"/>				
						</xsl:variable>
						
							<tr>
					  <xsl:choose>
						<xsl:when test="$slotNumber >= 5"> 
								<td valign="top" style="padding-top:3px; padding-left:1px;">
								<!-- Render the status image element -->
									<xsl:variable name="hwToolTip">
										<xsl:value-of select="//I18N/HWStatusToolTip"/>								
									</xsl:variable>
									  <xsl:choose>
											<xsl:when test="($typeOfDisplay=$BPV or $typeOfDisplay=$URACK)">
												<xsl:call-template name="statusIconLink">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="URL" select="$devHomeURL" />
													<xsl:with-param name="fallBackURL" select="$drillDownURL"/>
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="statusIcon">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:otherwise>
									</xsl:choose>
							</td>
								<td valign="bottom" height="22">
									<!-- Set up the blade's input checkbox -->
									<xsl:element name="input">
										<xsl:attribute name="type">checkbox</xsl:attribute>
											<xsl:attribute name="classtype">
												<xsl:value-of select="$classtype" />
											</xsl:attribute>
										<xsl:attribute name="rowselector">yes</xsl:attribute>
										<xsl:attribute name="devid">bay</xsl:attribute>
										<!-- Give the blade checkbox a unique ID based on the blade number -->
										<xsl:attribute name="id">
										<xsl:choose>																   			
											<xsl:when test="./@bayType='Server' or ./@bayType='Storage' or ./@bayType='Workstation'"><xsl:value-of select="'serverCheckBox'" /> </xsl:when>
											<xsl:otherwise><xsl:value-of select="'switchCheckBox'" /></xsl:otherwise>
										</xsl:choose>
										</xsl:attribute>
						                <!--
												Add an value attribute to <td> this will have the NodeID(GUID) of each device,
												This is used by the javascript to when the user clickes All Blades/All Switches,
												checkbox.
												height value.
										-->
										<xsl:attribute name="guid">
											<xsl:value-of select="./Common/NodeId" />
										</xsl:attribute>
									</xsl:element>

								</td>
						</xsl:when>
						<xsl:otherwise>
								<td valign="bottom" height="22">
									<!-- Set up the blade's input checkbox -->
									<xsl:element name="input">
										<xsl:attribute name="type">checkbox</xsl:attribute>
											<xsl:attribute name="classtype">
												<xsl:value-of select="$classtype" />
											</xsl:attribute>
										<xsl:attribute name="rowselector">yes</xsl:attribute>
										<xsl:attribute name="devid">bay</xsl:attribute>
										<!-- Give the blade checkbox a unique ID based on the blade number -->
										<xsl:attribute name="id">
										<xsl:choose>
											<xsl:when test="./@bayType='Server' or ./@bayType='Storage'"><xsl:value-of select="'serverCheckBox'" /> </xsl:when>
											<xsl:otherwise><xsl:value-of select="'switchCheckBox'" /></xsl:otherwise>
										</xsl:choose>
										</xsl:attribute>
						                <!--
												Add an value attribute to <td> this will have the NodeID(GUID) of each device,
												This is used by the javascript to when the user clickes All Blades/All Switches,
												checkbox.
												height value.
										-->
										<xsl:attribute name="guid">
											<xsl:value-of select="./Common/NodeId" />
										</xsl:attribute>
									</xsl:element>

								</td>
								<td valign="top" style="padding-top:3px; padding-left:1px;">
								<!-- Render the status image element -->
									<xsl:variable name="hwToolTip">
										<xsl:value-of select="//I18N/HWStatusToolTip"/>								
									</xsl:variable>
									  <xsl:choose>
											<xsl:when test="($typeOfDisplay=$BPV or $typeOfDisplay=$URACK)">
												<xsl:call-template name="statusIconLink">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="URL" select="$devHomeURL" />
													<xsl:with-param name="fallBackURL" select="$drillDownURL"/>
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="statusIcon">
													<xsl:with-param name="statusCode" select="$status" />
													<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
												</xsl:call-template>
											</xsl:otherwise>
									</xsl:choose>
								</td>
														
						</xsl:otherwise>	
						</xsl:choose>
							</tr>
				</table>
			<!-- No blade is present in bay (absent) -->
			</xsl:when>
			<xsl:otherwise>
				&#160;
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>	

</xsl:stylesheet>