<%@page import="com.hp.mx.core.nodemanager.MxNode,
		         com.hp.mx.core.client.MxNodeClient,
		         com.hp.mx.core.objectmodel.MxObjectID,
				 com.hp.mx.core.objectmodel.MxGUID,
				 com.hp.mx.portal.ui.MxBean,
				 com.hp.mx.core.tools.datacollection.http.oa.AllDevicesDetails,
 				 com.hp.mx.core.tools.datacollection.http.oa.DeviceDetailsBean,
				 java.util.Vector,
				 java.io.File,
				 com.hp.mx.portal.i18n.MonteroResourceManager,
				 com.hp.mx.portal.ui.MxOptions,
				 com.hp.mx.utilities.DebugSubsystem"
%>
<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />

<html>
<%		
try
{
	MxBean.jspInit(request, response);
	rbPortal.init(loginBean, "MxPortal");

	//all declarations
	MxNodeClient nodeClient = loginBean.getNodeCtlr();
	MxObjectID objID;
	MxNode enclosureNode;
	DeviceDetailsBean deviceDetailsBean;	
	Vector allDevicesDetailsVect = new Vector();
	AllDevicesDetails allDevicesDetailsObj = new AllDevicesDetails();
	Vector oaVector = new Vector();
	String styleClassName = "";

	//get all the url parameters
	String leftOaGuid  = request.getParameter("leftOaGuid");
	String rightOaGuid = request.getParameter("rightOaGuid");
	String enclGuid    = request.getParameter("enclosureGuid");
	String enclName    = request.getParameter("enclName");
	String model = "";
	//create the enclosure node from guid of enclosure
	if(enclGuid != null && !enclGuid.equals(""))
	{	
		objID = new MxObjectID(new MxGUID(enclGuid));	
		enclosureNode = nodeClient.getNode(objID, false); 
		//appending () here, so that blank () will not be displayed
		//when model is null/blank
		model = enclosureNode.getModel();
		if(model != null && model.length()>0)
			model = "(" + enclosureNode.getModel() + ")";
		allDevicesDetailsVect = allDevicesDetailsObj.getAllServersDetails(enclosureNode, loginBean);		
	}

	//create the MxNode from the left oa guid
	if(leftOaGuid != null && !leftOaGuid.equals(""))
	{
		deviceDetailsBean = (DeviceDetailsBean)allDevicesDetailsObj.getOADetails(leftOaGuid, loginBean);
		oaVector.add(deviceDetailsBean);
	}

	//create for the secondary OA
	if(rightOaGuid != null && !rightOaGuid.equals(""))
	{				
		deviceDetailsBean = allDevicesDetailsObj.getOADetails(rightOaGuid, loginBean);
		oaVector.add(deviceDetailsBean);
	}

	/********************* i18n values for the row header****************/
	
	String i18nSystemName			=	MonteroResourceManager.getInstance().getString("sysPg.SysName", loginBean.getLocale());
	String i18nModel				=	MonteroResourceManager.getInstance().getString("xml.Model", loginBean.getLocale());
	String i18nIpAddress			=	MonteroResourceManager.getInstance().getString("xml.IPAddress", loginBean.getLocale());
	String i18nMgmtProcIP			=	MonteroResourceManager.getInstance().getString("xml.MgmtProcIP", loginBean.getLocale());
	String i18nOsName				=	MonteroResourceManager.getInstance().getString("xml.OSName", loginBean.getLocale());
	String i18nBayNumber			=	MonteroResourceManager.getInstance().getString("xml.bay", loginBean.getLocale());
	String i18nSysROMVersion		=	MonteroResourceManager.getInstance().getString("xml.SysROMVersion", loginBean.getLocale());
	String i18nIloFMVer				=	MonteroResourceManager.getInstance().getString("xml.MgmtProcFMVersion", loginBean.getLocale());
	String i18nInsightMgtAgentVer	=	MonteroResourceManager.getInstance().getString("xml.InsightMgmtVersion", loginBean.getLocale());
	String i18nRole					=	MonteroResourceManager.getInstance().getString("xml.Role", loginBean.getLocale());
	String i18nOaFMVer				=	MonteroResourceManager.getInstance().getString("xml.FirmwareVersion", loginBean.getLocale());
	String i18nOaDetails			=	MonteroResourceManager.getInstance().getString("Onboard Administrator Details",loginBean.getLocale());
	String i18nSystemDetails		=	MonteroResourceManager.getInstance().getString("System Details of",loginBean.getLocale());
	String i18nServerDetails		=	MonteroResourceManager.getInstance().getString("Server Details",loginBean.getLocale());

	/*********************** end i18 values *****************************/
%>
<head>
	<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/bladeime/skin/css/default.css'>
	<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/bladeime/skin/css/blue_theme.css'>
	<LINK type='text/css' rel='stylesheet' href='/mxportal/css/MxPortalEx.css'>
</head>
<body class="body-flush-fit">

	<table width="100%"><tr><td class='title-name'><%=enclName%> <%=model%></td></tr></table>
	
	<br><b>&nbsp;&nbsp;<%=i18nSystemDetails%> <%=enclName%></b>
<!-- -------------------- OA Details ------------- -->
<%
	//when there are no servers and OAs in the enclosure, display the error message
	if(oaVector.size() == 0 && allDevicesDetailsVect.size() == 0)
	{
%>
		&nbsp;&nbsp; <p class="error-instruction"><%=MonteroResourceManager.getInstance().getString("err.noDevicesFound",loginBean.getLocale())%></p>
<%
	}
	else
	{
%>
		<br><br><br>
		<table width="99%" border="0" align="center">
<%
		//display the table, only when enclosure has atleast one OA
		if(oaVector.size() > 0)
		{
%>			
				<tr><td><b><%=i18nOaDetails%></b><td></tr>
				<tr><td>
				<table border="1" class="dataTable">

				<tHead>
					<tr class="centerCaptionRow" align="left">
						<th style="text-align:left"><%=i18nBayNumber%></th><th style="text-align:left"><%=i18nSystemName%></th>
						<th style="text-align:left"><%=i18nIpAddress%></th><th style="text-align:left"><%=i18nModel%></th>
						<th style="text-align:left"><%=i18nOaFMVer%></th><th style="text-align:left"><%=i18nRole%></th>
					</tr>
				</tHead>

				<tBody>
				<%
					for(int i=0;i<oaVector.size();i++)
					{
						deviceDetailsBean = (DeviceDetailsBean) oaVector.elementAt(i);
						styleClassName = "";
						if(i%2 == 0)
						{
							styleClassName = "altRowColor";
						}
						//iterate for each oa
				%>
					<tr class="<%=styleClassName%>">
						<td><%=deviceDetailsBean.getBayNumber()%></td>
						<td><%=deviceDetailsBean.getSystemName()%></td>			
						<td><%=deviceDetailsBean.getServerIPAddress()%></td>
						<td><%=deviceDetailsBean.getModel()%></td>
						<td><%=deviceDetailsBean.getOaFMVersion()%></td>
						<td><%=deviceDetailsBean.getOaRole()%></td>
					</tr>
				<%
					}
				%>
				</tBody>
				</table>	
	
	<%
	} //end of if enclosure has atleast one OA
	//check for servers. display server details table, only when enclosure contains atleast 1 server
	//else don't show the table
	if(allDevicesDetailsVect != null && allDevicesDetailsVect.size() >0)
	{
	%>
		</td></tr>
		<tr><td>

		<br>
		<!-- -------------------- Server Details --------------------- -->
		<b><%=i18nServerDetails%></b>

		<table border="1" class="dataTable" width="100%">
		
		<tHead>
			<tr class="centerCaptionRow" align="left">
				<th style="text-align:left"><%=i18nBayNumber%></th><th style="text-align:left"><%=i18nSystemName%></th>
				<th style="text-align:left"><%=i18nIpAddress%></th><th style="text-align:left"><%=i18nModel%></th>
				<th style="text-align:left"><%=i18nMgmtProcIP%></th><th><%=i18nIloFMVer%></th>
				<th style="text-align:left"><%=i18nInsightMgtAgentVer%></th><th style="text-align:left"><%=i18nSysROMVersion%></th>
				<th style="text-align:left"><%=i18nOsName%></th>
			</tr>
		</tHead>

		<tBody>
		<%		
				//iterate for each server
				for(int i=0;i<allDevicesDetailsVect.size();i++)		
				{
						styleClassName = "";
						if(i%2 == 0)
						{
							styleClassName = "altRowColor";
						}
						deviceDetailsBean = (DeviceDetailsBean)allDevicesDetailsVect.elementAt(i);
		%>
					<tr class="<%=styleClassName%>">
						<td><%=deviceDetailsBean.getBayNumber()%></td>
						<td><%=deviceDetailsBean.getSystemName()%></td>
						<td><%=deviceDetailsBean.getServerIPAddress()%></td>
						<td><%=deviceDetailsBean.getModel()%></td>
						<td><%=deviceDetailsBean.getMgmtProcIPAddress()%></td>
						<td><%=deviceDetailsBean.getMgmtProcFMVersion()%></td>
						<td><%=deviceDetailsBean.getMgmtAgentVersion()%></td>
						<td><%=deviceDetailsBean.getSystemROMFMVersion()%></td>
						<td><%=deviceDetailsBean.getOsName()%></td>
					</tr>
		<% 	
				}
		%>
		</tBody>
		</table>
<%
	} //end of "servers found"
%>
	</td></tr></table>
</body>
<%
	} //end of else (atleast 1 OA or 1 server is found)
	 } //end of try
	catch(Exception e)
	{
		DebugSubsystem LOGGER = new DebugSubsystem(AllDevicesDetails.class);
		out.println("<b>Unable to display details of all the servers. Close the window and try again</b>");
		LOGGER.exception("Exception in DisplayAllServersDetails.jsp " + e.toString());
	}	
%>
	<script>	
		//hide the progress bar and load the actual page
		if(parent.hideLoading)
		{
			parent.hideLoading();
		}
	</script>
</html>
