<%
/*************************************************************************************************
 ** File         : BladeIMEBPVEventCriteria.jsp
 ** Dependencies :
 ** Description  : This class is responsible for displaying event criteria for the selected 
 **				   container type. It Displays 3 event categories for Overlord and 2 for normal 
 **				   containers.
 ** @author      : 
 ** @created     : Sep 26, 2005
 ** (C) Copyright 2001-2004, Hewlett-Packard Company, All Rights Reserved.
 *************************************************************************************************
 */
%>

<%@ page import="com.hp.mx.portal.events.EventException"%>

<%@ page import="com.hp.mx.portal.ui.MxBean"%>
<%@ page import="com.hp.mx.portal.ui.MxOptions"%>
<%@ page import="com.hp.mx.html.core.MxHtmlUtil"%>
<%@ page import="com.hp.mx.portal.ui.MxPortalRender"%>
<%@ page import="com.hp.mx.core.nodemanager.MxNode"%>
<%@ page import="com.hp.mx.core.objectmodel.MxObjectID"%>
<%@ page import="com.hp.mx.core.objectmodel.MxGUID"%>
<%@ page import="com.hp.mx.portal.i18n.MonteroResourceManager"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="eventsBean" class="com.hp.mx.portal.events.EventsBean" scope="session" />
<jsp:useBean id="rbListTabRes" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />

<html>

<%
    MxBean.jspInit(request, response);

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
        return;

	MxHtmlUtil.dumpHeadBegin(out);
	MxPortalRender.dumpHeadContent(out);
	MxHtmlUtil.dumpHeadEnd(out);

    String target = request.getParameter("target");

	MxNode mxNode = (loginBean.getNodeCtlr()).getNode((new MxObjectID(new MxGUID(target))), false);

	if (mxNode == null)
	{
%>
		<jsp:forward page="<%=MxOptions.URL_BASE + "/bladeime/events/BladeIMEBPVEventErrorPage.jsp"%>"/>
<%
	}
	
	String[][] bpvEventsQueryIdList = null;
	try
	{
		eventsBean.init(mxNode, loginBean);
		bpvEventsQueryIdList = eventsBean.getBPVEventsList(loginBean);
	}
	catch(EventException e)
	{
%>
		<jsp:forward page="<%=MxOptions.URL_BASE + "/bladeime/events/BladeIMEBPVEventErrorPage.jsp"%>"/>
<%
	}
%>
<body style="margin-top:0px">
<form name="eventsForm" method="post" target="eventResultsFrame">
<input type="hidden" name="filterQName" value=""/>
<input type="hidden" name="eventType" value=""/>

<table border="0" cellpadding="0" cellspacing="0">
<tr>
	<td align="left"><%=MonteroResourceManager.getInstance().getString("bpvEvents.view",loginBean.getLocale())%></td>
	<td align="left">&nbsp;
		<select name="eventTypeSel" onchange="viewEvents()">
			<option value=''>- <%=MonteroResourceManager.getInstance().getString("select",loginBean.getLocale())%> - &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
			<%
			for (int i=0;i<bpvEventsQueryIdList.length;i++)
			{
				if (i == 1) // all events
				{
					%>
					<option selected value="<%=MxHtmlUtil.encodeHtmlEntities(bpvEventsQueryIdList[i][0])%>"><%=MxHtmlUtil.encodeHtmlEntities(bpvEventsQueryIdList[i][1])%></option>
				<%
				}
				else
				{
					%>
					<option value="<%=MxHtmlUtil.encodeHtmlEntities(bpvEventsQueryIdList[i][0])%>"><%=MxHtmlUtil.encodeHtmlEntities(bpvEventsQueryIdList[i][1])%></option>
				<%
				}
			}
		%>
		</select>
	</td></tr></table>
</body>

<script>
	var lastSel=document.eventsForm.eventTypeSel.selectedIndex;
	function viewEvents()
	{
		var eventTypeSel=document.eventsForm.eventTypeSel.value;
		//'' is for -select- and grouping option
		if(eventTypeSel == ''){
			alert("<%=rbListTabRes.getString("tabs.dropdown.error.displayCollectionMergeError")%>");
			document.eventsForm.eventTypeSel.selectedIndex=lastSel;
			return false;
		}
		var arrEvent = eventTypeSel.split(":");
		document.eventsForm.eventType.value=arrEvent[0];
		if(arrEvent[1]){
			document.eventsForm.filterQName.value=arrEvent[1];
		}else{
			document.eventsForm.filterQName.value="";
		}
		document.eventsForm.action= "<%=MxOptions.URL_BASE%>/bladeime/events/BladeIMEBPVEventResults.jsp?target=<%=MxHtmlUtil.encodeJScriptEntities(target)%>";
		lastSel=document.eventsForm.eventTypeSel.selectedIndex;
		document.eventsForm.submit();
	}
</script>
</form>
</html>