
//auto refresh interval for montero pages(BPV, Performance and Port Mapping)
//this is set to 2 mins, since SIM refreshes left navigation panel for every 2 minutes
var MONTERO_REFRESH_INTERVAL = 120000; //in milliseconds

//indicates if left pane is to be refreshed(will be set to true for BPV only)
var refreshLeftPane = false;

function init() 
{
	var pageTitle = "Rack Overview";
	top.mainPage.getRightSideFrame().setTitle(pageTitle);
}

function addEnclLink()
{
	document.getElementById('rackFrame').style.display='block';	
	document.getElementById('newaddEnclToRack').style.display='none';

	//reset the size of BPV, since properties table gets expanded on
	//displaying the "Add Enclosure To Rack" link. fix for QXCR1000405761
	
	if(document.getElementById("BPVTable") && window.setDimentions)
		setDimentions('BPVTable');
}
	
function selectEnclosure(num, name) 
{
	top.mainPage.getNavigationFrame().selectEnclosure(num, name);
}
	
function toggleEnclosureVisible(encId, expandImage,titleMax,titleMin,titleBarId)
{
	var enclosure = document.getElementById(encId);
	var enclosurePadding = document.getElementById(encId + "Padding");
	if (enclosure != null)
	{
		if (enclosure.style.display == 'none')
		{
			enclosure.style.display = 'block';
			expandImage.src = '/mxportal/bladeime/skin/images/misc/win_shrink.gif';
			expandImage.title = titleMin;
		}
		else
		{
			enclosure.style.display = 'none';				
			expandImage.src = '/mxportal/bladeime/skin/images/misc/win_expand.gif';
			expandImage.title = titleMax;
		}
	}

	tdNodeCollection = document.getElementsByTagName("td");

	for (var i=0;i<tdNodeCollection.length;i++)
	{
		tdColumn = tdNodeCollection[i];
		tdId = tdColumn.getAttribute("id");
		if (tdId == "minimizeBpv")
		{
			tdColumn.height="400";
		}
	}
	setTitleBarWidth(titleBarId);
}	

function toggleSectionVisible(encId, expandImage)
{
	var enclosure = document.getElementById(encId);
	var enclosurePadding = document.getElementById(encId + "Padding");
	if (enclosure != null)
	{
		if (enclosure.style.display == 'none')
		{
			enclosure.style.display = 'block';
			expandImage.src = '/mxportal/bladeime/skin/images/section_tree_contract.gif';
			enclosurePadding.style.display = 'none';				
		}
		else
		{
			enclosure.style.display = 'none';				
			expandImage.src = '/mxportal/bladeime/skin/images/section_tree_expand.gif';
			enclosurePadding.style.display = 'block';
		}
	}
}	
	
function displayEnclosure(url)
{
	document.location.replace(url);
}	

// ISSUE0000279332 Fix
function makeSelection(guid,glblSelecLstCnt)
{
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox" ||
			inputNodeCollection[i].getAttribute("id")=="enclCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="rackCheckBox") &&
			inputNodeCollection[i].getAttribute("guid")==guid)
		{
			inputNodeCollection[i].checked=true;
			count++;
		}
	}
	if(glblSelecLstCnt!=null) {
		count = glblSelecLstCnt;
	}
	makeButtonSelection(count);
}

guidList = "";
// ISSUE0000279332 Fix
function applySelection(inputID)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");

	if (inputID.getAttribute("id")=="All Blades")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	if (inputID.getAttribute("id") == "All Switches")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	if (inputID.getAttribute("id") == "All EMs")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	if (inputID.getAttribute("id") == "All Enclosures")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="enclCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	guidList = applyMulitpleGlobalSelection();

	toggleMultiNodeSelection(guidList);
}


function applySelectiononzoom(inputID)
{
   	var inputNodeCollection = window.document.getElementsByTagName("input");
	if (inputID.getAttribute("id")=="All Blades")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
				
			if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox" && inputNodeCollection[i].checked!=inputID.checked)
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked) {
					zoomCount++;
				} else {
					zoomCount--;
				}
				toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}

	if (inputID.getAttribute("id") == "All Switches")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox" && inputNodeCollection[i].checked!=inputID.checked)
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked) {
					zoomCount++; 
				}else {
	 			    zoomCount--;
				}
                //applyMulitpleGlobalSelection(inputNodeCollection[i]);
				toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}

	if (inputID.getAttribute("id") == "All EMs")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox" && inputNodeCollection[i].checked!=inputID.checked)
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked) {
				  zoomCount++;
				}else {
	 			    zoomCount--;
				}
				//applyMulitpleGlobalSelection(inputNodeCollection[i]);
                 toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}

	if (inputID.getAttribute("id") == "All Enclosures")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="enclCheckBox" && inputNodeCollection[i].checked!=inputID.checked)
			{
				if(inputNodeCollection[i].checked!=inputID.checked) {
					inputNodeCollection[i].checked = inputID.checked;
					if (inputID.checked) {
					  zoomCount++;
					}else {
	 				    zoomCount--;
					}
					toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
				}
			}
		}
	}

	if (inputID.getAttribute("id") == "All Racks")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="rackCheckBox" && inputNodeCollection[i].checked!=inputID.checked)
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked) {
				  zoomCount++;
				}else {
	 			    zoomCount--;
				}
                 
				//applyMulitpleGlobalSelection(inputNodeCollection[i]);
                 toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}
	makeButtonSelection(zoomCount);
 }

// ISSUE0000279332 Fix
function applyMulitpleGlobalSelection()
{
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");
	var selectedGUIDList = "";
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="rackCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="enclCheckBox") && 
			inputNodeCollection[i].checked)
		{
			count++;
			selectedGUIDList = selectedGUIDList + "|" + inputNodeCollection[i].getAttribute("guid");
		}
	}
	
	makeButtonSelection(count);	

	return selectedGUIDList;
}

// ISSUE0000279332 Fix
function applyGlobalSelection(inputNodeCollection, inputID)
{
	var count = 0;
	
	if(!inputID.checked) {
		zoomCount--;
	}else {
		zoomCount++;
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox" ||
			inputNodeCollection[i].getAttribute("id")=="enclCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="rackCheckBox") && 
			inputNodeCollection[i].checked)	{
			count++;
		} 
	}
	toggleNodeSelection(inputID,inputID.getAttribute("guid"),count);
	if(zoomCount>0) {
		makeButtonSelection(zoomCount);
	} else {
		makeButtonSelection(count);
	}
}

// ISSUE0000279332 Fix
function globalSelection(inputID)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");
	applyGlobalSelection(inputNodeCollection, inputID); 
	checkAllServersAndSwitches();
}

// ISSUE0000279332 Fix
function checkAllServersAndSwitches(inputNodeCollection)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");

	var allSwichesSelected = checkAllSwitchesSelected(inputNodeCollection);
	var allServersSelected = checkAllBladesSelected(inputNodeCollection);
	var allOAsSelected = checkAllOAsSelected(inputNodeCollection);
	var allEnclsSelected = checkAllEnclsSelected(inputNodeCollection);
	var allRacksSelected = checkAllRacksSelected(inputNodeCollection);

	makeAllServersAndSwitchesChoice(inputNodeCollection, allSwichesSelected, allServersSelected, allOAsSelected ,allEnclsSelected ,allRacksSelected);
}

function checkAllEnclsSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="enclCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isEnclosurePresent(inputNodeCollection);
}

function isEnclosurePresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="enclCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

function checkAllRacksSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="rackCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isRackPresent(inputNodeCollection);
}

function isRackPresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="rackCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}


// ISSUE0000279332 Fix
function checkAllSwitchesSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isSwitchPresent(inputNodeCollection);
}

// ISSUE0000279332 Fix
function checkAllBladesSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}				
	
	return isBladePresent(inputNodeCollection);
}

function checkAllOAsSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isOAPresent(inputNodeCollection);
}

function isOAPresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function isSwitchPresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function isBladePresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function makeAllServersAndSwitchesChoice(inputNodeCollection, allSwichesSelected, allServersSelected, allOAsSelected ,allEnclsSelected ,allRacksSelected)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Switches")
		{
			inputNodeCollection[i].checked = allSwichesSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Blades")
		{
			inputNodeCollection[i].checked = allServersSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All EMs")
		{
			inputNodeCollection[i].checked = allOAsSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Enclosures")
		{
			inputNodeCollection[i].checked = allEnclsSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Racks")
		{
			inputNodeCollection[i].checked = allRacksSelected;
			break;
		}
	}

}

// ISSUE0000279332 Fix
function drillDown(url)
{
	document.location.replace(url);
}

//This method is called to open an new window with the URL as the argument.
function drillDownforack(url)
{
	window.open(url);
}

/*
 * This method is called once the user clicks the View As combo box from Rack/Enclosure 
 */
function onViewChange(e)
{
    if (e.value != "")
    {
		//to fix the tabs issue
        //parent.document.location.replace(e.value);
		parent.document.location.replace(e.value);
    }
}

//This method is called to open an new window with the URL as the argument.
//Currently its being used to open SMH from a device status icon from the BPV
var windows=new Array();
function openNewWindow(url)
{
    if(url.length>75 && url.length<100)
    {
  	    first1 = url.substring(0, 63);
        first2 = url.substring(63, (url.length)-14) ;
    }
	else
		first2 = 0;
	for(i=0;i<windows.length;i++){
		if(windows[i]==url){
			window.open(url, "win"+first2+i);	
			return;
		}
	}
	window.open(url, "win"+first2+windows.length);
	windows[windows.length]=url;		
}
//This method is used to slide the enclosure(power/server) when the user clicks the left/right icon 
// in the Enclosure BPV
function slideEnclosure(encId, image, titleSlideLeft, titleSlideRight)
{
	var leftPane = document.getElementById('LEFT_PANE');
	var enclosure = document.getElementById(encId);
	if (enclosure != null) {	
		// Currently hidden click to show.
		if (enclosure.style.display == 'none') {
			enclosure.style.display = 'block';
			image.src = '/mxportal/bladeime/skin/images/misc/right.gif';
			image.title = titleSlideRight;
			leftPane.setAttribute("width","70%");
		}
		else { // Currently Visisble click to hide
			enclosure.style.display = 'none';				
			image.src = '/mxportal/bladeime/skin/images/misc/left.gif';
			image.title = titleSlideLeft;
			leftPane.setAttribute("width","99%");
			pausecomp(100);
		}
	}
}	

function pausecomp(millis) 
{
date = new Date();
var curDate = null;

do { var curDate = new Date(); } 
while(curDate-date < millis);
} 

/* The function sets the height of the slider and the BPV table in proportion to the height of
the properties displayed to the left of the BPV.*/

function setSliderHeight(view) 
{

	/* 
		Set the height of emptySpaceAboveBPV {td} above the bpv to the height of the 
		height of View as combo box {td id=ViewAsCombo} + the 8px which is the height
		of the empty space btw the combo box and the properties.
	*/
	var viewAsBox = document.getElementById("ViewAsCombo");
	var spaceBox = document.getElementById("emptySpaceAboveBPV");
	if(spaceBox!=null) { // For RackView space is null.
		if(viewAsBox!=null) { //For enclosure view ViewAs is present.
			spaceBox.setAttribute("height",viewAsBox.offsetHeight+8);	
		}else { //For power enclosure the View as combo is absent.
			if(view == 'bpv') {
				spaceBox.setAttribute("height",10);	
			}
		}
	}	
	//Set the height of the slider
    var renderBPVElem = document.getElementById("renderBPV")
	var renderHtElem = document.getElementById("renderProperties")
	if(renderBPVElem == null || renderHtElem==null) {
		return;
	}
	
	var bpvHeight = renderBPVElem.offsetHeight;
	var renderHeight = renderHtElem.offsetHeight;
	var errorCorrection = 0;
	var all_images = window.document.getElementsByTagName("img");
	var finalBPVHeight;
	var sliderElement;
	var bpvEmptySpaceEle;
	for (var i=0; i<all_images.length;i++) 
	{
		if (all_images[i].getAttribute("name")=="Power_Slider")
		{
				var newSliderHeight = 0;
				var curBPVHgt = all_images[i].getAttribute("height");
				var titleBarHght = document.getElementById("enclTitleBar").offsetHeight;
				var chkBox = document.getElementById("checkBoxEncl");
				var chkBoxHght;
				var error;
				if(chkBox==null) { //PowerEncl
					chkBoxHght = 0;
					error=78;
				}
				else {
					chkBoxHght = document.getElementById("checkBoxEncl").offsetHeight;
					error=76;
				}
				var finalHt = eval(curBPVHgt+ '+' + titleBarHght + '+' + chkBoxHght + '+' + error);
				sliderElement = all_images[i];
				sliderElement.setAttribute("height",finalHt);
				finalBPVHeight = finalHt;
		}
	}

	for (var i=0; i<all_images.length;i++) 
	{
		if (all_images[i].getAttribute("id")=="BPV_EMPTY_SPACE")
		{
				var incrBPVHeight = eval(renderHeight+'-'+finalBPVHeight+'-'+'9');
				if(incrBPVHeight>0) {
					bpvEmptySpaceEle = all_images[i];
					bpvEmptySpaceEle.setAttribute("height",incrBPVHeight);
				}
		}
	}
	if(renderHeight>finalBPVHeight) {
		sliderElement.setAttribute("height",eval(renderHeight+'-'+'10'));
	}
}

function hideProgressBar() {
	var progressBar = document.getElementById('progressBar');
	if(progressBar!=null) {
		progressBar.style.display = 'none';				
	}
}

function splitPowerRedundancyInfo()
{
	tableNodeCollection = window.document.getElementsByTagName("table");
	tdCollection= window.document.getElementsByTagName("td");
	//To display the Power Redundancy Information in an Enclosure BPV
	for(var j=0;j<tdCollection.length;j++)
	{
		tdNode=tdCollection[j];
		if(tdNode.className=="propertyValue")
		{
			redundancyInfo = tdNode.getAttribute("PowerRedundancyValue");
			if(tdNode.getAttribute("PowerRedundancyName")!=null)
			{
				redundancyName = tdNode.getAttribute("PowerRedundancyName");
			}

			if(redundancyInfo!=null)
			{
				redundancy = redundancyInfo.split("/");
				//fix for QXCR1000369855

				var powerRedundancyColumnText="";
				for(var k=0;k<redundancy.length;k++)
				{
					if(redundancy[k].length>0){
						powerRedundancyColumnText = powerRedundancyColumnText+redundancy[k]+"<br/>";
					}
				}
				tdNode.innerHTML=powerRedundancyColumnText;
			}
			
		}
	}
	//To display the Power Redundancy Information in Rack BPV
	for(var i=0;i<tableNodeCollection.length;i++)
	{
		 tableNode = tableNodeCollection[i];
		 if (tableNode.getAttribute("id")=="AttributeTable")
		 {
			redundancyInfo = tableNode.getAttribute("PowerRedundancyValue");
			if(tableNode.getAttribute("PowerRedundancyName")!=null)
			{
				redundancyName = tableNode.getAttribute("PowerRedundancyName");
			}

			if(redundancyInfo!=null)
			{
				redundancy = redundancyInfo.split("/");
				tbodyList = tableNode.getElementsByTagName("tbody");
				tbody = tbodyList[0];
				powerRedundancyFirstRow = document.createElement("tr"); 
				powerThermalfirstColumn = document.createElement("td");
				powerRedundancyColumnText=document.createTextNode(redundancyName);
				powerThermalfirstColumn.appendChild(powerRedundancyColumnText);
				powerRedundancyFirstRow.appendChild(powerThermalfirstColumn);
				for(var k=0;k<redundancy.length;k++)
				{
					powerRedundancyColumn= document.createElement("td");
					powerRedundancyColumnText = document.createTextNode(redundancy[k]);
					powerRedundancyColumn.appendChild(powerRedundancyColumnText);
					powerRedundancyFirstRow.appendChild(powerRedundancyColumn);
					powerRedundancyColumn.setAttribute("nowrap","");
					powerRedundancySecondRow = document.createElement("tr");
					powerRedundancySecondColumn = document.createElement("td");
					powerRedundancySecondRow.appendChild(powerRedundancySecondColumn);
					
					tbody.appendChild(powerRedundancyFirstRow);
					powerRedundancyFirstRow=powerRedundancySecondRow;
				}
			}
		}
	}
}

function loadDeviceInfoTip(e, toolTip) {

	positionTT(e);
	document.onmousemove = positionTT;
	var canvas=document.getElementById("toolText");
	canvas.innerHTML="";
	toolTip = toolTip.split(",");
	
	var tt="";
	for(var k=0;k<toolTip.length;k++) {
		if(toolTip[k].indexOf(":")>0) {
			var toolTipTitle = toolTip[k].split(":");
			tt += "<b>"+toolTipTitle[0]+" :</b>"+toolTipTitle[1]+"<br>"
		} else {
			tt += toolTip[k]+"<br>"
		}
	}
	toolTip=tt;
	canvas.innerHTML=toolTip;
	canvas.style.visibility="visible";

	if(e){
		e.stopPropagation();
	}else {
		event.cancelBubble=true;
	}

	//clear the curGuid, this is referred to repaint the tool tip layer
	//on receiving ajax reponse for firmware version info
	curGuid="";
}

function positionTT(e) {
		
	var canvas=document.getElementById("toolText");
	var isIE=true;
	if(!document.all){
		isIE=false;
		document.captureEvents(Event.MOUSEMOVE)
	}
	var mX,mY;
	if (isIE) { 
		mX = event.clientX + document.body.scrollLeft;
		mY = event.clientY + document.body.scrollTop;
	}else {  
		mX = e.pageX;
		mY = e.pageY;
	}

	var winWidth;
	if(document.all){
		winWidth=document.body.clientWidth;
	}else{
		winWidth=window.innerWidth;
	}
	var w = (mX + canvas.offsetWidth);
	if( w >= winWidth ){
		mX = mX - canvas.offsetWidth;
	}
	if(mX<0) {
		mX=0;
	}
	canvas.style.top=mY+20;
	canvas.style.left=mX;
}

function removeDeviceInfoTip() {
var canvas=document.getElementById("toolText");
canvas.style.visibility="hidden";
canvas.innerHTML="";
}

//auto refresh montero pages (called by BPV,Performance page and port mapping)
//refreshes left and right(montero) side frames
function autoRefreshMontero()
{
	if(document.getElementById("refreshFrame") == null)
		return false;
	refreshMonteroFrame();
	
	if(refreshLeftPane)
		refreshLeftSideFrame();
}	

// Refresh the left navigation panel 
function refreshLeftSideFrame()
{				
	var leftFrame = MxPortalGetLeftSideFrame();

	//get the iframe in which the navigation tree is loaded
	var iframe = leftFrame.contentWindow.document.getElementById("FRAME_ID_ORGANIZER");

	//call updateNavPanel() of SIM which will refresh the tree view
	if (leftFrame != null && typeof(iframe.contentWindow.updateNavPanel) == "function")    
		iframe.contentWindow.updateNavPanel();
}

//refresh right side frame
function refreshMonteroFrame()
{		
	//refresh the right frame
	if(refreshFrame != null)
	{		
		refreshFrame.src = linkUrl;
		isRefreshFrameLoaded();
	}
}

//checks if the hidden frame is done with loading.
//if so, the outer frame will be updated with the contents of 
//the hidden frame(refreshed frame) and perform some initial settings.	
function isRefreshFrameLoaded()
{	
	if(document.getElementById("refreshFrame") == null)
		return false;
	
	master = document.getElementById("refreshFrame").contentWindow.document.getElementById("master");

	if(master == null) //indicates not in UtilizationDisplay.jsp
	{
		if(document.getElementById("refreshFrame").contentWindow.isLoaded != true)
			setTimeout("isRefreshFrameLoaded()", 500);			
		else				
			resetDisplayOnAutoRefresh();				
	}
	else //inside UtilizationDisplay.jsp
	{	
		if(master.contentWindow.isLoaded != undefined)
		{			
			  if(master.contentWindow.isLoaded == false)
					setTimeout("isRefreshFrameLoaded()", 500);
	  		 else
			 {
					master.contentWindow.isLoaded = false;
					resetDisplayOnAutoRefresh();
			 }
		}
		else
			setTimeout("isRefreshFrameLoaded()", 500);		
	}		
}

//reset event handlers since events will be disabled due to copy of the contents from the hidden frame in BPV
function setEventHandlers()
{
	globalComponentInit();
	for(i=0;i<buttons.length;i++)
	{
		var button = document.getElementById(buttons[i][0]);
		if(button.onclick == null)
			button.onclick = buttons[i][1];									
	}
}

//save the onclick event handler of the button since initButton(Buttonmanage.js) resets onclick to null
//onclick need to be reset when the page is reloaded due to the auto refresh
function handleButtonEvents()
{
	buttons = new Array();
	var btnIndex = 0;

	var divs = document.getElementsByTagName("DIV");
    for (var divIndex=0;divIndex<divs.length;divIndex++) 
	{
       if (divs[divIndex].className.indexOf("bWrapper")!=-1) 
	   {
			divObj = divs[divIndex];
			if (divObj != null)
			{
			    var obj = divObj
			    while ((obj.childNodes[0]!=null) && ((obj.tagName!="BUTTON") && (obj.tagName!="INPUT"))  &&  (obj.tagName!="A") && (obj.tagName!="SUBMIT")) 
				{
					    obj = obj.childNodes[0];
						if(obj.onclick != null)
						{	
							buttons[btnIndex] = new Array(2);
							buttons[btnIndex][0] = obj.id;
							buttons[btnIndex][1] = obj.onclick;
							btnIndex++;
						}
				}
			}

		}
    }	
}

//update the refresh time stamp
function updateRefreshTimeStamp()
{					
	document.getElementById("timetd").innerHTML = refreshFrame.contentWindow.document.getElementById("timetd").innerHTML;	
}

//if performance data for HP-Ux is to be refreshed
function startRefreshForHpUx()
{
	if(isHpUxPageLoaded() == true)
	{
		setTimeout("autoRefreshMontero()", MONTERO_REFRESH_INTERVAL);
		return;
	}
	else	
		setTimeout("startRefreshForHpUx()",500);	
}

function isHpUxPageLoaded()
{
	master = document.getElementById("master");

	if(master != null)
	{
		var status = document.getElementById("master").contentWindow.isLoaded;
		if(status == undefined)
			return false;		 
		return status;
	}
	return false;
}

//refresh the performance data for Hp Ux from UtilizationDisplay.jsp
function resetDisplayOnAutoRefreshForHpUx()
{	
	document.getElementById("master").contentWindow.document.getElementById("PERFORMACE_PAGE").innerHTML = 
		refreshFrame.contentWindow.document.getElementById("master").contentWindow.document.getElementById("PERFORMACE_PAGE").innerHTML;	

	document.getElementById("master").contentWindow.document.getElementById("timetd").innerHTML = 
		refreshFrame.contentWindow.document.getElementById("master").contentWindow.document.getElementById("timetd").innerHTML;	

	startRefreshForHpUx();
}

//opens details of all servers in a pop up window 
// (for 2.1.11 feature - show firmware ver info)

function showAllServersDetails(tmpEnclName)
{
		//get left OA guid
		var leftOaGuid  = getGuid("oaCheckBox");

		//get right OA guid
		var rightOaGuid = getRightOaGuid("oaCheckBox");

		//get enclosure guid
		var enclosureGuid = getGuid("enclCheckBox");

		var winName = "serverDetailsWin" + enclosureGuid;

		//pass url parameters: encl name, left oa guid, right oa guid and enclgiud
		fileToOpen = "/mxportal/bladeime/ProgressBarForDisplayAllDevices.jsp?leftOaGuid="+leftOaGuid+"&rightOaGuid="+rightOaGuid+"&enclosureGuid="+enclosureGuid+"&enclName="+tmpEnclName; 

		pWin = window.open(fileToOpen,winName,'scrollbars=yes,resizable=yes,width=980,height=500,toobar=yes,menubar=yes');
		if(pWin)
			pWin.focus();
}

//returns guid of the enclosure or oa depending on the argument
function getGuid(deviceType)
{		
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");
	var deviceGuid="";
	
	//iterate for all the check boxes to get the guid
	for (var i=0; i<inputNodeCollection.length;i++) 
	{		
		if(inputNodeCollection[i].getAttribute("id") == deviceType)
		{
			deviceGuid = inputNodeCollection[i].getAttribute("guid");
			break;
		}
	}
	return deviceGuid;
}

//return the guid of the right OA
function getRightOaGuid(deviceType)
{		
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");
	var nameGuid = "";
	var isLeftOAFound = false;
	var rightOaGuid = ""

	for (var i=0; i<inputNodeCollection.length;i++) 
	{		
		if(inputNodeCollection[i].getAttribute("id") == deviceType)
		{
			//oaCheckBox found for the first time
			if(isLeftOAFound == false)
			{
				isLeftOAFound = true;
				continue;
			}
			
			//if left OA is already found and Oacheckbox is found again, then
			//it implies this checkbox is of right OA.
			if(isLeftOAFound == true)
			{							
				rightOaGuid = inputNodeCollection[i].getAttribute("guid");
				break;
			}							
		}
	}
	return rightOaGuid;
}