/***************************************************************************
* (c) Copyright 1998-2005  Hewlett-Packard Development Company, L.P. 
* ALL RIGHTS RESERVED.
****************************************************************************
*
*  @doc
*
*  @module  cridw_linux.h
*  Version: 1.0
*
*  Function: Provide basic support for the hp Advance Server
*            Management ASIC.
*
*  @doc
****************************************************************************
*
*  @doc
*
*  Change Log:
*
*       Date    Who   Description
*
*****************************************************************************/
#ifndef INC_CRIDW_LINUX_H
#define INC_CRIDW_LINUX_H

#include "linux/dist.h"

//Typedefs
#if LINUX_VERSION_CODE < 0x020600
int pci_get_slot(struct pci_dev* pdev, u8 * slot);
#endif
int crid_read_print_crid(char *Buf, char **start, off_t off, int count, int *eof, void *data, PCRIDDATA pInstance);

//*************************************************************************
//  Defines and typedefs
//*************************************************************************

#define MAX_CRID_TOID		6            /* Maximum number of timers */
#define MAX_CRID_LOCK		5            /* Maximum number of locks	 */

#define BUF_ORDER 3

#define MS_TO_TICKS(x)		((x)/1000*HZ)
#define US_TO_TICKS(x)		((x)/1000000*HZ)
#define TICKS_TO_MS(x)		((x)/HZ*1000)
#define TICKS_TO_US(x)		((x)/HZ*1000000)


//
// @struct UNIXADDR | Used to track Unix Address Allocations
//


typedef struct _CRIDLOCK {
    spinlock_t        lock;         
    int	 	      start;
    int		      end;
    char	      *file;
    ULONG	      flags;
} CRIDLOCK, *PCRIDLOCK;

typedef struct _CRIDTIMER {
    struct timer_list	entry;
    void		(*pFunction)(void*);
    void*		pArg;
    ULONG  		used;
} CRIDTIMER, *PCRIDTIMER;


typedef struct _OSDATA {
    CRIDLOCK	      	crid_lock[MAX_CRID_LOCK];
    wait_queue_head_t 	slot_wq[MAX_SEQ_NUM];
    wait_queue_head_t 	get_pkt_wq;
    CRIDTIMER		timer[MAX_CRID_TOID];
} OSDATA, *POSDATA;

#ifdef CRID_X86_64
typedef struct {
	void *in_cmd;
	unsigned short cmd_length;
	void * resp_cmd;
	unsigned short resp_length;
} ioctl_arg_type;

typedef struct {
	unsigned int in_cmd;
	unsigned short cmd_length;
	unsigned int resp_cmd;
	unsigned short resp_length;
} ioctl_arg_type32;
#endif


#endif 
