<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2004 Hewlett-Packard Development Company, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
<!ENTITY hp_link            "http://www.hp.com">
%common_en;
<!ENTITY devhome            "Homepage">
<!ENTITY devhome_tip        "Go to the System Management Homepage">
<!ENTITY help               "Help">
<!ENTITY help_tip           "Get help on using this utility">
<!ENTITY tasks              "Tasks">
<!ENTITY tasks_tip          "Click here to show or hide tasks for this page">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="lang">&default_lang_code;</xsl:param>
   <xsl:param name="operator">false</xsl:param>
   <xsl:param name="machine">localhost</xsl:param>
   <xsl:variable name="defaultTab">
      <xsl:value-of select="/cpqnav/navitem[@default='true']/@id"/>
   </xsl:variable>
   <xsl:output method="html" indent="yes"/>

   <xsl:template match="/">
      <html>
         <head>
            <title><xsl:value-of select="cpqnav/navheader/agentname"/></title>
            <link rel="stylesheet" type="text/css" href="&webapp_base;/cpqnav.css"/>
            <script language="JavaScript">
               var defTab = "<xsl:value-of select="$defaultTab"/>";
               var currentTab="";
               var lastTab="";

               function In(o)
               {
                  var d = document.getElementById(o.id + "A");
                  d.style.color = "#FFFFFF";
               }

               function Out(o)
               {
                  if (o.id != currentTab) {
                     var d = document.getElementById(o.id + "A");
                     d.style.color = "#CCCCCC";
                  }
               }

               function selectTab(tabName)
               {
                  if (tabName != currentTab)
                  {
                     lastTab = currentTab;
                     currentTab = tabName;
                     var oNewSelTab = document.getElementById(tabName);
                     if (oNewSelTab)
                     {
                        oNewSelTab.style.background = "url(&webapp_base;/img/hitab.gif)";
                        var oNewTarget = document.getElementById(tabName + "A");
                        oNewTarget.style.color = "#FFFFFF";
                     }

                     var oOldSelTab = document.getElementById(lastTab);
                     if (oOldSelTab)
                     {
                        oOldSelTab.style.background = "url(&webapp_base;/img/tab.gif)";
                        var oOldTarget = document.getElementById(lastTab + "A");
                        oOldTarget.style.color = "#CCCCCC";
                     }
                  }
               }

               function Navigate(obj)
               {
                  // IE/Win document.all(obj.id + "A").click();
                  parent.content.location.href = document.getElementById(obj.id + "A").href; // Linux/Win/Moz/IE
                  // this doesn't work... document.getElementById(obj.id + "A").click();
                  selectTab(obj.id);
               }

               function setDefaultTab()
               {
                  selectTab(defTab);
               }

               function ReloadContentPage(tabNameList) {
                  var aryTabs = tabNameList.split(',');
                  for (var i = 0; i != aryTabs.length; i++) {
                     if (aryTabs[i] == currentTab) {
                        Navigate(document.getElementById(currentTab));
                        break;
                     }
                  }
               }

               function setTab(tabName)
               {
                  if (tabName != currentTab)
                  {
                     selectTab(tabName);
                  }
                  // need to repaint the tab background. If the user is required to relogin the
                  // selected background tab is not paint properly.
                  // else if (document.all(tabName) != null)
                  //    document.all(tabName).background="&webapp_base;/img/hitab.gif";
               }

               var helpWindow = null;
               function openHelpWin(url)
               {
                  if (!helpWindow || helpWindow.closed)
                  {
                     helpWindow = window.open(url,"_helpwin",'toolbar=1,location=0,directories=0,status=1,menubar=0,scrollbars=1,resizable=1,width=640,height=480');
                  }
                  else
                  {
                     helpWindow.location = url;
                  }
                  helpWindow.focus();
                  return true;
               }

               function PageLoad() {
                  setDefaultTab();
                  // tell the frameset we're loaded
                  if (window.parent) {
                     window.parent.FrameLoaded(window.name);
                  }
               }
               // the frameset calls this when the frames are all loaded
               function onFramesLoaded() {/*noop for this frame*/}
            </script>
         </head>
         <body bgcolor="#FFFFFF" text="#000000" onload="PageLoad();" >
            <xsl:apply-templates select="cpqnav"/>
         </body>
      </html>
   </xsl:template>

   <xsl:template match="cpqnav">
      <xsl:apply-templates select="navheader"/>
      <DIV style="LEFT: 10px; TOP: 67px; POSITION: absolute;  margin: 1px 0 0 0 ">
       <table width="100%" cellpadding="0" cellspacing="0" border="0">
        <tr>
         <td>
         <table class="NavTab" border="0" cellPadding="0" cellSpacing="0">
            <tr class="NavTab">
               <xsl:apply-templates select="navitem"/>
               <td width="*">&#032;</td>
            </tr>
         </table>
        </td>
        </tr>
        <tr><td height="5px" bgcolor="#336699"> </td></tr>
       </table>
      </DIV>
   </xsl:template>

   <!--    Header template -->
   <xsl:template match="navheader">
      <!-- we allow for a logo image that is 86x16, with14px padding (size of "M") per corporate branding -->
      <DIV style="LEFT: 13px; TOP: 10px; POSITION: absolute; marginwidth: 0px">
         <table class="NavHdr" width="100%" valign="top" cellspacing="0" cellpadding="0">
            <col width="5%" valign="bottom"/>
            <col width="85%" valign="bottom"/>
            <col width="5%" valign="bottom"/>
            <col width="5%" valign="bottom"/>
            <tr class="NavHdr" valign="bottom">
               <td class="NavHdr">
                  <a href="&hp_link;" title="&corp_name;" target="new">
                     <img width="54" height="33" src="&webapp_base;/img/logo_top.gif" alt="&corp_name;"/>
                  </a>
               </td>
               <td class="NavHdr" style="padding-left:8;">
                  <xsl:value-of select="agentname"/>
               </td>
               <td class="NavHdr" style="padding-right:6" nowrap="1">
                  <a href="/" target="_parent" title="&devhome_tip;" alt="$machine"><xsl:value-of select="$machine"/><xsl:text> </xsl:text>&devhome;</a>
               </td>
               <td class="NavHdr" nowrap="1">
                  <a target="_helpwin" title="&help_tip;" onclick="javascript:openHelpWin('{helphref}');">
                     <xsl:attribute name="href"><xsl:value-of select="helphref"/></xsl:attribute>&help;
                  </a>
               </td>
             </tr>
            <tr class="NavHdr" style="margin-top: -1;">
               <td class="NavHdr" height="20"><img src="&webapp_base;/img/logo_bottom.gif" width="54" height="20"/></td>
               <td class="NavHdr" colspan="3" height="20"> </td>
            </tr>
         </table>
      </DIV>
   </xsl:template>

   <!--    Tab template  -->
   <xsl:template match="navitem">
      <td class="NavTab" id="{@id}" height="25" width="114" background="&webapp_base;/img/tab.gif" align="center" valign="center" onMouseOver="In(this);" onMouseOut="Out(this);" onClick="Navigate(this);" style="cursor:pointer;">
         <a class="NavTab" id="{@id}A" href="{href}" target="{targetframe}" title="{title}">
            <xsl:attribute name="title"><xsl:choose><xsl:when test="tip"><xsl:value-of select="tip"/></xsl:when></xsl:choose></xsl:attribute>
            <xsl:value-of select="title"/>
         </a>
      </td>
   </xsl:template>

</xsl:stylesheet>
