<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2002 Hewlett-Packard Development Group, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
<!ENTITY % vclog_en SYSTEM "../dtd.en/vclog.dtd">
%vclog_en;

<!ENTITY pageTitle             "&agent_name;&#160;Log">
<!ENTITY no_entry_msg          "The specified entry is not in the log.">
<!ENTITY entry_details         "Entry Details">
<!ENTITY additional_data       "Additional Data">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="entryId"/>
   <xsl:param name="showTaskIds"/>
   <xsl:param name="lang">&default_lang_code;</xsl:param>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <xsl:template match="&log_element;">
      <html>
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
            <meta http-equiv="pragma" content="no-cache"/>
            <title>&pageTitle;</title>
            <script src="&webapp_base;/timedate.js" language="JavaScript"/>
            <script src="&webapp_base;/timedate.vb" language="VBScript"/>
            <link rel="stylesheet" type="text/css" href="&webapp_base;/vclogtable.css"/>
            <script src="&webapp_base;/showhide.js" type="text/JavaScript" language="JavaScript"/>
            <script type="text/JavaScript">
               function pageLoad() {
                  if (("undefined"==typeof(window.opener)) || (null==window.opener)) {
                     // hide the close button - it won't work!
                     showhide2("Close");
                  }
               }
            </script>
         </head>
         <body onload="pageLoad();">
            <xsl:variable name="selectedEntry" select="entry[@id=$entryId]"/>
            <xsl:choose>
               <xsl:when test="count($selectedEntry)=0">
                  <center>
                     <div class="vcLogEntry">
                        <table class="vcLogEntry" width="60%" cellspacing="0" border="0">
                           <thead class="vcLogEntry">
                              <tr class="vcLogEntry">
                                 <th class="vcLogEntry" colspan="2" align="left">&txt_major;</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr class="vcLogEntry">
                                 <td class="vcLogEntry">
                                    <img src="&img_blank;"/>
                                    <img align="middle" src="&img_major;"/>
                                    <img src="&img_blank;"/>
                                 </td>
                                 <td class="vcLogEntry" width="100%">
                                    <br/>&no_entry_msg;<br/>
                                    <br/>
                                    <img src="&img_blank;"/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </center>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="$selectedEntry">
                     <xsl:with-param name="lang" select="$lang"/>
                     <xsl:with-param name="showTaskIds" select="$showTaskIds"/>
                  </xsl:apply-templates>
               </xsl:otherwise>
            </xsl:choose>
         </body>
      </html>
   </xsl:template>

   <!-- this template outputs the log details -->
   <xsl:template match="entry">
      <xsl:param name="lang">&default_lang_code;</xsl:param>
      <xsl:param name="showTaskIds"/>
      <div class="vcLogEntry">
         <a><xsl:attribute name="name">#<xsl:value-of select="@id"/></xsl:attribute></a>
         <center>
            <table class="vcLogEntry">
               <!-- since the <pre> stuff won't wrap, make sure the 2nd column doesn't end up out in space. -->
               <col width="5%"/>
               <col width="95%"/>
               <thead class="vcLogEntry">
                  <tr class="vcLogEntry">
                     <th class="vcLogEntry" align="left" colspan="2">&entry_details;</th>
                  </tr>
               </thead>
               <tbody>
                  <tr class="vcLogEntry">
                     <td class="vcLogEntry"><b><nobr>&severity;</nobr></b></td>
                     <td class="vcLogEntry" style="border-left:solid #006699 1px">
                        <xsl:choose>
                           <xsl:when test="severity = 100">
                              <img width="15" height="15" src="&img_info;" title="&txt_info;"/>&#032;&txt_info;
                           </xsl:when>
                           <xsl:when test="severity = 1">
                              <img width="15" height="15" src="&img_normal;" title="&txt_normal;"/>&#032;&txt_normal;
                           </xsl:when>
                           <xsl:when test="severity = 3">
                              <img width="15" height="15" src="&img_minor;" title="&txt_minor;"/>&#032;&txt_minor;
                           </xsl:when>
                           <xsl:when test="severity = 4">
                              <img width="15" height="15" src="&img_major;" title="&txt_major;"/>&#032;&txt_major;
                           </xsl:when>
                           <xsl:otherwise>
                              <img width="15" height="15" src="&img_unknown;" title="&txt_unknown;"/>&#032;&txt_unknown;
                           </xsl:otherwise>
                        </xsl:choose>
                     </td>
                  </tr>
                  <xsl:if test="$showTaskIds='true'">
                     <tr class="vcLogEntry">
                        <td class="vcLogEntry"><b><nobr>&task_id;</nobr></b></td>
                        <td class="vcLogEntry" style="border-left:solid #006699 1px"><xsl:value-of select="taskid"/></td>
                     </tr>
                  </xsl:if>
                  <tr class="vcLogEntry">
                     <td class="vcLogEntry"><b><nobr>&date_time;</nobr></b></td>
                     <td class="vcLogEntry" style="border-left:solid #006699 1px">
                        <script language="JavaScript">document.write(&vcTS2LocalDT;("<xsl:value-of select="@timestamp"/>"));</script>
                     </td>
                  </tr>
                  <tr class="vcLogEntry">
                     <td class="vcLogEntry"><b><nobr>&message;</nobr></b></td>
                     <td class="vcLogEntry" style="border-left:solid #006699 1px">
                        <xsl:choose>
                           <xsl:when test="xlates/xlate[@lang=$lang]">
                              <xsl:value-of select="xlates/xlate[@lang=$lang]"/>
                           </xsl:when >
                           <xsl:otherwise>
                              <xsl:value-of select="xlates/xlate[@lang='en']"/>
                           </xsl:otherwise>
                        </xsl:choose>
                     </td>
                  </tr>
                  <xsl:if test="not(data='')">
                     <tr class="vcLogEntry">
                        <!-- remove bottom border on this column -->
                        <td class="vcLogEntry" colspan="2" style="border-bottom-width: 0px"><b>&additional_data;</b></td>
                     </tr>
                     <tr class="vcLogEntry">
                        <td class="vcLogEntry" colspan="2">
                           <code class="vcLogEntry">
                              <xsl:value-of select="data" disable-output-escaping="yes"/>
                           </code>
                        </td>
                     </tr>
                  </xsl:if>
               </tbody>
            </table>
         </center>
      </div>
      <div align="center" width="90%" style="position: relative; top: 5;">
         <table width="90%">
            <tbody>
               <tr>
                  <td style="text-align:right"><input type="button" name="Close" id="Close" value="&txt_btn_close;" onclick="window.close();"/></td>
               </tr>
            </tbody>
         </table>
      </div>
   </xsl:template>
</xsl:stylesheet>
