<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2002 Hewlett-Packard Development Group, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!-- common entities must be in the same relative location for all projects -->
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
<!ENTITY % vclog_en SYSTEM "../dtd.en/vclog.dtd">
%vclog_en;
<!-- vclogtable entities -->
<!ENTITY task_id_tip           "Filter all records by this task ID">
<!ENTITY details               "details">
<!ENTITY details_tip           "More information is available">
<!ENTITY img_first_pages       "&webapp_base;/img/first.gif">
<!ENTITY show_first_pages      "Show the first page of log entries">
<!ENTITY img_previous          "&webapp_base;/img/prev.gif">
<!ENTITY show_previous         "Show the previous page of log entries">
<!ENTITY img_next              "&webapp_base;/img/next.gif">
<!ENTITY show_next             "Show the next page of log entries">
<!ENTITY img_last_pages        "&webapp_base;/img/last.gif">
<!ENTITY show_last_pages       "Show the last page of log entries">
<!ENTITY selectedEntriesLabel  "Selected Entries: ">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <!--
   ////////////////////////////////////////////////////////////////////////
   // Create table view of the log
   ////////////////////////////////////////////////////////////////////////
   -->
   <xsl:template name="vclogtable">
      <!-- 'true' displays the task id data column -->
      <xsl:param name="showTaskIds"/>
      <!-- if non-empty, use as a filter, and assume unpaged output -->
      <xsl:param name="filterTaskId"/>
      <!-- language code -->
      <xsl:param name="lang">&default_lang_code;</xsl:param>
      <!-- pagelinks template -->
      <link rel="stylesheet" type="text/css" href="&webapp_base;/vclogtable.css"/>
      <xsl:variable name="linkTaskId">
         <xsl:choose>
            <xsl:when test="$filterTaskId=''">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="filteredEntries">
         <xsl:choose>
            <xsl:when test="not($filterTaskId='')">
               <xsl:value-of select="count(entry[taskid=$filterTaskId])"/>
            </xsl:when>
            <xsl:otherwise/>
         </xsl:choose>
      </xsl:variable>
      <!-- script to launch entry details in another browser window -->
      <script src="&webapp_base;/showhide.js" type="text/JavaScript" language="JavaScript"/>
      <script language="JavaScript">
         function detailsclick(linkdata) {
            argFeatures = "toolbar=no,menubar=no,resizable=yes,location=no,width=640,height=320,status=no,scrollbars=yes";
            window.open(linkdata, "_blank", argFeatures);
         }

         function onPageLoad(){
            setHeader();
         }

         var fHeaderIsHidden = false;
         var fFirstTime = true;
         function setHeader() {
            var oTableCol = document.getElementById("tblLblSeverity");
            var oDsplyCol = document.getElementById("hdrLblSeverity");
            if (fFirstTime)
            {
               oDsplyCol.style.width = oTableCol.offsetWidth;
               document.getElementById("logTblColSeverity").width = oDsplyCol.style.width;
               <xsl:if test="$showTaskIds='true'">
                  oTableCol = document.getElementById("tblLblTaskId");
                  oDsplyCol = document.getElementById("hdrLblTaskId");
                  oDsplyCol.style.width = oTableCol.offsetWidth;
                  document.getElementById("logTblColTaskId").width = oDsplyCol.style.width;
               </xsl:if>
               fFirstTime = false;
            }
            else
            {
               document.getElementById("logTblColSeverity").width = oDsplyCol.style.width;
               <xsl:if test="$showTaskIds='true'">
                  oDsplyCol = document.getElementById("hdrLblTaskId");
                  document.getElementById("logTblColTaskId").width = oDsplyCol.style.width;
               </xsl:if>
            }
            oTableCol = document.getElementById("logTblColDateTime");
            oDsplyCol = document.getElementById("hdrLblDateTime");
            oDsplyCol.style.width = oTableCol.offsetWidth;
            //document.getElementById("logTblColDateTime").width = oDsplyCol.style.width;

            oTableCol = document.getElementById("logTblColMessage");
            oDsplyCol = document.getElementById("hdrLblMessage");
            oDsplyCol.style.width = oTableCol.offsetWidth;
            //document.getElementById("logTblColMessage").width = oDsplyCol.style.width;

            // blank out the header under the display header (showhide toggles visibility)
            if (!fHeaderIsHidden)
            {
               // it returned visible, so toggle again
               fHeaderIsHidden = !showhide2("logHeader");
               if (!fHeaderIsHidden)
               {
                  fHeaderIsHidden = !showhide2("logHeader");
               }
            }
            var contentHeight = document.body.clientHeight;
            document.body.style.height = document.body.clientHeight;
            var oLogTableDiv = document.getElementById("divLogTable");
            // set table rows height to client height minus header, pages + footer
            oLogTableDiv.style.height = contentHeight - 19 - 24 - 54;
            var contentWidth = oLogTableDiv.offsetWidth;
            // set table rows height to client height minus header, pages + footer
            var oLogTable = document.getElementById("logTable");
            oLogTable.style.width = contentWidth - 25;
         } 
      </script>
   	 <!-- To scroll the log table but keep the header fixed, we
              need duplicate the header to a separate table, and then
              set the header column widths to match the log table.
         -->
      <table class="vcLog" width="100%" id="hdrTable" cellspacing="0" cellpadding="0" style="height:19">
         <thead class="vcLog" id="dspHeader">
            <tr class="vcLog">
               <th id="hdrLblSeverity" class="vcLog">&severity;</th>
               <xsl:if test="$showTaskIds='true'">
                  <th id="hdrLblTaskId" class="vcLog">&task_id;</th>
               </xsl:if>
               <th id="hdrLblDateTime" class="vcLog">&date_time;</th>
               <th id="hdrLblMessage" class="vcLog">&message;</th>
            </tr>
         </thead>
      </table>
      <div class="vcLog" id="divLogTable" style="overflow:auto; height:85%;">
         <table class="vcLog" width="100%" id="logTable" name="logTable" >
            <col id="logTblColSeverity"/>
            <xsl:if test="$showTaskIds='true'">
               <col id="logTblColTaskId"/>
            </xsl:if>
            <col id="logTblColDateTime"/>
            <col id="logTblColMessage"/>
            <!-- output the log entries table header -->
            <thead class="vcLog" id="logHeader">
               <tr class="vcLog">
                  <th id="tblLblSeverity" class="vcLog">&severity;</th>
                  <xsl:if test="$showTaskIds='true'">
                     <th id="tblLblTaskId" class="vcLog">&task_id;</th>
                  </xsl:if>
                  <th id="tblLblDateTime" class="vcLog">&date_time;</th>
                  <th id="tblLblMessage" class="vcLog">&message;</th>
               </tr>
            </thead>
            <tbody class="vcLog">
               <!-- here are the table rows -->
               <xsl:choose>
                  <xsl:when test="$filterTaskId">
                     <xsl:choose>
                        <xsl:when test="count(entry[taskid=$filterTaskId])=0">
                           <br/><br/><br/>
                           <b>&no_matching_entries;</b>
                           <br/>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:apply-templates select="entry[taskid=$filterTaskId]">
                              <xsl:with-param name="showTaskIds" select="$showTaskIds"/>
                              <xsl:with-param name="linkTaskId" select="$linkTaskId"/>
                              <xsl:with-param name="lang" select="$lang"/>
                              <xsl:sort select="@timestamp" order="descending"/>
                           </xsl:apply-templates>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                     <!-- NO TASKID -->
                     <xsl:apply-templates select="entry">
                        <xsl:with-param name="showTaskIds" select="$showTaskIds"/>
                        <xsl:with-param name="linkTaskId" select="$linkTaskId"/>
                        <xsl:with-param name="lang" select="$lang"/>
                        <xsl:sort select="@timestamp" order="descending"/>
                     </xsl:apply-templates>
                  </xsl:otherwise>
               </xsl:choose>
            </tbody>
         </table>
      </div>
      <xsl:if test="$filterTaskId=''">
         <div class="vcLogPages" style="height:24">
            <xsl:if test="pages">
               <xsl:call-template name="pagelinks">
                  <xsl:with-param name="pagesxml" select="pages"/>
               </xsl:call-template>
            </xsl:if>
         </div>
      </xsl:if>
      <div class="vcLogFooter">
         <xsl:attribute name="style">
            <xsl:choose>
               <xsl:when test="$filterTaskId=''">height:54; margin:0 0 -10 0</xsl:when>
               <xsl:otherwise>height:66; margin:0 0 -10 0</xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <table class="vcLogFooter">
            <tr class="vcLogFooter">
               <td class="vcLogFooter">
                  <b>&totalEntriesLabel;</b>
                  <xsl:value-of select="total_entries"/>
               </td>
            </tr>
            <xsl:if test="$filterTaskId">
               <tr class="vcLogFooter">
                  <td class="vcLogFooter">
                     <b>&selectedEntriesLabel;</b>
                     <xsl:value-of select="$filteredEntries"/>
                  </td>
               </tr>
            </xsl:if>
            <tr class="vcLogFooter">
               <td class="vcLogFooter">
                  <b>&logCreatedLabel;</b>
                  <script language="JavaScript">document.write(&vcTS2LocalDT;("<xsl:value-of select="created/when/@utcDateTime"/>"));</script>
               </td>
            </tr>
         </table>
      </div>
   </xsl:template>

   <xsl:template match="entry">
      <xsl:param name="showTaskIds"/>
      <!-- set false to remove this column's data, true to add it -->
      <xsl:param name="linkTaskId"/>
      <!-- set false to remove task id filter/link, true to add link -->
      <xsl:param name="lang"/>
      <tr class="vcLog">
         <td class="vcLog" align="center">
            <xsl:choose>
               <xsl:when test="severity = 100">
                  <img class="vcLog" src="&img_info;" height="15" width="15" title="&txt_info;"/>
               </xsl:when>
               <xsl:when test="severity = 1">
                  <img class="vcLog" src="&img_normal;" height="15" width="15" title="&txt_normal;"/>
               </xsl:when>
               <xsl:when test="severity = 3">
                  <img class="vcLog" src="&img_minor;" height="15" width="15" title="&txt_minor;"/>
               </xsl:when>
               <xsl:when test="severity = 4">
                  <img class="vcLog" src="&img_major;" height="15" width="15" title="&txt_major;"/>
               </xsl:when>
               <xsl:otherwise>
                  <img class="vcLog" src="&img_unknown;" height="15" width="15" title="&txt_unknown;"/>
               </xsl:otherwise>
            </xsl:choose>
         </td>
         <xsl:if test="$showTaskIds='true'">
            <td class="vcLog">
               <xsl:choose>
                  <xsl:when test="$linkTaskId='true'">
                     <a title="&task_id_tip;">
                        <xsl:attribute name="href">&cgi_base;?legacyuri=&hmmo_base;/log&amp;taskid=<xsl:value-of select="taskid"/></xsl:attribute>
                        <xsl:value-of select="taskid"/>
                     </a>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="taskid"/>
                  </xsl:otherwise>
               </xsl:choose>
            </td>
         </xsl:if>
         <td class="vcLog">
            <script language="JavaScript">
                       document.write(&vcTS2LocalDT;("<xsl:value-of select="@timestamp"/>"));
                     </script>
         </td>
         <td class="vcLog">
            <xsl:choose>
               <xsl:when test="xlates/xlate[@lang=$lang]">
                  <xsl:value-of select="xlates/xlate[@lang=$lang]"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="xlates/xlate[@lang='en']"/>
               </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="vcrm_href">
               &#032;[<a target="_blank">
                  <xsl:variable name="temp" select="translate(vcrm_href/@url,'?','&amp;')"/>
                  <xsl:attribute name="href">&cgi_base;?legacyuri=<xsl:value-of select="$temp"/></xsl:attribute>
                  <xsl:value-of select="vcrm_href/@txt"/>
               </a>]
            </xsl:if>
            <xsl:if test="data">
               <xsl:variable name="details_href">&cgi_base;?legacyuri=&hmmo_base;/log&amp;entryId=<xsl:value-of select="@id"/>&amp;page=<xsl:value-of select="$current_page"/></xsl:variable>
               &#032;
               [
               <a onclick="detailsclick(this.href); return false;">
                  <xsl:attribute name="href"><xsl:value-of select="$details_href"/></xsl:attribute>
                  &details;
               </a>
               ]
            </xsl:if>
         </td>
      </tr>
   </xsl:template>

   <xsl:template name="pagelinks">
      <!-- passed in nodeset parameter -->
      <xsl:param name="pagesxml"/>
      <!-- probably want CSS entries for this table -->
      <table class="vcLogPages" align="center">
         <tr class="vcLogPages">
            <xsl:if test="$pagesxml/first!=''">
               <td class="vcLogPages">
                  <xsl:call-template name="pagelink">
                     <xsl:with-param name="page_link" select="$pagesxml/first"/>
                     <xsl:with-param name="link_img">&img_first_pages;</xsl:with-param>
                     <xsl:with-param name="link_txt"/>
                     <xsl:with-param name="link_tip">&show_first_pages;</xsl:with-param>
                  </xsl:call-template>
                  </td>
            </xsl:if>
            <xsl:if test="$pagesxml/previous!=''">
               <td class="vcLogPages">
                  <xsl:call-template name="pagelink">
                     <xsl:with-param name="page_link" select="$pagesxml/previous"/>
                     <xsl:with-param name="link_img">&img_previous;</xsl:with-param>
                     <xsl:with-param name="link_txt"/>
                     <xsl:with-param name="link_tip">&show_previous;</xsl:with-param>
                  </xsl:call-template>
               </td>
            </xsl:if>
            <xsl:for-each select="$pagesxml/page">
               <td class="vcLogPages">
                  <xsl:choose>
                     <xsl:when test="not(@active='true')">
                        <xsl:call-template name="pagelink">
                           <xsl:with-param name="page_link" select="."/>
                           <xsl:with-param name="link_img"/>
                           <xsl:with-param name="link_txt" select="."/>
                           <xsl:with-param name="link_tip"/>
                        </xsl:call-template>
                     </xsl:when>
                     <xsl:otherwise>
                        <b>
                           <xsl:value-of select="."/>
                        </b>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </xsl:for-each>
            <xsl:if test="$pagesxml/next!=''">
               <td class="vcLogPages">
                  <xsl:call-template name="pagelink">
                     <xsl:with-param name="page_link" select="$pagesxml/next"/>
                     <xsl:with-param name="link_img">&img_next;</xsl:with-param>
                     <xsl:with-param name="link_txt"/>
                     <xsl:with-param name="link_tip">&show_next;</xsl:with-param>
                  </xsl:call-template>
               </td>
            </xsl:if>
            <xsl:if test="$pagesxml/last!=''">
               <td class="vcLogPages">
                  <xsl:call-template name="pagelink">
                     <xsl:with-param name="page_link" select="$pagesxml/last"/>
                     <xsl:with-param name="link_img">&img_last_pages;</xsl:with-param>
                     <xsl:with-param name="link_txt"/>
                     <xsl:with-param name="link_tip">&show_last_pages;</xsl:with-param>
                  </xsl:call-template>
               </td>
            </xsl:if>
	   </tr>
      </table>
   </xsl:template>

   <xsl:template name="pagelink">
      <!-- passed in page number -->
      <xsl:param name="page_link"/>
      <!-- passed in text - can be empty -->
      <xsl:param name="link_txt"/>
      <!-- passed in image - can be empty -->
      <xsl:param name="link_img"/>
      <!-- passed in image tip - can be empty (but shouldn't be if link_img is not) -->
      <xsl:param name="link_tip"/>
      <a>
         <xsl:attribute name="href">&cgi_base;?legacyuri=&hmmo_base;/log&amp;page=<xsl:value-of select="$page_link"/></xsl:attribute>
         <xsl:choose>
            <xsl:when test="not($link_img='')">
               <img>
                  <xsl:attribute name="src"><xsl:value-of select="$link_img"/></xsl:attribute>
                  <xsl:attribute name="title"><xsl:value-of select="$link_tip"/></xsl:attribute>
               </img>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$link_txt"/>
            </xsl:otherwise>
         </xsl:choose>
      </a>
   </xsl:template>
</xsl:stylesheet>
