<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2002 Hewlett-Packard Development Group, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!-- common entities must be in the same relative location for all projects -->
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
<!ENTITY % vclog_en SYSTEM "../dtd.en/vclog.dtd">
%vclog_en;
<!-- vclogtxt entities -->
<!ENTITY showHideDetails       "show/hide details">
<!-- do not localize -->
<!ENTITY time_date_func        "dt.toLocaleString()">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <!-- 'true' displays the task id data column -->
   <xsl:param name="showTaskIds"/>
   <!--
   ////////////////////////////////////////////////////////////////////////
   // Create table view of the log
   ////////////////////////////////////////////////////////////////////////
   -->
   <xsl:template match="/&log_element;">
      <!-- language code -->
      <xsl:param name="lang">&default_lang_code;</xsl:param>
      <html>
         <head>
            <style>
              div.logtable {width:100%;height: 90%;border:solid black 1px;}
              table {font-family: verdana, arial, helvetica;border-collapse:collapse;border:solid black 2px;}
              th {font-size:11pt;font-weight:bold;text-align:left;border:solid black 2px;}
              tr {font-size:10pt;font-weight:normal;background-color:white;}
              td {text-align:left;border-style:solid;border-width:1px 1px 1px 1px;}
              td.details {border-width:0px 1px 0px 1px;}
              p.details {font-family:georgia,courier;font-weight:normal;font-size:9pt;margin-left:5}
              table.footer {border-width:0px;}
              td.footer {border-width:0px;}
            </style>
            <title>&agent_name;&#032;:&#032;<xsl:value-of select="created/onMachine/@name"/></title>
            <script language="javascript">
               function localTime(strdt) {
                  var y, m, d, h, n, s;
                  y = strdt.substr(0, 4); m = strdt.substr(5, 2); d = strdt.substr(8, 2);
                  h = strdt.substr(11, 2); n = strdt.substr(14, 2); s = strdt.substr(17, 2);
                  var dt = new Date(Date.UTC(y, m, d, h, n, s));
                  return &time_date_func;;
               }

               var lastHighlitRow = null;
               function showhide(pos) {
                 if (lastHighlitRow != null) {
                   lastHighlitRow.style.backgroundColor = "white";
                 }
                 var detailsId = "d_" + pos;
                 var oDetails = document.getElementById(detailsId);
                 if( (oDetails.style.display == "none")) {
                   oDetails.style.display = "block";
                   var rowId = "r_" + pos;
                   lastHighlitRow = document.getElementById(rowId);
                   lastHighlitRow.style.backgroundColor = "#99FFFF";
                 }
                 else {
                   oDetails.style.display = "none";
                 }
               }
            </script>
         </head>
         <body>
            <!--div class="logtable"-->
               <!-- output the log entries table header -->
               <table width="100%">
               <!-- here is the table header -->
               <thead>
                  <tr>
                     <th>&severity;</th>
                     <xsl:if test="$showTaskIds='true'">
                        <th>&task_id;</th>
                     </xsl:if>
                     <th>&date_time;</th>
                     <th>&message;</th>
                  </tr>
               </thead>
               <tbody>
                  <!-- here are the table rows -->
                  <xsl:apply-templates select="entry">
                     <xsl:with-param name="showTaskIds" select="$showTaskIds"/>
                     <xsl:with-param name="lang" select="$lang"/>
                     <xsl:sort select="@timestamp" order="descending"/>
                  </xsl:apply-templates>
               </tbody>
            </table>
         <!--/div-->
         <br/>
         <!--div-->
            <table class="footer">
               <tr>
                  <td class="footer">
                    <b>&totalEntriesLabel;</b>
                     <xsl:value-of select="total_entries"/>
                  </td>
               </tr>
               <tr>
                  <td class="footer">
                     <b>&logCreatedLabel;</b>
                     <script language="JavaScript">document.write(localTime("<xsl:value-of select="created/when/@utcDateTime"/>"));</script>
                  </td>
               </tr>
            </table>
         <!--/div-->
      </body>
      </html>
   </xsl:template>

   <xsl:template match="entry">
      <!-- set false to remove this column's data, true to add it -->
      <xsl:param name="showTaskIds"/>
      <xsl:param name="lang"/>
      <xsl:variable name="detailsId">d_<xsl:number value="position()"/></xsl:variable>
      <xsl:variable name="anchor">a_<xsl:number value="position()"/></xsl:variable>
      <tr><xsl:attribute name="id">r_<xsl:number value="position()"/></xsl:attribute>
         <a><xsl:attribute name="name"><xsl:value-of select="$anchor"/></xsl:attribute></a>
         <td>
            <xsl:choose>
               <xsl:when test="severity = 100">&txt_info;</xsl:when>
               <xsl:when test="severity = 1">&txt_normal;</xsl:when>
               <xsl:when test="severity = 3">&txt_minor;</xsl:when>
               <xsl:when test="severity = 4">&txt_major;</xsl:when>
               <xsl:otherwise>&txt_unknown;</xsl:otherwise>
            </xsl:choose>
         </td>
         <xsl:if test="$showTaskIds='true'">
            <td><xsl:value-of select="taskid"/></td>
         </xsl:if>
         <td>
            <script language="JavaScript">document.write(localTime("<xsl:value-of select="@timestamp"/>"));</script>
         </td>
         <td>
            <xsl:choose>
               <xsl:when test="xlates/xlate[@lang=$lang]">
                  <xsl:value-of select="xlates/xlate[@lang=$lang]"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="xlates/xlate[@lang='en']"/>
               </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="vcrm_href">&#032;[<xsl:value-of select="vcrm_href/@txt"/>]</xsl:if>
            <xsl:if test="data">&#032;[<a><xsl:attribute name="href">#<xsl:value-of select="$anchor"/></xsl:attribute><xsl:attribute name="onclick">showhide('<xsl:number value="position()"/>')</xsl:attribute>&showHideDetails;</a>]
               <p class="details" style="display:none;">
                  <xsl:attribute name="id"><xsl:value-of select="$detailsId"/></xsl:attribute>
                  <xsl:value-of select="data" disable-output-escaping="yes"/>
               </p>
            </xsl:if>

         </td>
      </tr>
   </xsl:template>
</xsl:stylesheet>
