<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2001-2003 Hewlett-Packard Development Company, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_ja SYSTEM "../dtd.ja/common.dtd">
%common_ja;
<!ENTITY nothing_available  "利用可能なソフトウェアはありません。">
<!ENTITY not_for_printing  "このページは印刷専用です。">
<!ENTITY txtSwStatusTitle "ソフトウェア ステータス">
<!ENTITY lblPrint "インストール済みインベントリの印刷">
<!ENTITY txtPageInstalledTitle "インストール済みソフトウェア">
<!ENTITY txtPageAvailSWTitle "利用可能ソフトウェア">
<!ENTITY txtSettingsTask "&#60;b&#62;エージェント設定の変更&#60;/b&#62;">
<!ENTITY lblOverallStatus         "全体のソフトウェア ステータス:&#160;">
<!ENTITY txtUnknownStatusNoVcrm   "&vcr_name; の名前が定義されていないためステータスを計算することができません。&vcr_name; を指定するには、エージェント設定変更タスクをクリックしてください。">
<!ENTITY txtUnknownStatus         "現在の &vcr_name; はステータスを応答しません。詳細情報はログを確認してください。別の &vcr_name;を指定するには、エージェント設定変更タスクをクリックしてください。">
<!ENTITY lblRefSupportPaq         "&txtRefSupportPaq;:&#160;">
<!ENTITY txtNoRefSP               "選択がありません。リファレンス&support_paq;を指定するには、エージェント設定変更タスクをクリックしてください。">
<!ENTITY txtItemDescHrefTip "アイテムの詳細を表示します。&vcr_name;.からリンクされます。">
<!ENTITY txtInstallTip            "ソフトウェアのインストール/アップデート">
<!ENTITY txtInstallDisabledTip    "ソフトウェアのインストールには、オペレータまたは管理者アクセスが必要です。">
<!ENTITY txtInstallDisabledSettingsTip "エージェント設定は、ソフトウェアのインストールを禁止します">
<!ENTITY txtName                  "名前">
<!ENTITY txtInstalledVersion      "インストール済みバージョン">
<!ENTITY txtBundleVersion         "&support_paq; バージョン">
<!ENTITY txtNewVersion            "最新バージョン">
<!ENTITY lblInventoryCreated      "最終作成日:">

<!ENTITY txtSeverity0             "">
<!ENTITY txtSeverity1 "このアップデートは、バグフィックスまたは新しいハードウェア サポートを含んでいます。&cpq;はこのバージョンについての情報を確認して、このアップデートを適切に適用することを推奨します。">
<!ENTITY txtSeverity2 "このアップデートは、クリティカルなバグフィックスが含まれています。&cpq;は、できるだけ早くこのアップデートを適用することを要求します。">
<!ENTITY txtNotEqualStatus "インストール済みのバージョンは参照用Support Pack中の同じ項目のバージョンと一致しません。そしてバージョン コントロール エージェント設定は正確に一致することを期待されています。">
<!ENTITY imgUpdate "&webapp_base;/img.en/upd.gif">
<!ENTITY imgDisabledUpdate "&webapp_base;/img.en/disupd.gif">
<!ENTITY imgHorizLine "&webapp_base;/img/horizlng.gif">
<!ENTITY installWndWidth          "600">
<!ENTITY installWndHeight         "400">
]>
<!-- end of localization header -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="operator">false</xsl:param>
   <xsl:param name="lang">&default_lang_code;</xsl:param>
   <xsl:param name="taskId">unknown</xsl:param>
   <xsl:param name="hmmoversion">1.0.0.0</xsl:param>
   <xsl:include href="menutasks.xsl"/>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <!-- check for "false" since older VCRMs didn't insert this attribute -->
   <xsl:variable name="operator_access">
      <xsl:choose><xsl:when test="softwareInventory[@operator_access='false']">false</xsl:when>
      <xsl:otherwise>true</xsl:otherwise></xsl:choose>
   </xsl:variable>
   <xsl:template match="softwareInventory">
      <html>
         <head>
            <meta http-equiv="pragma" content="no-cache"/>
            <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT"/>
            <link id="ReportStyles" rel="stylesheet" href="&webapp_base;/cpqwh.css" type="text/css"/>
            <title>
               <xsl:value-of select="machineName"/> - &txtPageInventoryTitle;</title>
            <script src="&webapp_base;/timedate.js" language="JavaScript"/>
            <script src="&webapp_base;/timedate.vb" language="VBScript"/>
            <script src="&webapp_base;/showhide.js" type="text/javascript" language="JavaScript"/>
            <script language="javascript">
            function onMouseOverInstallIcon(img) {
               var mouse_pointer = "pointer";
               if (navigator.appName.toLowerCase() == "microsoft internet explorer") {
                  if (6 > parseInt(navigator.appVersion)) {
                     mouse_pointer = "hand";
                  }
               }
               img.style.cursor = mouse_pointer;
            }

            var wndInstall;
            // this function called from setTimeout to increase likelihood that the window is loaded
            function submitInstall(formHtml) {
               wndInstall.focus();
               // copy the hidden form to it and submit from there
               wndInstall.document.open("text/html","replace");
               wndInstall.document.write("&lt;html&gt;&lt;body&gt;"+formHtml+"&lt;/body&gt;&lt;/html&gt;");
               wndInstall.document.close();
               var oInvForm = wndInstall.document.getElementById("inventory");
               oInvForm.submit();
            }
            // handle the install icon click
            function update(str1, str2) {
               // open the installer window first
               var style = "toolbar=0,directories=0,status=0,menubar=0,scrollbars=1,resizable=1,width=&installWndWidth;,height=&installWndHeight;";
               if (!wndInstall|| wndInstall.closed) {
                  wndInstall = window.open("", "", style);
               }
               if (str2.substr(str2.length - 1, 1) == ",")
                  // trim trailing comma
                  str2 = str2.substr(0, str2.length - 1);
               // set form hidden values
               document.inventory.displayName.value = str1;
               document.inventory.packageList.value = str2;
               // fill out window after a pause to allow it to load
               setTimeout("submitInstall(document.getElementById(\"inventoryForm\").innerHTML);", 100);
               return false;
            }

            // mozilla doesn't support outerHtml property...
            function GetOuterHTML(o) {
               var sTag = o.tagName;
               if (sTag.length == 0) return "";
               
               var sHTML = "&lt;" + sTag;
               var oAttrs = o.attributes;
               var idxAttr;
               var nAttrs = oAttrs.length;
               for (idxAttr = 0; idxAttr &lt; nAttrs; idxAttr++)
               {
                  var sVal = oAttrs[idxAttr].value;
                  if (sVal != "null" &amp;&amp; sVal != "")
                     sHTML += " " + oAttrs[idxAttr].name + "=\"" + sVal + "\"";
               }
               // close the outer HTML tag, including inner HTML if there is any
               var sInnerHTML = o.innerHTML;
               if ((sInnerHTML != null) &amp;&amp; sInnerHTML.length)
               {
                  sHTML += ("&gt;" + sInnerHTML + "&lt;/" + sTag +"&gt;");
               }
               else
               {
                  if ((sTag=="LINK") || (sTag=="BR") || (sTag=="IMG") || (sTag=="META"))
                     sHTML += "&gt;";
                  else
                     sHTML += "/&gt;";
               }
               <!-- default setting of disabled="false" messes up css in IE -->
               var reDisabledAttr = /disabled\=.false./i 
               return sHTML.replace(reDisabledAttr, "");
            }

            function doPrint()
            {
                // write outer HTML and onload handler
                var text = "&lt;html&gt;&lt;head&gt;\n ";
                text += GetOuterHTML(document.getElementById("ReportStyles"));
                text += "\n &lt;script language=\&quot;JavaScript\&quot; &gt;\n";
                text += "  function print_it() {\n";
                text += "    var icn = document.getElementById(\"PrintIcon\");\n";
                text += "    icn.innerHTML = \"\";\n";
                <!-- if new handlers are added to different tags, this function must change -->
                text += "    var tags, t, nTags;\n";
                <!-- remove onclicks, and onmousemoves from "A" tags - DOES NOT WORK! &^%$% -->
                text += "    tags = document.getElementsByTagName(\"A\");\n";
                text += "    nTags = tags.length;\n";
                text += "    for( t = 0 ; t != nTags; t++ ){\n";
                text += "      tags[t].href = \"\";\n";
                text += "      tags[t].target = \"\";\n";
                text += "      tags[t].onclick = \"\";\n";
                text += "      tags[t].onmousemove = \"\";\n";
                text += "    }\n";
                <!-- remove onmouseover from "IMG" tags -->
                text += "    tags = document.getElementsByTagName(\"IMG\");\n";
                text += "    nTags = tags.length;\n";
                text += "    for( t = 0 ; t != nTags ; t++ )\n";
                text += "      tags[t].onmouseover = \"\";\n";
                text += "    setTimeout(\"window.print();window.close()\", 100);\n";
                text += "  }\n";
                text += "       function noMouseClick() {\n";
                text += "       alert('&not_for_printing;')\n";
                text += "}\n";
                text += "document.onmousedown=noMouseClick\n";
                text += (" &lt;" + "/" + "script&gt;\n");
                text += ("&lt;" + "/" + "head&gt;\n");
                text += "&lt;body onload=\&quot;print_it();\&quot; &gt;";

                // pick up the parts of the document we want to display and print
                var i = 0;
                while( true )
                {
                    var name = "InvReport"+i;
                    var obj = document.getElementById(name);
                    if( obj == null )
                        break;

                    var sInOut = obj.getAttribute("ReportFmt", false);
                    if (sInOut == "includeTag" )
                    {
                       text += GetOuterHTML(obj);
                    }
                    else
                    {
                        text += obj.innerHTML;
                    }
                    i++;
                }
                // close the html page
                text += "&lt;/body&gt;&lt;/html&gt;";
                // display it
                //var args = "width=10,height=10,left=20,top=20,scrollbars,resizable,top=0,left=0";
                var win = window.open();
                win.focus( );
                win.document.open("text/html","replace");
                win.document.write(text);
                win.document.close();
            }

            function showhideAvailable(oMenu){
               var oAvailable = document.getElementById("available");
               if (null == oAvailable) {
                   // there is no available software to show or hide
                   window.alert("&nothing_available;");
                   return;
               }
               var bShowing = showhide2("available")
               if (bShowing) {
                  var new_txt = document.createTextNode("&home_task_hide_all;");
                  oMenu.cells[1].replaceChild(new_txt, oMenu.cells[1].childNodes[0]);
               }
               else {
                  var new_txt = document.createTextNode("&home_task_show_all;");
                  oMenu.cells[1].replaceChild(new_txt, oMenu.cells[1].childNodes[0]);
               }
            }

            function onPageLoad(){
               if (null != window.parent) {
                  window.parent.FrameLoaded(window.name);
               }
            }
            // the frameset calls this when the frames are all loaded
            function onFramesLoaded() {
               // make sure the nav frame highlights the right
               // tab when user pressed back/forward button
               window.parent.navigation.setTab("HomeTab");
            }
         </script>
         <style type="text/css">
            table.content {margin: 0 0 0 0}
            td.tabnavbar {padding-left:0; padding-top:2;}
            td.tabcontent {padding-left:5; padding-top:5;}
            table.status {width=100%}
            table.status th {text-align:left; background-color:#336699; color:#FFFFFF}
            table.status td {font-size:9pt; padding: 2 10 0 2}
         </style>
         </head>
         <body bgcolor="#FFFFFF" text="#000000" onLoad="onPageLoad();">
            <table class="content" style="height:92%;" width="100%" border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <!-- menu/nav bar column -->
                  <td class="tabnavbar" width="114" bgcolor="#336699" valign="top">
                     <xsl:call-template name="taskmenu">
                        <xsl:with-param name="curTabId">HomeTab</xsl:with-param>
                        <xsl:with-param name="operator"><xsl:value-of select="$operator"/></xsl:with-param>
                     </xsl:call-template>
                  </td>
                  <!-- content column -->
                  <td class="tabcontent" valign="top">
                     <!-- inventory / available software -->
                     <div style="overflow: auto;">
                        <xsl:apply-templates select="installedSoftware|allSoftware"/>
                     </div>
                     <!-- inventory page footer -->
                     <br/>
                     <div class="pageFooter">
                        <table cellspacing="0" border="0">
                           <tr>
                              <td nowrap="1">
                                 <b>&lblInventoryCreated;</b>
                              </td>
                              <td width="100%">
                                 <script>document.write(&vcTS2LocalDT;('<xsl:value-of select="created/@utcDateTime"/>'));</script>
                              </td>
                           </tr>
                        </table>
                     </div>
                  </td>
               </tr>
            </table>
            <div class="pageFooter">
               <table cellspacing="0" border="0">
                  <tr>
                     <td>&cpq_vca_name;&#032;
                        <a>
                           <xsl:value-of select="$hmmoversion"/>
                        </a>
                     </td>
                  </tr>
               </table>
            </div>
            <div name="inventoryForm" id="inventoryForm">
               <!-- hidden form fields -->
               <form name="inventory" id="inventory" method="post" action="&cgi_base;">
                  <input type="hidden" id="legacyuri" name="legacyuri" value="&hmmo_base;/install"/>
                  <input type="hidden" id="displayName" name="displayName"/>
                  <input type="hidden" id="packageList" name="packageList"/>
                  <input type="hidden" id="taskId" name="taskId">
                     <xsl:attribute name="value"><xsl:value-of select="$taskId"/></xsl:attribute>
                  </input>
               </form>
            </div>
         </body>
      </html>
   </xsl:template>
   <!-- installed software status template -->
   <xsl:template name="softwareStatus">
      <img>
         <xsl:choose>
            <xsl:when test="status[@value='1']">
               <xsl:attribute name="src">&img_minor;</xsl:attribute>
               <xsl:attribute name="title">&txtSeverity1;</xsl:attribute>
            </xsl:when>
            <xsl:when test="status[@value='2']">
               <xsl:attribute name="src">&img_major;</xsl:attribute>
               <xsl:attribute name="title">
                  <xsl:choose>
                     <xsl:when test="status[@not_equal_status='yes']">&txtNotEqualStatus;</xsl:when>
                     <xsl:otherwise>&txtSeverity2;</xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="src">&img_normal;</xsl:attribute>
               <xsl:attribute name="title">&txtSeverity0;</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
      </img>
   </xsl:template>

   <!-- installed software template -->
   <xsl:template match="installedSoftware">
      <div id="InvReport0" ReportFmt="includeTag" class="pageSectionTitle">
         <table width="100%" cellspacing="0" border="0">
            <tr>
               <td>&txtSwStatusTitle;</td>
               <td id="PrintIcon" align="center" width="30"><a href="javascript:doPrint();"><img title="&lblPrint;" width="16" height="14" src="&webapp_base;/img/print.gif" /></a></td>
            </tr>
         </table>
      </div>
      <xsl:variable name="has_bundle_info">
         <xsl:choose>
            <xsl:when test="(/softwareInventory/bundle/name/name_xlate[@lang=$lang]) or (/softwareInventory/bundle/name/name_xlate[@lang='en'])">
               <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="false()"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <table id="InvReport1" ReportFmt="includeTag" style="width:95%;" cellspacing="0" border="0">
         <tr>
            <td align="right" nowrap="true" valign="top">
               <b>&lblOverallStatus;</b>
            </td>
            <xsl:choose>
               <xsl:when test="/softwareInventory/repository">
                  <xsl:choose>
                     <xsl:when test="/softwareInventory/installedSoftware/status">
                        <td colspan="2">
                           <xsl:call-template name="softwareStatus"/>
                        </td>
                     </xsl:when>
                     <xsl:otherwise>
                        <!-- a VCRM without status - we assume w/o bundle info, too -->
                        <td valign="top">
                           <img src="&img_unknown;" title="&txt_unknown;"/>&#160;</td>
                        <td valign="top">&txtUnknownStatus;</td>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:when>
               <xsl:otherwise>
                  <!-- the VCRM has not been specified -->
                  <td valign="top">
                     <img src="&img_unknown;" title="&txt_unknown;"/>&#160;</td>
                  <td valign="top">&txtUnknownStatusNoVcrm;</td>
               </xsl:otherwise>
            </xsl:choose>
         </tr>
         <xsl:if test="/softwareInventory/repository">
            <tr>
               <td align="right" nowrap="true" valign="top">
                  <b>&lblRefSupportPaq;</b>
               </td>
               <xsl:choose>
                  <xsl:when test="$has_bundle_info='true'">
                     <td colspan="2">
                        <xsl:for-each select="/softwareInventory/bundle[1]">
                           <!-- only one! -->
                           <xsl:call-template name="available_item"/>
                        </xsl:for-each>
                     </td>
                  </xsl:when>
                  <xsl:otherwise>
                     <td colspan="2">&txtNoRefSP;</td>
                  </xsl:otherwise>
               </xsl:choose>
            </tr>
         </xsl:if>
      </table>
      <br id="InvReport2" ReportFmt="includeTag"/>
      <!-- Inventory table -->
      <div align="center" name="installed" id="installed" style="width:95%; ">
         <div id="InvReport3" ReportFmt="includeTag" class="pageSectionTitle">
            <table width="100%" cellspacing="0" border="0">
               <tr>
                  <td>&txtPageInstalledTitle;</td>
               </tr>
            </table>
         </div>
         <br/>
         <div id="InvReport4" class="tableStyle1">
            <table style="width:95%; text-align:center" cellspacing="0" border="0">
               <thead>
                  <tr>
                     <th align="left">&txtName;</th>
                     <th>&txtInstalledVersion;</th>
                     <!-- only add these columns if the repositoryName element is present -->
                     <xsl:if test="/softwareInventory/repository">
                        <xsl:if test="$has_bundle_info='true'">
                           <th colspan="2">&txtBundleVersion;</th>
                        </xsl:if>
                        <th colspan="2">&txtNewVersion;</th>
                     </xsl:if>
                  </tr>
               </thead>
               <tbody>
                  <xsl:for-each select="swItemList/swItem">
                     <xsl:variable name="inventory_item" select="."/>
                     <tr>
                        <td style="text-align:left;">
                           <xsl:choose>
                              <xsl:when test="name/name_xlate[@lang=$lang]">
                                 <xsl:value-of select="name/name_xlate[@lang=$lang]"/>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:value-of select="name/name_xlate[@lang='en']"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </td>
                        <td align="center">
                           <xsl:if test="key[@not_equal_status='yes']">
                              <xsl:attribute name="style">font-weight:bold; color:red;</xsl:attribute>
                           </xsl:if>
                           <xsl:value-of select="installedVer"/>
                        </td>
                        <xsl:choose>
                           <xsl:when test="availableVersions/availableVersion[@category='bundle']">
                              <xsl:for-each select="availableVersions/availableVersion[@category='bundle'][1]">
                                 <td align="right">
                                    <xsl:call-template name="softwareStatus"/>
                                 </td>
                                 <td align="left">
                                    <xsl:call-template name="available_inventory_item">
                                       <xsl:with-param name="inventory_item" select="$inventory_item"/>
                                    </xsl:call-template>
                                 </td>
                              </xsl:for-each>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:if test="$has_bundle_info='true'">
                                 <!-- an empty column entry -->
                                 <td/>
                                 <td/>
                              </xsl:if>
                           </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                           <xsl:when test="availableVersions/availableVersion[@category='newest']">
                              <xsl:for-each select="availableVersions/availableVersion[@category='newest'][1]">
                                 <td align="right">
                                    <xsl:call-template name="softwareStatus"/>
                                 </td>
                                 <td align="left">
                                    <xsl:call-template name="available_inventory_item">
                                       <xsl:with-param name="inventory_item" select="$inventory_item"/>
                                    </xsl:call-template>
                                 </td>
                              </xsl:for-each>
                           </xsl:when>
                           <xsl:otherwise>
                              <!-- an empty column entry -->
                              <td/>
                              <td/>
                           </xsl:otherwise>
                        </xsl:choose>
                     </tr>
                     <tr>
                        <xsl:choose>
                           <xsl:when test="/softwareInventory/repository">
                              <xsl:choose>
                                 <xsl:when test="/softwareInventory/bundle">
                                    <td colspan="6">
                                       <img src="&imgHorizLine;" height="1px" width="100%"/>
                                    </td>
                                 </xsl:when>
                                 <xsl:otherwise>
                                    <td colspan="4">
                                       <img src="&imgHorizLine;" height="1px" width="100%"/>
                                    </td>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:when>
                           <xsl:otherwise>
                              <td colspan="2">
                                 <img src="&imgHorizLine;" height="1px" width="100%"/>
                              </td>
                           </xsl:otherwise>
                        </xsl:choose>
                     </tr>
                  </xsl:for-each>
               </tbody>
            </table>
         </div>
         <br/>
         <br/>
      </div>
   </xsl:template>

   <!-- all available software template is initially hidden -->
   <xsl:template match="allSoftware">
      <div align="center" name="available" id="available" style="width:95%; display:none;">
         <div class="pageSectionTitle">
            <table width="100%" cellspacing="0" border="0">
               <tr><td>&txtPageAvailSWTitle;</td></tr>
            </table>
         </div>
         <br/>
         <xsl:for-each select="swCategory">
            <xsl:if test="count(bundleList/bundle) > 0 or count(swItemList/swItem) > 0">
               <div class="tableStyle1">
                  <table style="width:95%;" cellspacing="0" border="0">
                     <thead>
                        <tr>
                           <th align="left">
                              <xsl:choose>
                                 <xsl:when test="name/name_xlate[@lang=$lang]">
                                    <xsl:value-of select="name/name_xlate[@lang=$lang]"/>
                                 </xsl:when>
                                 <xsl:otherwise>
                                    <xsl:value-of select="name/name_xlate[@lang='en']"/>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </th>
                        </tr>
                     </thead>
                     <tbody>
                        <xsl:for-each select="bundleList">
                           <xsl:for-each select="bundle">
                              <tr>
                                 <td style="border-bottom:1px solid silver;">
                                    <xsl:call-template name="available_item"/>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:for-each>
                        <xsl:for-each select="swItemList">
                           <xsl:for-each select="swItem">
                              <tr>
                                 <td style="border-bottom:1px solid silver;">
                                    <xsl:call-template name="available_item"/>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:for-each>
                     </tbody>
                  </table>
               </div>
               <br/>
            </xsl:if>
         </xsl:for-each>
         <br/>
      </div>
   </xsl:template>

   <xsl:template name="repo_item">
      <xsl:param name="long_name"/>
      <xsl:param name="display_name"/>
      <xsl:param name="package_list"/>
      <xsl:param name="vcr_href"/>
      <xsl:variable name="fixed_lname">
         <xsl:call-template name="escape_apos">
            <xsl:with-param name="in_str" select="$long_name"/>
         </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="$operator_access='false'">
            <img title="&txtInstallDisabledSettingsTip;" align="absmiddle" src="&imgDisabledUpdate;" border="0"/>
         </xsl:when>
         <xsl:when test="$operator='true'">
            <a onmousemove="javascript:window.status='';">
               <xsl:attribute name="onclick">update('<xsl:value-of select="$fixed_lname"/>', '<xsl:value-of select="$package_list"/>')</xsl:attribute>
               <img title="&txtInstallTip;" align="absmiddle" src="&imgUpdate;" border="0" onmouseover="onMouseOverInstallIcon(this);"/>
            </a>
         </xsl:when>
         <xsl:otherwise>
            <img title="&txtInstallDisabledTip;" align="absmiddle" src="&imgDisabledUpdate;" border="0"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:text/>
      <a target="_blank">
         <xsl:attribute name="title">&txtItemDescHrefTip;</xsl:attribute>
         <xsl:attribute name="href">&cgi_base;?legacyuri=&hmmo_base;/vcrproxy/<xsl:value-of select="$vcr_href"/></xsl:attribute>
         <xsl:value-of select="$display_name"/>
      </a>
   </xsl:template>

   <xsl:template name="available_item">
      <xsl:variable name="item_long_name">
         <xsl:choose>
            <xsl:when test="name/name_xlate[@lang=$lang]">
               <xsl:value-of select="name/name_xlate[@lang=$lang]"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="name/name_xlate[@lang='en']"/>
            </xsl:otherwise>
         </xsl:choose>&txtVersion; <xsl:value-of select="version/@value"/>
         <xsl:value-of select="version/@revision"/>
         <xsl:choose>
            <xsl:when test="languages/languages_xlate[@lang=$lang]">&#032;(<xsl:value-of select="languages/languages_xlate[@lang=$lang]"/>)</xsl:when>
            <xsl:when test="languages/languages_xlate[@lang='en']">&#032;(<xsl:value-of select="languages/languages_xlate[@lang='en']"/>)</xsl:when>
            <xsl:otherwise/>
         </xsl:choose>
      </xsl:variable>
      <xsl:call-template name="repo_item">
         <xsl:with-param name="long_name">
            <xsl:value-of select="$item_long_name"/>
         </xsl:with-param>
         <xsl:with-param name="display_name">
            <xsl:value-of select="$item_long_name"/>
         </xsl:with-param>
         <xsl:with-param name="package_list">
            <xsl:choose>
               <xsl:when test="packageList">
                  <xsl:for-each select="packageList/package">
                     <xsl:value-of select="@fileName"/>,</xsl:for-each>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="package"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:with-param>
         <xsl:with-param name="vcr_href">
            <xsl:value-of select="descriptionHref"/>
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>

   <xsl:template name="available_inventory_item">
      <xsl:param name="inventory_item"/>
      <xsl:call-template name="repo_item">
         <xsl:with-param name="long_name">
            <xsl:choose>
               <xsl:when test="$inventory_item/name/name_xlate[@lang=$lang]">
                  <xsl:value-of select="$inventory_item/name/name_xlate[@lang=$lang]"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="$inventory_item/name/name_xlate[@lang='en']"/>
               </xsl:otherwise>
            </xsl:choose>&txtVersion;<xsl:value-of select="./@value"/>
            <xsl:value-of select="./@revision"/>
         </xsl:with-param>
         <xsl:with-param name="display_name">
            <xsl:value-of select="./@value"/>
            <xsl:value-of select="./@revision"/>
         </xsl:with-param>
         <xsl:with-param name="package_list">
            <xsl:value-of select="package"/>
         </xsl:with-param>
         <xsl:with-param name="vcr_href" select="descriptionHref"/>
      </xsl:call-template>
   </xsl:template>

   <xsl:template name="escape_apos">
      <xsl:variable name="replace">&apos;</xsl:variable>
      <xsl:param name="in_str"/>
      <xsl:choose>
         <xsl:when test="contains($in_str, $replace)">
            <xsl:value-of select="substring-before($in_str, $replace)"/>
            <xsl:text disable-output-escaping="no">\%27</xsl:text>
            <xsl:call-template name="escape_apos">
               <xsl:with-param name="in_str" select="substring-after($in_str, $replace)"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$in_str"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>
