<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2002 Hewlett-Packard Development Group, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_ja SYSTEM "../dtd.ja/common.dtd">
%common_ja;
<!ENTITY % vclog_ja SYSTEM "../dtd.ja/vclog.dtd">
%vclog_ja;
<!ENTITY pagetitle_clear "ログの消去 - &agent_name;">
<!ENTITY wiztitle_clear "&agent_name; ログの消去">
<!ENTITY heading_save "テキスト保存オプション">
<!ENTITY save_instructions "すべてのエントリを消去する前に、テキスト ページとしてログを保存する場合は、チェックボックスをチェックしてください。保存するファイルの位置が問い合わせられます。">
<!ENTITY label_save "ログテキストの保存">
<!ENTITY heading_clear "消去">
<!ENTITY clear_instructions "完了ボタンをクリックして、ログを消去してください。この処理は回復または中断することはできません。">
<!ENTITY close_instructions "閉じるボタンを押してこのウィンドウを閉じて、ログ ページをリフレッシュしてください。">
<!ENTITY close_save_instructions "ログファイルが保存されたら、閉じるボタンをクリックし、このウィンドウを閉じてログ ページをリフレッシュしてください。">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="log_clr_msg"/>
   <xsl:param name="saveckbox"/>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <xsl:template match="/">
      <xsl:variable name="read_only">
         <xsl:choose>
            <xsl:when test="not($log_clr_msg='')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <html>
         <head>
            <meta http-equiv="pragma" content="no-cache"/>
            <xsl:if test="$saveckbox='save'"><meta http-equiv="Refresh" content="1;url=&cgi_base;?legacyuri=&hmmo_base;/clrlogwiz&amp;logsave=true"/></xsl:if>
            <link rel="stylesheet" href="&webapp_base;/cpqwiz.css" type="text/css"/>
            <title>&heading_clear; - &agent_name;</title>
            <script src="&webapp_base;/frameck.js" type="text/JavaScript" language="JavaScript"/>
            <script language="JavaScript">
               var isAfterClear = <xsl:value-of select="$read_only"/>;
               function cancelclick() {
                  window.close();
               }
               function finishclick() {
                  document.getElementById("Finish").disabled = true;
                  document.getElementById("Cancel").disabled = true;
                  // redirect to the cleared log result -- this was a form post, but
                  // it wasn't possible to do the resulting download in a single operation
                  var url = "&cgi_base;?legacyuri=&hmmo_base;/logclr";
                  if (document.getElementById("saveckbox").checked) {
                     url += "&amp;saveckbox=save";
                  }
                  location.href = url;
               }
               function closeclick() {
                  // reload content page if it's currently active
                  if ((window.opener != null) &amp;&amp; (window.opener.parent != null)
                        &amp;&amp; (!window.opener.closed)) {
                     if (InOpenerFrameset("&webapp_base;")) {
                        window.opener.parent.frames[0].ReloadContentPage("LogTab");
                     }
                     else {
                        window.opener.location.reload();
                     }
                  }
                  isAfterClear = false; // prevent double-refresh
                  window.close();
               }
               <xsl:if test="$saveckbox='save'">
                  function pageload() {
                     // when they saved the log, wait before enabling the close button
                     <xsl:choose>
                        <xsl:when test="$saveckbox='save'">setTimeout("document.getElementById('Close').disabled=false;",6000);</xsl:when>
                        <xsl:otherwise>document.getElementById('Close').disabled=false;</xsl:otherwise>
                     </xsl:choose>
                  }
               </xsl:if>
               function pageunload() {
                  // this catches closings from closing the window or redirection
                  if (isAfterClear==true) {
                     if ((window.opener != null) &amp;&amp; (window.opener.parent != null)
                           &amp;&amp; (!window.opener.closed)) {
                        if (InOpenerFrameset("&webapp_base;")) {
                           window.opener.parent.frames[0].ReloadContentPage("LogTab");
                        }
                        else {
                           window.opener.location.reload();
                        }
                     }
                  }
               }
            </script>
         </head>
         <body onUnload="pageunload();">
            <xsl:if test="$saveckbox='save'">
               <xsl:attribute name="onload">pageload();</xsl:attribute>
            </xsl:if>
            <center>
               <div class="wiztitle">
                  <table width="100%" cellspacing="0" border="0">
                     <tr>
                        <td>&wiztitle_clear;</td>
                     </tr>
                  </table>
               </div>
               <xsl:if test="not($log_clr_msg='')">
                  <br/>
                  <b>
                     <xsl:value-of select="$log_clr_msg"/>
                  </b>
               </xsl:if>
               <form action="&cgi_base;" method="post" name="logclear">
                  <input type="hidden" name="method" id="method" value="logclear"/>
                  <input type="hidden" name="legacyuri" value="&hmmo_base;/logclr"/>
                  <br/>
                  <p>
                     <div class="wiztable">
                        <table width="90%">
                           <col width="30%"/>
                           <col width="70%"/>
                           <thead>
                              <tr>
                                 <th align="left" colspan="2">&heading_save;</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td colspan="2">&save_instructions;</td>
                              </tr>
                              <tr>
                                 <td>
                                    <b>&label_save;</b>
                                 </td>
                                 <td>
                                    <input type="checkbox" size="10" name="saveckbox" id="saveckbox" value="save">
                                       <xsl:if test="$read_only='true'">
                                          <xsl:attribute name="disabled">1</xsl:attribute>
                                          <xsl:if test="$saveckbox='save'">
                                             <xsl:attribute name="checked">1</xsl:attribute>
                                          </xsl:if>
                                       </xsl:if>
                                    </input>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <p>
                     <div class="wiztable">
                        <table width="90%">
                           <thead>
                              <tr>
                                 <xsl:choose>
                                    <xsl:when test="$read_only='true'">
                                       <th align="left">&txt_btn_close;</th>
                                    </xsl:when>
                                    <xsl:otherwise>
                                       <th align="left">&heading_clear;</th>
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <xsl:choose>
                                    <xsl:when test="$read_only='true'">
                                       <td>
                                          <xsl:choose>
                                             <xsl:when test="$saveckbox='save'">&close_save_instructions;</xsl:when>
                                             <xsl:otherwise>&close_instructions;</xsl:otherwise>
                                          </xsl:choose>
                                       </td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                       <td>&clear_instructions;</td>
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <!-- wizard buttons -->
                  <xsl:choose>
                     <xsl:when test="$read_only='true'">
                        <table width="90%" cellspacing="0" border="0">
                           <col width="100%"/>
                           <!-- put wizard buttons on the right side -->
                           <tbody>
                              <tr>
                                 <td align="right" style="padding: 0px 3px">
                                    <input type="button" name="Close" id="Close" value="&txt_btn_close;" onclick="closeclick();">
                                       <xsl:if test="$saveckbox='save'">
                                          <xsl:attribute name="disabled">true</xsl:attribute>
                                       </xsl:if>
                                    </input>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </xsl:when>
                     <xsl:otherwise>
                        <table width="90%" cellspacing="0" border="0">
                           <!-- put wizard buttons on the right side -->
                           <col width="97%"/>
                           <col width="1%"/>
                           <col width="1%"/>
                           <tbody>
                              <tr>
                                 <td align="left">
                                    <input type="reset" name="Reset" id="Reset" value="&txt_btn_reset;"/>
                                 </td>
                                 <td align="center" style="padding: 0px 3px">
                                    <input type="button" name="Finish" id="Finish" value="&txt_btn_finish;" onclick="finishclick();"/>
                                 </td>
                                 <td align="center" style="padding: 0px 3px">
                                    <input type="button" name="Cancel" id="Cancel" value="&txt_btn_cancel;" onclick="cancelclick();"/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </xsl:otherwise>
                  </xsl:choose>
               </form>
            </center>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
