<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2003 Hewlett-Packard Development Company, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_ja SYSTEM "../dtd.ja/common.dtd">
%common_ja;
<!ENTITY % vclog_ja SYSTEM "../dtd.ja/vclog.dtd">
%vclog_ja;

<!ENTITY log_preferences       "ログ設定">
<!ENTITY log_aging             "ログ年齢">
<!ENTITY aging_instructions    "このチェックボックスをチェックしてログ年齢を有効にし、自動削除のためのログエントリ内での有効日数を指定してください。チェックボックスをチェックしない場合、すべてのログ エントリが保持されます。">
<!ENTITY aging_ckbox_label     "ログ年齢を有効">
<!ENTITY aging_days_label      "エントリを保持する日数">
<!ENTITY page_size             "ページ毎のログ エントリ表示数">
<!ENTITY nan_err               "数字のみが利用できます。">
<!ENTITY npos_err              "0より大きな値のみが利用できます。">
<!ENTITY zero_aging_days       "ログ年齢を有効にするには、日数を指定してください。">
<!ENTITY prefs_saved           "ログ設定が保存されました。">
<!ENTITY prefs_save_err        "ログ設定の保存中にエラーが発生しました。">
<!ENTITY size_instructions     "各ログ ページに表示可能なエントリ数を選択してください。">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="prefs_save_msg"/>
   <xsl:param name="page"/>
   <xsl:param name="back_button">false</xsl:param>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <xsl:template match="settings">
      <xsl:variable name="read_only">
         <xsl:choose>
            <xsl:when test="not($prefs_save_msg='')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <html>
         <head>
            <meta http-equiv="pragma" content="no-cache"/>
            <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT"/>
            <title>&log_preferences; - &agent_name;</title>
            <link rel="stylesheet" href="&webapp_base;/cpqwiz.css" type="text/css"/>
            <script src="&webapp_base;/frameck.js" type="text/JavaScript" language="JavaScript"/>
            <script language="JavaScript">
         function agingclick() {
            if (document.logoptions.agingckbox.checked == true) {
               // enable the input for the number of days
               document.logoptions.vcLogAgingDays.disabled = false;
               document.logoptions.vcLogAgingDays.style.backgroundColor = 0xffffff;
            }
            else {
               document.logoptions.vcLogAgingDays.disabled = true;
               <!-- we want the disabled textbox to match the stylesheet table background, so watch this -->
               document.logoptions.vcLogAgingDays.style.backgroundColor = 0xf5f5f5;
               document.logoptions.vcLogAgingDays.value = "";
            }
         }
         function cancelclick() {
            window.close();
         }
         function closeclick() {
            // reload content page if it's currently active
            if ((window.opener != null) &amp;&amp; (window.opener.parent != null)
                  &amp;&amp; (!window.opener.closed)) {
               if (InOpenerFrameset("&webapp_base;")) {
                  window.opener.parent.frames[0].ReloadContentPage("LogTab");
               }
               else {
                  window.opener.location.reload();
               }
            }
            window.close();
         }
         var before;
         function dayskeydown() {
            before = document.logoptions.vcLogAgingDays.value;
         }
         function dayskeyup() {
            var after = document.logoptions.vcLogAgingDays.value;
            var len = after.length;
            if (len != 0) {
               var n = after.search("^\\d+$");
               if (n != 0) {
                   window.alert("&nan_err;");
                   document.logoptions.vcLogAgingDays.value = "";
                }
               else {
                  var nval = Number(after);
                  if (nval == 0) {
                     window.alert("&npos_err;");
                     document.logoptions.vcLogAgingDays.value = "";
                  }
               }
            }
         }
         function ResetForm() {
             document.logoptions.reset();
             if (true == document.logoptions.agingckbox.checked)
                 document.logoptions.vcLogAgingDays.disabled = false;
             else
                 document.logoptions.vcLogAgingDays.disabled = true;
         }
         function FormValidate() {
             if ((true == document.logoptions.agingckbox.checked) &amp;&amp;
                     (0 == document.logoptions.vcLogAgingDays.value)) {
                 window.alert("&zero_aging_days;");
                 return false;
             }
             document.logoptions.Reset.disabled = true;
             document.logoptions.Finish.disabled = true;
             document.logoptions.Cancel.disabled = true;
             document.logoptions.style.cursor = "wait";
             return true;
         }
      </script>
         </head>
         <body>
            <center>
               <div class="wiztitle">
                  <table width="100%" cellspacing="0" border="0">
                     <tr>
                        <td>&log_preferences;</td>
                     </tr>
                  </table>
               </div>
               <br/>
               <xsl:if test="not($prefs_save_msg='')"><b><xsl:value-of select="$prefs_save_msg"/></b><br/></xsl:if>
               <form action="&cgi_base;" method="post" name="logoptions" id="logoptions" onSubmit="return FormValidate();">
                  <input type="hidden" name="method" id="method" value="logoptions"/>
                  <input type="hidden" name="legacyuri" value="&hmmo_base;/logopts"/>
                  <xsl:if test="not($page='')">
                     <!-- this is for VCA group config edit -->
                     <input type="hidden" name="page" value="{$page}"/>
                  </xsl:if>
                  <!-- make any settings we don't use hidden -->
                  <xsl:for-each select="value">
                     <xsl:variable name="keyname"><xsl:value-of select="@key"/></xsl:variable>
                     <xsl:variable name="keyval"><xsl:value-of select="./text()"/></xsl:variable>
                     <xsl:choose>
                        <xsl:when test="$keyname='vcLogAgingDays'"></xsl:when>
                        <xsl:when test="$keyname='vcLogPageSize'"></xsl:when>
                        <xsl:otherwise>
                           <input type="hidden" name="{$keyname}" id="{$keyname}" value="{$keyval}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:for-each>
                  <br/>
                  <p>
                     <div class="wiztable">
                        <table width="90%" id="agingtable">
                           <col width="40%"/>
                           <col width="60%"/>
                           <thead>
                              <tr>
                                 <th colspan="2" align="left">&log_aging;</th>
                              </tr>
                           </thead>
                           <xsl:variable name="days">
                              <xsl:choose>
                                 <xsl:when test="value[@key='vcLogAgingDays']"><xsl:value-of select="value[@key='vcLogAgingDays']"/></xsl:when>
                                 <xsl:otherwise/>
                              </xsl:choose>
                           </xsl:variable>
                           <tbody>
                              <tr>
                                 <td colspan="2">&aging_instructions;</td>
                              </tr>
                              <tr>
                                 <td>
                                    <b>&aging_ckbox_label;</b>
                                 </td>
                                 <td>
                                    <input type="checkbox" size="5" name="agingckbox" id="agingckbox" onclick="agingclick();">
                                       <xsl:if test="not($days='')">
                                          <xsl:attribute name="checked"/>
                                       </xsl:if>
                                       <xsl:if test="$read_only='true'">
                                          <xsl:attribute name="disabled">true</xsl:attribute>
                                          <xsl:attribute name="tabindex">-1</xsl:attribute>
                                       </xsl:if>
                                    </input>
                                 </td>
                              </tr>
                              <tr>
                                 <td>
                                    <b>&aging_days_label;</b>
                                 </td>
                                 <td>
                                    <input type="text" size="5" maxlength="5" name="vcLogAgingDays" id="vcLogAgingDays" onkeydown="dayskeydown();" onkeyup="dayskeyup();">
                                       <xsl:choose>
                                          <xsl:when test="not($days='')">
                                             <xsl:attribute name="value"><xsl:value-of select="$days"/></xsl:attribute>
                                             <xsl:attribute name="style">background-Color: #ffffff</xsl:attribute>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:attribute name="value"/>
                                             <xsl:attribute name="disabled">disabled</xsl:attribute>
                                             <xsl:attribute name="style">background-Color: #f5f5f5</xsl:attribute>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                       <xsl:if test="$read_only='true'">
                                          <xsl:attribute name="disabled">true</xsl:attribute>
                                          <xsl:attribute name="tabindex">-1</xsl:attribute>
                                       </xsl:if>
                                    </input>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <br/>
                  <br/>
                  <p>
                     <div class="wiztable">
                        <table width="90%">
                           <col width="40%"/>
                           <col width="60%"/>
                           <thead>
                              <tr>
                                 <th colspan="2" align="left">&page_size;</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td>&size_instructions;</td>
                                 <td>
                                    <select name="vcLogPageSize" id="vcLogPageSize">
                                       <xsl:attribute name="value"><xsl:choose><xsl:when test="value[@key='vcLogPageSize']='100'">100</xsl:when><xsl:when test="value[@key='vcLogPageSize']='50'">50</xsl:when><xsl:otherwise>25</xsl:otherwise></xsl:choose></xsl:attribute>
                                       <xsl:if test="$read_only='true'">
                                          <xsl:attribute name="disabled">true</xsl:attribute>
                                          <xsl:attribute name="tabindex">-1</xsl:attribute>
                                       </xsl:if>
                                       <option value="25">
                                          <xsl:if test="not((value[@key='vcLogPageSize']='100') or (value[@key='vcLogPageSize']='50'))">
                                             <xsl:attribute name="selected"/>
                                          </xsl:if>25
                                       </option>
                                       <option value="50">
                                          <xsl:if test="value[@key='vcLogPageSize']='50'">
                                             <xsl:attribute name="selected"/>
                                          </xsl:if>50
                                       </option>
                                       <option value="100">
                                          <xsl:if test="value[@key='vcLogPageSize']='100'">
                                             <xsl:attribute name="selected"/>
                                          </xsl:if>100
                                       </option>
                                    </select>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <!-- wizard buttons -->
                  <xsl:choose>
                     <xsl:when test="$read_only='true'">
                        <table width="90%" cellspacing="0" border="0">
                           <!-- put wizard buttons on the right side -->
                           <tbody>
                              <tr>
                                 <td align="right" style="padding: 0px 3px">
                                    <input type="button" name="Close" id="Close" value="&txt_btn_close;" onclick="closeclick();"/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </xsl:when>
                     <xsl:otherwise>
                        <table width="90%" cellspacing="0" border="0">
                           <!-- put wizard buttons on the right side -->
                           <col width="97%"/>
                           <col width="1%"/>
                           <col width="1%"/>
                           <col width="1%"/>
                           <tbody>
                              <tr>
                                 <td align="left">
                                    <input type="button" name="Reset" id="Reset" value="&txt_btn_reset;" onclick="ResetForm();"/>
                                 </td>
                                 <xsl:choose>
                                    <xsl:when test="$back_button='true'">
                                       <td align="center" style="padding: 0px 3px">
                                          <input type="button" name="Back" id="Back" value="&txt_btn_back;" onclick="javascript:history.back(1);"/>
                                       </td>
                                    </xsl:when>
                                    <xsl:otherwise><td/></xsl:otherwise>
                                 </xsl:choose>
                                 <td align="center" style="padding: 0px 3px">
                                    <input type="submit" name="Finish" id="Finish" value="&txt_btn_finish;"/>
                                 </td>
                                 <td align="center" style="padding: 0px 3px">
                                    <input type="button" name="Cancel" id="Cancel" value="&txt_btn_cancel;" onclick="cancelclick();"/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </xsl:otherwise>
                  </xsl:choose>
               </form>
            </center>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
