<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:param name="version_string"></xsl:param>
<xsl:param name="sw_key"></xsl:param>
<xsl:param name="localized_windows">false</xsl:param>
<xsl:output encoding="utf-8" method="xml" version="1.0" indent="yes"/>
<xsl:template match="/manifest_v1">
   <SWFWPKG>
   <CLASS NAME="HP_SWRevisionManagement" SUPERCLASS="CIM_SoftwareIdentity">
      <PROPERTY NAME="Caption" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE><xsl:value-of select="cpq_package/name/name_xlate[@lang='en']"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="Description" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE><xsl:value-of select="cpq_package/description/description_xlate[@lang='en']"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="ElementName" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE><xsl:value-of select="cpq_package/name/name_xlate[@lang='en']"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="InstallDate" TYPE="datetime" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY.ARRAY NAME="OperationalStatus" TYPE="uint16" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE.ARRAY>
            <VALUE>0x8001</VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="StatusDescriptions" TYPE="string" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE.ARRAY>
            <VALUE>Installed and running</VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <!-- The major number component of the software's version information .... -->
      <xsl:variable name="major_version">
         <xsl:value-of select="substring-before($version_string, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="MajorVersion" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$major_version"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem1">
         <xsl:value-of select="substring-after($version_string, '.')"/>
      </xsl:variable>
      <xsl:variable name="minor_version">
         <xsl:value-of select="substring-before($ver_rem1, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="MinorVersion" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$minor_version"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem2">
         <xsl:value-of select="substring-after($ver_rem1, '.')"/>
      </xsl:variable>
      <xsl:variable name="revision_number">
         <xsl:value-of select="substring-before($ver_rem2, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="RevisionNumber" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$revision_number"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem3">
         <xsl:value-of select="substring-after($ver_rem2, '.')"/>
      </xsl:variable>
      <xsl:variable name="build_number">
         <xsl:value-of select="substring-before($ver_rem3, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="BuildNumber" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$build_number"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="VersionString" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$version_string"/></VALUE>
      </PROPERTY>
      <PROPERTY.ARRAY NAME="TargetOperatingSystems" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <xsl:for-each select="cpq_package/operating_systems/operating_system/operating_system_xlate">
               <VALUE><xsl:value-of select="."/></VALUE>
            </xsl:for-each>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY NAME="Manufacturer" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE>Hewlett-Packard</VALUE>
      </PROPERTY>
      <!-- assumes ProLiant s/w never supports more than 2 languages -->
      <xsl:variable name="lang_1"><xsl:value-of select="substring-before(cpq_package/languages/@langlist, ',')"/></xsl:variable>
      <xsl:variable name="lang_2"><xsl:value-of select="substring-after(cpq_package/languages/@langlist, ',')"/></xsl:variable>
      <xsl:if test="not($lang_1='')">
      <PROPERTY.ARRAY NAME="Languages" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE><xsl:value-of select="$lang_1"/></VALUE>
            <xsl:if test="not($lang_2='')"><VALUE><xsl:value-of select="$lang_2"/></VALUE></xsl:if>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      </xsl:if>
      <PROPERTY.ARRAY NAME="Classifications" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE>
            <xsl:choose>
            <xsl:when test="starts-with(cpq_package/category/@key, '120')">6</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '290')">10</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '113')">2</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '780')">4</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '930')">1</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '174')">4</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
            </VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="ClassificationDescriptions" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE>
            <xsl:choose>
            <xsl:when test="starts-with(cpq_package/category/@key, '120')">Firmware/BIOS</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '290')">Firmware</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '113')">Driver</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '780')">Application Software</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '930')">Other</xsl:when>
            <xsl:when test="starts-with(cpq_package/category/@key, '174')">Application Software</xsl:when>
            <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
            </VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY NAME="TargetType" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$sw_key"/></VALUE>
      </PROPERTY>
      <!-- Need the release date from the package XML for the installed version
      <PROPERTY NAME="ReleaseDate" TYPE="datetime" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE/>
      </PROPERTY>
       -->
      <!-- HP extensions -->
      <!-- Override of CIM_ManagedSystemElement.Name -->
      <!-- Need the filename of the package that was installed
      <PROPERTY NAME="Name" TYPE="string" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE/>
      </PROPERTY>
       -->
      <PROPERTY.ARRAY NAME="SOAR_TargetOperatingSystemCodes" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <xsl:for-each select="cpq_package/operating_systems/operating_system">
            <VALUE>
               <xsl:choose>
               <xsl:when test="@key='20'">181</xsl:when>
               <xsl:when test="@key='104'">1060</xsl:when>
               <xsl:when test="@key='1111'">1113</xsl:when>
               <xsl:otherwise>1005</xsl:otherwise>
               </xsl:choose>
            </VALUE>
            </xsl:for-each>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="SOAR_TargetOperatingSystemFamilyCodes" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <VALUE>
               <xsl:choose>
               <xsl:when test="$localized_windows='true'">10</xsl:when>
               <xsl:otherwise>9</xsl:otherwise>
               </xsl:choose>
            </VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <!-- An array of obsolete key values that correspond to this Software Identity. -->
      <xsl:if test="count(cpq_package/sw_keys/sw_keys_and/sw_key) &gt; 1">
      <PROPERTY.ARRAY NAME="PredecessorTargetTypes" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <xsl:for-each select="cpq_package/sw_keys/sw_keys_and/sw_key">
            <xsl:if test="position() != 1">
            <VALUE><xsl:value-of select="@name"/></VALUE>
            </xsl:if>
            </xsl:for-each>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      </xsl:if>
      <PROPERTY NAME="Enhancements" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE><xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text> <xsl:value-of select="cpq_package/revision_history/revision/version[@value=$version_string]/../revision_enhancements_xlate[@lang='en']/revision_enhancements_xlate_part" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">]]&gt;</xsl:text></VALUE>
      </PROPERTY>
      <PROPERTY NAME="Prerequisites" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE><xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text><xsl:value-of select="cpq_package/prerequisite_notes/prerequisite_notes_xlate[@lang='en']" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">]]&gt;</xsl:text></VALUE>
      </PROPERTY>
      <xsl:variable name="type_of_change"><xsl:value-of select="cpq_package/revision_history/revision/version[@value=$version_string]/@type_of_change"/></xsl:variable>
      <PROPERTY NAME="EnhancementType" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE>1</VALUE>
      </PROPERTY>
      <PROPERTY NAME="OtherEnhancementType" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE><xsl:choose>
            <xsl:when test="$type_of_change='1'">The type of change (1) indicates new hardware support or possibly an initial revision.</xsl:when>
            <xsl:when test="$type_of_change='2'">The type of change (2) indicates minor bug fixes, with possible support for new hardware.</xsl:when>
            <xsl:when test="$type_of_change='3'">The type of change (3) indicates minor bug fixes, with possible support for new hardware.</xsl:when>
            <xsl:otherwise></xsl:otherwise>
         </xsl:choose>
         Review the Enhancements and Fixes properties for additional information.
         </VALUE>
      </PROPERTY>
      <PROPERTY NAME="Fixes" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE><xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text><xsl:value-of select="cpq_package/revision_history/revision/version[@value=$version_string]/../revision_fixes_xlate[@lang='en']/revision_fixes_xlate_part" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">]]&gt;</xsl:text></VALUE>
      </PROPERTY>
      <PROPERTY NAME="FixesCriticality" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE><xsl:choose>
            <xsl:when test="$type_of_change='2'">4</xsl:when>
            <xsl:when test="$type_of_change='3'">5</xsl:when>
            <xsl:otherwise>3</xsl:otherwise>
         </xsl:choose></VALUE>
      </PROPERTY>
      <!-- A string describing the FixesCriticality when the instance's
           FixesCriticality property is 1 ("Other").
      <PROPERTY NAME="OtherFixesCriticality" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      -->
   </CLASS>
</SWFWPKG>
</xsl:template>
</xsl:stylesheet>
