<?xml version="1.0"?>
<xsl:stylesheet version="1.0"  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="urn:my-script-block">
	<xsl:output encoding="UTF-8" indent="yes" method="xml" version="1.0"/>
	<xsl:variable name="lcletters">abcdefghijklmnopqrstuvwxyz</xsl:variable>
	<xsl:variable name="ucletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<!-- Ignore List -->
	<xsl:variable name="g_nsFilteredPackages" select="/SWDiscovery/proliant_version_db/packages/package[@key != 'cqmghost.exe' and @key != 'cqmgserv.exe' and @key != 'cqmgstor.exe' and @key != 'cpqnimgt.exe' and @key != 'sym_u3.sys' and @key != 'cpqteam.exe' ]"/>
	<!-- Active & running sw tags-->
	<xsl:variable name="g_nsActivePackages" select="$g_nsFilteredPackages[installation_instance/status/install_state = 'installed' and installation_instance/status/run_state = 'active']"/>
	<xsl:template match="SWDiscovery">
		<xsl:element name="swItemListmain">
			<xsl:element name="swItemList">
				<xsl:for-each select="$g_nsActivePackages">
					<!--	Sorting List for showing only higher version-->
					<xsl:element name="swItem">
						<xsl:element name="key">
							<xsl:attribute name="Important">2</xsl:attribute>
							<xsl:value-of select="translate(@key,$ucletters,$lcletters)"/>
						</xsl:element>
						<xsl:element name="path"/>
						<xsl:element name="installedVer">
							<xsl:value-of select="installation_instance/version"/>
						</xsl:element>
						<xsl:element name="name">
							<xsl:element name="name_xlate">
								<xsl:attribute name="lang">en</xsl:attribute>
								<xsl:value-of select="installation_instance/component_name/component_name_xlate[@lang='en']"/>
							</xsl:element>
							<xsl:element name="name_xlate">
								<xsl:attribute name="lang">ja</xsl:attribute>
								<xsl:value-of select="installation_instance/component_name/component_name_xlate[@lang='ja']"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
