<!-- Copyright (C) 2004 Hewlett-Packard Development Company, L.P. -->
<!--
// function that takes UTC "like" date time and converts it to
// a locale specific time.  The month value is zero-relative.
var fIsIE = false;
if (navigator.appName.toLowerCase() == "microsoft internet explorer") fIsIE = true;

// this function takes a "UTC-like" date/time (zero relative month)
// and converts it to a locale specific date/time string
function vcUtcDateTimeToLocalDateTime(yr, mon, day, hr, min, sec)
{
   var fDateOnly = false;
   if (("undefined" == hr) || (0 == hr.length) || isNaN(hr)) {
      fDateOnly = true;
      var temp = new Date();
      hr = temp.getTimezoneOffset() / 60;
      min = sec = 0 ;
   }
   var dt = new Date(Date.UTC(yr, mon, day, hr, min, sec, 0));
   if (fIsIE) {
      // Use a combination of VBScript and JavaScript on IE to
      // get local date-time in the client's region settings
      mon = dt.getMonth() + 1;
      day = dt.getDate();
      yr  = dt.getFullYear();
      if (false == fDateOnly) {
         hr  = dt.getHours();
         min = dt.getMinutes();
         sec = dt.getSeconds();
      }
      else {
         hr = min = sec = "NaN";
      }
      // call the *VBScript* function to use user settings for date format
      return region_formatted_dt(mon, day, yr, hr, min, sec);
   }
   else {
      // use Javascript date formatting
      if (false == fDateOnly)
         return dt.toLocaleString();
      else
         return dt.toLocaleDateString();
   }
}
// Function that takes a Version Control timestamp string and converts
// it to a locale specific date-time string.  The input format is
// "yyyy-mm-dd.hh:mm:ss", with the month value zero-relative, but
// otherwise it is a UTC timestamp.  The actual delimiters used are
// not checked, so any delimiter or space character is acceptable.
function vcTS2LocaleDateTime(str) {
   var y, m, d, h, n, s;
   y = str.substr(0, 4); m = str.substr(5, 2); d = str.substr(8, 2);
   h = str.substr(11, 2); n = str.substr(14, 2); s = str.substr(17, 2);
   return vcUtcDateTimeToLocalDateTime(y, m, d, h, n, s);
}
// date string only - for "Release Date" field
function vcTS2LocaleDate(y, m, d) {
   // flag for date only - VBScript looks for "NaN" string explicitly
   return vcUtcDateTimeToLocalDateTime(y, m, d, "NaN", "NaN", "NaN");
}


// Japanese language versions create UTF-8 year/month/day characters
function vcTS2LocaleDateTimeJA(str) {
   var y, m, d, h, n, s;
   y = str.substr(0, 4); m = str.substr(5, 2); d = str.substr(8, 2);
   h = str.substr(11, 2); n = str.substr(14, 2); s = str.substr(17, 2);
   var dt = new Date(Date.UTC(y, m, d, h, n, s, 0));
   var rc;
   var yy = dt.getYear();
   var mm = dt.getMonth() + 1;
   var dd = dt.getDate();
   if (yy < 2000) { yy += 1900; }
   if (mm < 10) { mm = "0" + mm; }
   if (dd < 10) { dd = "0" + dd; }
   rc = yy + "年" + mm + "月" + dd + "日";
   var hh = dt.getHours();
   var mn = dt.getMinutes();
   var ss = dt.getSeconds();
   if (hh < 10) { hh = "0" + hh; }
   if (mn < 10) { mn = "0" + mn; }
   if (ss < 10) { ss = "0" + ss; }
   rc += " " + hh + ":" + mn + ":" + ss;
   return rc;
}
// date string only - for "Release Date" field
function vcTS2LocaleDateJA(y, m, d) {
   var dt = new Date(Date.UTC(y, m, d, 0, 0, 0, 0));
   var rc;
   var yy = dt.getYear();
   var mm = dt.getMonth() + 1;
   var dd = dt.getDate();
   if (yy < 2000) { yy += 1900; }
   if (mm < 10) { mm = "0" + mm; }
   if (dd < 10) { dd = "0" + dd; }
   rc = yy + "年" + mm + "月" + dd + "日";
   return rc;
}
//-->
