<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2001 Compaq Information Technologies Group, L.P.    -->
<!-- Copyright (C) 2001-2004 Hewlett-Packard Development Company, L.P. -->
<!-- Generated by makexsl.  Do not edit .XSL files with this header!   -->
<!DOCTYPE xsl:stylesheet [
<!-- vc global common entities -->
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
<!-- common config wizard entities -->
<!ENTITY % cfgui_en SYSTEM "../dtd.en/cfgui.dtd">
%cfgui_en;

<!ENTITY txtCancelConfirm       "Do you want to quit, discard any changes you have made, and retain the original settings?">

<!ENTITY titleCfgPage1          "Select the &vcr_name;">
<!ENTITY titleCfgPage2          "Select the &txtRefSupportPaq;">
<!ENTITY titleCfgPage4          "Current Settings">

<!ENTITY txtSwReposDesc         "Specify the name of a computer with a &cpq_vcr_name; installed.  This will allow a more detailed software inventory to be generated, as well as provide a way to update &cpq; software on the system.">
<!ENTITY txtLoginPrivDesc       "Specify the login account and password for the &vca_name; to use when retrieving data from the &vcr_name;.">
<!ENTITY setRepo                "Set the &vcr_name;">
<!ENTITY pg1BtnInstructions     "Click the &txt_btn_next; button to set the &vcr_name; and continue to set the &txtRefSupportPaq;.">
<!ENTITY txtUseAdminConfirm     "The 'administrator' account is reserved for use with legacy Version Control Repository Manager systems, and cannot be used with the System Management Homepage operating system authentication.  Are you sure you want to use the 'administrator' account?">

<!ENTITY txtRefSupportPaqDesc         "Specify the name of a &support_paq; to use as the default reference for the '&support_paq; Version' column in the inventory display.">
<!ENTITY txtNoSupportPaqInventoryDesc "No inventory information is available to obtain a list of &support_paqs; from.  A valid &vcr_name; that contains one or more &support_paqs; must be configured before a &txtRefSupportPaq; may be selected.  If you have just selected a repository, please wait a few minutes and then refresh this page. If you wish to continue to use the previously configured &txtRefSupportPaq; even though it is not currently available in this &vcr_name;, then select it from the drop down box below.">
<!ENTITY txtRefSupportPaqMissing      "The &txtRefSupportPaq; that is currently configured is not available in the current &vcr_name;.  Please select a valid &support_paq; from the list above.">
<!ENTITY txtPreviousValue             "Previous Value:">
<!ENTITY setRefSP               "Set the &txtRefSupportPaq;">
<!ENTITY txtMatchSP             "When checked, software status is based on installed software's version matching exactly that software's version in the Reference Support Pack.">
<!ENTITY pg2NextBtnInstructions "Click the &txt_btn_next; button to set the selected &txtRefSupportPaq;.  You can still save the &vcr_name; settings without specifying a &txtRefSupportPaq; if none are available or you choose not to specify one.">
<!ENTITY pg2FinishBtnInstructions "Click the &txt_btn_finish; button to set the selected &txtRefSupportPaq; and save the settings.  You can still save the &vcr_name; settings without specifying a &txtRefSupportPaq; if none are available or you choose not to specify one.">

<!-- last page only entities -->
<!ENTITY txtFinished            "Done with Settings">
<!ENTITY txtConfigReadOnly      "You cannot modify the current settings with the current login privilege.">
<!ENTITY txtConfigSaved         "The new configuration was stored successfully.  Click the &txt_btn_close; button to close this window.">
<!ENTITY txtConfigNotSaved      "There was a problem updating the configuration.  Check the log for information about the problem before trying again.  Click the &txt_btn_close; button to close this window.">
<!ENTITY lblLogAging            "Log Aging Days:">
<!ENTITY txtAgingDisabled       "(aging is not enabled)">
<!ENTITY lblLogEntriesPerPage   "Log Entries Per Page">

<!ENTITY emptyRowHeight         "15">

<!ENTITY page1Height            "450">
<!ENTITY page2Height            "400">
<!ENTITY page4Height            "350">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="lang">&default_lang_code;</xsl:param>
   <xsl:param name="allowPg1Back">false</xsl:param>
   <xsl:param name="page">1</xsl:param>
   <xsl:param name="err_msg"/>
   <!-- linke log settings to VCA options (for group config) -->
   <xsl:param name="&paramLinkLogPg;">false</xsl:param>
   <!-- message to use on last page (4) - one of these should be true -->
   <xsl:param name="use_saved_msg">false</xsl:param>
   <xsl:param name="use_err_msg">false</xsl:param>
   <xsl:param name="showLogSettings">false</xsl:param>
   <!-- UNITY category ID for a bundle -->
   <xsl:variable name="CAT_KEY_BUNDLE" select="15"/>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <xsl:template match="swmgrConfig">
      <html>
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
            <meta http-equiv="pragma" content="no-cache"/>
            <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT"/>
            <title>&txtPageTitle;</title>
            <script src="&webapp_base;/timedate.js" language="JavaScript"/>
            <script src="&webapp_base;/timedate.vb" language="VBScript"/>
            <script language="javascript">
               function setup(pageNum) {
                  var height;
                  switch (pageNum) {
                     case 4: height = &page4Height;; break;
                     case 2: height = &page2Height;; changeRefSP(); break;
                     <xsl:if test="$err_msg">case 1: height = &page1Height; + 40; break;</xsl:if>
                     default: height = &page1Height;; break;
                  }
                  <xsl:if test="$&paramLinkLogPg;='true'">height += 85;</xsl:if>
                  <xsl:if test="$showLogSettings='true'">height += 100;</xsl:if>
                  window.resizeTo(&pageWidth;, height);
                  <xsl:if test="$page='1'">checknext();</xsl:if>
               }

               function cancelclick() {
                  var fClose = window.confirm("&txtCancelConfirm;");
                  if (fClose) {
                     window.close();
                  }
               }

               <xsl:if test="$page='1'">
               function Pg1Submit() {
                  // confirm use of account named "administrator"
                  var sAcct = Trim(document.vcacfgwiz.&paramAcct;.value);
                  if (sAcct.substr(sAcct.length - 13,13).toLowerCase() == "administrator") {
                     var fUseAdmin = window.confirm("&txtUseAdminConfirm;");
                     if (false == fUseAdmin)
                        return false;
                  }
                  // make controls that we can read-only - don't disable
                  document.vcacfgwiz.&paramAcct;.value = sAcct;
                  document.vcacfgwiz.&paramVCRM;.readOnly = true;
                  document.vcacfgwiz.&paramPswd;.readOnly = true;
                  // disable the buttons
                  document.vcacfgwiz.Reset.disabled = true;
                  document.vcacfgwiz.Next.disabled = true;
                  document.vcacfgwiz.Cancel.disabled = true;
                  document.vcacfgwiz.style.cursor = "wait";
                  return true;
               }

               function checknext() {
                  var fDisableNext = true;
                  // check if we have a valid account/password pair - note,
                  // we do not modify the actual value here, but will do that
                  // on submit, to remove leading and trailing blanks
                  var sAcct = Trim(document.vcacfgwiz.&paramAcct;.value);
                  if (sAcct.length != 0) {
                     fDisableNext = false; // well, so far it looks OK
                  }
                  if (false == fDisableNext) {
                     // account-password is OK, check non-empty repository name
                     var s= Trim(document.vcacfgwiz.&paramVCRM;.value);
                     if (0 == s.length)
                        fDisableNext = true; // failed this check
                  }
                  // do what needs to be done
                  if (fDisableNext != document.vcacfgwiz.Next.disabled) {
                     document.vcacfgwiz.Next.disabled = fDisableNext;
                  }
               }

               function Trim(s) {
                  s2 = s;
                  while (s2.length &amp;&amp; (' ' == s2.charAt(0))) {
                     s2 = s2.substr(1, s2.length - 1);
                  }
                  while (s2.length &amp;&amp; (' ' == s2.charAt(s2.length - 1))) {
                     s2 = s2.substr(0, s2.length - 1);
                  }
                  return s2;
               }

               </xsl:if>
               <xsl:if test="$page='2'">
               function changeRefSP() { // select onchange handler
                  if (undefined != document.vcacfgwiz.exactCkBx)
                     document.vcacfgwiz.exactCkBx.disabled = true;
                  var i;
                  var selSP;
                  selSP= document.vcacfgwiz.&paramRefSP;;
                  if (selSP != undefined) {
                     for ( i = 0; i &lt; selSP.options.length; i++ ) {
                        if (true == selSP.options[i].selected) {
                           var sp = selSP.options[i].value;
                           // window.alert("sp value = " + sp);
                           if (sp.length > 0) document.vcacfgwiz.exactCkBx.disabled = false;
                           break;
                        }
                     }
                  }
                  return true;
               }

               function saveRefSPName() { // also the form validation called onSubmit
                  var i;
                  var selSP;
                  selSP= document.vcacfgwiz.&paramRefSP;;
                  if (selSP != undefined) {
                     for ( i = 0; i &lt; selSP.options.length; i++ ) {
                        if (true == selSP.options[i].selected) {
                           document.vcacfgwiz.refSPLongName.value = selSP.options[i].text;
                           break;
                        }
                     }
                  }
                  // patch up check box return value - nothing returned if not checked
                  if ( (undefined == document.vcacfgwiz.exactCkBx) ||
                       (true == document.vcacfgwiz.exactCkBx.disabled) ||
                       (false == document.vcacfgwiz.exactCkBx.checked) ) {
                     document.vcacfgwiz.&paramMatchSP;.value = "no";
                  }
                  else {
                     document.vcacfgwiz.&paramMatchSP;.value = "yes";
                  }
                  // don't disable the controls - their values are not posted!
                  // disable the buttons
                  document.vcacfgwiz.Reset.disabled = true;
                  document.vcacfgwiz.Back.disabled = true;
                  <xsl:choose>
                     <xsl:when test="$&paramLinkLogPg;='true'">document.vcacfgwiz.Next.disabled = true;</xsl:when>
                     <xsl:otherwise>document.vcacfgwiz.Finish.disabled = true;</xsl:otherwise>
                  </xsl:choose>
                  document.vcacfgwiz.Cancel.disabled = true;
                  document.vcacfgwiz.style.cursor = "wait";
                  return true;
               }
               </xsl:if>
               <xsl:if test="$page='4'">
               var fReloadCalled = false;
               function closeclick() {
                  <xsl:if test="not($showLogSettings='true')">
                  // reload home page if it's currently active
                  if ((window.opener != null) &amp;&amp; (window.opener.parent != null)
                        &amp;&amp; (!window.opener.closed) &amp;&amp;(window.opener.parent.frames[0]!=undefined)) {
                     window.opener.parent.frames[0].ReloadContentPage("HomeTab");
                     fReloadCalled = true;
                  }
                  </xsl:if>
                  window.close();
               }
               function pageunload() {
                  <xsl:if test="not($showLogSettings='true')">
                  // this catches closings from closing the window or redirection
                  if (false == fReloadCalled) {
                     if ((window.opener != null) &amp;&amp; (window.opener.parent != null)
                           &amp;&amp; (!window.opener.closed) &amp;&amp;(window.opener.parent.frames[0]!=undefined)) {
                        window.opener.parent.frames[0].ReloadContentPage("HomeTab");
                        fReloadCalled = true;
                     }
                  }
                  </xsl:if>
               }
               </xsl:if>
            </script>
            <link rel="stylesheet" href="&webapp_base;/cpqwiz.css" type="text/css"/>
         </head>
         <body onload="setup({$page});">
            <xsl:if test="$page='4'">
               <xsl:attribute name="onunload">pageunload();</xsl:attribute>
            </xsl:if>
            <center>
               <!-- note - page 3 is the log page, shown only from group config (IM) link -->
               <xsl:choose>
                  <xsl:when test="$page='4'">
                     <xsl:call-template name="cfgpage4">
                        <xsl:with-param name="msg">
                           <xsl:choose>
                              <xsl:when test="$use_saved_msg='true'">&txtConfigSaved;</xsl:when>
                              <xsl:when test="$use_err_msg='true'">&txtConfigNotSaved;</xsl:when>
                              <xsl:otherwise>&txtConfigReadOnly;</xsl:otherwise>
                           </xsl:choose>
                        </xsl:with-param>
                        <xsl:with-param name="icon">
                           <xsl:choose>
                              <xsl:when test="$use_saved_msg='true'">&img_normal;</xsl:when>
                              <xsl:when test="$use_err_msg='true'">&img_major;</xsl:when>
                              <xsl:otherwise>&img_info;</xsl:otherwise>
                           </xsl:choose>
                        </xsl:with-param>
                        <xsl:with-param name="showLogSettings" select="$showLogSettings"/>
                     </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="$page='2'">
                     <xsl:call-template name="cfgpage2">
                        <xsl:with-param name="&paramLinkLogPg;" select="$&paramLinkLogPg;"/>
                     </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:call-template name="cfgpage1">
                        <xsl:with-param name="&paramLinkLogPg;" select="$&paramLinkLogPg;"/>
                     </xsl:call-template>
                  </xsl:otherwise>
               </xsl:choose>
            </center>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="sectionHeading">
      <xsl:param name="title"/>
      <div class="wiztitle">
         <table width="100%" cellspacing="0" border="0">
            <tr>
               <td>
                  <xsl:value-of select="$title"/>
               </td>
            </tr>
         </table>
      </div>
      <br/>
      <xsl:if test="$err_msg!=''">
         <table><tr><td valign="top" width="2%"><img src="&img_major;" alt="&txt_major;"/></td><td><xsl:value-of select="$err_msg" disable-output-escaping="yes"/></td></tr></table>
      </xsl:if>
   </xsl:template>
<!-- first wizard page - this page gets the VCRM server name and login account and password -->
   <xsl:template name="cfgpage1">
      <xsl:param name="&paramLinkLogPg;"/>
      <!-- create the section heading -->
      <xsl:call-template name="sectionHeading">
         <xsl:with-param name="title">&titleCfgPage1;</xsl:with-param>
      </xsl:call-template>
      <form action="&cgi_base;" method="post" name="vcacfgwiz" id="vcacfgwiz" onsubmit="return Pg1Submit();">
         <!-- pass key value along unchanged from input param -->
         <input type="hidden" name="&paramLinkLogPg;" id="&paramLinkLogPg;" value="{$&paramLinkLogPg;}"/>
         <input type="hidden" name="page" id="page" value="2"/>
         <input type="hidden" name="legacyuri" value="&hmmo_base;/configui"/>
         <!-- make any settings we don't use hidden -->
         <xsl:for-each select="settings/value">
            <xsl:variable name="keyname"><xsl:value-of select="@key"/></xsl:variable>
            <xsl:variable name="keyval"><xsl:value-of select="./text()"/></xsl:variable>
            <xsl:choose>
               <xsl:when test="$keyname='&paramVCRM;'"></xsl:when>
               <xsl:when test="$keyname='&paramAcct;'"></xsl:when>
               <xsl:when test="$keyname='&paramPswd;'"></xsl:when>
               <xsl:otherwise>
                  <input type="hidden" name="{$keyname}" id="{$keyname}" value="{$keyval}"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
         <div class="wiztable">
            <table width="95%" cellspacing="0" border="0">
               <thead>
                  <tr>
                     <th align="left" colspan="2">&vcr_name;</th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td colspan="2">&txtSwReposDesc;</td>
                  </tr>
                  <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
                  <tr>
                     <td width="20%" align="right" valign="middle">
                        <b>&lblComputerName;</b>
                     </td>
                     <td valign="middle">
                        <input type="text" size="30" name="&paramVCRM;" id="&paramVCRM;" onkeyup="checknext();" onfocus="&paramVCRM;.select();">
                           <xsl:attribute name="value"><xsl:value-of select="settings/value[@key='&paramVCRM;']"/></xsl:attribute>
                        </input>
                     </td>
                  </tr>
                  <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
                  <tr>
                     <td colspan="2">&txtLoginPrivDesc;</td>
                  </tr>
                  <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
                  <tr>
                     <td width="20%" align="right" valign="middle">
                        <b>&lblLoginAcct;</b>
                     </td>
                     <td valign="middle">
                        <input type="text" size="30" name="&paramAcct;" id="&paramAcct;" onkeyup="checknext();" onfocus="&paramAcct;.select();">
                           <xsl:attribute name="value"><xsl:value-of select="settings/value[@key='&paramAcct;']"/></xsl:attribute>
                        </input>
                     </td>
                  </tr>
                  <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
                  <tr>
                     <td width="20%" align="right" valign="middle">
                        <b>&lblLoginPswd;</b>
                     </td>
                     <td valign="middle">
                        <input type="password" size="30" name="&paramPswd;" id="&paramPswd;" onkeyup="checknext();" onfocus="&paramPswd;.select();">
<!--                           <xsl:attribute name="value"><xsl:value-of select="settings/value[@key='&paramPswd;']"/></xsl:attribute> -->
                        </input>
                     </td>
                  </tr>
               </tbody>
            </table>
         </div>
         <p>
            <div class="wiztable">
               <table width="90%">
                  <thead>
                     <tr>
                        <th align="left">&setRepo;</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>&pg1BtnInstructions;</td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </p>
         <!-- wizard buttons -->
         <table width="90%" cellspacing="0" border="0">
            <!-- put wizard buttons on the right side -->
            <col width="97%"/>
            <col width="1%"/>
            <col width="1%"/>
            <col width="1%"/>
            <tbody>
               <tr>
                  <td align="left">
                     <input type="reset" name="Reset" id="Reset" value="&txt_btn_reset;" onclick="reset(); checknext();"/>
                  </td>
                  <td align="center" style="padding: 0px 3px">
                     <input type="button" name="Back" id="Back" value="&txt_btn_back;" onclick="javascript:history.back(1);">
                        <xsl:if test="$allowPg1Back='false'">
                            <xsl:attribute name="disabled"/>
                        </xsl:if>
                     </input>
                  </td>
                  <td align="center" style="padding: 0px 3px">
                     <input type="submit" name="Next" id="Next" value="&txt_btn_next;"/>
                  </td>
                  <td align="center" style="padding: 0px 3px">
                     <input type="button" name="Cancel" id="Cancel" value="&txt_btn_cancel;" onclick="cancelclick();"/>
                  </td>
               </tr>
            </tbody>
         </table>
      </form>
   </xsl:template>

<!-- 2nd wizard page - this page gets the reference support Paq -->
   <xsl:template name="cfgpage2">
      <xsl:param name="&paramLinkLogPg;"/>
      <!-- create the section heading -->
      <xsl:call-template name="sectionHeading">
         <xsl:with-param name="title">&titleCfgPage2;</xsl:with-param>
      </xsl:call-template>
      <form action="&cgi_base;" onsubmit="saveRefSPName();" method="post" name="vcacfgwiz" id="vcacfgwiz">
         <!-- pass page1 values along unchanged from input param -->
         <input type="hidden" name="&paramLinkLogPg;" id="&paramLinkLogPg;" value="{$&paramLinkLogPg;}"/>
         <input type="hidden" name="legacyuri" value="&hmmo_base;/configui"/>
         <!-- next page is 3 if linking to log settings, otherwise next page is 4 -->
         <input type="hidden" name="page" id="page">
            <xsl:attribute name="value">
               <xsl:choose>
                  <xsl:when test="$&paramLinkLogPg;='true'">3</xsl:when>
                  <xsl:otherwise>4</xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </input>
         <!-- make any settings we don't use (visually) hidden -->
         <xsl:for-each select="settings/value">
            <xsl:variable name="keyname"><xsl:value-of select="@key"/></xsl:variable>
            <xsl:variable name="keyval"><xsl:value-of select="./text()"/></xsl:variable>
            <xsl:choose>
               <xsl:when test="$keyname='&paramRefSP;'"></xsl:when>
               <xsl:otherwise>
                  <input type="hidden" name="{$keyname}" id="{$keyname}" value="{$keyval}"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
         <!-- save the localized long name for display - we don't relocalize or revalidate -->
         <input type="hidden" name="refSPLongName" id="refSPLongName" value=""/>
         <div class="wiztable">
            <!-- input data for the reference support paq -->
            <xsl:variable name="refSupportPaqFile">
               <xsl:value-of select="settings/value[@key='&paramRefSP;']"/>
            </xsl:variable>
            <table width="95%" cellspacing="0" border="0">
               <thead>
                  <tr>
                     <th align="left" colspan="2">&vcr_name;</th>
                  </tr>
               </thead>
               <tbody>
                  <xsl:choose>
                     <xsl:when test="count(bundleList/bundle) &lt; 1">
                        <tr>
                           <td colspan="2">
                              <img src="&img_minor;" align="absmiddle"/>&txtNoSupportPaqInventoryDesc;
                           </td>
                        </tr>
                        <xsl:choose>
                         <xsl:when test="$refSupportPaqFile!= ''">
                           <tr>
                           <td width="20%" align="middle" valign="middle">
                              <b>&txtRefSupportPaq;</b>
                              <select size="1" name="&paramRefSP;" id="&paramRefSP;" onchange="changeRefSP();">
                                 <option value="">&txtNoSelection;</option>
                                 <option>
                                   <xsl:value-of select="settings/value[@key='&paramRefSP;']"/>
                                 </option>
                              </select>
                           </td>
                           </tr>
                         </xsl:when>
                         <xsl:otherwise>
                           <tr>
                           <td width="20%" align="middle" valign="middle">
                              <b>&txtRefSupportPaq;</b>
                              <select size="1" name="&paramRefSP;" id="&paramRefSP;" onchange="changeRefSP();">
                                <option value="">&txtNoSelection;</option>
                              </select>
                           </td>
                           </tr>
                         </xsl:otherwise>
                        </xsl:choose>
                     </xsl:when>
                     <xsl:otherwise>
                        <tr>
                           <td colspan="2">&txtRefSupportPaqDesc;<br/>
                              <br/>
                           </td>
                        </tr>
                        <tr>
                           <td width="20%" align="right" valign="middle">
                              <b>&txtRefSupportPaq;</b>
                           </td>
                           <td valign="middle">
                              <select size="1" name="&paramRefSP;" id="&paramRefSP;" onchange="changeRefSP();">
                                 <option value="">&txtNoSelection;</option>
                                 <xsl:for-each select="bundleList/bundle">
                                    <option>
                                       <xsl:attribute name="value"><xsl:value-of select="@fileName"/></xsl:attribute>
                                       <xsl:if test="$refSupportPaqFile=@fileName">
                                          <xsl:attribute name="selected"/>
                                       </xsl:if>
                                       <xsl:choose>
                                          <xsl:when test="name/name_xlate[@lang=$lang]">
                                             <xsl:value-of select="name/name_xlate[@lang=$lang]"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:value-of select="name/name_xlate[@lang='en']"/>
                                          </xsl:otherwise>
                                       </xsl:choose>&txtVersion;<xsl:value-of select="version/@value"/>
                                       <xsl:value-of select="version/@revision"/>
                                    </option>
                                 </xsl:for-each>
                              </select>
                           </td>
                        </tr>

                        <tr>
                           <td width="20%" align="right" valign="middle">
                              <input type="checkbox" name="exactCkBx" id="exactCkBx" disabled="1">
                                 <xsl:if test="settings/value[@key='&paramMatchSP;']='yes'"><xsl:attribute name="checked"/></xsl:if>
                              </input>
                           </td>
                           <td valign="middle">&txtMatchSP;</td>
                        </tr>

                        <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
                        <xsl:if test="$refSupportPaqFile!= ''">
                           <xsl:choose>
                              <xsl:when test="bundleList/bundle[@fileName=$refSupportPaqFile]"/>
                              <xsl:otherwise>
                                 <tr>
                                    <td/>
                                    <td>
                                       <img src="&img_minor;" align="absmiddle"/>&txtRefSupportPaqMissing;
                                       <br/>
                                       <br/>
                                       &txtPreviousValue; <xsl:value-of select="settings/value[@key='&paramRefSP;']"/>
                                    </td>
                                 </tr>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:if>
                     </xsl:otherwise>
                  </xsl:choose>
               </tbody>
            </table>
         </div>
         <p>
            <div class="wiztable">
               <table width="90%">
                  <thead>
                     <tr>
                        <th align="left">&setRefSP;</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <xsl:choose>
                              <xsl:when test="$&paramLinkLogPg;='true'">&pg2NextBtnInstructions;</xsl:when>
                              <xsl:otherwise>&pg2FinishBtnInstructions;</xsl:otherwise>
                           </xsl:choose>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </p>
         <!-- wizard buttons -->
         <table width="90%" cellspacing="0" border="0">
            <!-- put wizard buttons on the right side -->
            <col width="97%"/>
            <col width="1%"/>
            <col width="1%"/>
            <col width="1%"/>
            <tbody>
               <tr>
                  <td align="left">
                     <input type="reset" name="Reset" id="Reset" value="&txt_btn_reset;" onclick="reset();setup(2);"/>
                  </td>
                  <td align="center" style="padding: 0px 3px">
                     <input type="button" name="Back" id="Back" value="&txt_btn_back;" onclick="javascript:history.back(1);">
                     </input>
                  </td>
                  <xsl:choose>
                     <xsl:when test="$&paramLinkLogPg;='true'">
                        <td align="center" style="padding: 0px 3px">
                           <input type="submit" name="Next" id="Next" value="&txt_btn_next;"/>
                        </td>
                     </xsl:when>
                     <xsl:otherwise>
                        <td align="center" style="padding: 0px 3px">
                           <input type="submit" name="Finish" id="Finish" value="&txt_btn_finish;"/>
                        </td>
                     </xsl:otherwise>
                  </xsl:choose>
                  <td align="center" style="padding: 0px 3px">
                     <input type="button" name="Cancel" id="Cancel" value="&txt_btn_cancel;" onclick="cancelclick();"/>
                  </td>
               </tr>
            </tbody>
         </table>
      </form>
   </xsl:template>


<!-- 4th (or 3rd) wizard page - displays the results after clicking Finish -->
   <xsl:template name="cfgpage4">
      <xsl:param name="msg"/>
      <xsl:param name="icon"/>
      <xsl:param name="showLogSettings"/>
      <!-- create the section heading -->
      <xsl:call-template name="sectionHeading">
         <xsl:with-param name="title">&titleCfgPage4;</xsl:with-param>
      </xsl:call-template>
      <!-- output the VCRM settings -->
      <xsl:variable name="refSupportPaqFile">
         <xsl:choose>
            <xsl:when test="settings/value[@key='refSPLongName']!=''">
               <xsl:value-of select="settings/value[@key='refSPLongName']"/>
            </xsl:when>
            <xsl:when test="settings/value[@key='&paramRefSP;']!=''">
               <xsl:value-of select="settings/value[@key='&paramRefSP;']"/>
            </xsl:when>
            <xsl:otherwise>&txtNoSelection;</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <div class="wiztable">
         <table width="95%" cellspacing="5" border="0">
            <col width="20%"/>
            <col width="80%"/>
            <thead>
               <tr>
                  <th align="left" colspan="2">&vcr_name;</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td align="right" valign="top" nowrap="true">
                     <b>&lblComputerName;&#160;</b>
                  </td>
                  <td valign="top">
                     <xsl:value-of select="settings/value[@key='&paramVCRM;']"/>
                  </td>
               </tr>
               <xsl:if test="not($showLogSettings='true')">
                   <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
               </xsl:if>
               <tr>
                  <td align="right" valign="top" nowrap="true">
                     <b>&lblLoginAcct;&#160;</b>
                  </td>
                  <td valign="top">
                     <xsl:value-of select="settings/value[@key='&paramAcct;']"/>
                  </td>
               </tr>
               <xsl:if test="not($showLogSettings='true')">
                   <tr><td height="&emptyRowHeight;" colspan="2"/></tr>
               </xsl:if>
               <tr>
                  <td align="right" valign="top" nowrap="true">
                     <b>&lblRefSP;&#160;</b>
                  </td>
                  <td valign="top">
                     <script type="text/javascript">document.write((('<xsl:value-of select="$refSupportPaqFile"/>')))</script>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <xsl:if test="$showLogSettings='true'">
         <!-- output the log settings -->
         <div class="wiztable">
            <table width="95%" cellspacing="5" border="0">
               <col width="20%"/>
               <col width="80%"/>
               <thead>
                  <tr>
                     <th align="left" colspan="2">&log_preferences;</th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td align="right" valign="top" nowrap="true">
                        <b>&lblLogAging;</b>
                     </td>
                     <td valign="top">
                        <xsl:choose>
                           <xsl:when test="not(settings/value[@key='vcLogAgingDays']='')"><xsl:value-of select="settings/value[@key='vcLogAgingDays']"/></xsl:when>
                           <xsl:otherwise>&txtAgingDisabled;</xsl:otherwise>
                        </xsl:choose>
                     </td>
                  </tr>
                  <tr>
                     <td align="right" valign="top" nowrap="true">
                        <b>&lblLogEntriesPerPage;</b>
                     </td>
                     <td valign="top">
                        <xsl:value-of select="settings/value[@key='vcLogPageSize']"/>
                     </td>
                  </tr>
               </tbody>
            </table>
         </div>
      </xsl:if>
      <p>
         <!-- output the message -->
         <div class="wiztable">
            <table width="90%">
               <thead>
                  <tr>
                     <th align="left">&txtFinished;</th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td><img width="15" height="15" src="{$icon}"/>&#160;<xsl:value-of select="$msg"/></td>
                  </tr>
               </tbody>
            </table>
         </div>
      </p>
      <!-- wizard buttons -->
      <table width="90%" cellspacing="0" border="0">
         <!-- put wizard buttons on the right side -->
         <col width="97%"/>
         <col width="1%"/>
         <col width="1%"/>
         <col width="1%"/>
         <tbody>
            <tr>
               <td/>
               <td/>
               <td/>
               <td align="center" style="padding: 0px 3px">
                  <input type="button" name="Close" id="Close" value="&txt_btn_close;" onclick="closeclick();"/>
               </td>
            </tr>
         </tbody>
      </table>
   </xsl:template> 

</xsl:stylesheet>
