<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2002 Hewlett-Packard Development Group, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output method="html" indent="yes"/>

   <xsl:template match="/">
      <html>
         <head>
            <title>&agent_name;</title>
            <link REL="shortcut icon" HREF="&webapp_base;/favicon.ico"/>
            <script language="JavaScript">
               // this allows us to have onload events in the frames
               // notify the frameset window when they are loaded.  it
               // then "calls back" to allow processing that the frames
               // may want to do in onload(), but requires another frame
               var nLoaded = 0;
               function FrameLoaded(framename) {
                  // we know how many frames we have...
                  nLoaded++;
                  if (2 &lt;= nLoaded) {
                     window.frames[0].onFramesLoaded();
                     window.frames[1].onFramesLoaded();
                  }
               }
               // check browser and pop-up message if we don't recognize it
               var fKnownBrowser = false;
               if (navigator.userAgent.indexOf("MSIE") != -1) {
                  var nVer = parseInt(navigator.userAgent.substr(navigator.userAgent.indexOf("MSIE") + 4));
                  if (nVer &gt;= 6) {
                     fKnownBrowser = true;
                  }
               }
               else {
                  if (navigator.userAgent.indexOf("Gecko") != -1) {
                     var nVer = parseFloat(navigator.userAgent.substr(navigator.userAgent.indexOf("rv:")+3));
                     if (nVer &gt;= 1.60) {
                        fKnownBrowser = true;
                     }
                  }
               }
               if (false == fKnownBrowser) {
                  window.alert("&unsupported_browser;");
               }
            </script>
         </head>
         <frameset rows="98,*" border="0px" frameborder="0">
            <xsl:apply-templates select="cpqFrameSet" />
         </frameset>
      </html>
   </xsl:template>

   <xsl:template match="cpqFrameSet">
      <xsl:for-each select="cpqFrame">
         <frame src="{@src}" frameborder="0">            
            <xsl:attribute name="name">
               <xsl:value-of select="id"/>
            </xsl:attribute>
            <xsl:attribute name="id">
               <xsl:value-of select="id"/>
            </xsl:attribute>
            <xsl:choose>
               <xsl:when test="scrolling">
                  <xsl:attribute name="scrolling">
                     <xsl:value-of select="scrolling"/>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
            <xsl:choose>
               <xsl:when test="marginwidth">
                  <xsl:attribute name="marginwidth">
                     <xsl:value-of select="marginwidth"/>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
            <xsl:choose>
               <xsl:when test="marginheight">
                  <xsl:attribute name="marginheight">
                     <xsl:value-of select="marginheight"/>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
            <xsl:choose>
               <xsl:when test="noresize">
                  <xsl:attribute name="noresize">
                     <xsl:value-of select="noresize"/>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
         </frame>
      </xsl:for-each>
   </xsl:template>
   
</xsl:stylesheet>
