<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2004 Hewlett-Packard Development Company, L.P. -->
<!DOCTYPE xsl:stylesheet [
   <!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
   %common_en;
   <!ENTITY force_install      "Force downgrade or re-install">
   <!ENTITY force_install_desc "Select this option to allow the software to reinstall itself over an existing or newer version.">
   <!ENTITY auto_reboot        "Automatic Reboot">
   <!ENTITY auto_reboot_desc   "Select this option to allow the Version Control Agent to reboot the device if the installation requires a reboot when finished.">
   <!ENTITY install            "Install">
   <!ENTITY install_desc       "Press the '&install;' button to begin the installation of <b><xsl:value-of select='$displayName' disable-output-escaping='yes'/></b> or press '&txt_btn_cancel;' to return to the inventory display.">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="machine"/>
   <xsl:param name="packageList"/>
   <xsl:param name="displayName"/>
   <xsl:param name="taskId"/>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <xsl:template match="/">
      <html>
         <head>
            <meta http-equiv="pragma" content="no-cache"/>
            <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT"/>
            <title>
               <xsl:value-of select="$machine"/> - &agent_name;</title>
            <link rel="stylesheet" href="&webapp_base;/cpqwiz.css" type="text/css"/>
            <script src="&webapp_base;/frameck.js" type="text/JavaScript" language="JavaScript"/>
            <script language="JavaScript">
               function InstallSubmit() {
                   // disable the install button so it doesn't get double-clicked
                   document.install.submit.disabled = true;
                   document.body.style.cursor = "wait";
                   return true;
               }
            </script>
         </head>
         <body>
            <center>
               <div class="wiztitle">
                  <table width="100%" cellspacing="0" border="0">
                     <tr>
                        <td>
                           <xsl:value-of select="$displayName" disable-output-escaping="yes"/>
                        </td>
                     </tr>
                  </table>
               </div>
               <br/>
               <form action="&cgi_base;" method="post" name="install" id="install" onsubmit="InstallSubmit();">
                  <input type="hidden" id="legacyuri" name="legacyuri" value="&hmmo_base;/install2"/>
                  <input type="hidden" id="packageList" name="packageList">
                     <xsl:attribute name="value"><xsl:value-of select="$packageList"/></xsl:attribute>
                  </input>
                  <input type="hidden" id="taskId" name="taskId">
                     <xsl:attribute name="value"><xsl:value-of select="$taskId"/></xsl:attribute>
                  </input>
                  <br/>
                  <p>
                     <div class="wiztable">
                        <table width="90%">
                           <thead>
                              <tr>
                                 <th align="left">&force_install;</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td>&force_install_desc;</td>
                              </tr>
                              <tr>
                                 <td>
                                    <INPUT type="checkbox" size="30" name="force" id="force" value="0">
                                       <b>&force_install;</b>
                                    </INPUT>
                                    <br/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <br/>
                  <p>
                     <div class="wiztable">
                        <table width="90%">
                           <thead>
                              <tr>
                                 <th align="left">&auto_reboot;</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td>&auto_reboot_desc;</td>
                              </tr>
                              <tr>
                                 <td>
                                    <input type="checkbox" size="30" name="reboot" id="reboot" value="0">
                                       <b>&auto_reboot;</b>
                                    </input>
                                    <br/>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </p>
                  <p>
                     <table width="90%">
                        <col width="90%"/>
                        <col width="5%"/>
                        <col width="5%"/>
                        <tr>
                           <td colspan="3">&install_desc;</td>
                        </tr>
                        <tr>
                           <td/>
                           <td>
                              <input type="submit" name="submit" id="submit" value="&install;"/>
                           </td>
                           <td>
                              <input type="button" name="cancel" id="cancel" value="&txt_btn_cancel;" onclick="javascript:window.close();"/>
                           </td>
                        </tr>
                     </table>
                  </p>
               </form>
            </center>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
