<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2003 Hewlett-Packard Development Company, L.P. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
<!-- menutasks entities -->
<!ENTITY not_oper_admin_msg     "You must be logged in as operator or administrator to perform this operation.">
<!-- menu bar icons -->
<!ENTITY img_menu_item_enabled  "&webapp_base;/img/arroww_13x13.gif">
<!ENTITY img_menu_item_disabled "&webapp_base;/img/arrowg_13x13.gif">
<!ENTITY feature_not_supported  "This feature is not supported in this browser.">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <!--    Task Menu template  -->
   <xsl:template name="taskmenu">
      <xsl:param name="curTabId"/>
      <xsl:param name="operator"/>
      <xsl:variable name="domNav" select="document('../xml.&default_lang_code;/nav.xml')"/>
      <script type="text/JavaScript" language="JavaScript">
         var subWindow;
         function TaskClick(href, style, br ) {

            if( br != "both" )
            {
               if( navigator.userAgent.indexOf( "MSIE" ) == -1 )
                  type = "moz";
               else
                  type = "ie";

               if( br != type )
               {
                  alert("&feature_not_supported;");
                  return;
               }
            }

            if (style=="")
               style = "toolbar=1,directories=0,status=1,menubar=0,scrollbars=1,resizable=1,width=600,height=400";

            if (!subWindow || subWindow.closed) {
               subWindow = window.open(href, "_blank", style);
            }
            else {
               subWindow.location = href;
            }

            subWindow.focus();
            return false;
         }

         function highlightmenu(tr)
         {
              if(tr.all)
              {
                tr.all("menubullet").src = "&img_menu_item_enabled;";
                tr.all("menutext").style.color = "#FFFFFF";
                tr.all("menutext").style.cursor = "hand";
                
              }
              else
              {
             	  tr.cells[0].childNodes[0].getAttributeNode("src").value = "&img_menu_item_enabled;";
                  tr.cells[1].style.color = "#FFFFFF";
              }
         }

         function unhighlightmenu(tr)
         {
              if(tr.all)
              {
                    tr.all("menubullet").src = "&img_menu_item_disabled;";
                    tr.all("menutext").style.color = "#CCCCCC";
                    tr.all("menutext").style.cursor = "auto";
              }
              else
              {
             	  tr.cells[0].childNodes[0].getAttributeNode("src").value = "&img_menu_item_disabled;";
                  tr.cells[1].style.color = "#CCCCCC";
              }
         }
         
      </script>
      <table class="menu">
         <xsl:for-each select="$domNav/cpqnav/navitem[@id=$curTabId]/navitemtasks/navitemtask">
            <xsl:call-template name="menuitem">
               <xsl:with-param name="task" select="$domNav/navitem[@id=$curTabId]/navitemtasks/navitemtask"/>
            </xsl:call-template>
         </xsl:for-each>
      </table>
   </xsl:template>

   <xsl:template name="menuitem">
            <xsl:variable name="tasktext"><xsl:value-of select="name"/></xsl:variable>
            <xsl:choose>
               <xsl:when test="$operator='false' and @requires_operator='true'">
                  <!--a onclick="javascript:window.alert('&not_oper_admin_msg;');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);"-->
                  <tr onclick="javascript:window.alert('&not_oper_admin_msg;');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);">
                     <td style="cursor:pointer;" valign="top"><img name="menubullet" id="menubullet" src="&img_menu_item_disabled;" height="13" width="13"/></td>
                     <td style="cursor:pointer; font-size:9pt; color:#CCCCCC" name="menutext" id="menutext" ><xsl:value-of select="$tasktext"/></td>
                  </tr>
                  <!--/a-->
               </xsl:when>
               <xsl:otherwise>
                  <xsl:choose>
                     <xsl:when test="href_ie">
                        <xsl:variable name="href"><xsl:value-of select="href_ie"/></xsl:variable>
                        <xsl:variable name="style"><xsl:value-of select="taskwinstyle"/></xsl:variable>
                        <tr onclick="javascript:TaskClick('{$href}','{$style}','ie');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);">
                           <td style="cursor:pointer;" valign="top"><img name="menubullet" id="menubullet" src="&img_menu_item_disabled;" height="13" width="13"/></td>
                           <td style="cursor:pointer; font-size:9pt; color:#CCCCCC" name="menutext" id="menutext" ><xsl:value-of select="$tasktext"/></td>
                        </tr>
                     </xsl:when>
                     <xsl:when test="href_moz">
                        <xsl:variable name="href"><xsl:value-of select="href_moz"/></xsl:variable>
                        <xsl:variable name="style"><xsl:value-of select="taskwinstyle"/></xsl:variable>
                        <tr onclick="javascript:TaskClick('{$href}','{$style}','moz');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);">
                           <td style="cursor:pointer;" valign="top"><img name="menubullet" id="menubullet" src="&img_menu_item_disabled;" height="13" width="13"/></td>
                           <td style="cursor:pointer; font-size:9pt; color:#CCCCCC" name="menutext" id="menutext" ><xsl:value-of select="$tasktext"/></td>
                        </tr>
                     </xsl:when>
                     <xsl:when test="altclick">
                        <xsl:variable name="clickee"><xsl:value-of select="altclick"/></xsl:variable>
                        <!--a target="_blank" onclick="{$clickee}" onmouseover="highlightmenu(this);" onmouseout="unhighlightmenu(this);"-->
                        <tr onclick="{$clickee}" onmouseover="highlightmenu(this);" onmouseout="unhighlightmenu(this);">
                           <td style="cursor:pointer;" valign="top"><img name="menubullet" id="menubullet" src="&img_menu_item_disabled;" height="13" width="13"/></td>
                           <td style="cursor:pointer; font-size:9pt; color:#CCCCCC" name="menutext" id="menutext"><xsl:value-of select="$tasktext"/></td>
                        </tr>
                        <!--/a-->
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:variable name="href"><xsl:value-of select="href"/></xsl:variable>
                        <xsl:variable name="style"><xsl:value-of select="taskwinstyle"/></xsl:variable>
                        <tr onclick="javascript:TaskClick('{$href}','{$style}','both');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);">
                        <!--a target="_blank" onclick="javascript:TaskClick('{$href}','{$style}');return false;" onmouseover="javascript:highlightmenu(this);" onmouseout="javascript:unhighlightmenu(this);"-->
                           <td style="cursor:pointer;" valign="top"><img name="menubullet" id="menubullet" src="&img_menu_item_disabled;" height="13" width="13"/></td>
                           <td style="cursor:pointer; font-size:9pt; color:#CCCCCC" name="menutext" id="menutext" ><xsl:value-of select="$tasktext"/></td>
                        <!--/a-->
                        </tr>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:otherwise>
            </xsl:choose>
   </xsl:template>

</xsl:stylesheet>
