<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2001 Compaq Information Technologies Group, L.P. -->
<!-- .XSL files are generated by makexsl.  Do not edit .XSL files with this header! -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;

<!ENTITY pageTitle             "&cpq_vca_name;">

<!ENTITY linkText1             "Click">
<!ENTITY linkText2             "here">
<!ENTITY linkText3             "to view the log for more detailed information.">

<!ENTITY imgWait               "&webapp_base;/img.en/waitani.gif">
<!ENTITY imgHorizLine          "&webapp_base;/img/horizlng.gif">
]>
<!-- end of makexsl generated header -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="msgId">0</xsl:param>
<xsl:param name="msgText"/>

<xsl:param name="lang">&default_lang_code;</xsl:param>

<xsl:param name="linkHref"></xsl:param>
<xsl:param name="detailInfo"></xsl:param>
<xsl:param name="redirParams"></xsl:param>

<xsl:output indent="yes" method="html" encoding="UTF-8"/>

<xsl:template match="smMsgTbl">
<html>

<head>
    <title>&pageTitle;</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link rel="stylesheet" href="&webapp_base;/cpqwh.css" type="text/css"/>

    <xsl:if test="msg[@id=$msgId]/redirect">
        <meta http-equiv="refresh">
        <xsl:attribute name="content">
            <xsl:value-of select="msg[@id=$msgId]/redirect/@timeout"/>;url=<xsl:value-of select="msg[@id=$msgId]/redirect"/>
            <xsl:if test="$redirParams">?<xsl:value-of select="$redirParams"/></xsl:if>
        </xsl:attribute>
        </meta>
    </xsl:if>
</head>

<body>
<center>

<xsl:choose>
    <xsl:when test="$msgText">
        <xsl:call-template name="msg">
            <xsl:with-param name="txtTitle"><xsl:value-of select="msg[@id=$msgId]/titles/title[@lang=$lang]"/></xsl:with-param>
            <xsl:with-param name="txtMessage"><xsl:value-of select="$msgText"/></xsl:with-param>
            <xsl:with-param name="nSeverity"><xsl:value-of select="msg[@id=$msgId]/severity/@code"/></xsl:with-param>
        </xsl:call-template>
    </xsl:when>
    <xsl:when test="msg[@id=$msgId]">
        <xsl:call-template name="msg">
            <xsl:with-param name="txtTitle"><xsl:value-of select="msg[@id=$msgId]/titles/title[@lang=$lang]"/></xsl:with-param>
            <xsl:with-param name="txtMessage"><xsl:value-of select="msg[@id=$msgId]/content/text[@lang=$lang]"/></xsl:with-param>
            <xsl:with-param name="nSeverity"><xsl:value-of select="msg[@id=$msgId]/severity/@code"/></xsl:with-param>
        </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:call-template name="msg">
            <xsl:with-param name="txtTitle"><xsl:value-of select="msg[@id=971]/titles/title[@lang=$lang]"/></xsl:with-param>
            <xsl:with-param name="txtMessage"><xsl:value-of select="msg[@id=971]/content/text[@lang=$lang]"/></xsl:with-param>
            <xsl:with-param name="nSeverity"><xsl:value-of select="msg[@id=971]/severity/@code"/></xsl:with-param>
        </xsl:call-template>
    </xsl:otherwise>
</xsl:choose>

</center>
</body>
</html>
</xsl:template>

<xsl:template name="msg">
    <xsl:param name="txtTitle"/>
    <xsl:param name="txtMessage"/>
    <xsl:param name="nSeverity"/>

<div class="tableStyle1">
<table width="60%" cellspacing="0" border="0">
<thead>
    <tr>
        <th colspan="2" align="left"><xsl:value-of select="$txtTitle"/></th>
    </tr>
</thead>
<tbody>
    <tr>
        <td>
            <img src="&img_blank;"/>
            <img align="middle">
                <xsl:attribute name="src">
                        <xsl:choose>
                            <xsl:when test="$nSeverity=100">&img_info;</xsl:when>
                            <xsl:when test="$nSeverity=1">&img_normal;</xsl:when>
                            <xsl:when test="$nSeverity=3">&img_minor;</xsl:when>
                            <xsl:when test="$nSeverity=4">&img_major;</xsl:when>
                            <xsl:otherwise>&img_info;</xsl:otherwise>
                        </xsl:choose>
                </xsl:attribute>
            </img>
            <img src="&img_blank;"/>
        </td>
        <td width="100%">
            <br/>
            <xsl:value-of select="$txtMessage"/>
            <br/><br/><img src="&img_blank;"/>
        </td>
    </tr>
    <xsl:if test="$detailInfo">
            <tr>
            <td colspan="2">
                <img src="&imgHorizLine;" height="1px" width="100%"/>
            </td>
        </tr>
        <tr>
            <td colspan="2"><b>&addlDataLabel;</b></td>
        </tr>
        <tr>
            <td colspan="2">
                <code><xsl:value-of select="$detailInfo"/></code>
                <br/><br/>
                <img src="&img_blank;"/>
            </td>
        </tr>
    </xsl:if>

    <xsl:if test="$linkHref">
        <tr>
            <td colspan="2"><img src="&imgHorizLine;" height="1px" width="100%"/></td>
        </tr>
        <tr>
            <td colspan="2" valign="middle" align="center"><br/>&linkText1;
                <a>
                    <xsl:attribute name="href"><xsl:value-of select="$linkHref"/></xsl:attribute>
                    &linkText2;
                </a>
                &linkText3;
                <br/><br/>
                <img src="&img_blank;"/>
            </td>
        </tr>
    </xsl:if>

    <xsl:if test="msg[@id=$msgId]/redirect">
        <tr>
            <td colspan="2" align="center">
                <img src="&imgWait;"/><br/><br/><img src="&img_blank;"/>
            </td>
        </tr>
    </xsl:if>

</tbody>
</table>
</div>
</xsl:template>

</xsl:stylesheet>
