<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2001 Compaq Information Technologies Group, L.P.      -->
<!-- Copyright (C) 2002, 2003 Hewlett-Packard Development Company, L.P.  -->
<!-- This is a generated file.  Do not edit .XSL files with this header! -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_ja SYSTEM "../dtd.ja/common.dtd">
%common_ja;
<!-- common config wizard entities -->
<!ENTITY % cfgui_ja SYSTEM "../dtd.ja/cfgui.dtd">
%cfgui_ja;

<!ENTITY txtSettingsTitle "&cpq_vca_name; コンフィギュレーション設定">
<!ENTITY txtKeyValue "&vcr_name;">
<!ENTITY txtRepositoryTitle "&vcr_name; マシン名">
<!ENTITY txtSrAcctTitle "&vcr_name; 用ログインアカウント名">
<!ENTITY txtSrPwdTitle "&vcr_name; 用ログインパスワード">
<!ENTITY txtLogAgingDays "ログ年齢 (日付)">
<!ENTITY txtLogPageLen "ログページ長">
<!ENTITY txtNoLogAging "(ログ年齢は無効です。)">
<!ENTITY txtVersionsMatchRefSP "正確なバージョン マッチはソフトウェア ステータス算出のために使用されました">
]>
<!-- end of localization preface -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:strip-space elements="*" />

<xsl:param name="messageId" select="0"/>

<xsl:param name="lang">&default_lang_code;</xsl:param>

<xsl:variable name="inventoryDOM" select="document('../cache/inventory.xml')"/>

<!-- this stylesheet converts XML in the form of the cpqsmhmo.cfg to CIMXML -->
<xsl:output indent="yes" method="xml" version="1.0" encoding="UTF-8"/>
<xsl:template match="swmgrConfig">
<CIM CIMVERSION="2.0" DTDVERSION="2.0">
   <MESSAGE PROTOCOLVERSION="1.0">
   <xsl:attribute name="ID"><xsl:value-of select="$messageId"/></xsl:attribute>
      <SIMPLERSP>
         <IMETHODRESPONSE NAME="EnumerateInstances">
            <IRETURNVALUE>
               <VALUE.NAMEDINSTANCE>
                  <INSTANCENAME CLASSNAME="VCAgent_Settings">
                     <KEYBINDING NAME="">
                        <KEYVALUE>&txtKeyValue;</KEYVALUE>
                     </KEYBINDING>
                  </INSTANCENAME>
                  <INSTANCE CLASSNAME="VCAgent_Settings">
                     <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
                        <VALUE>&txtSettingsTitle;</VALUE>
                     </QUALIFIER>
          <!-- the property output is dependent on knowing the configuration items
               but we at least move that bit of ugliness to another template... -->
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">&paramVCRM;</xsl:with-param>
                        <xsl:with-param name="display_name">&txtRepositoryTitle;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">&paramAcct;</xsl:with-param>
                        <xsl:with-param name="display_name">&txtSrAcctTitle;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">&paramPswd;</xsl:with-param>
                        <xsl:with-param name="display_name">&txtSrPwdTitle;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">&paramRefSP;</xsl:with-param>
                        <xsl:with-param name="display_name">&txtRefSupportPaq;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">&paramMatchSP;</xsl:with-param>
                        <xsl:with-param name="display_name">&txtVersionsMatchRefSP;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">vcLogAgingDays</xsl:with-param>
                        <xsl:with-param name="display_name">&txtLogAgingDays;</xsl:with-param>
                     </xsl:call-template>
                     <xsl:call-template name="propertyOutput">
                        <xsl:with-param name="property_name">vcLogPageSize</xsl:with-param>
                        <xsl:with-param name="display_name">&txtLogPageLen;</xsl:with-param>
                     </xsl:call-template>
                  </INSTANCE>
               </VALUE.NAMEDINSTANCE>
            </IRETURNVALUE>
         </IMETHODRESPONSE>
      </SIMPLERSP>
   </MESSAGE>
</CIM>
</xsl:template>


<!-- add display names for the properties which are group configured -->
<xsl:template name="propertyOutput">
   <xsl:param name="property_name"/>
   <xsl:param name="display_name"/>
   <xsl:variable name="property_value" select="settings/value[@key=$property_name]"/>
   <PROPERTY PROPAGATED="true" TYPE="string">
      <xsl:attribute name="NAME"><xsl:value-of select="$property_name"/></xsl:attribute>
      <xsl:if test="not($display_name='')">
         <QUALIFIER NAME="DISPLAYNAME" TYPE="string">
            <VALUE><xsl:value-of select="$display_name"/></VALUE>
         </QUALIFIER>
      </xsl:if>
      <xsl:choose>
         <xsl:when test="$property_name='&paramRefSP;'">
            <xsl:variable name="refSupportPaqFile" select="$property_value"/>
            <xsl:call-template name="supportPaqDisplayName">
               <xsl:with-param name="bundleItem" select="$inventoryDOM/softwareInventory/allSoftware/swCategory/bundleList/bundle[@fileName=$refSupportPaqFile]"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:when test="$property_name='&paramMatchSP;'">
            <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
               <VALUE>
                  <xsl:choose>
                     <xsl:when test="$property_value='yes'">&txtYes;</xsl:when>
                     <xsl:otherwise>&txtNo;</xsl:otherwise>
                  </xsl:choose>
               </VALUE>
            </QUALIFIER>
         </xsl:when>
         <xsl:when test="$property_name='&paramAcct;'">
            <xsl:if test="$property_value=''">
               <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
                  <VALUE>&txt_acct_anon;</VALUE>
                </QUALIFIER>
            </xsl:if>
         </xsl:when>
         <xsl:when test="$property_name='&paramPswd;'">
            <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
               <VALUE>********</VALUE>
            </QUALIFIER>
         </xsl:when>
         <xsl:when test="$property_name='vcLogAgingDays'">
            <xsl:if test="$property_value=''">
               <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
                  <VALUE>&txtNoLogAging;</VALUE>
               </QUALIFIER>
            </xsl:if>
         </xsl:when>
      </xsl:choose>
      <VALUE>
         <xsl:value-of select="$property_value"/>
      </VALUE>
   </PROPERTY>
</xsl:template>


<!-- add a friendly name for the reference support paq, if we've got one -->
<xsl:template name="supportPaqDisplayName">
   <xsl:param name="bundleItem"/>
   <xsl:if test="$bundleItem != ''">
      <QUALIFIER NAME="DISPLAYPROPERTYVALUE" TYPE="string">
         <VALUE>
            <xsl:value-of select="$bundleItem/name/name_xlate[@lang=$lang]"/> &txtVersion; <xsl:value-of select="$bundleItem/version/@value"/><xsl:value-of select="$bundleItem/version/@revision"/>
         </VALUE>
      </QUALIFIER>
   </xsl:if>
</xsl:template>


</xsl:stylesheet>
