<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2001 Compaq Information Technologies Group, L.P. -->
<!-- .XSL files are generated by makexsl.  Do not edit .XSL files with this header! -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_ja SYSTEM "../dtd.ja/common.dtd">
%common_ja;

<!ENTITY pageTitle             "&vca_name;&#160;&title_log;">

<!ENTITY refreshText           "このページはタスクが完了するまで自動的にリフレッシュされます。">
<!ENTITY refreshLabel          "今すぐリフレッシュ">

]>
<!-- end of makexsl generated header -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:param name="taskId"/>
   <xsl:param name="showRefresh"/>
   <xsl:param name="current_page"/>
   <xsl:param name="lang">&default_lang_code;</xsl:param>
   <xsl:param name="operator">false</xsl:param>
   <xsl:output indent="yes" method="html" encoding="UTF-8"/>
   <!-- MSGID of the message that indicates a task has been completed -->
   <xsl:variable name="TASK_END_MSGID">24</xsl:variable>
   <!-- vclogtable templates -->
   <xsl:include href="vclogtable.xsl"/>
   <xsl:include href="menutasks.xsl"/>
   <xsl:template match="&log_element;">
      <!-- in case we need it, get the machine name -->
      <xsl:variable name="machName" select="created/onMachine/@name"/>
      <html>
         <head>
            <meta http-equiv="pragma" content="no-cache"/>
            <meta http-equiv="expires" content="Tue, 01 Jan 1981 01:00:00 GMT"/>
            <link rel="stylesheet" href="&webapp_base;/cpqwh.css" type="text/css"/>
            <title>&pageTitle;</title>
            <xsl:if test="$showRefresh">
               <xsl:for-each select="entry[taskid=$taskId]">
                  <xsl:if test="position()=last()">
                     <xsl:if test="not(msgid=$TASK_END_MSGID)">
                        <meta http-equiv="refresh">
                           <xsl:attribute name="content"><xsl:value-of select="$showRefresh"/>;url=&cgi_base;?legacyuri=&hmmo_base;/log&amp;taskid=<xsl:value-of select="$taskId"/>&amp;refresh=<xsl:value-of select="$showRefresh"/></xsl:attribute>
                        </meta>
                     </xsl:if>
                  </xsl:if>
               </xsl:for-each>
            </xsl:if>
            <script src="&webapp_base;/frameck.js" type="text/JavaScript" language="JavaScript"/>
            <script type="text/javascript" language="JavaScript">
               function PageLoad(){
                  onPageLoad(); // vclog function
                  if (InParentFrameset("&webapp_base;")) {
                     if (window.parent.FrameLoaded!=undefined)
                        window.parent.FrameLoaded(window.name);
                  }
               }
               // the frameset calls this when the frames are all loaded
               function onFramesLoaded() {
                  // make sure the nav frame highlights the right
                  // tab when user pressed back/forward button
                  window.parent.navigation.setTab("LogTab");
               }
            </script>
            <script src="&webapp_base;/timedate.vb" language="VBScript"/>
            <script src="&webapp_base;/timedate.js" language="JavaScript"/>
            <!-- add device home link if not in a frame and not refreshing
                 (probably a link from Insight Manager for task log entries) -->
            <xsl:if test="not($showRefresh)">
               <script language="JavaScript">
                  if ((null == window.parent) || (0 == window.parent.frames.length)) {
                     document.write("&lt;p&gt;&lt;a href='/' title='Go to the Device Home page' alt='<xsl:value-of select='$machName'/>'&gt;&lt;b&gt;<xsl:value-of select='$machName'/>&lt;/b&gt;&lt;/p&gt;&lt;/a&gt;");
                  }
               </script>
            </xsl:if>
            <style type="text/css">
               table.content {margin: 0 0 0 0 position:absolute; overflow:visible}
               td.tabnavbar {padding-left:0; padding-top:2;}
               td.tabcontent {padding-left:5; padding-top:5;}
            </style>
         </head>
         <body bgcolor="#FFFFFF" text="#000000" onLoad="PageLoad();" onresize="setHeader()">
            <table class="content" width="100%" height="95%" border="0" cellspacing="0" cellpadding="0">
               <tr height="100%">
                  <!-- menu/nav bar column -->
                  <xsl:if test="not($showRefresh)">
                     <td class="tabnavbar" width="114" bgcolor="#336699" valign="top">
                        <xsl:call-template name="taskmenu">
                           <xsl:with-param name="curTabId">LogTab</xsl:with-param>
                           <xsl:with-param name="operator"><xsl:value-of select="$operator"/></xsl:with-param>
                        </xsl:call-template>
                     </td>
                  </xsl:if>
                  <!-- content column -->
                  <td class="tabcontent">
                     <xsl:call-template name="vclogtable">
                        <xsl:with-param name="showTaskIds">true</xsl:with-param>
                        <xsl:with-param name="filterTaskId" select="$taskId"/>
                        <xsl:with-param name="lang" select="$lang"/>
                     </xsl:call-template >
                  </td>
               </tr>
            </table>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
