<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="urn:my-script-block">
	<xsl:output encoding="UTF-8" indent="yes" method="xml" version="1.0"/>
	<xsl:variable name="lcletters">abcdefghijklmnopqrstuvwxyz</xsl:variable>
	<xsl:variable name="ucletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<xsl:template match="HWDiscovery">
	<xsl:element name="swItemListmain">
		<xsl:element name="swItemList">
			<!-- System ROM -->
			<xsl:if test="/HWDiscovery/ServerInformation/ROM != ''">
				<xsl:variable name="m_month" select="substring-before(/HWDiscovery/ServerInformation/ROMDate,'/')"></xsl:variable>
				<xsl:variable name="m_day" select="substring-before(substring-after(/HWDiscovery/ServerInformation/ROMDate,'/'),'/')"></xsl:variable>
				<xsl:variable name="m_year" select="substring-after(substring-after(/HWDiscovery/ServerInformation/ROMDate,'/'),'/')"></xsl:variable>
				<xsl:element name="swItem">
					<xsl:element name="key">
						<xsl:attribute name="Important">0</xsl:attribute>
						<xsl:value-of select='translate(/HWDiscovery/ServerInformation/ROM,$ucletters,$lcletters)'/>
					</xsl:element>
					<xsl:element name="path"></xsl:element>
					<xsl:element name="installedVer"><xsl:value-of select="$m_year"/>.<xsl:value-of select="$m_month"/>.<xsl:value-of select="$m_day"/></xsl:element>
					<xsl:element name="name">
						<xsl:element name="name_xlate">
							<xsl:attribute name="lang">en</xsl:attribute>Compaq System ROM</xsl:element>
						<xsl:element name="name_xlate">
							<xsl:attribute name="lang">ja</xsl:attribute>Compaq System ROM</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:if>

			<xsl:for-each select="/HWDiscovery/storage_info/devices/device">
				<xsl:if test="string-length(device_id/@value) = 1">
					<xsl:element name="swItem">
						<xsl:element name="key">
							<xsl:attribute name="Important">0</xsl:attribute>
							<xsl:value-of select='translate(product_id/@value,$ucletters,$lcletters)'/>
						</xsl:element>
						<xsl:element name="path"></xsl:element>
						<xsl:element name="installedVer">
							<xsl:value-of select="active_version/@value"/>
						</xsl:element>
						<xsl:element name="name">
							<xsl:element name="name_xlate">
								<xsl:attribute name="lang">en</xsl:attribute>
								<xsl:value-of select="product_id/@value"/>
							</xsl:element>
							<xsl:element name="name_xlate">
								<xsl:attribute name="lang">ja</xsl:attribute>
								<xsl:value-of select="product_id/@value"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
	</xsl:element>
	</xsl:template>
</xsl:stylesheet>