<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="sw_key"></xsl:param>
<xsl:param name="os_name"></xsl:param>
<xsl:param name="soar_os_code"></xsl:param>
<xsl:param name="localized_windows">false</xsl:param>

<xsl:output encoding="utf-8" method="xml" version="1.0" indent="yes"/>

<xsl:template match="/">
<!--
   <xsl:for-each select="softwareInventory/installedSoftware/swItemList/swItem[key=$sw_key]">
      <xsl:apply-templates select="."/>
   </xsl:for-each>
-->
   <xsl:apply-templates select="softwareInventory/installedSoftware/swItemList/swItem[key=$sw_key]"/>
</xsl:template>

<xsl:template match="swItem">
   <xsl:variable name="version_string"><xsl:value-of select="installedVer"/></xsl:variable>
   <SWFWPKG>
   <CLASS NAME="HP_SWRevisionManagement" SUPERCLASS="CIM_SoftwareIdentity">
      <PROPERTY NAME="Caption" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE><xsl:value-of select="name/name_xlate[@lang='en']"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="Description" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY NAME="ElementName" TYPE="string" CLASSORIGIN="CIM_ManagedElement">
         <VALUE><xsl:value-of select="name/name_xlate[@lang='en']"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="InstallDate" TYPE="datetime" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY.ARRAY NAME="OperationalStatus" TYPE="uint16" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE.ARRAY>
            <VALUE>0x8001</VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="StatusDescriptions" TYPE="string" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE.ARRAY>
            <VALUE>Installed and running</VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <!-- The major number component of the software's version information .... -->
      <xsl:variable name="major_version">
         <xsl:value-of select="substring-before($version_string, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="MajorVersion" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$major_version"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem1">
         <xsl:value-of select="substring-after($version_string, '.')"/>
      </xsl:variable>
      <xsl:variable name="minor_version">
         <xsl:value-of select="substring-before($ver_rem1, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="MinorVersion" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$minor_version"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem2">
         <xsl:value-of select="substring-after($ver_rem1, '.')"/>
      </xsl:variable>
      <xsl:variable name="revision_number">
         <xsl:value-of select="substring-before($ver_rem2, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="RevisionNumber" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$revision_number"/></VALUE>
      </PROPERTY>
      <xsl:variable name="ver_rem3">
         <xsl:value-of select="substring-after($ver_rem2, '.')"/>
      </xsl:variable>
      <xsl:variable name="build_number">
         <xsl:value-of select="substring-before($ver_rem3, '.')"/>
      </xsl:variable>
      <PROPERTY NAME="BuildNumber" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$build_number"/></VALUE>
      </PROPERTY>
      <PROPERTY NAME="VersionString" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$version_string"/></VALUE>
      </PROPERTY>
      <PROPERTY.ARRAY NAME="TargetOperatingSystems" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
           <VALUE><xsl:value-of select="$os_name"/></VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY NAME="Manufacturer" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE>Hewlett-Packard</VALUE>
      </PROPERTY>
      <!-- don't know
      <PROPERTY.ARRAY NAME="Languages" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE/>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="Classifications" TYPE="uint16" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE/>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="ClassificationDescriptions" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE.ARRAY>
            <VALUE/>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
       -->
      <PROPERTY NAME="TargetType" TYPE="string" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE><xsl:value-of select="$sw_key"/></VALUE>
      </PROPERTY>
      <!-- Need the release date from the package XML for the installed version
      <PROPERTY NAME="ReleaseDate" TYPE="datetime" CLASSORIGIN="CIM_SoftwareIdentity">
         <VALUE/>
      </PROPERTY>
       -->
      <!-- HP extensions -->
      <!-- Override of CIM_ManagedSystemElement.Name -->
      <!-- Need the filename of the package that was installed
      <PROPERTY NAME="Name" TYPE="string" CLASSORIGIN="CIM_ManagedSystemElement">
         <VALUE/>
      </PROPERTY>
       -->
      <PROPERTY.ARRAY NAME="SOAR_TargetOperatingSystemCodes" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <VALUE><xsl:value-of select="$soar_os_code"/></VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <PROPERTY.ARRAY NAME="SOAR_TargetOperatingSystemFamilyCodes" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <VALUE>
               <xsl:choose>
               <xsl:when test="$localized_windows='true'">10</xsl:when>
               <xsl:otherwise>9</xsl:otherwise>
               </xsl:choose>
            </VALUE>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      <!-- 
      <PROPERTY.ARRAY NAME="PredecessorTargetTypes" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE.ARRAY>
            <xsl:for-each select="cpq_package/sw_keys/sw_keys_and/sw_key">
            <xsl:if test="position() != 1">
            <VALUE><xsl:value-of select="@name"/></VALUE>
            </xsl:if>
            </xsl:for-each>
         </VALUE.ARRAY>
      </PROPERTY.ARRAY>
      -->
      <PROPERTY NAME="Enhancements" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY NAME="Prerequisites" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY NAME="EnhancementType" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE>0</VALUE> <!-- Unknown -->
      </PROPERTY>
      <!--
      <PROPERTY NAME="OtherEnhancementType" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      -->
      <PROPERTY NAME="Fixes" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      <PROPERTY NAME="FixesCriticality" TYPE="uint16" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE>0</VALUE> <!-- Unknown -->
      </PROPERTY>
      <!-- A string describing the FixesCriticality when the instance's
           FixesCriticality property is 1 ("Other").
      <PROPERTY NAME="OtherFixesCriticality" TYPE="string" CLASSORIGIN="HP_SWRevisionManagement">
         <VALUE/>
      </PROPERTY>
      -->
   </CLASS>
   </SWFWPKG>
</xsl:template>
</xsl:stylesheet>
