<!--
   Copyright (C) 2001, 2002 Compaq Information Technologies Group, L.P.
   This file was generated by makexsl.  Do not edit this file.
-->
<!DOCTYPE xsl:stylesheet [
<!ENTITY % common_en SYSTEM "../dtd.en/common.dtd">
%common_en;
]>
<!-- end of makexsl generated header -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="taskId"/>
	<xsl:param name="startMsgId" select="'0'"/>
	<xsl:param name="endMsgId" select="'9999'"/>
	<xsl:param name="logHref" />
	<xsl:param name="msgNoEntries" select="'No log entries were found for the specified task.'"/>
	<xsl:output indent="yes" method="xml" encoding="UTF-8"/>
	<!-- /////////////////////////////////////////////////////////////////////////////
     // template for setting the taskStatus and content of a task's status
     /////////////////////////////////////////////////////////////////////////////
-->
	<xsl:template name="taskStatus">
		<xsl:choose>
			<xsl:when test="count(entry[taskid=$taskId])!=0">
				<xsl:variable name="resultCode">
					<xsl:call-template name="taskResult">
						<xsl:with-param name="taskEntries" select="entry[taskid=$taskId]"/>
					</xsl:call-template>
				</xsl:variable>
				<taskStatus>
					<xsl:attribute name="loghref"><xsl:value-of select="$logHref"/></xsl:attribute>
					<xsl:attribute name="result"><xsl:value-of select="$resultCode"/></xsl:attribute>
				</taskStatus>
				<content>
				  <xsl:for-each select="entry[taskid=$taskId]">
				     <!-- recreate the VCA 1.0 log format - what Insight Manager expects -->
               <entry>
                  <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
                  <when><xsl:attribute name="id"><xsl:value-of select="@timestamp"/></xsl:attribute></when>
                  <xsl:copy-of select="taskid"/>
                  <xsl:copy-of select="msgid"/>
                  <message><xsl:value-of select="xlates/xlate[@lang='en']"/></message>
                  <xsl:copy-of select="severity"/>
                  <xsl:copy-of select="data"/>
                  <xsl:copy-of select="taskData"/>
               </entry>
				  </xsl:for-each>
				</content>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$msgNoEntries"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- /////////////////////////////////////////////////////////////////////////////
     // template for setting the taskStatus element
     /////////////////////////////////////////////////////////////////////////////
-->
	<xsl:template name="taskResult">
		<xsl:param name="taskEntries"/>
		<xsl:choose>
			<xsl:when test="count($taskEntries)!=0">
				<!-- non-empty list, so get the final message result, if there
			     else, mark in progress if the "start" message is there
			     otherwise, return a successful status, since we don't know
			-->
				<xsl:variable name="foundEndEntry">
					<xsl:call-template name="entryResult">
						<xsl:with-param name="singleEntry" select="$taskEntries[msgid=$endMsgId]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="foundStartEntry">
					<xsl:call-template name="entryResult">
						<xsl:with-param name="singleEntry" select="$taskEntries[msgid=$startMsgId]"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- <xsl:value-of select="$foundEndEntry"/> -->
				<!-- <xsl:value-of select="$foundStartEntry"/> -->
				<xsl:choose>
					<xsl:when test="$foundEndEntry!='false'">
						<xsl:value-of select="$foundEndEntry"/>
					</xsl:when>
					<xsl:when test="$foundStartEntry!='false'">3</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- the list is empty, so return a failed status -->
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- /////////////////////////////////////////////////////////////////////////////
     // template to return the result for a single entry, if one
     /////////////////////////////////////////////////////////////////////////////
-->
	<xsl:template name="entryResult">
		<xsl:param name="singleEntry"/>
		<xsl:choose>
			<xsl:when test="count($singleEntry)!=0">
				<!-- there is an entry, so return the result code (or 1, if none) -->
				<xsl:choose>
					<xsl:when test="$singleEntry/result/@code">
						<xsl:value-of select="$singleEntry/result/@code"/>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
