<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output indent="yes" method="xml" version="1.0" encoding="UTF-8"/>
   <!--
   ////////////////////////////////////////////////////////////////////////
   // Convert an old VCA log to something the new common
   // log subsystem can convert to the new log data file
   OLD:
   <swmgrlog version="1.0">
      <created>
         <onMachine name="FIOLSPELARE" address="127.0.0.1"/>
         <when utcDateTime="2002-06-20 21:37:59"/>
      </created>
      <content>
         <entry id="VCA1026150351">
            <when utcDateTime="2002-06-22 17:45:50.541"/>
            <taskid>VCA1026150334</taskid>
            <msgid>21</msgid>
            <message>Smart Component, cp002068.exe, was downloaded from Version Control Repository Manager server fiolspelare.</message>
            <result code="1"/>
            <severity>1</severity>
            <data/>
            <taskData><![CDATA[<package fileName="cp002068.exe"/>]]></taskData>
         </entry>
      </content>
   </swmgrlog>

   INTERMEDIATE:
   <convert_log>
      <entry id="VCA1026150351" timestamp="2002-06-22 17:45:50.541">
         <taskid>VCA1026150334</taskid>
         <msgid>21</msgid>
         <severity>1</severity>
         <data/>
         <xlates>
            <xlate lang="en">Smart Component, cp002068.exe, was downloaded from Version Control Repository Manager server fiolspelare.</xlate>
         </xlates>
         <custom_tags>
            <custom_tag name="taskData">
               <custom_tag_text><![CDATA[<package fileName="cp002068.exe"/>]]></custom_tag_text>
            </custom_tag>
            <custom_tag name="result">
               <custom_tag_attribute name="code">1</custom_tag_attribute>
            </custom_tag>
         </custom_tags>
      </entry>
   </convert_log>
   ////////////////////////////////////////////////////////////////////////
   -->
   <xsl:template match="/swmgrlog">
      <!-- here are the table rows -->
      <convert_log>
         <!--<xsl:apply-templates select="created"/>-->
         <xsl:apply-templates select="content/entry"/>
      </convert_log>
   </xsl:template>

   <xsl:template match="taskid|msgid|severity|data" mode="common">
      <xsl:copy-of select="."/>
   </xsl:template>

   <xsl:template match="message" mode="common">
      <xlates>
         <xlate lang="en">
            <xsl:value-of select="."/>
         </xlate>
      </xlates>
   </xsl:template>

   <xsl:template match="taskData" mode="custom">
      <custom_tag name="taskData">
         <custom_tag_text><xsl:value-of select="."/></custom_tag_text>
      </custom_tag>
   </xsl:template>

   <xsl:template match="result" mode="custom">
      <custom_tag name="result">
         <custom_tag_attribute name="code"><xsl:value-of select="@code"/></custom_tag_attribute>
      </custom_tag>
   </xsl:template>

   <xsl:template match="entry">
      <entry>
         <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
         <xsl:attribute name="timestamp"><xsl:value-of select="when/@utcDateTime"/></xsl:attribute>
         <!-- copy "generic" entry data -->
         <xsl:apply-templates select="taskid" mode="common"/>
         <xsl:apply-templates select="msgid" mode="common"/>
         <xsl:apply-templates select="severity" mode="common"/>
         <xsl:apply-templates select="data" mode="common"/>
         <xsl:apply-templates select="message" mode="common"/>
         <xsl:if test="taskData or result">
            <custom_tags>
               <xsl:apply-templates select="taskData" mode="custom"/>
               <xsl:apply-templates select="result" mode="custom"/>
            </custom_tags>
         </xsl:if>
      </entry>
   </xsl:template>
</xsl:stylesheet>
