#!/bin/sh
#
# Name: remove_lpfc_hbaconf_entry.sh 
# Copyright: (c)Copyright 2006 Hewlett-Packard Development Company, L.P.
#
# Description: Removes lpfc entry from /etc/hba.conf so that HBAnyware works
#              correctly 
#
# Modification History
#
# CD            08/25/06 Initial Development

# Check for help message

if [ "$1" = "-h" ] || [ "$1" = "--help" ]
then
 echo "$0: Removes lpfc entry from /etc/hba.conf so that HBAnyware works correctly"
 exit 0
fi

#
# Defines
#

HBACONF=/etc/hba.conf
HBACONFLINE="/usr/lib/libemsdm.so"
HBANYWAREDIR=/usr/sbin/hbanyware

if test ! -f ${HBANYWAREDIR}/hbanyware
then
	echo "HBAnyware not installed"
	exit 1
fi

# Stop HBAnyware processes

cd $HBANYWAREDIR
./stop_hbanyware

# Remove entry from /etc/hba.conf if needed

echo "Removing $HBACONFLINE from $HBACONF"
cat $HBACONF | grep -v $HBACONFLINE > $HBACONF.new
mv -f $HBACONF $HBACONF.old
mv -f $HBACONF.new $HBACONF
chmod 644 $HBACONF

# Restart HBAnyware processes

echo "Restarting HBAnyware services"
./start_elxdiscovery

if test -f ${HBANYWAREDIR}/start_rmserver
then
	./start_rmserver
else
	./start_elxhbamgr
fi


