// $RCSfile: numcnvrt.js,v $ $Revision: 1.5 $
// (C) Copyright 2004 Hewlett-Packard Development Company, L.P.

function hexfromdec(num)
{
   if (num > 65535) return ("Max is 65535");
   first = Math.round(num/4096 - .5);
   temp1 = num - first * 4096;
   second = Math.round(temp1/256 -.5);
   temp2 = temp1 - second * 256;
   third = Math.round(temp2/16 - .5);
   fourth = temp2 - third * 16;
   return (""+getletter(first)+getletter(second)+getletter(third)+getletter(fourth));
}
function getletter(num)
{
   if (num < 10)
      return num;
   else
   {
      if (num == 10) return "A";
      if (num == 11) return "B";
      if (num == 12) return "C";
      if (num == 13) return "D";
      if (num == 14) return "E";
      if (num == 15) return "F";
   }
}
function decfromhex(num)
{
   while (num.length < 4)
   {
      num = "0" + num;
   }
   return (eval(getnum(num.substring(3,4))) + eval(getnum(num.substring(2,3))) * 16 +
           eval(getnum(num.substring(1,2))) * 256 + eval(getnum(num.substring(0,1))) * 4096);
}
function getnum(letter)
{
   if (letter <= "9")
      return letter;
   else
   {
      if ((letter == "a") || (letter == "A")) return 10;
      if ((letter == "b") || (letter == "B")) return 11;
      if ((letter == "c") || (letter == "C")) return 12;
      if ((letter == "d") || (letter == "D")) return 13;
      if ((letter == "e") || (letter == "E")) return 14;
      if ((letter == "f") || (letter == "F")) return 15;
      return 0;
   }
}
function rawToHex(rawIn, spacer)
{
   var i;
   var rc = "";

   if (null == spacer)
       spacer = "";

   for (i = 0; i < rawIn.length; i++)
   {
      rc += hexfromdec(rawIn[i]).substring(2,4) + spacer;
   }
   return rc;
}
function rawToDate(rawTimeStr)
{
   eventyearhi = rawTimeStr[0] << 8;
   eventyearlow = rawTimeStr[1];
   eventyear = eventyearhi + eventyearlow;
   eventyear = eventyear + "";
   if (eventyear.substring(0,2) == "19")
      eventyear = eventyear % 100;
   eventmonth = rawTimeStr[2];
   eventday = rawTimeStr[3];
   eventdata = eventmonth + "/" + eventday + "/" + eventyear ;
   eventhour = rawTimeStr[4];
   period = "  ";
   if (eventhour >= 0 && eventhour <= 12)
      period = "AM";

   if (eventhour > 12 && eventhour <= 24)
   {
      period = "PM";
      eventhour -= 12;
   }
   eventminute = rawTimeStr[5];
   if (eventminute < 10)
      eventminute = "0" + eventminute;
   eventtime = eventhour + ":" + eventminute + period;
   return (eventdata + "   " + eventtime);
}
