
################################################################
## copyright 2007 Compaq Information Technologies Group, L.P. ##
################################################################

###############################################
###  SLES 10 Kernel Build Environment ONLY!! ##
###############################################
## SLES 10, of course, is different than the ##
## standard Linux environment so has to be   ##
## special cased.                            ##
###############################################


.PHONY: all clean install

LINUX_KERN_DIRS=$(shell ls /lib/modules)
PWD=`pwd`



ifeq "$(EFS_VER)" ""
	EFS_VER=$(LINUX_KERN_DIR)
endif


# IPMI_DEVINTF_VERSION = $(EFS_VER)
# IPMI_KCS_VERSION = $(EFS_VER)
# IPMI_MSGHANDLER_VERSION = $(EFS_VER)
# IPMI_SI_VERSION = $(EFS_VER)


    
all:	init build 

init:
	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/source" ;\
		echo "Initializing KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG ]; then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi.h $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG; \
			fi ;\
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG ]; then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG; \
			fi ;\
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG ];  then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG; \
			fi ;\
			cp include/linux/ipmi.h $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
			cp include/linux/ipmi_msgdefs.h $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
			cp include/linux/ipmi_smi.h $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
		fi ;\
	done



#
# Due to a quirk in the Linux 2.6 Kernel Environment, we need to clean up 
# some temporary (and hidden) files inbetween each build. NOTE:
# this is NOT a full clean and is not designed to be.
#
build:

################################################################
## We have to move the ".config" files for each build because ##
## SLES 10 does not follow a standard Linux Build Environment ##
################################################################

	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/source" ;\
		LINUX_CONFIG_DIR="/lib/modules/$$kversion/build" ;\
		echo "Building  KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			mkdir -p $(PWD)/bin/$$kversion  ;\
			rm -f drivers/char/ipmi/*.o  ;\
			rm -f drivers/char/ipmi/*.ko  ;\
			rm -f drivers/char/ipmi/*.mod.c  ;\
			rm -f drivers/char/ipmi/.ipmi*.cmd  ;\
			rm -rf drivers/char/ipmi/.tmp_versions  ;\
			if [ ! -f $$LINUX_BUILD_DIR/.config ]; then \
				cp $$LINUX_CONFIG_DIR/.config $$LINUX_BUILD_DIR/.config ;\
			else \
				mv $$LINUX_BUILD_DIR/.config $$LINUX_BUILD_DIR/.config.ORIG ;\
			fi ;\
			make -C $$LINUX_CONFIG_DIR V=1 M=$(PWD)/drivers/char/ipmi modules   ;\
			if [ ! -f $$LINUX_BUILD_DIR/.config.ORIG ]; then \
				rm $$LINUX_BUILD_DIR/.config ;\
			else \
				mv $$LINUX_BUILD_DIR/.config.ORIG $$LINUX_BUILD_DIR/.config ;\
			fi ;\
			if [ -f drivers/char/ipmi/ipmi_devintf.ko ]; then \
				mv -vf drivers/char/ipmi/ipmi_*.ko $(PWD)/bin/$$kversion/.  ;\
			else \
				echo "BUILD ERROR: Build for  KERNEL VERSION: $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR FAILED"  ;\
				exit 1 ;\
			fi  ;\
		else \
			echo " "  ;\
			echo "WARNING:  THERE IS NO BUILD DIRECTORY FOR VERSION:  $$kversion"  ;\
			echo "          The LINUX_BUILD_DIR resolves to:  $$LINUX_BUILD_DIR"  ;\
			echo " "  ;\
		fi ;\
	done

clean:
	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/source"  ;\
		echo "Cleaning  KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ $(PWD) != "/" ] ; then \
			rm -rf $(PWD)/bin/$$kversion ;\
		fi  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG ]; then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
			fi ;\
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG ]; then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
			fi ;\
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG ];  then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
			fi ;\
		fi   ;\
	done


install:
ifneq "$(RPM_BUILD_ROOT)" ""
	echo "INSTALLING Files to create RPM"
	sh make_install $(RPM_MAKE_ROOT) $(RPM_BUILD_ROOT)
endif


