
################################################################
## copyright 2002 Compaq Information Technologies Group, L.P. ##
################################################################

.PHONY: all clean install

# LINUX_KERN_DIR=$(shell uname -r)
LINUX_KERN_DIR=$(shell uname -r | sed -e 's/smp//g' -e 's/hugemem//g')
OS_VERSION_UP=$(LINUX_KERN_DIR)
OS_VERSION_MP=$(LINUX_KERN_DIR)smp
OS_VERSION_HM=$(LINUX_KERN_DIR)hugemem

PWD=`pwd`


LINUX_BUILD_UP = /lib/modules/$(OS_VERSION_UP)/build/
LINUX_BUILD_MP = /lib/modules/$(OS_VERSION_MP)/build/
LINUX_BUILD_HM = /lib/modules/$(OS_VERSION_HM)/build/

ifeq "$(EFS_VER)" ""
	EFS_VER=$(LINUX_KERN_DIR)
endif


# IPMI_DEVINTF_VERSION = $(EFS_VER)
# IPMI_KCS_VERSION = $(EFS_VER)
# IPMI_MSGHANDLER_VERSION = $(EFS_VER)
# IPMI_SI_VERSION = $(EFS_VER)


    
all:	init up smp hm

init:
	if [ -d $(LINUX_BUILD_UP) ]; then \
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG ]; then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi.h $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG ];  then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG; \
		fi ;\
		cp include/linux/ipmi.h $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
		cp include/linux/ipmi_msgdefs.h $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
		cp include/linux/ipmi_smi.h $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
	fi 

	if [ -d $(LINUX_BUILD_MP) ]; then \
		if [ ! -f $(LINUX_BUILD_MP)/include/linux/ipmi.h.ORIG ]; then \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi.h $(LINUX_BUILD_MP)/include/linux/ipmi.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h.ORIG ];  then \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h.ORIG; \
		fi ;\
		cp include/linux/ipmi.h $(LINUX_BUILD_MP)/include/linux/ipmi.h ;\
		cp include/linux/ipmi_msgdefs.h $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h ;\
		cp include/linux/ipmi_smi.h $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h ;\
	fi


	if [ -d $(LINUX_BUILD_HM) ]; then \
		if [ ! -f $(LINUX_BUILD_HM)/include/linux/ipmi.h.ORIG ]; then \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi.h $(LINUX_BUILD_HM)/include/linux/ipmi.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h.ORIG ];  then \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h.ORIG; \
		fi ;\
		cp include/linux/ipmi.h $(LINUX_BUILD_HM)/include/linux/ipmi.h ;\
		cp include/linux/ipmi_msgdefs.h $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h ;\
		cp include/linux/ipmi_smi.h $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h ;\
	fi

	if [ ! -f /boot/kernel.h.ORIG ]; then \
		mv /boot/kernel.h /boot/kernel.h.ORIG; \
	fi 


#
# Due to a quirk in the Linux 2.6 Kernel Environment, we need to clean up 
# some temporary (and hidden) files inbetween each build. NOTE:
# this is NOT a full clean and is not designed to be.
#
up:
	mkdir -p $(PWD)/bin/$(OS_VERSION_UP)
	cp boot/kernel.h.UP /boot/kernel.h 
	rm -f drivers/char/ipmi/*.o 
	rm -f drivers/char/ipmi/*.ko 
	rm -f drivers/char/ipmi/*.mod.c 
	rm -f drivers/char/ipmi/.ipmi*.cmd 
	rm -rf drivers/char/ipmi/.tmp_versions 
	make -C $(LINUX_BUILD_UP) SUBDIRS=$(PWD)/drivers/char/ipmi modules 
	mv -f drivers/char/ipmi/ipmi_devintf.o $(PWD)/bin/$(OS_VERSION_UP)/. 
	mv -f drivers/char/ipmi/ipmi_msghandler.o $(PWD)/bin/$(OS_VERSION_UP)/.
	mv -f drivers/char/ipmi/ipmi_si_drv.o $(PWD)/bin/$(OS_VERSION_UP)/. 
	mv -f drivers/char/ipmi/ipmi_watchdog.o $(PWD)/bin/$(OS_VERSION_UP)/. 
	cp /boot/kernel.h.ORIG /boot/kernel.h 

smp:
	mkdir -p $(PWD)/bin/$(OS_VERSION_MP) 
	cp boot/kernel.h.SMP /boot/kernel.h 
	rm -f drivers/char/ipmi/*.o 
	rm -f drivers/char/ipmi/*.ko 
	rm -f drivers/char/ipmi/*.mod.c 
	rm -f drivers/char/ipmi/.ipmi*.cmd 
	rm -rf drivers/char/ipmi/.tmp_versions 
	make -C $(LINUX_BUILD_MP) SUBDIRS=$(PWD)/drivers/char/ipmi modules 
	mv -f drivers/char/ipmi/ipmi_devintf.o $(PWD)/bin/$(OS_VERSION_MP)/.
	mv -f drivers/char/ipmi/ipmi_msghandler.o $(PWD)/bin/$(OS_VERSION_MP)/.
	mv -f drivers/char/ipmi/ipmi_si_drv.o $(PWD)/bin/$(OS_VERSION_MP)/. 
	mv -f drivers/char/ipmi/ipmi_watchdog.o $(PWD)/bin/$(OS_VERSION_MP)/.
	cp /boot/kernel.h.ORIG /boot/kernel.h 

hm:
	if [ -d $(LINUX_BUILD_HM) ]; then \
		mkdir -p $(PWD)/bin/$(OS_VERSION_HM) ;\
		cp boot/kernel.h.HUGEMEM /boot/kernel.h ;\
		rm -f drivers/char/ipmi/*.o ;\
		rm -f drivers/char/ipmi/*.ko ;\
		rm -f drivers/char/ipmi/*.mod.c ;\
		rm -f drivers/char/ipmi/.ipmi*.cmd ;\
		rm -rf drivers/char/ipmi/.tmp_versions ;\
		make -C $(LINUX_BUILD_HM) SUBDIRS=$(PWD)/drivers/char/ipmi modules ;\
		mv -f drivers/char/ipmi/ipmi_devintf.o $(PWD)/bin/$(OS_VERSION_HM)/. ;\
		mv -f drivers/char/ipmi/ipmi_msghandler.o $(PWD)/bin/$(OS_VERSION_HM)/. ;\
		mv -f drivers/char/ipmi/ipmi_si_drv.o $(PWD)/bin/$(OS_VERSION_HM)/. ;\
		mv -f drivers/char/ipmi/ipmi_watchdog.o $(PWD)/bin/$(OS_VERSION_HM)/. ;\
		cp /boot/kernel.h.ORIG /boot/kernel.h ;\
	fi

clean:
	rm -f drivers/char/ipmi/*.o
	rm -f drivers/char/ipmi/*.ko
	rm -f drivers/char/ipmi/*.ko-??
	rm -f drivers/char/ipmi/*.mod.c
	rm -f drivers/char/ipmi/.*.cmd
	rm -rf drivers/char/ipmi/.tmp_versions
	if [ $(PWD) != "/" ] ; then \
		rm -rf $(PWD)/bin ;\
	fi

	if [ -d $(LINUX_BUILD_UP) ]; then \
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG ]; then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
		fi ;\
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
		fi ;\
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG ];  then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
		fi ;\
	fi 

	if [ -d $(LINUX_BUILD_MP) ]; then \
		if [ -f $(LINUX_BUILD_MP)/include/linux/ipmi.h.ORIG ]; then \
			rm $(LINUX_BUILD_MP)/include/linux/ipmi.h; \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi.h.ORIG $(LINUX_BUILD_MP)/include/linux/ipmi.h; \
		fi ;\
		if [ -f $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			rm $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h; \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h.ORIG $(LINUX_BUILD_MP)/include/linux/ipmi_msgdefs.h; \
		fi ;\
		if [ -f $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h.ORIG ];  then \
			rm $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h; \
			mv $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h.ORIG $(LINUX_BUILD_MP)/include/linux/ipmi_smi.h; \
		fi ;\
	fi 

	if [ -d $(LINUX_BUILD_HM) ]; then \
		if [ -f $(LINUX_BUILD_HM)/include/linux/ipmi.h.ORIG ]; then \
			rm $(LINUX_BUILD_HM)/include/linux/ipmi.h; \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi.h.ORIG $(LINUX_BUILD_HM)/include/linux/ipmi.h; \
		fi ;\
		if [ -f $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			rm $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h; \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h.ORIG $(LINUX_BUILD_HM)/include/linux/ipmi_msgdefs.h; \
		fi ;\
		if [ -f $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h.ORIG ];  then \
			rm $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h; \
			mv $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h.ORIG $(LINUX_BUILD_HM)/include/linux/ipmi_smi.h; \
		fi ;\
	fi 

	if [ -f /boot/kernel.h.ORIG ]; then \
		rm /boot/kernel.h; \
		mv /boot/kernel.h.ORIG /boot/kernel.h; \
	fi 


install:
ifneq "$(RPM_BUILD_ROOT)" ""
	sh make_install $(RPM_MAKE_ROOT) $(RPM_BUILD_ROOT)
endif


