/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Fibre Channel Host Bus Adapters.                                *
 * Copyright (C) 2003-2005 Emulex.  All rights reserved.           *
 * EMULEX and SLI are trademarks of Emulex.                        *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of version 2 of the GNU General       *
 * Public License as published by the Free Software Foundation.    *
 * This program is distributed in the hope that it will be useful. *
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
 * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
 * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
 * more details, a copy of which can be found in the file COPYING  *
 * included with this package.                                     *
 *******************************************************************/

/*
 * $Id: lpfc_debug_ioctl.c 2801 2006-01-06 21:11:22Z sf_support $
 */
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/ptrace.h>
#include <linux/ioport.h>
#include <linux/in.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/blkdev.h>
#include <linux/string.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/unistd.h>
#include <linux/timex.h>
#include <linux/timer.h>
#include <linux/skbuff.h>
#include <linux/if_arp.h>
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <asm/irq.h>

#include <linux/blkdev.h>
#include <scsi/scsi.h>
#include <scsi/scsi_device.h>
#include <scsi/scsi_host.h>
#include <scsi/scsi_tcq.h>
#include <scsi/scsi_transport_fc.h>
#include <asm/pci.h>

#include "lpfc_hw.h"
#include "lpfc_sli.h"
#include "lpfc_disc.h"
#include "lpfc_scsi.h"
#include "lpfc.h"
#include "lpfc_diag.h"
#include "lpfc_ioctl.h"
#include "lpfc_diag.h"
#include "lpfc_crtn.h"
#include "lpfc_debug_ioctl.h"
#include "lpfc_misc.h"
#include "lpfc_compat.h"

extern struct mutex lpfcdfc_lock;

int
lpfc_ioctl_lip(struct lpfc_hba * phba, LPFCCMDINPUT_t * cip, void *dataout)
{
	return  - lpfc_issue_lip(phba->host);
}

static int
copy_sli_info(dfcsli_t * pdfcsli, struct lpfc_hba * phba)
{
	struct lpfc_sli *psli;
	int i, j;

	psli = &phba->sli;

	for (i = 0; i < LPFC_MAX_RING; ++i) {
		for (j = 0; j < LPFC_MAX_RING_MASK; ++j) {
			pdfcsli->sliinit.ringinit[i].prt[j].rctl =
				psli->ring[i].prt[j].rctl;
			pdfcsli->sliinit.ringinit[i].prt[j].type =
				psli->ring[i].prt[j].type;
		}
		pdfcsli->sliinit.ringinit[i].num_mask =
			psli->ring[i].num_mask;
		pdfcsli->sliinit.ringinit[i].iotag_ctr =
			psli->ring[i].iotag_ctr;
		pdfcsli->sliinit.ringinit[i].numCiocb =
			psli->ring[i].numCiocb;
		pdfcsli->sliinit.ringinit[i].numRiocb =
			psli->ring[i].numRiocb;
	}
	pdfcsli->sliinit.num_rings = psli->num_rings;
	pdfcsli->sliinit.sli_flag = psli->sli_flag;
	pdfcsli->MBhostaddr.addrlo =
		(uint64_t)((unsigned long)&phba->slim2p->mbx) & 0xffffffff;
	pdfcsli->MBhostaddr.addrhi =
		(uint64_t)((unsigned long)&phba->slim2p->mbx) >> 32;
	for (i = 0; i < LPFC_MAX_RING; ++i) {
		pdfcsli->ring[i].rspidx = psli->ring[i].rspidx;
		pdfcsli->ring[i].cmdidx = psli->ring[i].cmdidx;
		pdfcsli->ring[i].txq_cnt = psli->ring[i].txq_cnt;
		pdfcsli->ring[i].txq_max = psli->ring[i].txq_max;
		pdfcsli->ring[i].txcmplq_cnt = psli->ring[i].txcmplq_cnt;
		pdfcsli->ring[i].txcmplq_max = psli->ring[i].txcmplq_max;
		pdfcsli->ring[i].cmdringaddr.addrlo =
			(uint64_t)((unsigned long)psli->ring[i].cmdringaddr)
			& 0xffffffff;
		pdfcsli->ring[i].cmdringaddr.addrhi =
			(uint64_t)((unsigned long)psli->ring[i].cmdringaddr)
			>> 32;
		pdfcsli->ring[i].rspringaddr.addrlo =
			(uint64_t)((unsigned long)psli->ring[i].rspringaddr)
			& 0xffffffff;
		pdfcsli->ring[i].rspringaddr.addrhi =
			(uint64_t)((unsigned long)psli->ring[i].rspringaddr)
			>> 32;
		pdfcsli->ring[i].missbufcnt = psli->ring[i].missbufcnt;
		pdfcsli->ring[i].postbufq_cnt = psli->ring[i].postbufq_cnt;
		pdfcsli->ring[i].postbufq_max = psli->ring[i].postbufq_max;
	}
	pdfcsli->mboxq_cnt = psli->mboxq_cnt;
	pdfcsli->mboxq_max = psli->mboxq_max;
	for (i = 0; i < LPFC_MAX_RING; ++i) {
		pdfcsli->slistat.iocbEvent[i].lo =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_event)
			& 0xffffffff;
		pdfcsli->slistat.iocbEvent[i].hi =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_event)
			>> 32;
		pdfcsli->slistat.iocbCmd[i].lo =
			(uint64_t)((unsigned long)psli->ring[i].stats.iocb_cmd)
			& 0xffffffff;
		pdfcsli->slistat.iocbCmd[i].hi =
			(uint64_t)((unsigned long)psli->ring[i].stats.iocb_cmd)
			>> 32;
		pdfcsli->slistat.iocbRsp[i].lo =
			(uint64_t)((unsigned long)psli->ring[i].stats.iocb_rsp)
			& 0xffffffff;
		pdfcsli->slistat.iocbRsp[i].hi =
			(uint64_t)((unsigned long)psli->ring[i].stats.iocb_rsp)
			>> 32;
		pdfcsli->slistat.iocbCmdFull[i].lo =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_cmd_full)
			& 0xffffffff;
		pdfcsli->slistat.iocbCmdFull[i].hi =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_cmd_full)
			>> 32;
		pdfcsli->slistat.iocbCmdEmpty[i].lo =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_cmd_empty)
			& 0xffffffff;
		pdfcsli->slistat.iocbCmdEmpty[i].hi =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_cmd_empty)
			>> 32;
		pdfcsli->slistat.iocbRspFull[i].lo =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_rsp_full)
			& 0xffffffff;
		pdfcsli->slistat.iocbRspFull[i].hi =
			(uint64_t)((unsigned long)
				   psli->ring[i].stats.iocb_rsp_full)
			>> 32;
	}
	pdfcsli->slistat.mboxStatErr.lo =
		(uint64_t)((unsigned long)psli->slistat.mbox_stat_err)
		& 0xffffffff;
	pdfcsli->slistat.mboxStatErr.hi =
		(uint64_t)((unsigned long)psli->slistat.mbox_stat_err)
		>> 32;
	pdfcsli->slistat.mboxCmd.lo =
		(uint64_t)((unsigned long)psli->slistat.mbox_cmd)
		& 0xffffffff;
	pdfcsli->slistat.mboxCmd.hi =
		(uint64_t)((unsigned long)psli->slistat.mbox_cmd)
		>> 32;
	pdfcsli->slistat.sliIntr.lo =
		(uint64_t)((unsigned long)psli->slistat.sli_intr)
		& 0xffffffff;
	pdfcsli->slistat.sliIntr.hi =
		(uint64_t)((unsigned long)psli->slistat.sli_intr)
		>> 32;
	pdfcsli->slistat.errAttnEvent = psli->slistat.err_attn_event;
	pdfcsli->slistat.linkEvent = psli->slistat.link_event;
	pdfcsli->fcp_ring = (uint32_t)psli->fcp_ring;
	return (0);
}

int
lpfc_ioctl_inst(struct lpfc_hba * phba, LPFCCMDINPUT_t * cip, void *dataout)
{
	struct pci_dev * dev = NULL;
	struct Scsi_Host   *host;
	int *p_int;
	int rc = 0, devcount = 0;
	struct lpfc_hba *iphba;

	p_int = dataout;
	p_int++;

	mutex_lock (&lpfcdfc_lock);
	while ((dev = pci_get_device(PCI_VENDOR_ID_EMULEX,PCI_ANY_ID,dev))
	       != NULL) {
		host = pci_get_drvdata(dev);
		if(host != NULL) {
			iphba = (struct lpfc_hba*)host->hostdata;
			*p_int++ = iphba->brd_no;
			devcount++;
		}
	}
	mutex_unlock (&lpfcdfc_lock);

	/* Store the number of devices */
	p_int = dataout;
	*p_int = devcount;

	return (rc);
}

int
copy_node_list(dfcnodelist_t *pdfcndl, struct lpfc_nodelist *pndl)
{
	pdfcndl->nlp_failMask = 0;
	pdfcndl->nlp_type = pndl->nlp_type;
	pdfcndl->nlp_rpi = pndl->nlp_rpi;
	pdfcndl->nlp_state = pndl->nlp_state;
	pdfcndl->nlp_xri = pndl->nlp_xri;
	pdfcndl->nlp_flag = pndl->nlp_flag;
	pdfcndl->nlp_DID = pndl->nlp_DID;
	memcpy(pdfcndl->nlp_portname,
	       (uint8_t *)&(pndl->nlp_portname),
	       sizeof(pdfcndl->nlp_portname));
	memcpy(pdfcndl->nlp_nodename,
	       (uint8_t *)&(pndl->nlp_nodename),
	       sizeof(pdfcndl->nlp_nodename));
	pdfcndl->nlp_sid = pndl->nlp_sid;

	return (sizeof (dfcnodelist_t));
}

int
lpfc_ioctl_reset(struct lpfc_hba * phba, LPFCCMDINPUT_t * cip)
{
	uint32_t reset_type;
	struct completion online_compl;
	int status = 0;
	int rc = 0;

	reset_type = (ulong) cip->lpfc_arg1;

	switch (reset_type) {
	case 1:		/* Selective reset */
	case 2:		/* Coordinated reset */
		init_completion(&online_compl);
		lpfc_workq_post_event(phba, &status, &online_compl,
				      LPFC_EVT_OFFLINE);
		wait_for_completion(&online_compl);
		if (status) {
			rc = EIO;
			break;
		}
		init_completion(&online_compl);
		lpfc_workq_post_event(phba, &status, &online_compl,
				      LPFC_EVT_ONLINE);
		wait_for_completion(&online_compl);
		if (status)
			rc = EIO;
		break;

	default:
		rc = ERANGE;
		break;
	}

	return rc;
}

int
copy_hba_info(void *dataout, struct lpfc_hba * phba)
{
	dfchba_t * pdfchba;

	pdfchba = (dfchba_t*)dataout;

	pdfchba->hba_state = phba->hba_state;
	pdfchba->fc_busflag = 0;
	copy_sli_info(&pdfchba->sli, phba);
	return (0);
}

int
copy_stat_info(void *dataout, struct lpfc_hba * phba)
{
	dfcstats_t * pdfcstat;
	pdfcstat = (dfcstats_t*)dataout;

	pdfcstat->elsRetryExceeded = phba->fc_stat.elsRetryExceeded;
	pdfcstat->elsXmitRetry = phba->fc_stat.elsXmitRetry;
	pdfcstat->elsRcvDrop = phba->fc_stat.elsRcvDrop;
	pdfcstat->elsRcvFrame = phba->fc_stat.elsRcvFrame;
	pdfcstat->elsRcvRSCN = phba->fc_stat.elsRcvRSCN;
	pdfcstat->elsRcvRNID = phba->fc_stat.elsRcvRNID;
	pdfcstat->elsRcvFARP = phba->fc_stat.elsRcvFARP;
	pdfcstat->elsRcvFARPR = phba->fc_stat.elsRcvFARPR;
	pdfcstat->elsRcvFLOGI = phba->fc_stat.elsRcvFLOGI;
	pdfcstat->elsRcvPLOGI = phba->fc_stat.elsRcvPLOGI;
	pdfcstat->elsRcvADISC = phba->fc_stat.elsRcvADISC;
	pdfcstat->elsRcvPDISC = phba->fc_stat.elsRcvPDISC;
	pdfcstat->elsRcvFAN = phba->fc_stat.elsRcvFAN;
	pdfcstat->elsRcvLOGO = phba->fc_stat.elsRcvLOGO;
	pdfcstat->elsRcvPRLO = phba->fc_stat.elsRcvPRLO;
	pdfcstat->elsRcvPRLI = phba->fc_stat.elsRcvPRLI;
	pdfcstat->elsRcvRRQ = 0;
	pdfcstat->frameRcvBcast = phba->fc_stat.frameRcvBcast;
	pdfcstat->frameRcvMulti = phba->fc_stat.frameRcvMulti;
	pdfcstat->strayXmitCmpl = phba->fc_stat.strayXmitCmpl;
	pdfcstat->frameXmitDelay = phba->fc_stat.frameXmitDelay;
	pdfcstat->xriCmdCmpl = phba->fc_stat.xriCmdCmpl;
	pdfcstat->xriStatErr = phba->fc_stat.xriStatErr;
	pdfcstat->LinkUp = phba->fc_stat.LinkUp;
	pdfcstat->LinkDown = phba->fc_stat.LinkDown;
	pdfcstat->LinkMultiEvent = phba->fc_stat.LinkMultiEvent;
	pdfcstat->NoRcvBuf = phba->fc_stat.NoRcvBuf;
	pdfcstat->fcpCmd = phba->fc_stat.fcpCmd;
	pdfcstat->fcpCmpl = phba->fc_stat.fcpCmpl;
	pdfcstat->fcpRspErr = phba->fc_stat.fcpRspErr;
	pdfcstat->fcpRemoteStop = phba->fc_stat.fcpRemoteStop;
	pdfcstat->fcpPortRjt = phba->fc_stat.fcpPortRjt;
	pdfcstat->fcpPortBusy = phba->fc_stat.fcpPortBusy;
	pdfcstat->fcpError = phba->fc_stat.fcpError;
	return(0);
}

int
lpfc_ioctl_read_hba(struct lpfc_hba *phba, LPFCCMDINPUT_t *cip, void *dataout,
		    int size)
{

	struct lpfc_sli *psli;
	int rc = 0;
	int cnt = 0;
	unsigned long iflag;
	void* psavbuf = 0;

	psli = &phba->sli;
	if (cip->lpfc_arg1) {

		/* HBA SLI state */
		spin_lock_irqsave(phba->host->host_lock, iflag);

		if (psli->sli_flag & LPFC_SLI2_ACTIVE) {

			/*
			 * The SLIM2 size is stored in the next field.  We
			 * cannot exceed the size of the dataout buffer so if
			 * it's not big enough we need to allocate a temp
			 * buffer.
			 */
			cnt = SLI2_SLIM_SIZE;
			if (cnt > size) {
				psavbuf = dataout;
				dataout = kmalloc(cnt, GFP_ATOMIC);
				if (!dataout) {
					spin_unlock_irqrestore(phba->host->
							host_lock, iflag);
					return (ENOMEM);
				}
			}
		} else {
			cnt = 4096;
		}

		if (psli->sli_flag & LPFC_SLI2_ACTIVE) {
			/* copy results back to user */
			lpfc_sli_pcimem_bcopy(&phba->slim2p->mbx, dataout, cnt);
		} else {
			/* First copy command data */
			lpfc_memcpy_from_slim( dataout, phba->MBslimaddr, cnt);
		}

		/* HBA SLI state */
		spin_unlock_irqrestore(phba->host->host_lock, iflag);
		if (copy_to_user
		    ((uint8_t *) cip->lpfc_arg1, (uint8_t *) dataout,
		     cnt)) {
			rc = EIO;
		}
		if (psavbuf) {
			kfree(dataout);
			dataout = psavbuf;
			psavbuf = 0;
		}
		if (rc)
			return (rc);
	}
	copy_hba_info(dataout, phba);
	return (rc);
}

int
lpfc_ioctl_stat(struct lpfc_hba * phba, LPFCCMDINPUT_t * cip, void *dataout)
{
	int rc = 0;

	if ((ulong) cip->lpfc_arg1 == 1) {
		copy_hba_info(dataout, phba);
	}

	/* Copy struct lpfc_stats */
	if ((ulong) cip->lpfc_arg1 == 2) {
		copy_stat_info(dataout, phba);
	}

	return (rc);
}
