
################################################################
## copyright 2002 Compaq Information Technologies Group, L.P. ##
################################################################

.PHONY: all clean install

# LINUX_KERN_DIR=$(shell uname -r)
LINUX_KERN_DIR=$(shell uname -r | sed -e 's/smp//g' -e 's/hugemem//g')
OS_VERSION_UP=$(LINUX_KERN_DIR)
OS_VERSION_MP=$(LINUX_KERN_DIR)smp

PWD=`pwd`


LINUX_BUILD_UP = /lib/modules/$(OS_VERSION_UP)/build/

ifeq "$(EFS_VER)" ""
	EFS_VER=$(LINUX_KERN_DIR)
endif


# IPMI_DEVINTF_VERSION = $(EFS_VER)
# IPMI_KCS_VERSION = $(EFS_VER)
# IPMI_MSGHANDLER_VERSION = $(EFS_VER)
# IPMI_SI_VERSION = $(EFS_VER)


    
all:	init up 

init:
	if [ -d $(LINUX_BUILD_UP) ]; then \
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG ]; then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi.h $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG; \
		fi ;\
		if [ ! -f $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG ];  then \
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG; \
		fi ;\
		cp include/linux/ipmi.h $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
		cp include/linux/ipmi_msgdefs.h $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
		cp include/linux/ipmi_smi.h $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
	fi 


#
# Due to a quirk in the Linux 2.6 Kernel Environment, we need to clean up 
# some temporary (and hidden) files inbetween each build. NOTE:
# this is NOT a full clean and is not designed to be.
# NOTE:  RHEL 3, Update 6 (i86emt) is an entire different animal than
#        regular Linux.  We only build an SMP kernel but we have to
#        treat it like a UP kernel because of Red Hat naming convention.
#
up:
	mkdir -p $(PWD)/bin/$(OS_VERSION_UP)
	rm -f drivers/char/ipmi/*.o
	rm -f drivers/char/ipmi/*.ko
	rm -f drivers/char/ipmi/*.mod.c
	rm -f drivers/char/ipmi/.ipmi*.cmd
	rm -rf drivers/char/ipmi/.tmp_versions
	make -C $(LINUX_BUILD_UP) SUBDIRS=$(PWD)/drivers/char/ipmi modules
	mv -f drivers/char/ipmi/ipmi_devintf.o $(PWD)/bin/$(OS_VERSION_UP)/.
	mv -f drivers/char/ipmi/ipmi_msghandler.o $(PWD)/bin/$(OS_VERSION_UP)/.
#	mv -f drivers/char/ipmi/ipmi_poweroff.ko $(PWD)/bin/$(OS_VERSION_UP)/.
	mv -f drivers/char/ipmi/ipmi_si_drv.o $(PWD)/bin/$(OS_VERSION_UP)/.
	mv -f drivers/char/ipmi/ipmi_watchdog.o $(PWD)/bin/$(OS_VERSION_UP)/.


clean:
	rm -f drivers/char/ipmi/*.o
	rm -f drivers/char/ipmi/*.ko
	rm -f drivers/char/ipmi/*.ko-??
	rm -f drivers/char/ipmi/*.mod.c
	rm -f drivers/char/ipmi/.*.cmd
	rm -rf drivers/char/ipmi/.tmp_versions
	if [ $(PWD) != "/" ] ; then \
		rm -rf $(PWD)/bin ;\
	fi

	if [ -d $(LINUX_BUILD_UP) ]; then \
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG ]; then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi.h ;\
		fi ;\
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG ]; then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi_msgdefs.h ;\
		fi ;\
		if [ -f $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG ];  then \
			rm $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
			mv $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h.ORIG $(LINUX_BUILD_UP)/include/linux/ipmi_smi.h ;\
		fi ;\
	fi 


install:
ifneq "$(RPM_BUILD_ROOT)" ""
	sh make_install $(RPM_MAKE_ROOT) $(RPM_BUILD_ROOT)
endif


