/*
Name: pb_inst.rh.c
Copyright: (c)2005-2007 Hewlett-Packard Company

Description: puts and removes probe-luns startup code in
             /etc/rc.d/rc.sysinit

Chad Dupuis 	04/25/05 Initial Devlopement
Chad Dupuis	12/19/05 Look for HP DEVLABEL code when
                         inserting probe-luns startup code
Chad Dupuis	03/08/07 add #include <string.h> to fix compiler
                         warnings
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

/* defines */

#define RCSYSINIT "/etc/rc.d/rc.sysinit"
#define RCSYSINITNEW "/etc/rc.d/rc.sysinit.new"
#define INSERT_MODE 1
#define REMOVE_MODE 2
#define STARTUPSTR "# PROBE-LUNS install begin -- Do Not Edit\n\necho \"Running probe-luns\"\n\nif [ -f /sbin/probe-luns ] ; then\n	/sbin/probe-luns -d >/dev/null 2>&1\nfi\n\n# PROBE-LUNS install end -- Do Not Edit\n"
#define HPDEVLABELCMD "grep \"# HP DEVLABEL install begin -- Do Not Edit\" /etc/rc.sysinit 1>/dev/null 2>/dev/null"

int main (int argc, char *argv[])
{
 FILE *rcsysinit;
 FILE *rcsysinit_new;
 int mode = 0;
 int rc = 0;
 char compare_str[256]; /* string to be used as a comparison operator */

 /* check command line arguments */

 if ( argc != 2 )
 {
	print_usage ();
	exit (1);
 }

 if ( ((strcmp("-i", argv[1])) != 0) && ((strcmp("-u", argv[1])) != 0 ) )
 {
	print_usage ();
	exit (1);
 }

 if ( (strcmp("-i", argv[1])) == 0 )
 {
	mode = INSERT_MODE;
 }
 else
 {
	mode = REMOVE_MODE;
 }

 /* check for the existance of HPDEVLABEL code to see what string we
    should use to tell where we insert the probe-luns code */

 rc = system(HPDEVLABELCMD);

 if (rc < 1)
 {
	/* look for HP DEVLABEL string in /etc/rc.sysinit */
	strcpy (compare_str, "# HP DEVLABEL install begin -- Do Not Edit\n");
 }
 else
 { 
	/* look for LVM code startup in /etc/rc.sysinit */
	#ifdef RHEL4
	strcpy (compare_str, "# LVM2 initialization\n");
	#else
	strcpy (compare_str, "# LVM initialization\n");
	#endif
 }
	
 /* open rc.sysinit */

 rcsysinit = fopen (RCSYSINIT, "r");

 if ( rcsysinit == NULL )
 {
 	perror ("fopen");
	fprintf (stderr, "Could not open %s\n", RCSYSINIT);
	exit (1);
 }

 /* open new file to write to */

 rcsysinit_new = fopen (RCSYSINITNEW, "w");

 if ( rcsysinit_new == NULL )
 {
 	perror ("fopen");
	fprintf (stderr, "Could not open %s\n", RCSYSINITNEW);
	exit (1);
 }

 /* insert or remove probe-luns startup code depending upon which mod we are
    operating in */

 if ( mode == INSERT_MODE )
 {
 	insert_text (rcsysinit, rcsysinit_new, compare_str);
 }
 else if ( mode == REMOVE_MODE )
 {
	remove_text (rcsysinit, rcsysinit_new);
 }

 fclose (rcsysinit_new);
 fclose (rcsysinit);	
 return (0);
}

/* inserts the probe-luns startup code into the rc.sysinit file */

int insert_text (FILE *rcsysinit, FILE *rcsysinit_new, char compare_str[])
{
 char strbuf[4096];
 int rc;
 
 /* copy original rc.sysinit to rc.sysinit.new and inserting the
    probe-luns startup text */

 while ( fgets(strbuf, sizeof(strbuf), rcsysinit) != NULL )
 {
 
	/* insert text once we have seen the target text */

	if ((strcmp(strbuf, compare_str)) == 0 )
	{
		rc = fprintf (rcsysinit_new, "%s", STARTUPSTR);
	
		if ( rc < 0 )
		{
			perror ("fprintf");
			fprintf (stderr, "Error writing to %s\n", RCSYSINITNEW);
			exit (1);
		}
	}


 	/* copy current string to new rcsysinit file */

      	rc = fprintf (rcsysinit_new, "%s", strbuf);
	
	if ( rc < 0 )
	{
		perror ("fprintf");
		fprintf (stderr, "Error writing to %s\n", RCSYSINITNEW);
		fclose (rcsysinit_new);
		fclose (rcsysinit);
		exit (1);
	} 
	
 }
}


/* removes the probe-luns startup code from rc.sysinit */

int remove_text (FILE *rcsysinit, FILE *rcsysinit_new)
{
 char strbuf[4096];
 int rc;
 int output = 1; /* used to tell when to output text to a file */
	         /* 0 = no output, 1 = output */

 /* copy original rc.sysinit to rc.sysinit.new while removing the
    probe-luns startup text */

 while ( fgets(strbuf, sizeof(strbuf), rcsysinit) != NULL )
 {
 	/* toggle the output variable based upon whether we see "PROBE-LUNS" */

	if ( (strstr(strbuf, "PROBE-LUNS")) != NULL )
	{
		/* get one more string to get rid of the end string */

		if ( output == 0 )
		{
			fgets (strbuf, sizeof(strbuf), rcsysinit);
		}
		
		output = !output;
	}
	
	/* only output strings to text file if output = 1 */

	if ( output == 1 )
	{
        	/* copy current string to new rcsysinit file */

		rc = fprintf (rcsysinit_new, "%s", strbuf);
	
		if ( rc < 0 )
		{
			perror ("fprintf");
			fprintf (stderr, "Error writing to %s\n", RCSYSINITNEW);
			fclose (rcsysinit_new);
			fclose (rcsysinit);
			exit (1);
		} 
	}
	
 }
}


/* prints out a usage statement */

int print_usage ()
{
 printf ("Usage: pb_inst.rh -i|-r\n");
}
