#!/bin/bash
#
# Name: pbl_inst.sh
# Copyright: (c) 2005-2007 Hewlett-Packard Company
#
# Description: installation script for probe-luns program
#
# CD		04/25/05 Initial Development
# CD		09/19/06 Put probe-luns in S04 instead of S03
# CD		03/07/07 Added check to make sure the script doesn't
#			 run on RHEL 5

#
# defines
#

REDHAT=1
SUSE=2
RCSYSINIT=/etc/rc.d/rc.sysinit
SUSEBOOT=/opt/hp/hp_fibreutils/pbl/boot.probe-luns
PBLORIG=/opt/hp/hp_fibreutils/probe-luns
PBLEXE=/sbin/probe-luns

# Determine if we are SLES 10
if test -f /etc/SuSE-release
then
	if [ "`cat /etc/SuSE-release | grep "SUSE Linux Enterprise Server 10"`" != "" ]
	then
		SLES10=y	
	else
		SLES10=n	
	fi
else
	SLES10=n
fi

#
# functions
#

# copies the boot code for probe-luns to the proper location

install () {

 # look for /sbin/probe-luns

 if test ! -f $PBLORIG
 then
	echo "Could not find /opt/hp/hp_fibreutils/probe-luns installation aborted!"
  	exit 1
 fi

 # copy probe-luns 

 echo "Copying probe-luns"
 cp $PBLORIG $PBLEXE 
 chmod 555 $PBLEXE 
 chown root:root $PBLEXE 

 # remove link for probe-luns to /usr/sbin

 rm -f /usr/sbin/probe-luns

 if [ $DISTRO -eq $REDHAT ]
 then
 	# We are Red hat, put code in rc.sysinit
	# check to make sure we don't have startup code already in rc.sysinit 

	if [ "`cat $RCSYSINIT | grep probe-luns`" != "" ]
	then
		echo "$RCSYSINIT already contains startup code for probe-luns, installation aborted"
		exit 1
	fi

	# insert startup code into rc.sysinit

	echo "Inserting probe-luns startup code into $RCSYSINIT"
	cp $RCSYSINIT $RCSYSINIT.old
	$RHINST -i

	if [ $? -ne 0 ]
	then
		echo "Insertion of probe-luns startup code into $RCSYSINIT failed, installation aborted"
		exit 1
	fi
	
	mv -f $RCSYSINIT.new $RCSYSINIT
	chmod 755 $RCSYSINIT
	chown root:root $RCSYSINIT
 elif [ $DISTRO -eq $SUSE ]
 then
 	# We are SUSE, copy boot script
	
	echo "Copying $SUSEBOOT to /etc/rc.d and creating symbolic link to boot.d"
	cp $SUSEBOOT /etc/rc.d

	if [ $? -ne 0 ]
	then
		echo "Copy of $SUSEBOOT failed, installation aborted!"
		exit 1
	fi

	chmod 744 /etc/rc.d/boot.probe-luns
	chown root:root /etc/rc.d/boot.probe-luns
	
	# What we do is dependent upon which version of SLES we're running 

	if [ "$SLES10" = "y" ]
	then
		chkconfig --add boot.probe-luns
	else
		cd /etc/rc.d/boot.d
		ln -fs ../boot.probe-luns S04boot.probe-luns
	fi

	if [ $? -ne 0 ]
	then
		echo "Symbolic link failed, installation aborted!"
		exit 1
	fi
 fi
}


# removes boot code for probe-luns 

uninstall () {

 # remove probe-luns from /sbin

 echo "Removing $PBLEXE"
 rm -f $PBLEXE

 # restore original probe-luns link

 ln -fs $PBLORIG /usr/sbin/probe-luns

 if [ $DISTRO -eq $REDHAT ]
 then
 	# We are Red hat, remove code in rc.sysinit
	
	# remove startup code into rc.sysinit

	echo "Removing probe-luns startup code from $RCSYSINIT"
	cp $RCSYSINIT $RCSYSINIT.old
	$RHINST -u

	if [ $? -ne 0 ]
	then
		echo "Removal of probe-luns startup code from $RCSYSINIT failed, uninstall aborted"
		exit 1
	fi
	
	mv -f $RCSYSINIT.new $RCSYSINIT
	chmod 755 $RCSYSINIT
	chown root:root $RCSYSINIT
 elif [ $DISTRO -eq $SUSE ]
 then
 	# We are SUSE, remove boot scripts
	
	echo "Removing probe-luns boot scripts"
	
	# What we do is dependent upon which version of SLES we are running
	if [ "$SLES10" = "y" ]
	then
		chkconfig -d boot.probe-luns
	else
		rm -f /etc/rc.d/boot.d/S04boot.probe-luns
	fi
	
	rm -f /etc/rc.d/boot.probe-luns
 fi
}

#
# script main
#

if [ $# -ne 1 ]
then
 echo "Usage: pbl_inst.sh -i|-u"
 echo ""
 echo "-i: installs probe-luns"
 echo "-u: uninstalls probe-luns"
 exit 1
fi

# determine if we are using a 2.4 or 2.6 kernel

if [ "`uname -r | cut -c 1-3`" != "2.4" ] && [ "`uname -r | cut -c 1-3`" != "2.6" ]
then
 echo "probe-luns is only supported on 2.4 or 2.6 kernels"
 exit 1
fi

# Check to make sure that we are not running RHEL 5

RHVERFILE=/etc/redhat-release

if test -f $RHVERFILE
then
        VERSTR="`cat $RHVERFILE | grep "Red Hat Enterprise Linux"`"

        if [ "`echo $VERSTR | grep "release 4.92"`" != "" ] || [ "`echo $VERSTR | grep "release 5 "`" != "" ]
        then
                echo "$0 is not supported on RHEL 5"
                exit 1
        fi
fi

# determine what distribution we are

if test -f /etc/redhat-release
then
 # set red hat installation program

 if [ "`cat /etc/redhat-release | grep " 4 "`" != "" ]
 then
	RHINST="/opt/hp/hp_fibreutils/pbl/pbl_inst.rh4"
 else
 	RHINST="/opt/hp/hp_fibreutils/pbl/pbl_inst.rh"
 fi
 
 DISTRO=$REDHAT
elif test -f /etc/SuSE-release
then
 DISTRO=$SUSE 
else
 echo "Unknown distribution!"
 exit 1
fi

# parse command line argument

if [ "$1" = "-i" ]
then
 install
elif [ "$1" = "-u" ]
then
 uninstall
else
 echo "Bad Argument"
fi




