//
// Name: scsi_info.C
// Copyright: (c) Copyright 2005 Hewlett-Packard Development Company, L.P.
//
// Description: Issues SCSI inquiry command to specified device and then
//              prints out the data returned in a colen (:) delineated list
//
// CD		07/07/05 Initial Development

#include <iostream>
#include "ScsiInfo.h"
using namespace std;

void print_help();

int main (int argc, char* argv[])
{
 ScsiInfo scsi_info;
 int rc;

 // check argument count

 if (argc != 2)
 {
	print_help();
	return (1); 
 }
 
 // set the name of the device that we are going to
 // do the inquiry to

 rc = scsi_info.SetDeviceName (argv[1]);

 if ( rc != 0 )
 {
 	scsi_info.PrintError (rc, "SetDeviceName()");
	return (1);
 }

 // check to make sure that device exists

 rc = scsi_info.DoesDeviceExist();

 if ( rc != 0 )
 {
 	scsi_info.PrintError (rc, "DoesDeviceExist()");
	return (1);
 }

 // get device information from device
 
 rc = scsi_info.GetDeviceInfo();

 if ( rc != 0)
 {
	scsi_info.PrintError (rc, "GetDeviceInfo()");
	return (1);
 }

 // print out information obtained from device

 scsi_info.PrintDeviceInfo();

 return(0);
}

void print_help()
{
 cout << "syntax: scsi_info <device name>\n";
}


