/*++

(C) Copyright 2000-2005 Hewlett-Packard Development Company, L.P.

Module Name:

    CpqCiUlx.h

Abstract:

    This module contains the NT-dependent constructs for a usermode NT 
    application that uses the CpqCiSend/CpqCiRecv routines.  This
    module is also shared between the usermode application and kernel
    mode driver.

Environment:

    Kernel mode

Revision History:

--*/

#ifndef _CPQCIUxxh
#define _CPQCIUxxh

//
//  CPQCI to NT constant used for specifying an infinite wait.
//
#define CPQCIWAITFOREVER UINT_MAX

//
//  Driver object base name.
//
#define CPQCI_DEVICE_NAME  "CpqCiDrv"

#ifdef CPQCI_X86_64
typedef struct _CPQCIDRVHANDLEPARMS32 {
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    CPQCIPRIORITY   Priority;
    unsigned int    SendPackets;
    unsigned int    SendPacketSize;
    unsigned int    RecvPackets;
    unsigned int    RecvPacketSize;
    CPQCIBOOL       KeyPresent;
    u8_t	    Key[CPQCI_KEY_SIZE];
    u8_t	    Ccb[CPQCI_KEY_SIZE];
    CPQCISTATUS     Error;
    unsigned int    TimeOut;
    int             Oshandle;
} CPQCIDRVHANDLEPARMS32;
typedef struct _CPQCIDRVHANDLEPARMS {
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    CPQCIPRIORITY   Priority;
    CPQCIENTRIES    SendPackets;
    CPQCISIZE       SendPacketSize;
    CPQCIENTRIES    RecvPackets;
    CPQCISIZE       RecvPacketSize;
    CPQCIBOOL       KeyPresent;
    u8_t	    Key[CPQCI_KEY_SIZE];
    u8_t	    Ccb[CPQCI_KEY_SIZE];
    CPQCISTATUS     Error;
    CPQCITIMEOUT    TimeOut;
    int             Oshandle;
} CPQCIDRVHANDLEPARMS;
#else
typedef struct _CPQCIDRVHANDLEPARMS {
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    CPQCIPRIORITY   Priority;
    CPQCIENTRIES    SendPackets;
    CPQCISIZE       SendPacketSize;
    CPQCIENTRIES    RecvPackets;
    CPQCISIZE       RecvPacketSize;
    CPQCIBOOL       KeyPresent;
    u8_t	    Key[CPQCI_KEY_SIZE];
    u8_t	    Ccb[CPQCI_KEY_SIZE];
    CPQCISTATUS     Error;
    CPQCITIMEOUT    TimeOut;
    int             Oshandle;
} CPQCIDRVHANDLEPARMS;
#endif

//
//  Driver IO Control Functions.
//
#define CPQCI_MINOR	209
#define CPQCI_IOCTL_BASE 'C'

#define CPQCI_IOCTL_GET_INFO\
    _IOWR(CPQCI_IOCTL_BASE, 3, module_info_type)
#ifdef CPQCI_X86_64
#define CPQCI_IOCTL_REGISTER_WAITER\
    _IOWR(CPQCI_IOCTL_BASE, 2, unsigned int)

#define CPQCI_IOCTL_CREATE_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 0, CPQCIDRVHANDLEPARMS32)

#define CPQCI_IOCTL_OPEN_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 1, CPQCIDRVHANDLEPARMS32)

#define CPQCI_IOCTL_PHYSMEM_ALLOC\
    _IOWR(CPQCI_IOCTL_BASE, 4, struct _CPQCIDRVOSMEMHANDLE32)

#define CPQCI_IOCTL_PHYSMEM_FREE\
    _IOWR(CPQCI_IOCTL_BASE, 5, struct _CPQCIDRVOSMEMHANDLE32)
#else
#define CPQCI_IOCTL_REGISTER_WAITER\
    _IOWR(CPQCI_IOCTL_BASE, 2, unsigned long)

#define CPQCI_IOCTL_CREATE_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 0, CPQCIDRVHANDLEPARMS)

#define CPQCI_IOCTL_OPEN_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 1, CPQCIDRVHANDLEPARMS)

#define CPQCI_IOCTL_PHYSMEM_ALLOC\
    _IOWR(CPQCI_IOCTL_BASE, 4, struct _CPQCIDRVOSMEMHANDLE)

#define CPQCI_IOCTL_PHYSMEM_FREE\
    _IOWR(CPQCI_IOCTL_BASE, 5, struct _CPQCIDRVOSMEMHANDLE)
#endif

#if defined(LINUX)
#ifdef CPQCI_DEBUG
#define CpqCiPrintf(x, args...) if (CpqCiTestFlag & 0xff) fprintf(stdout, x, ##args)
#else
#define CpqCiPrintf(x, args...)
#endif
#elif defined(WIN32)
#ifdef CPQCI_DEBUG
#define CpqCiPrintf if (CpqCiTestFlag & 0xff) printf
#else
#define CpqCiPrintf //
#endif
#endif

#endif // _CPQCIUxxh
