summary     	: OpenIPMI +HP
name        	: hp-OpenIPMI
Version		:        7.7.0
Release		:        111.rhel4
group       	: System Environment/Kernel
source		: hp-OpenIPMI.tar.gz
copyright   	: 2006 Hewlett-Packard Development Company, L.P. 
packager    	: Hewlett-Packard Company
vendor		: Hewlett-Packard Company
url         	: http://www.hp.com/linux
buildroot   	: /var/tmp/%{name}
icon		: hprpm.xpm
autoreqprov	: no
prereq		: /bin/sh, /bin/bash

%description
This is an upgraded version of the Open IPMI device driver that is shipped as part of the standard Linux kernel. This release is for Linux 2.6 kernels. This provides support for PCI Based Base Management Controllers that are truly interrupt driven. This package will NOT activate on it's own.  The drivers for this release are place in the /opt/hp/hp-OpenIPMI/bin with a script that can be used to launch the IPMI drivers.  This has been done as the changes made to the IPMI drivers are expected to be included in future Linux kernels.

The hp-OpenIPMI driver can be built for any kernel like any other GPL Open Source application.  You need to load the appropriate kernel-devel (for Red Hat releases) package to do this.

%prep
%setup -n %{name}

%build
EFS_VER=%{version}\-%{release}
PKG_VER=%{version}\-CUSTOM
echo "$PKG_VER" > PKG_VERSION
make -f hp-OpenIPMI.mk OS_MODEL=LINUX EFS_VER="$EFS_VER" all

%pre

BUSY=`lsmod |fgrep ipmi_msghandler`
if [ ${#BUSY} -ne 0 ]; then
	echo "There is an existing IPMI driver already loading on this system:"
	echo " ---  ${BUSY}"
	echo "Please disable or remove ${BUSY} after loading "
	echo "this package to avoid potential conflicts."
	echo "NOTE:  Unloading current IPMI driver if possible."

	rmmod ipmi_si
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_si!"
		echo "Please remove the installed 'ipmi' modules and disable"
		echo "the initialization scripts."
		exit 1
	fi

	rmmod ipmi_devintf
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_devintf!"
		echo "Please remove the installed 'ipmi' modules and disable"
		echo "the initialization scripts."
		exit 1
	fi

	rmmod ipmi_msghandler
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_msghandler!"
		echo "Please remove the installed 'ipmi' modules and disable"
		echo "the initialization scripts."
		exit 1
	fi
fi


#
# We need to clean up from previously installed versions which
# did not delete all instances of the driver
#

#for OS_VER in `ls -d /lib/modules/*`; do
#done;



%install
if [ $RPM_BUILD_ROOT != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi

mkdir -p $RPM_BUILD_ROOT

export RPM_BUILD_ROOT
export RPM_MAKE_ROOT=.
export RPM_NAME=%{name}

make -f hp-OpenIPMI.mk install


%post
#Change file permissions
chmod go-rwx /opt/hp/hp-OpenIPMI
chmod go-rwx /opt/hp/hp-OpenIPMI/bin

ln -s /opt/hp/hp-OpenIPMI/hp-OpenIPMI.mk /opt/hp/hp-OpenIPMI/Makefile

sync
#
# Display EULA for Source Modules
#
echo "Please read the Licence Agreement for this software at"
echo
echo "         /opt/hp/hp-OpenIPMI/COPYING"
echo "                       and"
echo "         /opt/hp/hp-OpenIPMI/hp-OpenIPMI.license"
echo
echo "By not removing this package, you are accepting the terms"
echo "of the included licenses."
echo ""
echo "The man page, hp-OpenIPMI(4), describes how enable and use"
echo "the hp-OpenIPMI device drivers."


%preun
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ $1 -ne 0 ]; then
   echo "Upgrades are not permitted for the hp-OpenIPMI package."
   echo "Please remove the package using the command: rpm -e hp-OpenIPMI"
   exit 1
fi


BUSY=`lsmod |fgrep ipmi_msghandler`
if [ ${#BUSY} -ne 0 ]; then
	rmmod ipmi_si
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_si!"
		echo "Make sure all applications using the IPMI interface"
		echo "have been terminated before removing this package."
		exit 1
	fi
fi

BUSY=`lsmod |fgrep ipmi_devintf`
if [ ${#BUSY} -ne 0 ]; then
	rmmod ipmi_devintf
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_devintf!"
		echo "Make sure all applications using the IPMI interface"
		echo "have been terminated before removing this package."
		exit 1
	fi
fi

BUSY=`lsmod |fgrep ipmi_msghandler`
if [ ${#BUSY} -ne 0 ]; then
	rmmod ipmi_msghandler
	if [ $? != 0 ]; then
		echo "Unable to remove module ipmi_msghandler!"
		echo "Make sure all applications using the IPMI interface"
		echo "have been terminated before removing this package."
		exit 1
	fi
fi


%postun
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ $1 -ne 0 ]; then
   echo "Post hp-OpenIPMI package Upgrade. . ."
   echo "Upgrades are not permitted for the hp-OpenIPMI package."
   echo "Please remove the package using the command: rpm -e hp-OpenIPMI"
   exit 1
fi

rm -rf /opt/hp/hp-OpenIPMI
echo "The hp-OpenIPMI package has been removed from this system"
rm -f  /var/lock/subsys/hp-OpenIPMI
echo -e "\n"

%clean
rm -fR $RPM_BUILD_ROOT

%files 
%defattr(755,root,root)
/opt/hp/hp-OpenIPMI
%defattr(644,root,root)
/usr/share/man/man4/hp-OpenIPMI.4.gz

