#!/bin/sh
#
# This script attempts to find out if a patch has been installed on SunOS
# 4.1.3 systems that fixes Motif problems running in Open Windows (mouse won't
# work with menus and occasional Open Windows crashes).
#
# The patch number is 100444-66 which specifies bug number 1133986 for
# Motif menu problems and several others mentioning Open Windows crashes. 
#

#
# Determine where to look for xnews
#

if [ -n "$OPENWINHOME" ]; then
	myopenwinhome=$OPENWINHOME
else
	myopenwinhome=/usr/openwin
fi 

#
# Check to see if the xnews executable has been patched
#

if [ -f $myopenwinhome/bin/xnews ]; then
	patch=`/usr/ucb/strings $myopenwinhome/bin/xnews | grep "Patch #3000-114"`
	#echo $patch
	if [ -n "$patch" ]; then
		#echo "Patch is installed"
		foundstatus=0
	else
		#echo "Patch is not installed"
		foundstatus=1	
	fi
else
	#echo "xnews not found in standard location"
	foundstatus=1	
fi

#
# Uncomment the following line if you want the script to always return true.
# This would be the case if you run Motif Window Manager (not Open Windows)
# and xnews has not been patched.
#
#foundstatus=0

#
# Return to the caller
#

exit $foundstatus
