#! /bin/sh
#	install.sh
#	Copyright (c) 1999, by Powerware (R) Corporation. All rights reserved.
#	A shell script which installs LanSafe III for Unix
#	It extracts the data from the media and copies it to /usr/ls3,
#	edits /etc/services, /etc/inittab and a few other things.
#	At the end it runs install.ls3
:
PATH=$PATH:/bin:/usr/bin:/usr/ucb:.; export PATH

compute_files () {
cat <<EOF
ls3.email
ls3.broadcast
ls3.shutdown
ls3.unload
ls3.sh
ls3icon
ls3conX.ico
hoh.hlp
ls3conX.hlp
ls3mon.hlp
manualu.hlp
manualu.rtf
install.mfg
install.ups
upslist.ups
alert.def
abmdchrg.bmp
abmchrg.bmp
abmfloat.bmp
abmrest.bmp
aboost.bmp
abuck.bmp
abypass.bmp
acharger.bmp
aifilter.bmp
ainvert.bmp
aofilter.bmp
arectify.bmp
chrg.bmp
dchrg.bmp
digit0.bmp
digit1.bmp
digit2.bmp
digit3.bmp
digit4.bmp
digit5.bmp
digit6.bmp
digit7.bmp
digit8.bmp
digit9.bmp
digitP.bmp
float.bmp
ibattery.bmp
iboost.bmp
ibuck.bmp
ibypass.bmp
icharger.bmp
iifilter.bmp
iinvert.bmp
inpict.bmp
iofilter.bmp
irectify.bmp
load.bmp
outpict.bmp
phase1.bmp
phase2.bmp
phase3.bmp
runtime.bmp
volts.bmp
ups.bmp
comp.bmp
segment.bmp
ok.bmp
okm.bmp
not_ok.bmp
not_okm.bmp
install.ls3
Ls3s
Ls3c
Ls3m
ls3X
ls3conX
ls3con
ls3help
EOF

if [ $system = "sco" ]; then
	cat <<EOF
s1.objscr
picture.px
Ls3.node
EOF
fi

if [ $system = "sunos" ]; then
	cat <<EOF
XKeysymDB
chk4patch.sh
EOF
fi

if [ "$system" = "linux" ]; then
	cat <<EOF
ls3conX.sco
README.TXT
EOF
fi
}

Convert_Case () {
	if [ -n "$uppercase_mount" ]; then
		echo `Convert_UpperCase $1`
	else
		echo `Convert_LowerCase $1`
	fi
}

Convert_UpperCase () {
	case $1 in
	ls3.email)
		echo LS3.EMA
		;;
	ls3.broadcast)
		echo LS3.BRO
		;;
	ls3.shutdown)
		echo LS3.SHU
		;;
	ls3.unload)
		echo LS3.UNL
		;;
	ls3.sh)
		echo LS3.SH
		;;
	ls3icon)
		echo LS3ICON
		;;
	ls3conX.ico)
		echo LS3CONX.ICO
		;;
	hoh.hlp)
		echo HOH.HLP
		;;
	ls3conX.hlp)
		echo LS3CONX.HLP
		;;
	ls3mon.hlp)
		echo LS3MON.HLP
		;;
	manualu.hlp)
		echo MANUALU.HLP
		;;
	manualu.rtf)
		echo MANUALU.RTF
		;;
	install.mfg)
		echo INSTALL.MFG
		;;
	install.ups)
		echo INSTALL.UPS
		;;
	upslist.ups)
		echo UPSLIST.UPS
		;;
	alert.def)
		echo ALERT.DEF
		;;
	abmdchrg.bmp)
		echo ABMDCHRG.BMP
		;;
	abmchrg.bmp)
		echo ABMCHRG.BMP
		;;
	abmfloat.bmp)
		echo ABMFLOAT.BMP
		;;
	abmrest.bmp)
		echo ABMREST.BMP
		;;
	aboost.bmp)
		echo ABOOST.BMP
		;;
	abuck.bmp)
		echo ABUCK.BMP
		;;
	abypass.bmp)
		echo ABYPASS.BMP
		;;
	acharger.bmp)
		echo ACHARGER.BMP
		;;
	aifilter.bmp)
		echo AIFILTER.BMP
		;;
	ainvert.bmp)
		echo AINVERT.BMP
		;;
	aofilter.bmp)
		echo AOFILTER.BMP
		;;
	arectify.bmp)
		echo ARECTIFY.BMP
		;;
	chrg.bmp)
		echo CHRG.BMP
		;;
	dchrg.bmp)
		echo DCHRG.BMP
		;;
	digit0.bmp)
		echo DIGIT0.BMP
		;;
	digit1.bmp)
		echo DIGIT1.BMP
		;;
	digit2.bmp)
		echo DIGIT2.BMP
		;;
	digit3.bmp)
		echo DIGIT3.BMP
		;;
	digit4.bmp)
		echo DIGIT4.BMP
		;;
	digit5.bmp)
		echo DIGIT5.BMP
		;;
	digit6.bmp)
		echo DIGIT6.BMP
		;;
	digit7.bmp)
		echo DIGIT7.BMP
		;;
	digit8.bmp)
		echo DIGIT8.BMP
		;;
	digit9.bmp)
		echo DIGIT9.BMP
		;;
	digitP.bmp)
		echo DIGITP.BMP
		;;
	float.bmp)
		echo FLOAT.BMP
		;;
	ibattery.bmp)
		echo IBATTERY.BMP
		;;
	iboost.bmp)
		echo IBOOST.BMP
		;;
	ibuck.bmp)
		echo IBUCK.BMP
		;;
	ibypass.bmp)
		echo IBYPASS.BMP
		;;
	icharger.bmp)
		echo ICHARGER.BMP
		;;
	iifilter.bmp)
		echo IIFILTER.BMP
		;;
	iinvert.bmp)
		echo IINVERT.BMP
		;;
	inpict.bmp)
		echo INPICT.BMP
		;;
	iofilter.bmp)
		echo IOFILTER.BMP
		;;
	irectify.bmp)
		echo IRECTIFY.BMP
		;;
	load.bmp)
		echo LOAD.BMP
		;;
	outpict.bmp)
		echo OUTPICT.BMP
		;;
	phase1.bmp)
		echo PHASE1.BMP
		;;
	phase2.bmp)
		echo PHASE2.BMP
		;;
	phase3.bmp)
		echo PHASE3.BMP
		;;
	runtime.bmp)
		echo RUNTIME.BMP
		;;
	volts.bmp)
		echo VOLTS.BMP
		;;
	ups.bmp)
		echo UPS.BMP
		;;
	comp.bmp)
		echo COMP.BMP
		;;
	segment.bmp)
		echo SEGMENT.BMP
		;;
	ok.bmp)
		echo OK.BMP
		;;
	okm.bmp)
		echo OKM.BMP
		;;
	not_ok.bmp)
		echo NOT_OK.BMP
		;;
	not_okm.bmp)
		echo NOT_OKM.BMP
		;;
	install.ls3)
		echo INSTALL.LS3
		;;
	Ls3s)
		echo LS3S
		;;
	Ls3c)
		echo LS3C
		;;
	Ls3m)
		echo LS3M
		;;
	ls3X)
		echo LS3X
		;;
	ls3conX)
		echo LS3CONX
		;;
	ls3con)
		echo LS3CON
		;;
	ls3help)
		echo LS3HELP
		;;
	s1.objscr)
		echo S1.OBJ
		;;
	picture.px)
		echo PICTURE.PX
		;;
	Ls3.node)
		echo LS3.NOD
		;;
	XKeysymDB)
		echo XKEYSYMD
		;;
	chk4patch.sh)
		echo CHK4PATC.SH
		;;
	ls3conX.sco)
		echo LS3CONX.SCO
		;;
	readme.txt|README.TXT)
		echo README.TXT
		;;
	*)
		echo UNKNOWN
		;;
	esac
}

Convert_LowerCase () {
	case $1 in
	ls3.email)
		echo ls3.ema
		;;
	ls3.broadcast)
		echo ls3.bro
		;;
	ls3.shutdown)
		echo ls3.shu
		;;
	ls3.unload)
		echo ls3.unl
		;;
	ls3.sh)
		echo ls3.sh
		;;
	ls3icon)
		echo ls3icon
		;;
	ls3conX.ico)
		echo ls3conx.ico
		;;
	hoh.hlp)
		echo hoh.hlp
		;;
	ls3conX.hlp)
		echo ls3conx.hlp
		;;
	ls3mon.hlp)
		echo ls3mon.hlp
		;;
	manualu.hlp)
		echo manualu.hlp
		;;
	manualu.rtf)
		echo manualu.rtf
		;;
	install.mfg)
		echo install.mfg
		;;
	install.ups)
		echo install.ups
		;;
	upslist.ups)
		echo upslist.ups
		;;
	alert.def)
		echo alert.def
		;;
	abmdchrg.bmp)
		echo abmdchrg.bmp
		;;
	abmchrg.bmp)
		echo abmchrg.bmp
		;;
	abmfloat.bmp)
		echo abmfloat.bmp
		;;
	abmrest.bmp)
		echo abmrest.bmp
		;;
	aboost.bmp)
		echo aboost.bmp
		;;
	abuck.bmp)
		echo abuck.bmp
		;;
	abypass.bmp)
		echo abypass.bmp
		;;
	acharger.bmp)
		echo acharger.bmp
		;;
	aifilter.bmp)
		echo aifilter.bmp
		;;
	ainvert.bmp)
		echo ainvert.bmp
		;;
	aofilter.bmp)
		echo aofilter.bmp
		;;
	arectify.bmp)
		echo arectify.bmp
		;;
	chrg.bmp)
		echo chrg.bmp
		;;
	dchrg.bmp)
		echo dchrg.bmp
		;;
	digit0.bmp)
		echo digit0.bmp
		;;
	digit1.bmp)
		echo digit1.bmp
		;;
	digit2.bmp)
		echo digit2.bmp
		;;
	digit3.bmp)
		echo digit3.bmp
		;;
	digit4.bmp)
		echo digit4.bmp
		;;
	digit5.bmp)
		echo digit5.bmp
		;;
	digit6.bmp)
		echo digit6.bmp
		;;
	digit7.bmp)
		echo digit7.bmp
		;;
	digit8.bmp)
		echo digit8.bmp
		;;
	digit9.bmp)
		echo digit9.bmp
		;;
	digitP.bmp)
		echo digitp.bmp
		;;
	float.bmp)
		echo float.bmp
		;;
	ibattery.bmp)
		echo ibattery.bmp
		;;
	iboost.bmp)
		echo iboost.bmp
		;;
	ibuck.bmp)
		echo ibuck.bmp
		;;
	ibypass.bmp)
		echo ibypass.bmp
		;;
	icharger.bmp)
		echo icharger.bmp
		;;
	iifilter.bmp)
		echo iifilter.bmp
		;;
	iinvert.bmp)
		echo iinvert.bmp
		;;
	inpict.bmp)
		echo inpict.bmp
		;;
	iofilter.bmp)
		echo iofilter.bmp
		;;
	irectify.bmp)
		echo irectify.bmp
		;;
	load.bmp)
		echo load.bmp
		;;
	outpict.bmp)
		echo outpict.bmp
		;;
	phase1.bmp)
		echo phase1.bmp
		;;
	phase2.bmp)
		echo phase2.bmp
		;;
	phase3.bmp)
		echo phase3.bmp
		;;
	runtime.bmp)
		echo runtime.bmp
		;;
	volts.bmp)
		echo volts.bmp
		;;
	ups.bmp)
		echo ups.bmp
		;;
	comp.bmp)
		echo comp.bmp
		;;
	segment.bmp)
		echo segment.bmp
		;;
	ok.bmp)
		echo ok.bmp
		;;
	okm.bmp)
		echo okm.bmp
		;;
	not_ok.bmp)
		echo not_ok.bmp
		;;
	not_okm.bmp)
		echo not_okm.bmp
		;;
	install.ls3)
		echo install.ls3
		;;
	Ls3s)
		echo ls3s
		;;
	Ls3c)
		echo ls3c
		;;
	Ls3m)
		echo ls3m
		;;
	ls3X)
		echo ls3x
		;;
	ls3conX)
		echo ls3conx
		;;
	ls3con)
		echo ls3con
		;;
	ls3help)
		echo ls3help
		;;
	s1.objscr)
		echo s1.obj
		;;
	picture.px)
		echo picture.px
		;;
	Ls3.node)
		echo ls3.nod
		;;
	XKeysymDB)
		echo xkeysymd
		;;
	chk4patch.sh)
		echo chk4patch.sh
		;;
	ls3conX.sco)
		echo ls3conx.sco
		;;
	readme.txt|README.TXT)
		echo readme.txt
		;;
	*)
		echo UNKNOWN
		;;
	esac
}

compute_echo () {
	if [ `echo "\c" | wc -l` = 1 ]; then
		echo true
	else
		echo ""
	fi
}

compute_sco_system () {
	set `uname -a`
	case $1 in
	SCO_SV)
		echo sco5
		;;
	*)
		echo sco3
		;;
	esac
}

fixup_linux_system () {
	stty ocrnl onocr onlret echonl inlcr echok echoe erase 

	if [ -d /usr/lib/terminfo ]; then
		ln -s /usr/lib/terminfo /usr/share/terminfo
	elif [ -d /usr/share/terminfo ]; then
		ln -s /usr/share/terminfo /usr/lib/terminfo
	else
		echo "No terminfo files in either /usr/share/ or /usr/lib/"
	fi
}

compute_dgux_system () {
	set `uname -a`
	case $3 in
	R4.20|R4.1*|R4.0*)
		echo "You need to have at least DG/UX release 4.20MU01. Can't continue LanSafe installation."
		exit 1
		;;
	*)
		;;
	esac
}

compute_SYSTEM () {
	set `uname -a`
	case $1 in
	Linux)
		SYSTEM=LINUX
		;;
	SunOS)
		case $3 in
		5.*)
			case $5 in
			i86pc)
				SYSTEM=SOLINT
				;;
			*)
				SYSTEM=SOLARI
				;;
			esac
		;;
		*)
			SYSTEM=SUNOS
			;;
		esac
		;;
	HP-UX)
		SYSTEM=HPUX
		;;
	OSF1)
		SYSTEM=DEC
		;;
	dgux)
		SYSTEM=DGUX
		;;
	SCO_SV)
		SYSTEM=SCO
		;;
	UnixWare)
		SYSTEM=UW2
		;;
	UNIX_SV)
		if [ -f /etc/issue ]; then
			grep "UnixWare" /etc/issue >/dev/null 2>/dev/null
			if [ $? != 1 ]; then
				SYSTEM=UW2
			else
				SYSTEM=SVR4
			fi
		else
			SYSTEM=SVR4
		fi
		;;
	AIX)
		case $4 in
		3)
			SYSTEM=AIX3
			;;
		4)
			SYSTEM=AIX4
			;;
		esac
		;;
	*)
		if [ -c /dev/tty1A ]; then
			SYSTEM=SCO
		elif [ -c /dev/ttyd0 -a "$1" != "Linux" ]; then
			SYSTEM=IA
		elif [ -c /dev/ttypa -a "$1" != "Linux" ]; then
			SYSTEM=IA
		else
			SYSTEM="Unknown System"
		fi
		;;
	esac
}

compute_system () {
	case $SYSTEM in
	LINUX)
		system=linux
		;;
	SOLINT)
		system=solint
		;;
	SOLARI)
		system=solari
		;;
	SUNOS)
		system=sunos
		;;
	HPUX)
		system=hpux
		;;
	DEC)
		system=dec
		;;
	DGUX)
		system=dgux
		;;
	SCO)
		system=sco
		;;
	UW2)
		system=uw2
		;;
	SVR4)
		system=svr4
		;;
	AIX3)
		system=aix3
		;;
	AIX4)
		system=aix4
		;;
	IA)
		system=ia
		;;
	"Unknown System")
		system="Unknown System"
		;;
	*)
		echo
		echo Unknown System \"$SYSTEM\". LanSafe III installation can not continue.
		echo Please specify your system like, "\"./install.sh <SYSTEM>\""
		echo Vaild systems are LINUX SOLINT SOLARI SUNOS HPUX DEC DGUX SCO UW2 SVR4 AIX3 AIX4 IA
		echo
		exit
		;;
	esac
}

compute_disks () {
	case $system in
	linux)
		echo 1 2 3 4 5
		;;
	sco|dgux)
		echo 1 2 3 4
		;;
	ia)
		echo 1 2 3
		;;
	sunos)
		echo 1 2 3 4
		;;
	hpux)
		echo 1 2 3
		;;
	solari)
		echo 1 2 3 4
		;;
	solint)
		echo 1 2 3
		;;
	dec)
		echo 1 2 3 4
		;;
	uw2)
		echo 1 2
		;;
	aix3)
		echo 1 2
		;;
	aix4)
		echo 1 2
		;;
	svr4)
		echo 1 2 3
		;;
	esac
}

compute_tapedirs () {
	for disk in `compute_disks`; do
		case $disk in
		1)
			if [ -n "$cdrom_install" ]; then
				if [ -n "$uppercase_mount" ]; then
					echo_n 1_INSTAL " "
				else
					echo_n 1_instal " "
				fi
			else
				echo_n 1_install " "
			fi
			;;
		*)
			if [ -n "$uppercase_mount" ]; then
				echo_n ${disk}_$SYSTEM " "
			else
				echo_n ${disk}_$system " "
			fi
			;;
		esac
	done
	echo
}

compute_topath () {
	case $1 in
	*.afm|typeface.map)
		echo /usr/lib/Xp/FontMetrics/AFM
		;;
	*.fonts)
		echo /usr/lib/Xp
		;;
	hoh.hlp)
		echo /usr/lib/hyperhelp
		;;
	HyperHelp)
		echo /usr/lib/X11/app-defaults
		;;
	picture.px| s1.objscr)
		echo /usr/lib/X11/XDesktop3/applications/Ls3.obj
		;;
	Ls3.node)
		echo /etc/conf/node.d
		;;
	XKeysymDB)
		echo /usr/lib/X11
		;;
	*)
		echo $instpath
		;;
	esac
}

compute_toperm () {
	case $1 in
	install.ls3 |\
	chk4patch.sh |\
	ls3X |\
	ls3conX |\
	ls3help |\
	ls3con)
		echo 0755
		;;
	Ls3s |\
	Ls3m |\
	Ls3c |\
	ls3.init | \
	ls3.email | \
	ls3.broadcast | \
	ls3.shutdown | \
	ls3.unload | \
	ls3.sh)
		echo 0744
		;;
	alert.cfg | \
	alert.def)
		echo 0600
		;;
	*)
		echo 0444
		;;
	esac
}

compute_uncompress () {
	for subdir in `compute_tapedirs`; do
		if [ -f $subdir/gunzip ]; then
			echo $subdir/gunzip
			return
		fi
	done
	if [ -f gunzip ]; then
		echo gunzip
	fi
	echo uncompress
}

echo_n () {
	if [ $bsdecho ]; then
		echo -n "$*"
	else
		echo "$*\c"
	fi
}

create_path() {
	fullpath=""
	for path in `echo $1 | sed 's/\// /g'`; do
		fullpath=$fullpath/$path
		if [ ! -d $fullpath ]; then
			mkdir $fullpath
			if [ $? != 0 ]; then
				return 1
			fi
			chmod 755 $fullpath

			if [ "$system" = sunos -o "$SYSTEM" = SUNOS ]; then
				/usr/etc/chown bin $fullpath
			else
				chown bin $fullpath
			fi

			chgrp bin $fullpath
			if [ $? != 0 ]; then
				return 1
			fi
		fi
	done
	if [ -d $1 ]; then
		return 0
	fi
	return 1
}

check_fatal () {
	if [ $? != 0 ]; then
		if [ $override ]; then
			echo "Install failed. Override set."
			return 0
		fi
		echo "Install failed. Exiting"
		exit 1
	fi
}

check_status () {
	if [ $? != 0 ]; then
		if [ $override ]; then
			echo "Check status failed. Override set."
			return 0
		fi
		return 1
	fi
	return 0
}

untar_to () {
	name=$1
	dst=$2
	perm=$3
	prefix=.
	for subdir in `compute_tapedirs`; do
		if [ -f $subdir/$name ]; then
			prefix=$subdir
		fi

		if [ -f $subdir/$name.z ]; then
			prefix=$subdir
		fi

		if [ -f $subdir/$name.Z ]; then
			prefix=$subdir
		fi
	done
	src=$prefix/$name

	create_path $dst
	check_fatal

	if [ ! -f $src ]; then
		if [ -f $src.z ]; then
			$uncompress_cmd $src.z
			check_fatal
		fi
		if [ -f $src.Z ]; then
			$uncompress_cmd $src.Z
			check_fatal
		fi
	fi

	if [ -f $dst/$name ]; then
		mv -f $dst/$name $dst/$name~ > /dev/null 2>&1
	fi

	mv -f $src $dst >/dev/null 2>&1
	if [ $? != 0 ]; then
		cp $src $dst
	check_fatal
	rm -f $src
	fi

	chmod $perm $dst/$name
	(cd $dst; tar -xvf $name |
	awk '{ print "Installing " $2 " to '$dst' ... done" }' |
	sed 's/, / /' ) 2>/dev/null
	check_fatal
	for f in `(cd $dst; tar -tf $name 2>/dev/null)`; do
		echo "Installed: $dst/$f" >> $instpath/installed
		chmod $perm $dst/$f
		check_fatal

		if [ "$system" = sunos -o "$SYSTEM" = SUNOS ]; then
			/usr/etc/chown bin $dst/$f
		else
			chown bin $dst/$f
		fi

	chown bin $dst/$f
	chgrp bin $dst/$f
	done
	rm -f $dst/$name
}

install_to () {
	name=$1
	dst=$2
	perm=$3
	prefix=.
	lc_name=$name
	if [ -n "$cdrom_install" ]; then
		name=`Convert_Case $name`
	fi

	echo_n "Installing $lc_name to $dst ... "
	for subdir in `compute_tapedirs`; do
		if [ -f $subdir/$name ]; then
			prefix=$subdir
		fi

		if [ -f $subdir/$name.z ]; then
			prefix=$subdir
		fi

		if [ -f $subdir/$name.Z ]; then
			prefix=$subdir
		fi
	done
	src=$prefix/$name

	create_path $dst
	check_fatal

	if [ ! -f $src ]; then
		if [ -f $src.z ]; then
			$uncompress_cmd $src.z
			check_fatal
		fi
		if [ -f $src.Z ]; then
			if [ -n "$cdrom_install" ]; then
				cp $src.Z /tmp/$name.Z
				$uncompress_cmd /tmp/$name.Z
				src=/tmp/$name
			else
				$uncompress_cmd $src.Z
			fi
			check_fatal
		fi
	fi

	rm -f $dst/$lc_name
	if [ -f $dst/$lc_name ]; then
		mv -f $dst/$lc_name $dst/$lc_name~ > /dev/null 2>&1
	fi

	if [ -n "$cdrom_install" ]; then
		cp $src $dst/$lc_name
		check_fatal
	else
		mv -f $src $dst/$lc_name >/dev/null 2>&1

		if [ $? != "0" ]; then
			cp $src $dst/$lc_name
			check_fatal
			rm -f $src
		fi
	fi

	chmod $perm $dst/$lc_name
	check_fatal

	if [ "$system" = sunos -o "$SYSTEM" = SUNOS ]; then
		/usr/etc/chown bin $dst/$lc_name
	else
		chown bin $dst/$lc_name
	fi

	chgrp bin $dst/$lc_name
	echo "Installed: $dst/$lc_name" >> $instpath/installed
	echo "done"
}

read_one () {
	prompt=$1
	default=$2

	echo_n "$prompt"
	stty -icanon min 1
	answer=`/bin/dd count=1 2>/dev/null`
	stty icanon
	echo
}

read_def () {
	prompt=$1
	default=$2

	echo_n "$prompt"
	read answer
	if [ -z "$answer" ]; then
		answer=$default
	fi
}

install_files () {
	echo
	rm -f $instpath/installed
	uncompress_cmd=`compute_uncompress`
	for f in `compute_files`; do
		if [ ! -z "$skip_install" ]; then
			break
		fi

		topath=`compute_topath $f`
		toperm=`compute_toperm $f`
		case $f in
		*.tar)
			untar_to $f $topath $toperm
			;;
		ls3.load)
			install_to $f $topath $toperm
			mv -f $topath/$f $topath/$$
			sed '
/\/usr\/ls3/c\
instpath='$topath'
' $topath/$$ > $topath/$f
			rm -f $topath/$$
			chmod $toperm $topath/$f
			check_fatal
			;;
		*)
			install_to $f $topath $toperm
			;;
		esac
	done
	cp $instpath/install.mfg $instpath/ls3X.mfg
	cp $instpath/install.mfg $instpath/ls3conX.mfg
	cp $instpath/install.mfg $instpath/ls3con.mfg
	cp $instpath/alert.def $instpath/alert.cfg
}

get_tardev () {
	tardev=""
	while [ -z "$tardev" ]; do
	echo
	echo "Please enter the name of the device (or tarfile) to install from."
	read_def " Install device: "
	if [ -z "$answer" ]; then
		continue
	fi

	if [ '(' -c "$answer" ')' -o '(' -b "$answer" ')' ]; then
		tardev=$answer
	elif [ -d $answer ]; then
		echo "'$answer' is a invalid because it is a directory?"
		elif [ -f $answer ]; then
			echo "Expecting a device name, but '$answer' is a file?"
			tardev=$answer
			read_def " Is this okay? (y/n) [n] " "n"
			case $answer in
			[yY]|[yY][eE][sS])
				tar_install=true
				;;
			*)
				tardev=""
				;;
			esac
		else
			echo "'$answer' does not exist or is not a device?"
			if [ $override ]; then
				echo "Override set, using '$answer'."
				tardev=$answer
			else
				continue
			fi
		fi
	done
}

maybe_eject () {
	case $system in
	sunos| solari | solint)
		echo "Ejecting disk ..."
		eject $tardev > /dev/null 2>&1
		;;
	esac
}

extract_files () {
	firsttime=true
	while [ -z "$tardev" -o ! -z "$firsttime" ]; do
	# Prompt for different device name only if extract below fails i.e firsttime=""
	if [ -z "$firsttime" ]; then
		get_tardev
	fi

	firsttime=""
	case $tardev in
	*f0*|*f1*|*fd*|*floppy*|*dsk*)
		media=disk
		# For each disk
		for disk in `compute_disks`; do
			if [ $disk != "1" ]; then
				maybe_eject
				if [ "$system" = "ia" ]; then
					LongName="Interactive"
				else
					LongName="$system"
				fi
				echo
				echo_n "Insert $LongName disk #"$disk "... press Enter when ready. "
				read x
			fi

			echo "Extracting files ..."
			if [ $disk != 1 ]; then
				tar -xf $tardev ${disk}_$system > /dev/null 2>&1
			else
				tar -xf $tardev 1_install > /dev/null 2>&1
			fi

			check_status
			if [ $? != 0 ]; then
				echo "Error extracting files?"
				tardev=
				continue 2
			fi
		done
		maybe_eject
		;;
	*st*|*mt*|*)
		media=tape
		echo
		echo "Extracting files ..."
		tar -xf $tardev `compute_tapedirs` > /dev/null 2>&1
		check_status
		if [ $? != 0 ]; then
			echo "Error extracting files?"
			tardev=
			continue
		fi
		;;
	esac
	done
	# end-of extract_files
}

install_upsdrv() {
	echo "A special Device Driver is needed to allow the LanSafe III"
	echo "daemon to communicate with your model"
	echo "This device driver will be installed next."
	echo ""

	if [ ! -d /tmp/ups_drv ]; then
		mkdir /tmp/ups_drv
	fi

	if [ -n "$cdrom_install" ]; then
		if [ -n "$uppercase_mount" ]; then
			cp 2_$SYSTEM/UPS_DRV/DRIVER.O	/tmp/ups_drv/Driver.o
			cp 2_$SYSTEM/UPS_DRV/FILES		/tmp/ups_drv/Files
			cp 2_$SYSTEM/UPS_DRV/INSTALL	/tmp/ups_drv/Install
			cp 2_$SYSTEM/UPS_DRV/MASTER		/tmp/ups_drv/Master
			cp 2_$SYSTEM/UPS_DRV/NAME		/tmp/ups_drv/Name
			cp 2_$SYSTEM/UPS_DRV/NODE		/tmp/ups_drv/Node
			cp 2_$SYSTEM/UPS_DRV/REMOVE		/tmp/ups_drv/Remove
			cp 2_$SYSTEM/UPS_DRV/SIZE		/tmp/ups_drv/Size
			cp 2_$SYSTEM/UPS_DRV/SPACE.C	/tmp/ups_drv/Space.c
			cp 2_$SYSTEM/UPS_DRV/SYSTEM		/tmp/ups_drv/System
			cp 2_$SYSTEM/UPS_DRV/MKDISK		/tmp/ups_drv/mkdisk
			cp 2_$SYSTEM/UPS_DRV/UPS.H		/tmp/ups_drv/ups.h
			if [ $SYSTEM = "SCO" ]; then
				cp 2_$SYSTEM/UPS_DRV/UPS.H	/tmp/ups_drv/upstmp
			fi
		else
			cp 2_$system/ups_drv/driver.o	/tmp/ups_drv/Driver.o
			cp 2_$system/ups_drv/files		/tmp/ups_drv/Files
			cp 2_$system/ups_drv/install	/tmp/ups_drv/Install
			cp 2_$system/ups_drv/master		/tmp/ups_drv/Master
			cp 2_$system/ups_drv/name		/tmp/ups_drv/Name
			cp 2_$system/ups_drv/node		/tmp/ups_drv/Node
			cp 2_$system/ups_drv/remove		/tmp/ups_drv/Remove
			cp 2_$system/ups_drv/size		/tmp/ups_drv/Size
			cp 2_$system/ups_drv/space.c	/tmp/ups_drv/Space.c
			cp 2_$system/ups_drv/system		/tmp/ups_drv/System
			cp 2_$system/ups_drv/mkdist		/tmp/ups_drv/mkdisk
			cp 2_$system/ups_drv/ups.h		/tmp/ups_drv/ups.h
			if [ $SYSTEM = "SCO" ]; then
				cp 2_$system/ups_drv/ups.h	/tmp/ups_drv/upstmp
			fi
		fi
	else
		mv 2_$system/ups_drv/* /tmp/ups_drv
	fi

	if [ $system = "uw1" -o $system = "uw2" ]; then
		echo "LanSafe III: Warning"
		echo "The asyc device driver controlling the serial port must be disabled."
		echo "Please edit the /etc/conf/cf.d/sdevice and /etc/conf/sdevice.d/asyc files to"
		echo "disable the asyc driver on the UPS port. In both files locate the line"
		echo "specifying that the asyc driver should manage that serial port and"
		echo "change the Y to an N to disable the asyc driver. To disable the ups device driver"
		echo "from a port edit the /etc/conf/cf.d/sdevice and /etc/conf/sdevice.d/ups files."
		echo "You must make these changes before installing the ups device driver."
	fi

	if [ $system = "ia" ]; then
		echo "LanSafe III: Warning"
		echo "The asy device driver controlling the serial port must be disabled."
		echo "Edit the /etc/conf/cf.d/sdevice and /etc/conf/sdevice.d/asy files to"
		echo "disable the asy driver on the UPS port. In both files locate the line"
		echo "specifying that the asyc driver should manage that serial port and"
		echo "change the Y to an N to disable the asy driver. To disable the ups device driver"
		echo "from a port edit the /etc/conf/cf.d/sdevice and /etc/conf/sdevice.d/ups files."
		echo "You must make these changes before installing the ups device driver."
	fi

	echo ""
	echo "During the driver installation your kernel will be rebuilt to"
	echo "include this device driver. When the installation is completed"
	echo "you must reboot your computer to install this new kernel."
	echo ""

	read_def " Install the device driver? (y/n) [y] " "y"
	case $answer in
		[yY]|[yY][eE][sS])
			orig_dir=$PWD
			cd /tmp/ups_drv
			./Install
			cd $orig_dir
			;;
		*)
			echo "The UPS Driver MUST be built into the kernel for LanSafe III to work"
			echo "The files for the driver has been copied to /tmp/ups_drv"
			echo "To install the driver into the kernel login in as root and type:"
			echo "cd /tmp/ups_drv"
			echo "./Install"
			;;
	esac
}

kill_ls3() {
	pidargs=-ax			# BSD sunos
	ps -ax > /dev/null 2>&1
	if [ $? != "0" ]; then
		pidargs=-e		# svr3 svr4
	fi
	pids=`ps $pidargs | awk '/ls3/ { print $1 }'`
	kill -9 $pids > /dev/null 2>&1
}

install_ptf122() {
	echo "A Patch is needed on UnixWare 1.1 to allow the LanSafe III"
	echo "daemon to communicate with the Dry Contact UPS."
	echo "This patch will be installed next."
	echo ""
	echo ""
	echo "During the patch installation your kernel will be rebuilt to"
	echo "include this patch. When the installation is completed"
	echo "you must reboot your computer to install a new kernel."
	echo ""
	mv 3_unixware/ptf122.tar /tmp/ptf122.tar
	cd /tmp
	tar xvf ptf122.tar
	read_def " Install the patch? (y/n) [y] " "y"
	case $answer in
	[yY]|[yY][eE][sS])
		pkgadd -d /tmp/ptf122 ptf122
		;;
	*)
		echo "The ptf122 patch MUST be built into the kernel for LanSafe III to work"
		echo "The files for the driver has been copied to /tmp"
		echo "To install the driver into the kernel, login as root and type:"
		echo "pkgadd -d /tmp/ptf122 ptf122"
		;;
	esac
}

streamsmsg() {
	echo
	echo "STREAMS must be installed in the kernel."
	case $system in
	sco)
		echo "Run 'mkdev streams' to install STREAMS into the kernel."
		;;
	ia)
		echo "Run 'kconfig' and add the STREAMS feature to the kernel."
		;;
	*)
		echo "Configure STREAMS into the kernel."
		;;
	esac
	echo
}

chk4sp() {
	CONF=/etc/conf
	CONFBIN=$CONF/bin
	NODEFILE=$CONF/node.d/Ls3.node

	case $system in
	sco)
		if [ -c /dev/socksys -a -f /etc/services ]; then
			return 0;	# looks like they have tcp skip sp check
		fi
		;;
	ia| uw1| uw2)
		if [ -c /dev/tcp -a -c /dev/udp -a -f /etc/services ]; then
			return 0;	# looks like they have tcp skip sp check
		fi
		;;
	*)
		return 0;	# non error
		;;
	esac

	# must have clone
	$CONFBIN/idcheck -p clone || $CONFBIN/idcheck -y clone
	if [ $? = 0 ]; then
		echo "Module clone is missing from the kernel."
		streamsmsg
		return 1	# error
	fi

	# must have sp
	$CONFBIN/idcheck -p sp || $CONFBIN/idcheck -y sp
	if [ $? = 0 ]; then
		echo "Module sp is missing from the kernel."
		streamsmsg
		return 1	# error
	fi

	if [ $system = "sco" ]; then
		# must have str
		$CONFBIN/idcheck -p str || $CONFBIN/idcheck -y str
		if [ $? = 0 ]; then
			echo "Module str is missing from the kernel."
			streamsmsg
			return 1	# error
		fi
	fi

	if [ ! -c /dev/spx ]; then
		echo "All neccessary STREAMS modules are configured in the kernel."
		echo "But, the node /dev/spx is missing from device directory."
		if [ -f $NODEFILE ]; then
			echo
			echo "Now that $NODEFILE has been installed,"
			echo "rebuild kernel with $CONFBIN/idbuild, reboot and reinstall."
			echo
		else
			echo
		fi
		return 1;
	fi
	return 0;
}

setup_services () {
	# Need to do more for yp servers.
	services=/etc/services

	# Check for existence of services
	if [ ! -f $services ]; then
		echo
		echo "The file $services does not exist."
		echo "Skipping modifications to $services."
		echo
		return;
	fi

	# Find an appropriate port for the LanSafe III service
	port=`sed -e 's/#.*//' $services | awk '
	NF>0 {
	l = length($2);
	if ($2 ~ /\/tcp$/)
		tcp[substr($2, 1, l - 4)] = $1;
	if ($2 ~ /\/udp$/)
		udp[substr($2, 1, l - 4)] = $1;
	}
	END {
	for (i = 3069; i < 9999; i++) {
		if ((tcp[i] == ""     && udp[i] == "")    || \
			(tcp[i] == ""     && udp[i] == "ls3") || \
			(tcp[i] == "ls3" && udp[i] == "")     || \
			(tcp[i] == "ls3" && udp[i] == "ls3") || \
			(tcp[i] == ""     && udp[i] == "lsii") || \
			(tcp[i] == "lsii" && udp[i] == "")     || \
			(tcp[i] == "lsii" && udp[i] == "lsii")) {
			print i;
			break;
			}
		}
	}
	'`
	check_fatal
	echo "Installing ls3 service at port $port in $services."
	# Backup old services file.
	mv -f $services ${services}.ls3
	check_fatal
	# Add new lines using computed port number
	sed -e '
$a\
ls3		'$port'/tcp			# LanSafe III for Unix
$a\
ls3		'$port'/udp			# LanSafe III for Unix
/ls3.*udp/d
/ls3.*tcp/d
/lsii.*udp/d
/lsii.*tcp/d
' ${services}.ls3 > $services
	check_fatal
	chmod 444 $services
	check_fatal

	echo "Modified: $services" >> $instpath/installed
	echo "The following lines were removed from $services:"
	diff ${services}.ls3 $services | grep '^<' | sed -e 's/< //'
	echo "The following lines were added to $services:"
	diff ${services}.ls3 $services | grep '^>' | sed -e 's/> //'
}

bsd_startatboot () {
	rcfile=/etc/rc.local

	mv -f $rcfile ${rcfile}.ls3
	check_fatal

#	Use sed to remove old occurance, both lsii and ls3 and new occurance (when [ $startatboot = "yes" ]) of lines with the form below:
#	if [ -f $instpath/ls3 ]; then
#		$instpath/ls3 $instpath; echo "ls3 (LanSafe III Power Server)"
#	fi

	if [ "$startatboot"  = "yes" ]; then	# replace
		sed -e '
$a\
if [ -f '$instpath'/ls3 ]; then
$a\
\	'$instpath'/ls3&
$a\
\	echo "ls3 (LanSafe III Power Monitor)"
$a\
fi
/if.*ls3/,/fi/d
/if.*lsiid/,/fi/d
' ${rcfile}.ls3 > $rcfile
		check_fatal
	else	# remove
		sed -e '
/if.*ls3/,/fi/d
/if.*lsiid/,/fi/d
' ${rcfile}.ls3 > $rcfile
		check_fatal
	fi

	# Fixup perms on rcfile.
	chmod 755 $rcfile
	check_fatal
	echo "Modified: $rcfile" >> $instpath/installed
	echo "The following lines were removed from $rcfile:"
	diff ${rcfile}.ls3 $rcfile | grep '^<' | sed -e 's/< //'
	echo "The following lines were added to $rcfile:"
	diff ${rcfile}.ls3 $rcfile | grep '^>' | sed -e 's/> //'
}

sysv_startatboot_linux () {
	if [ -d /sbin/init.d ]; then
# SuSe?
		initfile=/sbin/init.d/ls3.init
		startfile=/sbin/init.d/rc2.d/S89ls3.init
		stopfile=/sbin/init.d/rc0.d/K89ls3.init
		return
	fi

	if [ -d /etc/rc.d/init.d ]; then
# Most Linuxes ?
		initfile=/etc/rc.d/init.d/ls3.init
		startfile=/etc/rc.d/rc3.d/S89ls3.init
		startfile2=/etc/rc.d/rc5.d/S89ls3.init
		stopfile=/etc/rc.d/rc0.d/K89ls3.init
		return
	fi

# Other cases?
	initfile=/sbin/init.d/ls3.init
	startfile=/sbin/rc2.d/S515ls3.init
	stopfile=/sbin/rc1.d/K485ls3.init
}

sysv_startatboot_other () {
	if [ -d /etc/init.d ]; then
		initfile=/etc/init.d/ls3.init
		startfile=/etc/rc2.d/S89ls3.init
		stopfile=/etc/rc0.d/K99ls3.init
		return
	fi
	
	if [ $system = "dec" ]; then
		initfile=/sbin/init.d/ls3.init
		startfile=/sbin/rc3.d/S89ls3.init
		stopfile=/sbin/rc0.d/K99ls3.init
		return
	fi

	initfile=/sbin/init.d/ls3.init
	startfile=/sbin/rc2.d/S515ls3.init
	stopfile=/sbin/rc1.d/K485ls3.init
}

sysv_startatboot () {
#	Delete lsii stuff, if it exists
	lsii_initfile=/etc/init.d/lsii.init
	lsii_startfile=/etc/rc2.d/S89lsii.init
	lsii_stopfile=/etc/rc0.d/K99lsii.init

	startfile2=

	if [ $system = "linux" ]; then
		sysv_startatboot_linux
	else
		sysv_startatboot_other
	fi

# Cleanup from previous install, okay for these to fail. First delete lsii files
	if [ -f $lsii_initfile ]; then
		rm -f $lsii_initfile
		echo "Removed: $lsii_initfile" >> $instpath/installed
	fi

	if [ -f $lsii_startfile ]; then
		rm -f $lsii_startfile
		echo "Removed: $lsii_startfile" >> $instpath/installed
	fi

	if [ -f $lsii_stopfile ]; then
		rm -f $lsii_stopfile
		echo "Removed: $lsii_stopfile" >> $instpath/installed
	fi

# Second, Delete ls3 files
	if [ -f $initfile ]; then
		rm -f $initfile
		echo "Removed: $initfile" >> $instpath/installed
	fi

	if [ -f $startfile ]; then
		rm -f $startfile
		echo "Removed: $startfile" >> $instpath/installed
	fi

	if [ -f $stopfile ]; then
		rm -f $stopfile
		echo "Removed: $stopfile" >> $instpath/installed
	fi

# Copy ls3.init while setting install path
	if [ -n "$cdrom_install" ]; then
		if [ -n "$uppercase_mount" ]; then
			InstallFile=1_INSTAL/LS3.INI
		else
			InstallFile=1_instal/ls3.ini
		fi
	else
		InstallFile=1_install/ls3.init
	fi

	if [ "$startatboot" = "yes" ]; then
	echo_n "Installing ls3.init to init.d ... "
	sed '/\usr\/ls3/c\
instpath='$instpath'
' $InstallFile > $initfile
	check_fatal

# Set permissions
	chmod 755 $initfile
	check_fatal
	echo "Installed: $initfile" >> $instpath/installed
	echo "done"

# Link init file in rc dirs.
	if [ -f "$startfile" ]; then
		echo "Deleting $startfile"
		rm $startfile
	fi

	if [ -f "$startfile2" ]; then
		echo "Deleting $startfile2"
		rm $startfile2
	fi

	echo_n "Linking $startfile to $initfile ... "		
	if [ -d /sbin/init.d -o -d /etc/rc.d/init.d -o "$system" = linux -o "$SYSTEM" = LINUX ]; then
		ln -fs $initfile $startfile
	else
		ln $initfile $startfile
		check_fatal
		echo "Linked: $startfile to $initfile" >> $instpath/installed
	fi

	# make sure startfile2 is not null before linking it.
	if [ -n "$startfile2" ]; then
		echo
		echo_n "Linking $startfile2 to $initfile ... "		
		ln -fs $initfile $startfile2
		check_fatal
		echo "Linked: $startfile2 to $initfile" >> $instpath/installed
		echo "done"
	fi

	if [ -f "$stopfile" ]; then
		echo "Deleting $stopfile"
		rm $stopfile
	fi
	echo_n "Linking $stopfile to $initfile ... "
	if [ -d /sbin/init.d -o -d /etc/rc.d/init.d -o "$system" = linux -o "$SYSTEM" = LINUX ]; then
		ln -fs $initfile $stopfile
	else
		ln $initfile $stopfile
	fi
	check_fatal
	echo "Linked: $stopfile to $initfile" >> $instpath/installed
	echo "done"
	fi
}

inittab_startatboot () {
	inittab=/etc/inittab
# Backup old inittab
	mv -f $inittab ${inittab}.ls3
	check_fatal
# Use sed to remove old occurance of form below and add new lines of the form below
#	ls3:234:once:$instpath/ls3

	if [ $startatboot = "yes" ]; then
		sed -e '
$a\
ls3:234:once:'$instpath'/ls3.sh&
/^ls3:234:once:/d
/^lsii:23:once:/d
' ${inittab}.ls3 > $inittab
		check_fatal
	else
		sed -e '
/^ls3:234:once:/d
/^lsii:23:once:/d
' ${inittab}.ls3 > $inittab
		check_fatal
	fi
# Fixup perms on inittab.
	chmod 444 $inittab
	check_fatal

# Report differences
	echo "Modified: $inittab" >> $instpath/installed
	echo "The following lines were removed from $inittab:"
	diff ${inittab}.ls3 $inittab | grep '^<' | sed -e 's/< //'
	echo "The following lines were added to $inittab:"
	diff ${inittab}.ls3 $inittab | grep '^>' | sed -e 's/> //'

# modify ls3.sh

	InstallFile=$instpath/ls3.tmp
	FinalFile=$instpath/ls3.sh
	mv $FinalFile $InstallFile

	sed '/\usr\/ls3/c\
instpath='$instpath'
' $InstallFile > $FinalFile

	chmod 744 $instpath/ls3.sh
}

FixScoFile () {
#	Put the the correct path into s1.objscr
	File2Fix=/usr/lib/X11/XDesktop3/applications/Ls3.obj/s1.objscr
	mv -f $File2Fix $File2Fix.ls3
	sed '/\usr\/ls3/c\
instpath='$instpath'
'   $File2Fix.ls3 > $File2Fix
}

DisableInsight() {
	InsightFile=/usr/bin/compaq/ups/ups.cfg
	if [ $system = "uw2" ]; then
		cpqups_stopper="/etc/init.d/cpqups"
	else
		cpqups_stopper="/etc/cpqups"
	fi

	if [ -f $InsightFile -a -f $cpqups_stopper ]; then
		echo
		echo "Compaq Insight Manager UPS management functions must be"
		echo "disabled to install LanSafe III UPS management."
		read_def "Do you want them disabled? (y/n) [y] " "y"
		case $answer in
		[yY]|[yY][eE][sS])	#/etc/cpqups stop
			if [ $system = "uw2" ]; then
				sh /etc/init.d/cpqups stop
			else
				$cpqups_stopper stop
			fi
			mv -f $InsightFile $InsightFile.ls3
			sed '/SERIAL_PORT/c\
SERIAL_PORT=""
' $InsightFile.ls3 > $InsightFile
			;;
		*)
			exit 0
			;;
		esac
	fi
}

main () {
# override=true
# global bsdecho
# global system
# global uncompress_cmd has to be set after extract
# skip_extract=true
# skip_install=true
# skip_chk4sp=true
# skip_services=true
# skip_config=true
# skip_cleanup=true
# Setup some globals
	ret=TRUE;
	bsdecho=`compute_echo`

# Must set system and SYSTEM prior prompting generic AT&T SVR4 if system is undetermined.
	if [ "$1" = "" ] ; then
		compute_SYSTEM

# Need to know if we are on sco3 or sco5 at this point.
		if [ "$system" = sco -o "$SYSTEM" = SCO ]; then
			sco_system=`compute_sco_system`
		fi

# Need to know if we are running at least DG/UX 4.20MU01 or above.
		if [ "$system" = dgux -o "$SYSTEM" = DGUX ]; then
			compute_dgux_system
		fi
	else
		SYSTEM=$1
	fi

# now convert uppercase into lower and check validity at the same time
	compute_system
#	echo $system

#	Is the installation from a cd-rom?
#	USED TO BE: if the name of this file is in CAPITAL letters then it is on a CD-ROM.
#	NOW: if lansafe or LANSAFE dir exists -> CDROM: Andrei 4.10

	if [ -d "./LANSAFE" -o -d "./lansafe" ]; then
		cdrom_install=true
		skip_extract=true
		skip_gettardev=tar
		skip_cleanup=true
		tardev=CD_ROM
	fi

	if [ -f ./INSTALL.SH ]; then
		uppercase_mount=true
	fi

# Say hello
#	if system is aix3, dec, ia, linux, sunos, svr4 or sco3
#		then we'll install just vanilla ls3 unix
#	else
#		we'll install vanilla ls3 unix and prompt for ls3 snmp agent installation.
	echo
	echo "           Welcome to LanSafe III !"
	if [ "$system" = ia -o "$SYSTEM" = IA ]; then
		echo "                Version 3.72"
	else
		echo "                Version 4.15"
	fi
	echo "To install LanSafe III for UNIX, press <ENTER>"
	echo "and fill in the configuration items as they are presented to you."
	echo

	if [ '(' "$system" = aix3 ')' -o '(' "$system" = dec ')' -o '(' "$system" = ia ')' -o '(' "$system" = linux ')' \
		-o '(' "$system" = sunos ')' -o '(' "$system" = svr4 ')' -o '(' "$SYSTEM" = AIX3 ')' -o '(' "$SYSTEM" = DEC ')' \
		-o '(' "$SYSTEM" = IA ')' -o '(' "$SYSTEM" = LINUX ')' -o '(' "$SYSTEM" = SUNOS ')' -o '(' "$SYSTEM" = SVR4 ')' \
		-o '(' x$sco_system = xsco3 ')' -o '(' "$system" = dgux ')' -o '(' "$SYSTEM" = DGUX ')' ];
	then
		read_def "  Continue installation? (y/n) [y] " "y"
		case $answer in
		[yY]|[yY][eE][sS])
			;;
		*)
			exit 0
			;;
		esac
	else
		echo "The installation process is divided as follows:"
		echo
		echo "   LanSafe for Unix will be installed first."
		echo "   LanSafe SNMP agent will be installed next."
		echo
		echo "NOTE: If you already have LanSafe for Unix installed and you"
		echo "      do not wish to re-install it, select (N)o to stop"
		echo "      LanSafe for Unix installation. You will be then prompted"
		echo "      to install LanSafe SNMP agent."
		echo
		echo
		read_def "  Continue LanSafe for Unix installation? (y/n) [y] " "y"
		case $answer in
		[yY]|[yY][eE][sS])
			;;
		*)
			echo
			echo "           LanSafe for SNMP installation"
			echo "                   Version 4.15"
			echo
			echo "LanSafe SNMP agent gives your SNMP manageable network node the"
			echo "capability to manage UPS information."
			echo
			echo "In order to manage SNMP information, a node must have SNMP"
			echo "daemon installed and running."
			echo
			read_def " Do you want to install LanSafe SNMP agent? (y/n) [y] " "y"

			case $answer in
			[yY]|[yY][eE][sS])
				if [ -n "$skip_gettardev" ]; then
					get_tardev
				fi

# Different cases for dat, cdrom and floppy media.
				if [ -n "$cdrom_install" ]; then
					tardev=CD_ROM
					echo tardev
					echo $tardev
					echo instpath
					echo $instpath
					exec ./AGENT.SH $tardev
				else
					echo

# agent.sh will be generic for all platforms
					if [ -z "$tardev" ]; then
						get_tardev
					fi
					tar -xf $tardev agent.sh >/dev/null 2>&1
					check_status
					if [ $? != 0 ]; then
						echo "Error extracting files?"
						exit 0
					fi

					exec ./agent.sh $tardev
#					exec sh -x ./agent.sh $tardev
				fi
				;;
			*)	#default for "Do you want to install ls3 snmp agent?"
				exit 0
				;;
			esac
			;;
		esac
	fi	# end-of big "if system aix3 -o system -o dec.. "

	if [ x"$system" = x"Unknown System" ]
	then
		echo
		echo "  Unable to determine your system."
		answer=""
		while [ -z "$answer" ]; do
			echo
			echo "Answering (N)o to this question will exit install.sh without installing LanSafe."
			echo
			read_def "  Do you want to install LanSafe III for AT&T SVR4 derivative? (y/n) "
			case $answer in
				[yY]|[yY][eE][sS])
					system=svr4
					SYSTEM=SVR4
					;;
				[nN]|[nN][Oo])
					exit 0
					;;
				*)
					answer=""
					;;
			esac
		done
	fi	# end-of "if system = Unknown system"

	echo
	echo
	if [ -n "$cdrom_install" ]; then
		read_def "Are you installing from a CD-ROM? (y/n) [y] " "y"
	else
		read_def "Are you installing from a CD-ROM? (y/n) [n] " "n"
	fi

	case $answer in
	[yY]|[yY][eE][sS])
		cdrom_install=true
		skip_extract=true
		skip_gettardev=tar
		skip_cleanup=true
		tardev=CD_ROM
		;;
	esac

# Prompt for answers to all questions, with verify.
	userverified=""
	while [ -z "$userverified" ]; do
# Get device for file extraction.
		if [ -z "$skip_gettardev" ]; then
			get_tardev
		fi

# Get install path
		defpath=/usr/ls3
		instpath=
		newpath=
		while [ -z "$instpath" ]; do
			newpath=$defpath
				echo
				echo "The default install path name for this software is:  $defpath"
				read_def '   Do you want to change the install path? (y/n) [n] ' "n"
			case $answer in
			[yY]|[yY][eE][sS])
				read_def "   Enter absolute install path: "
				newpath=$answer
				case $newpath in
				/*)
					echo
					echo "New install path is:  $answer"
					read_def '   Is this OK? (y/n) [y] ' "y"
					case $answer in
						[yY]|[yY][eE][sS])
							;;
						*)
							newpath=
							;;
					esac
					;;
				*)
					echo
					echo "Warning:  You must enter absolute path to install directory.  e.g. $defpath"
					newpath=
				esac
			esac

			if [ ! -z "$newpath" ]; then
				create_path $newpath
				if [ $? = 0 ]; then
					instpath=$newpath
				else
					echo "Unable to install to $newpath.  Choose another directory."
				fi
				bitmapdir=$newpath"/bitmaps"
				create_path $bitmapdir
				if [ $? != 0 ]; then
					echo "Unable to create bitmaps directory"
				fi
			fi
		done	# end-of while $instpath

		if [ "$system" = linux -o "$SYSTEM" = LINUX ]; then
			fixup_linux_system
		fi

# Get start at boot flag
		echo "Automatic Startup"
		echo "To automatically run LanSafe III upon startup on the computer"
		echo "being installed, enter (y)es, otherwise enter (n)o."
		echo "NOTE: It is strongly recommended that you select Yes for this option"
		echo "in order to provide full protection from multiple power outages."
		echo
		read_def "   Automatically run LanSafe III power monitor daemon on startup? (y/n) [y] " "y"
		case $answer in
		[yY]|[yY][eE][sS])
			startatboot="yes"
			;;
		*)
			startatboot="no"
			;;
		esac

		echo
		echo "---------------------------------------------------------------"
		echo "LanSafe III Installation Parameters:"
		echo
		echo "              Device to install from is :  $tardev"
		echo "              Directory to install to is:  $instpath"
		echo "Automatically run LanSafe III on startup:  $startatboot"
		echo "---------------------------------------------------------------"
		echo
		answer=""
		while [ -z "$answer" ]; do
			echo
			read_def "  Are these installation parameters acceptable? (y/n) "
		done

		case $answer in
		[yY]|[yY][eE][sS])
			userverified=true
			;;
		esac
	done

# Extract files
#	tardev="", tardev set above!
	if [ -z "$skip_extract" ]; then
		extract_files
	fi

# Install files
	if [ -z "$skip_install" ]; then
		install_files
	fi

# Check for stream pipes in kernel
	if [ -z "$skip_chk4sp" ]; then
		chk4sp
		check_fatal
	fi

# Setup /etc/services
	if [ -z "$skip_services" ]; then
		setup_services
	fi

# Setup auto start on boot
	if [ -f /etc/rc.local ]; then
		bsd_startatboot
	elif [ -d /etc/init.d -o -d /sbin/init.d -o -d /etc/rc.d/init.d ]; then
		sysv_startatboot
	elif [ -f /etc/inittab ]; then
		inittab_startatboot
	else
		if [ $startatboot = "yes" ]; then
			echo
			echo
			echo "-------------------------------------------------------"
			echo "     Unable to determine how to make your system       "
			echo "     automatically load the Power Monitor at boot time. "
			echo "     Consult the manual for your system.               "
			echo "-------------------------------------------------------"
			echo
			echo
			read_def "  Okay? (y) [y] "
		fi
	fi

# Disable the Insight UPS device driver
	DisableInsight

# Move the bitmap files to the bitmaps directory
	bitmaps=$instpath"/*.bmp"
	bitmapdir=$instpath"/bitmaps"
	mv $bitmaps $bitmapdir

#	If on SCO - Change the s1.objscr file to point to install directory
	if [ $system = "sco" ]; then
		FixScoFile
	fi

# Kill the ls3 daemon if it is running so the copy during installation will run OK
	kill_ls3

# Run install.ls3 to build initial ls3.cfg
# If an old ls3.cfg exits then values in it are used for defaults.
	echo
	if [ -z "$skip_config" ]; then
		$instpath/install.ls3
		InstallDriver=$?
		if [ $? != "123" ]; then
			check_fatal
		fi
	fi

# Install the UPS device driver.
# Install.ls3 returns 123 if the UPS driver should be installed.

	if [ -z "$skip_upsdrv" ]; then
		if [ $InstallDriver = "123" ]; then
			if [ $system = "uw2" ]; then
				echo "LanSafe III does not support UnixWare 2.x with a Dry Contact UPS"
				ret=FALSE
			else
				install_upsdrv
			fi
		fi
	fi

# ls3agent available for aix4, hp9, hp10, solaris sparc, uw2 and sco5
	if [ '(' "$system" = aix4 ')' -o '(' "$system" = solari ')' -o '(' "$system" = uw2 ')'  \
	-o '(' "$SYSTEM" = AIX4 ')' -o '(' "$SYSTEM" = SOLARI ')' -o '(' "$system" = UW2 ')' \
	-o '(' "$SYSTEM" = HPUX ')' -o '(' "$system" = hpux ')' -o '(' x"$sco_system" = xsco5 ')' ];
	then

		echo
		echo "LanSafe for SNMP installation"
		echo "-----------------------------"
		echo
		echo "LanSafe SNMP gives your SNMP manageable network node the"
		echo "capability to manage UPS information."
		echo
		echo "In order to manage SNMP information, a node must have SNMP"
		echo "daemon installed and running."
		echo
		read_def " Do you want to install LanSafe SNMP agent? (y/n) [y] " "y"

		case $answer in
		[yY]|[yY][eE][sS])
			if [ -z "skip_gettardev" ]; then
				get_tardev
			fi
# Different cases for dat, cdrom and floppy media.
			if [ -n "$cdrom_install" ]; then
				if [ -n "$uppercase_mount" ]; then
					exec ./AGENT.SH $tardev $instpath
				else
					exec ./agent.sh $tardev $instpath
				fi
			fi

			if [ -z "$tar_install" ]; then
				echo
				echo_n "Insert $system disk # 1... press Enter when ready. ."
				read x
			fi

			echo
			echo "Now extracting LanSafe III SNMP agent installation script. Please wait..."
			tar -xf $tardev agent.sh >/dev/null 2>&1
			check_status
			if [ $? != 0 ]; then
				echo "Error extracting files?"
				exit 0
			fi
			exec ./agent.sh $tardev $instpath
			;;
		*)
# Clean up
			if [ -z "$skip_cleanup" ]; then
				rm -rf `compute_tapedirs`
				rm -f install.sh
				rm -f agent.sh
				rm -f picture.px
				rm -f s1.objscr
			fi
			;;
		esac
	else	# This is else for if [ "$system" != aix3 -o "$system" != dec -o "$system" != ia ..."
# Clean up
		if [ -z "$skip_cleanup" ]; then
			rm -rf `compute_tapedirs`
			rm -f install.sh
			rm -f agent.sh
			rm -f picture.px
			rm -f s1.objscr
		fi
	fi

# If HP-UX 10.0, check for transition links.
	if [ $system = "hpux" ]; then
		set `uname -a`
		if [ $3 = "B.10.00" ]; then
			set `swlist -l fileset Upgrade.UPG-TLINK | grep B.10.00 | wc -l`
			if [ $1 != 1 ]; then
				echo
				echo "---------------------------------------------------------------"
				echo "     LanSafe III Notification:"
				echo "     LanSafe III requires HP-UX 10.0 transition links which"
				echo "     may not be installed on your system. See Installing"
				echo "     HP-UX 10.0 and the swinstall manpage for further"
				echo "     information."
				echo "---------------------------------------------------------------"
				echo
				read_one "Press ENTER to continue: "
				echo
			fi
		fi
	fi

# If SunOS, check for Motif patch and notify installer if they need it. Also, let them know about the -nosunview switch for xnews.
	if [ $system = "sunos" ]; then
		$instpath/chk4patch.sh
		if [ $? != 0 ]; then
			echo
			echo "---------------------------------------------------------------"
			echo "     LanSafe III Notification:"
			echo "     SunOS 4.1.3 requires a patch to run Motif applications."
			echo "     LanSafe III may require the patch in order to run the"
			echo "     ls3X and ls3conX applications while using the xnews X"
			echo "     server. The patch is not required to run the ls3 and"
			echo "     ls3con applications (Power Monitor and the character"
			echo "     based LanSafe III Console). Contact Sun Microsystems"
			echo "     for patch number 100444-66."
			echo "---------------------------------------------------------------"
			echo
		fi

		echo
		echo "---------------------------------------------------------------"
		echo "     LanSafe III Notification:"
		echo "     If the openwin script is used to start the Open Look Window"
		echo "     Manager (olwm) and the xnews X server, it will need to be"
		echo "     started with the -nosunview switch in order for context"
		echo "     senstive help to be enabled in the ls3X and ls3conX"
		echo "     applications."
		echo "---------------------------------------------------------------"
		echo
		read_one "Press ENTER to continue: "
		echo
	fi

# Say goodbye
	if [ $ret = "TRUE" ]; then
		echo "---------------------------------------------------------------"
		echo "     LanSafe III was successfully installed on your system.     "
		echo "---------------------------------------------------------------"
		echo
	else
		echo "-----------------------------------------------------------------------------"
		echo "     WARNING: LanSafe III was NOT successfully installed on your system.     "
		echo "-----------------------------------------------------------------------------"
		echo
	fi
}

main $1
