//***************************************************************
//                   Web WMI Control File
//***************************************************************
//    The following section is the main control section for this
//    product.
//***************************************************************
//
//    Name = The Marketing Name of the product
//
//    Description = What is displayed as the description of the
//              product. (Required Field)
//
//    Execute = This option is used to execute an application.
//              Some possible uses for this would be launching
//              another installation program, or a configuration
//              applet.
//
//    RequiredSpace = The total amount of disk space required
//              by this product for installation.
//
//    Dependency = This is a field that will specify a case
//              that must exist for the product to be installed.
//
//    Compaq_System = This field specifies if it needs to be a
//              Compaq System.
//                    1 = Needs to be a Compaq Machine
//                    0 = Can be any machine type
//
//    Services = This is a list of services that need to be
//              setup.  The list here, is a list of the service name
//              divided by a comma.  Each service name will then
//              be a section listed in the services section.
//
//    Registry = This is a list of registry keys that need to be
//              added.
//
//    DefaultLoad = This will specify if the product is loaded as a
//              default.
//                     1 = Product is loaded
//                     0 = Product is not loaded
//
//    Version = This is the current version of the agents
//
//    MinBuildNumber = This value will give a specific product the
//              ability to not install on a version of NT different from
//              the main product.
//
//    MaxBuildNumber = Similar to th MinBuildNumber, this one will
//              allow you to specifiy the maximum build number for this
//              product.
//
//    DllCalls = This is for specifiying additional Dll calls.
//
//***************************************************************

[Main]
Name=Compaq WMI Agent
Description=This component runs as a software service under Windows. The service allows access to WMI information from a web browser. The WMI information is displayed through the Compaq Web Agent.
Execute=
RequiredSpace=1000000
Dependency=Compaq Web Agent
Compaq_System=1
Services=CpqWebWMI,CpqWebWMI_351,CpqWebWMI_NOTCPIP
Registry=
DefaultLoad=0
Version=%%SMA_REL_MAJ%%.%%SMA_REL_MIN%%%%SMA_REL_LET%%
VersionFile=cpqwmi.exe
InstalledVersionFile=WindowsSysDir\CPQMgmt\cpqwmi.exe
RebootRequired=0
RebootUpgrade=0

//***************************************************************
//    This is where the start menu items are added.
//***************************************************************
//
//    Folder = The folder to be added
//
//    Entry# = The entries to be added
//
//***************************************************************


//***************************************************************
//    Locations of all of the source directories
//***************************************************************
//
//    The entry names are the ones specified in the [Files] section
//    by the NAME_SOURCE directories.  This abstacts the actual
//    source directory, to this portion of the control file.
//
//***************************************************************

[SourcePath]
CPQWMI=.
Webagent=.
Images=.\images
Eng=.\cqmghost\eng
Help=.\cqmghost\Help
Help_Eng=.\cqmghost\Help\Eng
//***************************************************************
//    Locations of all of the destination directories
//***************************************************************
//
//    The entry names are the ones specifid in the [Files] section
//    by the NAME_DESTINATION directories.  This abstacts the actual
//    destination directory, to this portion of the control file.
//
//***************************************************************

[DestinationPath]
CPQMGMT=WindowsSysDir\cpqmgmt
Webagent=WindowsSysDir\cpqmgmt\webagent
Images=WindowsSysDir\cpqmgmt\webagent\images
Eng=WindowsSysDir\cpqmgmt\webagent\cqmghost\eng
Help=WindowsSysDir\cpqmgmt\webagent\cqmghost\help
Help_Eng=WindowsSysDir\cpqmgmt\webagent\cqmghost\help\eng


//***************************************************************
//    Names of all of the files that are to be copied
//***************************************************************
//
//    FILE_LIST = This lists a code name for a file grouping.
//              Each group is a set of files that are similar in
//              behavior.  They all have the same source, destination
//              and flag conditions.  All file groups are separated
//              by a comma.
//
//    DEFAULT_NOTIFY = This is the default for the files in this section
//              it specifies if the dialog box will appear or not that
//              will ask if you want to over-write the file.  Any file
//              group that specifys a notify will be over-written.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_SOURCE = This shows the name of the source directory
//              for the group of files called NAME.
//
//    NAME_DESTINATION = This shows the name of the destination directory
//              for the group of files called NAME.
//
//    NAME_FILES = This is a list of the files that need to be copied.
//
//    NAME_NOTIFY = This will over-write the DEFAULT_NOTIFY option
//              listed above.  If it is not specified, it will NOT
//              chage the default.
//                    1 = Will display box
//                    0 = Will write over existing file.
//
//    NAME_UNINSTALL = This will determine if the files listed will be
//               removed on an uninstall.  The default is uninstall all
//               files.
//                    1 = Will uninstall this group of files
//                    0 = Will leave these files during an uninstall
//
//    DELETE_FILES = List of files to be deleted
//
//***************************************************************

[Files]
FILE_LIST=CPQWMI,WEBAGENT,IMAGES,ENG,HELP,HELP_ENG

CPQWMI_SOURCE=CPQWMI
CPQWMI_DESTINATION=CPQMGMT
CPQWMI_FILES=cpqwmi.exe
CPQWMI_UNINSTALL=1

WEBAGENT_SOURCE=Webagent
WEBAGENT_DESTINATION=Webagent
WEBAGENT_FILES=cqmgwmi.ini
WEBAGENT_UNINSTALL=1

IMAGES_SOURCE=Images
IMAGES_DESTINATION=Images
IMAGES_FILES=ntos.gif,ntoshdr.gif
IMAGES_UNINSTALL=1

ENG_SOURCE=Eng
ENG_DESTINATION=Eng
ENG_FILES=cqmgwmi.tpf,wmiboot.tpf,wmiinfo.tpf,wmijobs.tpf,wmiosmnu.tpf,wmiutils.js
ENG_UNINSTALL=1

HELP_SOURCE=HELP
HELP_DESTINATION=HELP
HELP_FILES=wmimap.js
HELP_UNINSTALL=1

HELP_ENG_SOURCE=Help_Eng
HELP_ENG_DESTINATION=Help_Eng
HELP_ENG_FILES=Ima00050.htm,Ima00052.htm,Ima00053.htm,Wmicont.htm,Wmiidx.htm
HELP_ENG_UNINSTALL=1



//***************************************************************
//    Names of the services that are to be installed
//***************************************************************
//
//    Description = The Display name of the service
//
//    Path = The Image Path of the service
//
//    Dependencies = This is a field that will specify a case
//              that must exist for the service to be installed.
//
//    Start = The start parameter for the service
//
//    Type = The type value for the service
//
//    ObjectName = The Name of the object
//
//***************************************************************

[CpqWebWMI]
Name=CpqWebWMI
Description=Compaq WMI WEB Agent
DependOnService=TcpIp
DependOnGroup=
Path=%systemroot%\system32\cpqmgmt\cpqwmi.exe
Dependency=System\CurrentControlSet\Services\Tcpip & !VER(1000-1300)
Start=2
Type=16
ErrorControl=1
ObjectName=LocalSystem
EventMessageFile=%systemroot%\system32\cpqmgmt\cpqwmi.exe
EventMessageEntry=Compaq WMI WEB Agent

[CpqWebWMI_NOTCPIP]
Name=CpqWebWMI
Description=Compaq WMI WEB Agent
DependOnService=TcpIp
DependOnGroup=
Path=%systemroot%\system32\cpqmgmt\cpqwmi.exe
Dependency=!System\CurrentControlSet\Services\Tcpip & !VER(1000-1300)
Start=3
Type=16
ErrorControl=1
ObjectName=LocalSystem
EventMessageFile=%systemroot%\system32\cpqmgmt\cpqwmi.exe
EventMessageEntry=Compaq WMI WEB Agent


[CpqWebWMI_351]
Name=CpqWebWMI
Description=Compaq WMI WEB Agent
DependOnService=TcpIp
DependOnGroup=
Path=%systemroot%\system32\cpqmgmt\cpqwmi.exe
Dependency=VER(1000-1300)
Start=4
Type=16
ErrorControl=1
ObjectName=LocalSystem
EventMessageFile=%systemroot%\system32\cpqmgmt\cpqwmi.exe
EventMessageEntry=Compaq WMI WEB Agent

//***************************************************************
//    Names of the Registry Values that are to be installed
//***************************************************************
//
//    NAME - The label of how it will be refered by the service
//           This value gives the key that the registry will be
//           Installed into
//
//    NAME_Dependency - This key must exist for the value to be
//           Installed
//
//    NAME_Name - This is the value to be created
//
//    NAME_Type - This is the type of registy entry that will be
//           created.
//
//    NAME_Data - This is the data that will be entered
//
//***************************************************************

[Registry]
